/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.CastingTuning;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.Instantiable.Formula.MathExpression;
import Reika.DragonAPI.Instantiable.Formula.PeriodicExpression;
import Reika.DragonAPI.Instantiable.ParticleController.FlashColorController;
import Reika.DragonAPI.Instantiable.ParticleController.SpiralMotionController;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkCoordIntPair;

public class CastingTuningMismatchReaction {
    private static final int SOUND_DURATION = 176;
    private static final int DURATION = 4224;
    private final TileEntityCastingTable tile;
    private final EntityPlayer trigger;
    private final Random fixedRand = new Random();
    private final Random particleRand = new Random();
    private int tick;
    private float shockwaveCharge;
    private int shockwaveCooldown;

    public CastingTuningMismatchReaction(TileEntityCastingTable te, EntityPlayer ep) {
        this.tile = te;
        this.trigger = ep;
        this.fixedRand.setSeed(ChunkCoordIntPair.func_77272_a((int)te.field_145851_c, (int)te.field_145849_e) ^ (long)te.field_145848_d);
        this.fixedRand.nextBoolean();
        this.fixedRand.nextBoolean();
    }

    public boolean tick() {
        if (this.tile.field_145850_b.field_72995_K) {
            this.doParticles();
        }
        if (this.tick % 88 == 0) {
            ChromaSounds.CASTTUNEREJECT.playSoundAtBlockNoAttenuation((TileEntity)this.tile, 0.5f, 1.0f, 128);
        }
        if (this.fixedRand.nextInt(50) == 0) {
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this.tile).func_72314_b(60.0, 24.0, 60.0);
            List li = this.tile.field_145850_b.func_72872_a(EntityLivingBase.class, box);
            EntityLivingBase e = (EntityLivingBase)ReikaJavaLibrary.getRandomListEntry((Random)this.fixedRand, (List)li);
            CrystalElement c = (CrystalElement)ReikaJavaLibrary.getRandomListEntry((Random)this.fixedRand, Arrays.asList(CrystalElement.BLACK, CrystalElement.WHITE, CrystalElement.YELLOW, CrystalElement.BLUE, CrystalElement.LIGHTGRAY, CrystalElement.PURPLE));
            double dx = (double)this.tile.field_145851_c + 0.5;
            double dz = (double)this.tile.field_145849_e + 0.5;
            double dy = ReikaRandomHelper.getRandomBetween((double)((double)this.tile.field_145848_d + 2.5), (double)(this.tile.field_145848_d + 9));
            ChromaAux.dischargeIntoPlayer(dx, dy, dz, e.func_70681_au(), e, c, 1.0f, 3.5f);
        }
        if (this.shockwaveCooldown > 0) {
            --this.shockwaveCooldown;
        } else {
            this.shockwaveCharge = this.shockwaveCharge * 1.05f + 0.015f;
            ChromaSounds.KILLAURA_CHARGE.playSoundAtBlockNoAttenuation((TileEntity)this.tile, 1.0f, 0.5f + 1.5f * this.shockwaveCharge * 2.0f, 128);
            if (this.shockwaveCharge >= 1.0f) {
                this.shockwave();
            }
        }
        ++this.tick;
        return this.tick >= 4224;
    }

    private void shockwave() {
        this.shockwaveCharge = 0.0f;
        this.shockwaveCooldown = 60 + this.fixedRand.nextInt(200);
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this.tile).func_72314_b(24.0, 12.0, 24.0);
        List li = this.tile.field_145850_b.func_72872_a(Entity.class, box);
        for (Entity e : li) {
            double dx = e.field_70165_t - (double)this.tile.field_145851_c - 0.5;
            double dy = e.field_70163_u - (double)this.tile.field_145848_d - 0.5;
            double dz = e.field_70161_v - (double)this.tile.field_145849_e - 0.5;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            double v = 5.0;
            double vy = 2.5;
            e.func_70024_g(v * dx / dd, vy + 0.0 * Math.max(v * dy / dd, vy), v * dz / dd);
            e.field_70133_I = true;
            e.field_70143_R = 20.0f;
            if (e instanceof EntityLivingBase) {
                ChromaAux.doPylonAttack(null, (EntityLivingBase)e, 3.0f);
            } else {
                e.func_70097_a(DamageSource.field_76376_m, 3.0f);
            }
            if (!(e instanceof EntityPlayer)) continue;
            ((EntityPlayer)e).field_71075_bZ.field_75101_c = false;
            ((EntityPlayer)e).field_71075_bZ.field_75100_b = false;
        }
        if (this.tile.field_145850_b.field_72995_K) {
            this.doShockwaveParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles() {
        int n = ReikaRandomHelper.getRandomBetween((int)1, (int)4);
        for (int i = 0; i < n; ++i) {
            float s = (float)ReikaRandomHelper.getRandomBetween((double)7.5, (double)15.0);
            int l = ReikaRandomHelper.getRandomBetween((int)20, (int)80);
            double vy = ReikaRandomHelper.getRandomBetween((double)0.125, (double)1.0);
            EntityCCBlurFX fx = new EntityCCBlurFX(this.tile.field_145850_b, (double)this.tile.field_145851_c + 0.5, (double)this.tile.field_145848_d + 0.5, (double)this.tile.field_145849_e + 0.5, 0.0, vy, 0.0);
            fx.setIcon(ChromaIcons.FADE_GENTLE).setScale(s).setColor(0xFFFFFF).setLife(l);
            fx.forceIgnoreLimits().setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (double br = 2.5; br <= 7.5; br += 2.5) {
            for (double a = 0.0; a < 360.0; a += 30.0) {
                double r = ReikaRandomHelper.getRandomPlusMinus((double)br, (double)1.0);
                double ang = ReikaRandomHelper.getRandomPlusMinus((double)a, (double)2.5);
                double dx = (double)this.tile.field_145851_c + 0.5 * r * Math.cos(Math.toRadians(ang));
                double dz = (double)this.tile.field_145849_e + 0.5 * r * Math.sin(Math.toRadians(ang));
                double dy = (double)this.tile.field_145848_d + 0.5 - 4.0;
                float s = (float)ReikaRandomHelper.getRandomBetween((double)7.5, (double)15.0) * 1.5f * (float)Math.sqrt(br / 7.5);
                int c = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)ReikaRandomHelper.getRandomBetween((int)22, (int)45));
                c = ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)((float)ReikaRandomHelper.getRandomBetween((double)0.4, (double)0.9)));
                int l = ReikaRandomHelper.getRandomBetween((int)40, (int)180);
                float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
                double vv = ReikaRandomHelper.getRandomBetween((double)0.0, (double)0.125);
                double ra = ReikaRandomHelper.getRandomBetween((double)1.0, (double)4.0);
                SpiralMotionController m = new SpiralMotionController((double)this.tile.field_145851_c + 0.5, (double)this.tile.field_145849_e + 0.5, ra, vv, r, 0.0, ang);
                EntityCCBlurFX fx = new EntityCCBlurFX(this.tile.field_145850_b, dx, dy, dz);
                fx.setIcon(ChromaIcons.FADE_GENTLE).setScale(s).setColor(c).setLife(l).setGravity(g);
                fx.forceIgnoreLimits().setRapidExpand().setAlphaFading().setMotionController((MotionController)m).setPositionController((PositionController)m);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doShockwaveParticles() {
        int n = ReikaRandomHelper.getRandomBetween((int)120, (int)240);
        for (int i = 0; i < n; ++i) {
            double a1 = this.particleRand.nextDouble() * 360.0;
            double a2 = this.particleRand.nextDouble() * 360.0;
            double v = ReikaRandomHelper.getRandomBetween((double)0.5, (double)2.0);
            double vx = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)(v * 1.5));
            double vz = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)(v * 1.5));
            float s = (float)ReikaRandomHelper.getRandomBetween((double)10.0, (double)20.0);
            int l = ReikaRandomHelper.getRandomBetween((int)10, (int)40) * 2;
            float g = (float)ReikaRandomHelper.getRandomBetween((double)(v * 0.5), (double)v);
            EntityCCBlurFX fx = new EntityCCBlurFX(this.tile.field_145850_b, (double)this.tile.field_145851_c + 0.5, this.tile.field_145848_d + 1, (double)this.tile.field_145849_e + 0.5, vx, v, vz);
            double d = this.particleRand.nextDouble() * 360.0;
            PeriodicExpression e = new PeriodicExpression().addWave(1.0, 1.0, d).addWave(0.5, 2.0, d + 90.0).addWave(0.125, 4.0, d).normalize();
            FlashColorController blink = new FlashColorController((MathExpression)e, 0xA0A0A0, 0x707070);
            fx.setIcon(ChromaIcons.FADE).setScale(s).setColor(0xFFFFFF).setLife(l).setGravity(g).setColorController((ColorController)blink);
            fx.forceIgnoreLimits().setRapidExpand();
            fx.field_70145_X = false;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }
}

