/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.CastingTuning;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.CastingTuning.CastingTuningManager;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.ReikaDirectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

public class TuningKey {
    private static final String ICON_SHEET = "Textures/cast_tuning_icons.png";
    private static final int ICON_COLS = 4;
    private static final int ICON_ROWS = 4;
    private final HashMap<Coordinate, CrystalElement> runes = new HashMap();
    public final UUID uid;
    public final int iconIndex;
    private final double textureU;
    private final double textureV;
    private final double textureDU;
    private final double textureDV;

    TuningKey(UUID uid) {
        this.uid = uid;
        if (this.uid.equals(DragonAPICore.Reika_UUID)) {
            this.iconIndex = 12;
        } else {
            int s = 15;
            int val = (uid.hashCode() % s + s) % s;
            if (val >= 12) {
                ++val;
            }
            this.iconIndex = val;
        }
        int col = this.iconIndex % 4;
        int row = this.iconIndex / 4;
        this.textureU = (float)col / 4.0f;
        this.textureV = (float)row / 4.0f;
        this.textureDU = this.textureU + 0.25;
        this.textureDV = this.textureV + 0.25;
    }

    void putRune(Coordinate c, CrystalElement e) {
        this.runes.put(c, e);
    }

    public Map<Coordinate, CrystalElement> getRunes() {
        return Collections.unmodifiableMap(this.runes);
    }

    public boolean check(TileEntityCastingTable te) {
        return this.runes.equals(te.getCurrentTuningMap());
    }

    public HashMap<ReikaDirectionHelper.FanDirections, CrystalElement> getCompass() {
        HashMap<ReikaDirectionHelper.FanDirections, CrystalElement> ret = new HashMap<ReikaDirectionHelper.FanDirections, CrystalElement>();
        for (Map.Entry<ReikaDirectionHelper.FanDirections, Coordinate> e : CastingTuningManager.instance.tuningKeys.entrySet()) {
            ret.put(e.getKey(), this.runes.get(e.getValue()));
        }
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawIconInGUI(Tessellator v5, double s, double z, int color) {
        this.initGL(v5, color);
        v5.func_78374_a(0.0, s, z, this.textureU, this.textureDV);
        v5.func_78374_a(s, s, z, this.textureDU, this.textureDV);
        v5.func_78374_a(s, 0.0, z, this.textureDU, this.textureV);
        v5.func_78374_a(0.0, 0.0, z, this.textureU, this.textureV);
        v5.func_78381_a();
        GL11.glPopAttrib();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawIcon(Tessellator v5, double s, int color) {
        this.initGL(v5, color);
        v5.func_78374_a(-s, -s, 0.0, this.textureU, this.textureV);
        v5.func_78374_a(s, -s, 0.0, this.textureDU, this.textureV);
        v5.func_78374_a(s, s, 0.0, this.textureDU, this.textureDV);
        v5.func_78374_a(-s, s, 0.0, this.textureU, this.textureDV);
        v5.func_78381_a();
        GL11.glPopAttrib();
    }

    private void initGL(Tessellator v5, int color) {
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)ICON_SHEET);
        GL11.glPushAttrib((int)1048575);
        GL11.glEnable((int)3042);
        ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        v5.func_78382_b();
        v5.func_78378_d(color);
    }
}

