/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.Auxiliary.Structure.MusicTempleStructure;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.RainbowTreeEffects;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.TileEntity.Decoration.TileEntityCrystalMusic;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityFluidFX;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.MusicScore;
import Reika.DragonAPI.Instantiable.ParticleController.AttractiveMotionController;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumIDHandler;
import Reika.DragonAPI.ModList;
import Reika.ReactorCraft.API.RadiationHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class CrystalMusicTemple {
    private static final ExpectedMelody melody = new ExpectedMelody();
    private static final Coordinate fluidSource = new Coordinate(0, -2, 0);
    private static final Collection<Coordinate> pitLocations = new ArrayList<Coordinate>();
    private static final Collection<Coordinate> fluidStartLocations = new ArrayList<Coordinate>();
    private final LinkedList<ReikaMusicHelper.MusicKey>[] tracks = new LinkedList[16];
    private final MusicTempleStructure structure = new MusicTempleStructure();
    private final int[] pillarHighlightTimes = new int[8];
    private final ArrayList<Particle> particles = new ArrayList();
    private final HashSet<GlowingCoord> glowingCoords = new HashSet();
    private HashSet<GlowingCoord> lastAddedCoords = new HashSet();
    private SongSections lastSection;
    private int lastNoteTick = -1;
    private long musicStartTick;
    private Coordinate tileLocation;
    private boolean isStructureComplete;
    private boolean isCorrectMelody;
    private float renderBrightness;

    public void setCore(TileEntityCrystalMusic te) {
        this.tileLocation = new Coordinate((TileEntity)te);
        this.structure.setOrigin(te.field_145850_b, this.tileLocation);
    }

    public void onMusicStart(World world, MusicScore.ScoreTrack track0) {
        if (track0 == null || track0.isEmpty()) {
            return;
        }
        if (this.isStructureComplete) {
            try {
                this.setMelody(track0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.isCorrectMelody) {
                this.musicStartTick = world.func_82737_E();
                this.lastSection = null;
                NBTTagCompound tag = new NBTTagCompound();
                this.writeSyncData(tag);
                ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.MUSICTEMPLESTART.ordinal(), (NBTTagCompound)tag, (PacketTarget)new PacketTarget.RadiusTarget(world, this.tileLocation, 256));
                fluidSource.offset(this.tileLocation).setBlock(world, Blocks.field_150350_a);
            }
        }
    }

    private void spillFluid(World world, SongSections s) {
    }

    private void setMelody(MusicScore.ScoreTrack track) {
        track = track.alignToGrid(4);
        this.isCorrectMelody = true;
        ReikaMusicHelper.MusicKey lowest = track.getLowest();
        if (lowest.getNote() != melody.lowest.rootNote) {
            this.isCorrectMelody = false;
            return;
        }
        int diff = lowest.octaveNumber - melody.lowest.octaveOffset;
        for (ExpectedNote e : melody.melody) {
            if (e == null) continue;
            e.setOctaveOffset(diff);
            if (e.match(track)) continue;
            this.isCorrectMelody = false;
            return;
        }
    }

    public void onNote(World world, ReikaMusicHelper.MusicKey m, int track, int tick) {
        if (track == 0 && this.isStructureComplete && this.isCorrectMelody) {
            this.lastNoteTick = tick;
            if (world.field_72995_K) {
                this.onNotePlayed(m, tick);
            } else {
                SongSections sec = SongSections.getSectionAt(this.getTick(world));
                if (sec.ordinal() == SongSections.ONE.ordinal()) {
                    for (int n = 0; n < 8; ++n) {
                        Coordinate c = MusicTempleStructure.getPillarRoot(n).offset(this.tileLocation);
                        for (int i = -1; i <= 1; ++i) {
                            for (int k = -1; k <= 1; ++k) {
                                if (i == 0 && k == 0) continue;
                                world.func_147449_b(c.xCoord + i, c.yCoord, c.zCoord + k, Blocks.field_150350_a);
                            }
                        }
                    }
                }
                if (sec.ordinal() >= SongSections.THREE.ordinal()) {
                    // empty if block
                }
                ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.MUSICTEMPLE.ordinal(), (World)world, (Coordinate)this.tileLocation, (int)256, (int[])new int[]{m.ordinal(), track, tick});
            }
        }
    }

    public void onMusicEnd(World world) {
        if (this.isStructureComplete && this.isCorrectMelody) {
            this.onSongComplete(world);
        }
        ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.MUSICTEMPLEEND.ordinal(), (World)world, (Coordinate)this.tileLocation, (int)256, (int[])new int[0]);
        this.checkStructure(world);
    }

    private void onSongComplete(World world) {
        fluidSource.offset(this.tileLocation).setBlock(world, Blocks.field_150350_a);
        for (Coordinate c : pitLocations) {
            c.offset(this.tileLocation).setBlock(world, Blocks.field_150350_a);
        }
        ReikaWorldHelper.blockRain((World)world, (int)384000, (boolean)false);
        if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world)) {
            ReikaMystcraftHelper.removeInstabilityForAge((World)world);
            RainbowTreeEffects.instance.addDecayClearing(world, -1L);
        }
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.clearTaintAndEerie(world);
        }
        if (Loader.isModLoaded((String)"pixelmon")) {
            try {
                Block b = GameRegistry.findBlock((String)"pixelmon", (String)"tidal_bell");
                if (b != null) {
                    long time = world.func_72820_D();
                    world.func_72877_b(13000L);
                    TileEntity te = b.createTileEntity(world, 0);
                    te.field_145851_c = this.tileLocation.xCoord;
                    te.field_145848_d = this.tileLocation.yCoord;
                    te.field_145849_e = this.tileLocation.zCoord;
                    Field f1 = te.getClass().getDeclaredField("spawning");
                    Field f2 = te.getClass().getDeclaredField("owner");
                    f1.setAccessible(true);
                    f2.setAccessible(true);
                    f1.set(te, true);
                    f2.set(te, ((TileEntityCrystalMusic)this.tileLocation.getTileEntity((IBlockAccess)world)).getPlacerID());
                    te.func_145845_h();
                    world.func_72877_b(time);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ModList.REACTORCRAFT.isLoaded()) {
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((Coordinate)this.tileLocation).func_72314_b(256.0, 256.0, 256.0);
            List li = world.func_72872_a(RadiationHandler.getRadiationClass(), box);
            for (Entity e : li) {
                e.func_70106_y();
            }
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    private void clearTaintAndEerie(World world) {
        for (int i = -128; i <= 128; ++i) {
            for (int k = -128; k <= 128; ++k) {
                int dx = this.tileLocation.xCoord + i;
                int dz = this.tileLocation.zCoord + k;
                BiomeGenBase b = world.func_72807_a(dx, dz);
                if (b.field_76756_M != ThaumIDHandler.Biomes.EERIE.getID() && b.field_76756_M != ThaumIDHandler.Biomes.TAINT.getID()) continue;
                ReikaWorldHelper.convertBiomeRegionFrom((World)world, (int)dx, (int)dz, (BiomeGenBase)b, null, (BiomeGenBase)BiomeGenBase.field_76767_f, (int)2048);
            }
        }
    }

    public void checkStructure(World world) {
        this.isStructureComplete = this.tileLocation != null && this.structure.validate();
    }

    public boolean isComplete() {
        return this.isStructureComplete;
    }

    public boolean isPlayingMelody() {
        return this.isCorrectMelody;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isRendering() {
        return this.renderBrightness > 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private void onNotePlayed(ReikaMusicHelper.MusicKey note, int tick) {
        this.pillarHighlightTimes[this.getPillar((ReikaMusicHelper.MusicKey)note)] = tick;
        this.lastNoteTick = tick;
        this.renderBrightness = Math.max(this.renderBrightness, 0.001f);
        this.stepGlowCalc(1);
    }

    @SideOnly(value=Side.CLIENT)
    private void stepGlowCalc(int n) {
        for (int i = 0; i < n; ++i) {
            if (this.lastAddedCoords.isEmpty()) continue;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            HashSet<GlowingCoord> add = new HashSet<GlowingCoord>();
            for (GlowingCoord gc : this.lastAddedCoords) {
                if (gc.depth >= 72) continue;
                for (Coordinate c : gc.location.getAdjacentCoordinates()) {
                    Block b;
                    if (c.isEmpty((IBlockAccess)world) || c.yCoord > ((GlowingCoord)gc).location.yCoord || c.yCoord > this.tileLocation.yCoord || !c.isWithinSquare(this.tileLocation, 72) || (b = c.getBlock((IBlockAccess)world)).func_149645_b() != 0 && !b.func_149662_c() && !b.func_149686_d() && !ReikaBlockHelper.isLiquid((Block)b)) continue;
                    add.add(new GlowingCoord((World)world, c, gc.depth + 1));
                }
            }
            this.lastAddedCoords.clear();
            for (GlowingCoord gc : add) {
                this.lastAddedCoords.add(gc);
                if (!gc.isValid((World)world)) continue;
                this.glowingCoords.add(gc);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onStartSection(SongSections s) {
        switch (s) {
            case INTRO: {
                this.glowingCoords.add(new GlowingCoord((World)Minecraft.func_71410_x().field_71441_e, this.tileLocation.offset(0, -1, 0), 0));
                this.lastAddedCoords.addAll(this.glowingCoords);
                this.particles.add(new Particle(ParticleTypes.RED, 0));
                this.particles.add(new Particle(ParticleTypes.YELLOW, 0));
                this.particles.add(new Particle(ParticleTypes.BLUE, 0));
                double r = 5.0;
                for (Particle p : this.particles) {
                    double a = p.type.ordinal() * 120;
                    p.setRadialPosition((double)this.tileLocation.xCoord + 0.5, (double)this.tileLocation.zCoord + 0.5, (double)this.tileLocation.yCoord - 1.75, a, r);
                }
                break;
            }
            case ONE: {
                for (Particle p : this.particles) {
                    p.motionY = 0.075;
                    p.motionX = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.15);
                    p.motionZ = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.15);
                }
                break;
            }
            case TWO: {
                for (int i = 0; i < 6; ++i) {
                    Particle p = new Particle(ParticleTypes.PURPLE, i);
                    this.particles.add(p);
                    p.angle = i * 60;
                }
                break;
            }
            case THREE: {
                Iterator<Particle> it = this.particles.iterator();
                while (it.hasNext()) {
                    Particle p = it.next();
                    if (p.type != ParticleTypes.PURPLE) continue;
                    it.remove();
                }
                for (int i = 0; i < 1; ++i) {
                    this.particles.add(new Particle(ParticleTypes.FINAL, i));
                }
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateParticles(SongSections s, float tick) {
        double t = tick;
        double ft = (tick - (float)s.startTick) / (float)(s.endTime() - s.startTick);
        switch (s) {
            case INTRO: {
                float lf = ft >= 0.5 ? 1.0f : (float)(ft * 2.0);
                for (Particle p : this.particles) {
                    p.lscale = lf;
                }
                break;
            }
            case TWO: {
                double dt = 2.0 + 6.0 * ft;
                double r = 7.5 - 5.0 * ft;
                for (Particle p : this.particles) {
                    if (p.type != ParticleTypes.PURPLE) continue;
                    p.angleSpeed = dt * 0.5;
                    p.setRadialPosition((double)this.tileLocation.xCoord + 0.5, (double)this.tileLocation.zCoord + 0.5, (double)this.tileLocation.yCoord - 1.75, p.angle, r);
                    p.lscale = 1.5f;
                    p.gscale = 1.5f;
                    p.size = 1.75f;
                    p.colorDelay = 6;
                }
            }
            case ONE: {
                for (Particle p : this.particles) {
                    if (p.type == ParticleTypes.PURPLE) continue;
                    for (Particle p2 : this.particles) {
                        if (p.type == ParticleTypes.PURPLE) continue;
                        double f2 = 0.03;
                        double x2 = p2.posX;
                        double y2 = p2.posY;
                        double z2 = p2.posZ;
                        if (p == p2) {
                            x2 = (double)this.tileLocation.xCoord + 0.5;
                            y2 = (double)this.tileLocation.yCoord + 0.5 + 3.5;
                            z2 = (double)this.tileLocation.zCoord + 0.5;
                        }
                        double dx = x2 - p.posX;
                        double dy = y2 - p.posY;
                        double dz = z2 - p.posZ;
                        double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
                        if (p == p2) {
                            f2 = dd < 5.0 ? 0.0 : (f2 *= 10.0);
                        }
                        if (!(f2 > 0.0)) continue;
                        double f = Math.min(0.2, f2 / (dd * dd));
                        double vx = dx / dd * f;
                        double vy = dy / dd * f;
                        double vz = dz / dd * f;
                        Particle particle = p;
                        particle.motionX = particle.motionX + (vx + ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.05));
                        particle = p;
                        particle.motionY = particle.motionY + vy;
                        particle = p;
                        particle.motionZ = particle.motionZ + (vz + ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.05));
                    }
                }
                break;
            }
            case THREE: {
                double dft = ft >= 0.75 ? 0.0 : (0.75 - ft) * 1.333;
                for (Particle p : this.particles) {
                    double a = p.type == ParticleTypes.FINAL ? (double)(120 * p.listIndex) : (double)(p.type.ordinal() * 120 + 60);
                    double r2 = 3.5;
                    p.size = p.type == ParticleTypes.FINAL ? 2.25f : 1.0f;
                    double h = Math.sin(t * 0.2 + a * 2.0) * (0.5 - dft / 4.0);
                    if (p.type == ParticleTypes.FINAL) {
                        r2 += 4.5 * dft + 1.0;
                        p.colorDelay = -12;
                        t *= -3.0;
                    } else {
                        r2 += (2.0 + 3.5 * Math.cos(t * 0.3 + a * 3.5)) * dft;
                        h += 3.0 * Math.sin(t * 0.4 + a * 2.5) * dft;
                    }
                    p.setRadialPosition((double)this.tileLocation.xCoord + 0.5, (double)this.tileLocation.zCoord + 0.5, (double)this.tileLocation.yCoord + 2.5 + h, (a + t * 3.0) % 360.0, r2);
                }
                break;
            }
        }
        for (Particle p : this.particles) {
            p.move(this.tileLocation);
            p.spawnFX();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(float ptick) {
        SongSections sec;
        int playTick = this.getTick();
        this.renderBrightness = playTick == -1 ? Math.max(0.0f, this.renderBrightness - 0.0125f) : Math.min(1.5f, this.renderBrightness + 0.15f);
        if (this.renderBrightness <= 0.0f) {
            return;
        }
        SongSections songSections = sec = playTick < 0 ? SongSections.THREE : SongSections.getSectionAt(playTick);
        if (sec != this.lastSection) {
            this.onStartSection(sec);
        }
        if (!Minecraft.func_71410_x().func_147113_T() && playTick >= 0) {
            this.updateParticles(sec, (float)playTick + ptick);
        }
        this.lastSection = sec;
        ReikaTextureHelper.bindTerrainTexture();
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (sec == SongSections.INTRO && !Minecraft.func_71410_x().func_147113_T()) {
            Random rand = new Random(playTick / 4);
            rand.nextBoolean();
            for (int i = 0; i < 3; ++i) {
                Coordinate c = MusicTempleStructure.getPillarRoot(rand.nextInt(8)).offset(this.tileLocation);
                double dx = ReikaRandomHelper.getRandomBetween((double)-1.0, (double)2.0, (Random)rand);
                double dz = ReikaRandomHelper.getRandomBetween((double)-1.0, (double)2.0, (Random)rand);
                double tx = (double)this.tileLocation.xCoord + 0.5 + dx;
                double tz = (double)this.tileLocation.zCoord + 0.5 + dz;
                double vy = ReikaRandomHelper.getRandomPlusMinus((double)0.155, (double)0.005, (Random)rand);
                double dmp = ReikaRandomHelper.getRandomPlusMinus((double)0.99, (double)0.005, (Random)rand);
                EntityFluidFX fx = new EntityFluidFX((World)world, (double)c.xCoord + dx, (double)c.yCoord + 0.85, (double)c.zCoord + dz, FluidRegistry.WATER);
                fx.setLife(80);
                fx.field_70145_X = true;
                fx.setMotionController((MotionController)new AttractiveMotionController(tx, (double)this.tileLocation.yCoord - 1.5, tz, 0.0026041666666666665, vy, dmp));
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        Tessellator v5 = Tessellator.field_78398_a;
        IIcon ico = ChromaIcons.CAUSTICS_CRYSTAL.getIcon();
        v5.func_78382_b();
        v5.func_78380_c(240);
        int c0 = 38655;
        int c1 = 2021515;
        double ft = 0.0;
        if (playTick == -1 || sec.ordinal() >= SongSections.ONE.ordinal()) {
            ft = sec == SongSections.ONE ? (double)(((float)playTick + ptick - (float)sec.startTick) / (float)(sec.endTime() - sec.startTick)) : 1.0;
            ft = ft * 0.9375 + 0.01;
        }
        if (ft > 0.0) {
            v5.func_78372_c(0.0f, -3.0f, 0.0f);
            double u = ico.func_94209_e();
            double du = ico.func_94212_f();
            double v = ico.func_94206_g();
            double dv = ico.func_94210_h();
            v5.func_78378_d(ReikaColorAPI.getColorWithBrightnessMultiplier((int)c1, (float)Math.min(1.0f, this.renderBrightness * 0.7f)));
            double ft2 = Math.min(0.9375, ft * 2.0);
            v5.func_78374_a(-2.0, ft2, 3.0, u, dv);
            v5.func_78374_a(3.0, ft2, 3.0, du, dv);
            v5.func_78374_a(3.0, ft2, -2.0, du, v);
            v5.func_78374_a(-2.0, ft2, -2.0, u, v);
            v5.func_78372_c(0.0f, 3.0f, 0.0f);
        }
        for (int i = 0; i < 8; ++i) {
            float f = this.pillarIntensity((float)playTick + ptick, i);
            int c = ReikaColorAPI.mixColors((int)c1, (int)c0, (float)f);
            if (ft > 0.0) {
                Coordinate c2 = MusicTempleStructure.getPillarRoot(i);
                v5.func_78372_c((float)c2.xCoord, (float)c2.yCoord, (float)c2.zCoord);
                double u = ico.func_94209_e();
                double du = ico.func_94212_f();
                double v = ico.func_94206_g();
                double dv = ico.func_94210_h();
                v5.func_78378_d(ReikaColorAPI.getColorWithBrightnessMultiplier((int)c0, (float)Math.min(1.0f, this.renderBrightness * 0.7f)));
                v5.func_78374_a(-1.0, ft, 2.0, u, dv);
                v5.func_78374_a(2.0, ft, 2.0, du, dv);
                v5.func_78374_a(2.0, ft, -1.0, du, v);
                v5.func_78374_a(-1.0, ft, -1.0, u, v);
                v5.func_78372_c((float)(-c2.xCoord), (float)(-c2.yCoord), (float)(-c2.zCoord));
            }
            v5.func_78378_d(ReikaColorAPI.getColorWithBrightnessMultiplier((int)c, (float)Math.min(1.0f, this.renderBrightness)));
            Map<Coordinate, BlockKey> map = this.structure.getPillar(i);
            for (Map.Entry<Coordinate, BlockKey> e : map.entrySet()) {
                Coordinate c2 = e.getKey();
                BlockKey bk = e.getValue();
                v5.func_78372_c((float)c2.xCoord, (float)c2.yCoord, (float)c2.zCoord);
                this.renderAround((World)world, c2, bk, ico, v5, false, c2.yCoord == -3 ? ft : 0.0);
                v5.func_78372_c((float)(-c2.xCoord), (float)(-c2.yCoord), (float)(-c2.zCoord));
            }
        }
        if (playTick == -1 || sec.ordinal() >= SongSections.TWO.ordinal()) {
            v5.func_78372_c((float)(-this.tileLocation.xCoord), (float)(-this.tileLocation.yCoord), (float)(-this.tileLocation.zCoord));
            for (GlowingCoord g : this.glowingCoords) {
                float f = this.renderBrightness * 0.15f * g.getRenderBrightness((float)playTick + ptick - (float)SongSections.TWO.startTick);
                if (!(f > 0.0f)) continue;
                v5.func_78378_d(ReikaColorAPI.getColorWithBrightnessMultiplier((int)c1, (float)Math.min(1.0f, f)));
                v5.func_78372_c((float)((GlowingCoord)g).location.xCoord, (float)((GlowingCoord)g).location.yCoord, (float)((GlowingCoord)g).location.zCoord);
                this.renderAround((World)world, g.location, g.block, ico, v5, g.isFluid, 0.0);
                v5.func_78372_c((float)(-((GlowingCoord)g).location.xCoord), (float)(-((GlowingCoord)g).location.yCoord), (float)(-((GlowingCoord)g).location.zCoord));
            }
            v5.func_78372_c((float)this.tileLocation.xCoord, (float)this.tileLocation.yCoord, (float)this.tileLocation.zCoord);
        }
        v5.func_78381_a();
    }

    private int getPillar(ReikaMusicHelper.MusicKey note) {
        ReikaMusicHelper.Note n = note.getNote();
        int idx = n.keyIndex + 1;
        if (n == ReikaMusicHelper.Note.FSHARP) {
            idx = ReikaMusicHelper.Note.F.keyIndex + 1;
        }
        if (n == ReikaMusicHelper.Note.B && note.ordinal() >= ReikaMusicHelper.MusicKey.B7.ordinal()) {
            idx = 0;
        }
        return idx;
    }

    private float pillarIntensity(float tick, int pillar) {
        int t = this.pillarHighlightTimes[pillar];
        if (t == -1) {
            return 0.0f;
        }
        float age = tick - (float)t;
        return age < 40.0f ? 1.0f : (age > 100.0f ? 0.0f : 1.0f - (age - 40.0f) / 60.0f);
    }

    @SideOnly(value=Side.CLIENT)
    private void renderAround(World world, Coordinate c2, BlockKey bk, IIcon ico, Tessellator v5, boolean liq, double minY) {
        int x = c2.xCoord + this.tileLocation.xCoord;
        int y = c2.yCoord + this.tileLocation.yCoord;
        int z = c2.zCoord + this.tileLocation.zCoord;
        double o = 0.001;
        int sx = 4;
        int sy = 4;
        double ux = (float)(x % sx) / (float)sx * 16.0f;
        double uy = (float)((y + z) % sy) / (float)sy * 16.0f;
        float u = ico.func_94214_a(ux);
        float v = ico.func_94207_b(uy + minY * 16.0 / (double)sy);
        float du = ico.func_94214_a(ux + 16.0 / (double)sx);
        float dv = ico.func_94207_b(uy + 16.0 / (double)sy);
        if (bk.blockID.func_149646_a((IBlockAccess)world, x, y, z - 1, ForgeDirection.NORTH.ordinal())) {
            v5.func_78374_a(0.0 - o, 1.0 + o, 0.0 - o, (double)u, (double)dv);
            v5.func_78374_a(1.0 + o, 1.0 + o, 0.0 - o, (double)du, (double)dv);
            v5.func_78374_a(1.0 + o, minY - o, 0.0 - o, (double)du, (double)v);
            v5.func_78374_a(0.0 - o, minY - o, 0.0 - o, (double)u, (double)v);
        }
        if (bk.blockID.func_149646_a((IBlockAccess)world, x, y, z + 1, ForgeDirection.SOUTH.ordinal())) {
            v5.func_78374_a(0.0 - o, minY - o, 1.0 + o, (double)u, (double)v);
            v5.func_78374_a(1.0 + o, minY - o, 1.0 + o, (double)du, (double)v);
            v5.func_78374_a(1.0 + o, 1.0 + o, 1.0 + o, (double)du, (double)dv);
            v5.func_78374_a(0.0 - o, 1.0 + o, 1.0 + o, (double)u, (double)dv);
        }
        if (bk.blockID.func_149646_a((IBlockAccess)world, x - 1, y, z, ForgeDirection.WEST.ordinal())) {
            v5.func_78374_a(0.0 - o, minY - o, 0.0 - o, (double)u, (double)v);
            v5.func_78374_a(0.0 - o, minY - o, 1.0 + o, (double)du, (double)v);
            v5.func_78374_a(0.0 - o, 1.0 + o, 1.0 + o, (double)du, (double)dv);
            v5.func_78374_a(0.0 - o, 1.0 + o, 0.0 - o, (double)u, (double)dv);
        }
        if (bk.blockID.func_149646_a((IBlockAccess)world, x + 1, y, z, ForgeDirection.EAST.ordinal())) {
            v5.func_78374_a(1.0 + o, 1.0 + o, 0.0 - o, (double)u, (double)dv);
            v5.func_78374_a(1.0 + o, 1.0 + o, 1.0 + o, (double)du, (double)dv);
            v5.func_78374_a(1.0 + o, minY - o, 1.0 + o, (double)du, (double)v);
            v5.func_78374_a(1.0 + o, minY - o, 0.0 - o, (double)u, (double)v);
        }
        if (bk.blockID.func_149646_a((IBlockAccess)world, x, y + 1, z, ForgeDirection.UP.ordinal())) {
            v5.func_78374_a(0.0 - o, 1.0 + o, 1.0 + o, (double)u, (double)dv);
            v5.func_78374_a(1.0 + o, 1.0 + o, 1.0 + o, (double)du, (double)dv);
            v5.func_78374_a(1.0 + o, 1.0 + o, 0.0 - o, (double)du, (double)v);
            v5.func_78374_a(0.0 - o, 1.0 + o, 0.0 - o, (double)u, (double)v);
        }
        if (bk.blockID.func_149646_a((IBlockAccess)world, x, y - 1, z, ForgeDirection.DOWN.ordinal())) {
            v5.func_78374_a(0.0 - o, 0.0 - o, 0.0 - o, (double)u, (double)v);
            v5.func_78374_a(1.0 + o, 0.0 - o, 0.0 - o, (double)du, (double)v);
            v5.func_78374_a(1.0 + o, 0.0 - o, 1.0 + o, (double)du, (double)dv);
            v5.func_78374_a(0.0 - o, 0.0 - o, 1.0 + o, (double)u, (double)dv);
        }
    }

    public void writeSyncData(NBTTagCompound tag) {
        tag.func_74757_a("complete", this.isStructureComplete);
        tag.func_74757_a("song", this.isCorrectMelody);
        if (this.tileLocation != null) {
            this.tileLocation.writeToNBT("tile", tag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void readSyncData(NBTTagCompound tag) {
        this.isCorrectMelody = tag.func_74767_n("song");
        this.isStructureComplete = tag.func_74767_n("complete");
        this.tileLocation = Coordinate.readFromNBT((String)"tile", (NBTTagCompound)tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onStart(NBTTagCompound tag) {
        tag.func_74757_a("coords", true);
        this.readSyncData(tag);
        this.particles.clear();
        for (int i = 0; i < this.pillarHighlightTimes.length; ++i) {
            this.pillarHighlightTimes[i] = -1;
        }
        this.glowingCoords.clear();
        this.lastAddedCoords.clear();
        this.lastSection = null;
        this.musicStartTick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
    }

    @SideOnly(value=Side.CLIENT)
    public void onEnd() {
        this.particles.clear();
        this.lastNoteTick = -1;
        this.lastSection = null;
        this.musicStartTick = -1L;
    }

    @SideOnly(value=Side.CLIENT)
    private int getTick() {
        return this.getTick((World)Minecraft.func_71410_x().field_71441_e);
    }

    private int getTick(World world) {
        return this.musicStartTick >= 0L ? (int)(world.func_82737_E() - this.musicStartTick) : -1;
    }

    static {
        try (InputStream in = ChromatiCraft.class.getResourceAsStream("Resources/templesong.dat");){
            CrystalMusicTemple.melody.load(in);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fluidStartLocations.add(fluidSource);
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
            pitLocations.add(new Coordinate(dir.offsetX * 2, -3, dir.offsetZ * 2));
            fluidStartLocations.add(new Coordinate(dir.offsetX * 1, -2, dir.offsetZ * 1));
            fluidStartLocations.add(new Coordinate(dir.offsetX * 2, -2, dir.offsetZ * 2));
            fluidStartLocations.add(new Coordinate(dir.offsetX * 2, -3, dir.offsetZ * 2));
        }
    }

    private static class RelativeKey {
        private final int octaveOffset;
        private final ReikaMusicHelper.Note rootNote;
        private int scanOffset = 0;

        private RelativeKey(ReikaMusicHelper.Note n, int o) {
            this.rootNote = n;
            this.octaveOffset = o;
        }

        public boolean match(MusicScore.Note n) {
            return n.key.getNote() == this.rootNote && n.key.octaveNumber == this.octaveOffset + this.scanOffset;
        }

        public boolean isAbove(RelativeKey rk) {
            return rk.octaveOffset < this.octaveOffset || rk.octaveOffset == this.octaveOffset && rk.rootNote.ordinal() < this.rootNote.ordinal();
        }

        public static RelativeKey parse(String s) {
            int offset = Character.getNumericValue(s.charAt(s.length() - 1));
            ReikaMusicHelper.Note n = ReikaMusicHelper.Note.getNoteByName((String)s.substring(0, s.length() - 1));
            return new RelativeKey(n, offset);
        }

        public int hashCode() {
            return this.rootNote.ordinal() | this.octaveOffset << 4 | this.scanOffset << 8;
        }

        public String toString() {
            return this.rootNote + "@" + this.octaveOffset + "+" + this.scanOffset;
        }
    }

    private static class ExpectedNote {
        public final int tick;
        private final HashSet<RelativeKey> permitted = new HashSet();
        private boolean allowEmpty = false;

        private ExpectedNote(int t, Collection<RelativeKey> c) {
            this(t, c != null ? c.toArray(new RelativeKey[c.size()]) : null);
        }

        private void setOctaveOffset(int off) {
            for (RelativeKey rk : this.permitted) {
                rk.scanOffset = off;
            }
        }

        private boolean match(MusicScore.ScoreTrack s) {
            for (int d = -12; d <= 12; d += 4) {
                Collection c = s.getActiveNotesAt(this.tick + d);
                if (!this.match(c)) continue;
                return true;
            }
            return false;
        }

        private boolean match(Collection<MusicScore.Note> c) {
            if (this.requireEmpty()) {
                return c.isEmpty();
            }
            if (c.isEmpty()) {
                return this.allowEmpty;
            }
            for (MusicScore.Note n : c) {
                boolean flag = false;
                for (RelativeKey rk : this.permitted) {
                    if (!rk.match(n)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                return false;
            }
            return true;
        }

        private ExpectedNote(int t, RelativeKey ... keys) {
            this.tick = t;
            if (keys == null || keys.length == 0) {
                this.allowEmpty = true;
            } else {
                boolean flag = false;
                for (RelativeKey mk : keys) {
                    if (mk == null) {
                        this.allowEmpty = true;
                        continue;
                    }
                    this.permitted.add(mk);
                }
            }
        }

        private void add(Collection<RelativeKey> keys) {
            this.allowEmpty = keys.isEmpty();
            for (RelativeKey key : keys) {
                this.add(key);
            }
        }

        private void add(RelativeKey key) {
            this.allowEmpty |= key == null;
            if (key != null) {
                this.permitted.add(key);
            }
        }

        private boolean requireEmpty() {
            return this.permitted.isEmpty();
        }

        public String toString() {
            return this.tick + ": " + this.allowEmpty + " & " + this.permitted;
        }
    }

    private static class ExpectedMelody {
        private final LinkedList<ExpectedNote> melody = new LinkedList();
        private RelativeKey lowest;

        private ExpectedMelody() {
        }

        private void load(InputStream in) throws Exception {
            this.melody.clear();
            this.lowest = null;
            int tick = 0;
            ArrayList li = ReikaFileReader.getFileAsLines((InputStream)in, (boolean)false, (Charset)Charset.defaultCharset());
            for (String s : li) {
                if (s.startsWith("--")) continue;
                ExpectedNote e = null;
                if (!s.equalsIgnoreCase("null")) {
                    int idxc = s.indexOf(58);
                    int idxl = s.indexOf(91);
                    int idxr = s.indexOf(93);
                    String flag = s.substring(0, idxc);
                    String[] keys = s.substring(idxl + 1, idxr).split(",");
                    e = new ExpectedNote(tick, new RelativeKey[0]);
                    for (String s2 : keys) {
                        RelativeKey rk = RelativeKey.parse(s2);
                        e.permitted.add(rk);
                        if (this.lowest != null && !this.lowest.isAbove(rk)) continue;
                        this.lowest = rk;
                    }
                    e.allowEmpty = Boolean.parseBoolean(flag);
                }
                this.melody.add(e);
                tick += 4;
            }
        }

        public int tickLength() {
            return this.melody.getLast().tick + 8;
        }
    }

    private static class GlowingCoord {
        private static final int MAXDEPTH = 72;
        private static final int FALLOFF_START = 32;
        private static final float FALLOFF = 0.025f;
        private final Coordinate location;
        private final BlockKey block;
        private final int depth;
        private final boolean isFluid;

        private GlowingCoord(World world, Coordinate c, int d) {
            this.location = c;
            this.block = c.getBlockKey((IBlockAccess)world);
            this.depth = d;
            this.isFluid = ReikaBlockHelper.isLiquid((Block)this.block.blockID);
        }

        public boolean isValid(World world) {
            return ReikaWorldHelper.isExposedToAir((World)world, (int)this.location.xCoord, (int)this.location.yCoord, (int)this.location.zCoord);
        }

        public int hashCode() {
            return this.location.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof GlowingCoord && ((GlowingCoord)o).location.equals((Object)this.location);
        }

        public String toString() {
            return this.block.toString() + " @ " + this.location.toString() + " #" + this.depth;
        }

        public float getRenderBrightness(float tick) {
            if (tick >= 0.0f && (tick /= 5.0f) < (float)this.depth) {
                return 0.0f;
            }
            float base = this.depth < 32 ? 1.0f : 1.0f - (float)(this.depth - 32) * 0.025f;
            return (int)tick == this.depth ? base * 0.5f : base;
        }
    }

    private static enum ParticleTypes {
        BLUE(831981, 8573164),
        YELLOW(16769792, 14730240),
        RED(15411979, 15915497),
        PURPLE(12001023, 14456575),
        FINAL(15396601, 2172320);

        public final int primaryColor;
        public final int secondaryColor;
        private static final ParticleTypes[] list;

        private ParticleTypes(int c1, int c2) {
            this.primaryColor = c1;
            this.secondaryColor = c2;
        }

        public ChromaIcons getIcon() {
            switch (this) {
                case BLUE: {
                    return ChromaIcons.FADE_SNOW;
                }
                case RED: {
                    return ChromaIcons.FADE_CLOUD;
                }
                case YELLOW: {
                    return ChromaIcons.FADE_RAY;
                }
                case PURPLE: {
                    return ChromaIcons.FADE_GENTLE;
                }
            }
            return ChromaIcons.CENTER;
        }

        static {
            list = ParticleTypes.values();
        }
    }

    private static enum SongSections {
        INTRO(0),
        ONE(64),
        TWO(128),
        THREE(256);

        public final int startTick;
        private static final SongSections[] list;
        private static final TreeMap<Integer, SongSections> timeMap;

        private SongSections(int idx) {
            this.startTick = idx * 4;
        }

        public int endTime() {
            return this.ordinal() == list.length - 1 ? melody.tickLength() : SongSections.list[this.ordinal() + 1].startTick;
        }

        public int length() {
            return this.endTime() - this.startTick;
        }

        private static SongSections getSectionAt(int t) {
            return timeMap.floorEntry(t).getValue();
        }

        static {
            list = SongSections.values();
            timeMap = new TreeMap();
            for (SongSections s : list) {
                timeMap.put(s.startTick, s);
            }
        }
    }

    private static class Particle
    implements ColorController {
        private final ParticleTypes type;
        private final int listIndex;
        private double posX;
        private double posY;
        private double posZ;
        private double motionX;
        private double motionY;
        private double motionZ;
        private float gscale = 1.0f;
        private float size = 1.0f;
        private float lscale = 1.0f;
        private int colorDelay = 0;
        private double angle;
        private double angleSpeed;
        private static final int fxLife = 25;

        private Particle(ParticleTypes p, int idx) {
            this.type = p;
            this.listIndex = idx;
        }

        public double getDistance(Particle p) {
            return ReikaMathLibrary.py3d((double)(p.posX - this.posX), (double)(p.posY - this.posY), (double)(p.posZ - this.posZ));
        }

        private void move(Coordinate ctr) {
            this.posX += this.motionX;
            this.posY += this.motionY;
            this.posZ += this.motionZ;
            this.motionX *= 0.93;
            this.motionY *= 0.93;
            this.motionZ *= 0.93;
            this.angle += this.angleSpeed;
            this.posX = MathHelper.func_151237_a((double)this.posX, (double)(ctr.xCoord - 12), (double)(ctr.xCoord + 13));
            this.posZ = MathHelper.func_151237_a((double)this.posZ, (double)(ctr.zCoord - 12), (double)(ctr.zCoord + 13));
            this.posY = MathHelper.func_151237_a((double)this.posY, (double)(ctr.yCoord - 2), (double)(ctr.yCoord + 6));
        }

        @SideOnly(value=Side.CLIENT)
        private void spawnFX() {
            EntityCCBlurFX fx = new EntityCCBlurFX((World)Minecraft.func_71410_x().field_71441_e, this.posX, this.posY, this.posZ);
            float g = -((float)ReikaRandomHelper.getRandomBetween((double)0.075, (double)0.2));
            fx.setIcon(this.type.getIcon()).setLife((int)(25.0f * this.lscale)).setGravity(g * this.gscale).setScale(2.5f * this.size);
            fx.setAlphaFading().setRapidExpand().setColorController((ColorController)this);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }

        private void setRadialPosition(double x0, double z0, double y, double ang, double r) {
            this.angle = ang;
            this.posX = x0 + r * Math.cos(Math.toRadians(this.angle));
            this.posY = y;
            this.posZ = z0 + r * Math.sin(Math.toRadians(this.angle));
        }

        private void setPosition(double x, double y, double z) {
            this.posX = x;
            this.posY = y;
            this.posZ = z;
        }

        public void update(Entity e) {
        }

        public int getColor(Entity e) {
            int age = e.field_70173_aa;
            int l = 25;
            if (this.colorDelay > 0) {
                age = Math.max(0, age - this.colorDelay);
            } else if (this.colorDelay < 0) {
                l = Math.max(age, l + this.colorDelay);
            }
            int mid = l / 4;
            float f = age <= mid ? 0.0f : (float)(age - mid) * 1.333f / (float)l;
            return ReikaColorAPI.mixColors((int)this.type.secondaryColor, (int)this.type.primaryColor, (float)f);
        }
    }
}

