/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.API.CrystalElementAccessor;
import Reika.ChromatiCraft.API.CrystalPotionAPI;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.Tools.ItemPendant;
import Reika.ChromatiCraft.Items.Tools.Powered.ItemPurifyCrystal;
import Reika.ChromatiCraft.ModInterface.MystPages;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumIDHandler;
import Reika.DragonAPI.ModList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class CrystalPotionController
implements CrystalPotionAPI {
    public static final CrystalPotionController instance = new CrystalPotionController();
    private final EnumMap<CrystalElement, Potion> potions = new EnumMap(CrystalElement.class);
    private final EnumMap<CrystalElement, Potion> potionsNether = new EnumMap(CrystalElement.class);
    private final HashSet<Integer> ignoredPotions = new HashSet();
    private final Random rand = new Random();

    private CrystalPotionController() {
        this.addColorPotion(CrystalElement.BLUE, Potion.field_76439_r);
        this.addColorPotion(CrystalElement.CYAN, Potion.field_76427_o);
        this.addColorPotion(CrystalElement.GRAY, Potion.field_76421_d);
        this.addColorPotion(CrystalElement.GREEN, Potion.field_76436_u);
        this.addColorPotion(CrystalElement.LIGHTBLUE, Potion.field_76424_c);
        this.addColorPotion(CrystalElement.LIGHTGRAY, Potion.field_76437_t);
        this.addColorPotion(CrystalElement.LIME, Potion.field_76430_j);
        this.addColorPotion(CrystalElement.MAGENTA, ChromatiCraft.betterRegen);
        this.addColorPotion(CrystalElement.RED, Potion.field_76429_m);
        this.addColorPotion(CrystalElement.ORANGE, Potion.field_76426_n);
        this.addColorPotion(CrystalElement.PINK, Potion.field_76420_g);
        this.addColorPotion(CrystalElement.YELLOW, Potion.field_76422_e);
        this.addColorPotion(CrystalElement.WHITE, Potion.field_76441_p);
        this.addColorPotion(CrystalElement.BROWN, ChromatiCraft.betterSat);
        this.addNetherPotion(CrystalElement.BLACK, Potion.field_82731_v);
        this.addNetherPotion(CrystalElement.CYAN, Potion.field_76438_s);
        this.addNetherPotion(CrystalElement.GRAY, Potion.field_76440_q);
        this.addNetherPotion(CrystalElement.GREEN, Potion.field_76436_u);
        this.addNetherPotion(CrystalElement.LIGHTBLUE, Potion.field_76421_d);
        this.addNetherPotion(CrystalElement.LIGHTGRAY, Potion.field_76437_t);
        this.addNetherPotion(CrystalElement.YELLOW, Potion.field_76419_f);
        this.addNetherPotion(CrystalElement.WHITE, Potion.field_76441_p);
        this.addNetherPotion(CrystalElement.BROWN, Potion.field_76431_k);
        this.addNetherPotion(CrystalElement.BLUE, Potion.field_76439_r);
        this.addNetherPotion(CrystalElement.PINK, Potion.field_76420_g);
        this.addNetherPotion(CrystalElement.MAGENTA, ChromatiCraft.betterRegen);
    }

    private void addColorPotion(CrystalElement color, Potion pot) {
        this.potions.put(color, pot);
    }

    private void addNetherPotion(CrystalElement color, Potion pot) {
        this.potionsNether.put(color, pot);
    }

    public boolean shouldBeHostile(EntityLivingBase e, World world) {
        if (e instanceof EntityPlayer && ItemPurifyCrystal.isActive((EntityPlayer)e)) {
            return false;
        }
        return this.isWorldHostile(world);
    }

    @Override
    public boolean isWorldHostile(World world) {
        if (ModList.EXTRAUTILS.isLoaded() && ExtraUtilsHandler.getInstance().initializedProperly() && world.field_73011_w.field_76574_g == ExtraUtilsHandler.getInstance().darkID) {
            return true;
        }
        if (ModList.THAUMCRAFT.isLoaded() && ThaumIDHandler.getInstance().initializedProperly() && world.field_73011_w.field_76574_g == ThaumIDHandler.getInstance().dimensionID) {
            return true;
        }
        if (ModList.MYSTCRAFT.isLoaded() && MystPages.Pages.HOSTILE.existsInWorld(world)) {
            return true;
        }
        return world.field_73011_w.field_76575_d;
    }

    @Override
    public boolean isPotionAllowed(PotionEffect eff, EntityLivingBase e) {
        if (eff == null) {
            return false;
        }
        Potion pot = Potion.field_76425_a[eff.func_76456_a()];
        PotionEffect has = e.func_70660_b(pot);
        if (has != null) {
            if (has.func_76458_c() > eff.func_76458_c()) {
                return false;
            }
            if (has.func_76459_b() > eff.func_76459_b()) {
                return false;
            }
        }
        if (e instanceof EntityPlayer && ItemPurifyCrystal.isActive((EntityPlayer)e)) {
            return !ReikaPotionHelper.isBadEffect((Potion)pot);
        }
        if (!(e instanceof EntityPlayer)) {
            boolean flag = false;
            if (e instanceof EntityCreature) {
                boolean bl = flag = ((EntityCreature)e).func_70668_bt() == EnumCreatureAttribute.UNDEAD;
            }
            return this.shouldBeHostile(e, e.field_70170_p) ? ReikaPotionHelper.isBadEffect((Potion)pot) == flag : true;
        }
        if (this.shouldBeHostile(e, e.field_70170_p)) {
            return eff.func_76456_a() == Potion.field_76439_r.field_76415_H || ReikaPotionHelper.isBadEffect((Potion)pot);
        }
        if (e.field_70170_p.field_73011_w.field_76574_g == 1) {
            return true;
        }
        return !ReikaPotionHelper.isBadEffect((Potion)pot);
    }

    public boolean isBadPotion(CrystalElement e) {
        Potion pot = this.potions.get(e);
        return pot != null && ReikaPotionHelper.isBadEffect((Potion)pot);
    }

    public PotionEffect getEffectFromColor(CrystalElement color, int dura, int level, boolean evil) {
        EnumMap<CrystalElement, Potion> map = evil ? this.potionsNether : this.potions;
        Potion pot = map.get(color);
        if (pot == null) {
            return null;
        }
        return new PotionEffect(pot.field_76415_H, dura, level, true);
    }

    public String getPotionName(CrystalElement color) {
        if (color == CrystalElement.BLACK) {
            return "corrupting";
        }
        if (color == CrystalElement.PURPLE) {
            return "enhancing";
        }
        Potion pot = this.potions.get(color);
        if (pot == null && color == CrystalElement.BROWN) {
            return "lengthening";
        }
        if (pot == null) {
            return "[None]";
        }
        return StatCollector.func_74838_a((String)pot.func_76393_a());
    }

    public boolean requiresCustomPotion(CrystalElement color) {
        if (color == CrystalElement.CYAN) {
            return true;
        }
        if (color == CrystalElement.YELLOW) {
            return true;
        }
        if (color == CrystalElement.LIME) {
            return true;
        }
        if (color == CrystalElement.RED) {
            return true;
        }
        return color == CrystalElement.BROWN;
    }

    public boolean isCorruptedPotion(CrystalElement color) {
        if (color == CrystalElement.GRAY) {
            return true;
        }
        if (color == CrystalElement.LIGHTGRAY) {
            return true;
        }
        return color == CrystalElement.WHITE;
    }

    public boolean isPotionModifier(CrystalElement color) {
        if (color == CrystalElement.BLACK) {
            return true;
        }
        return color == CrystalElement.PURPLE;
    }

    public String getEffectName(CrystalElement color) {
        if (color == CrystalElement.BLACK) {
            return "Confuses Mobs";
        }
        if (color == CrystalElement.PURPLE) {
            return "Gives XP";
        }
        if (color == CrystalElement.WHITE) {
            return "Clears Effects";
        }
        return StatCollector.func_74838_a((String)this.potions.get(color).func_76393_a());
    }

    public String getNetherEffectName(CrystalElement color) {
        if (color == CrystalElement.BROWN) {
            return "Nausea";
        }
        if (color == CrystalElement.PURPLE) {
            return "Takes XP";
        }
        if (color == CrystalElement.ORANGE) {
            return "Fire Damage";
        }
        if (color == CrystalElement.LIME) {
            return "Jump Disability";
        }
        if (color == CrystalElement.RED) {
            return "Direct Damage";
        }
        return StatCollector.func_74838_a((String)this.potionsNether.get(color).func_76393_a());
    }

    @Override
    public Set<Integer> ignoredBadPotionsForLevelZero() {
        return Collections.unmodifiableSet(this.ignoredPotions);
    }

    @Override
    public void addBadPotionForIgnore(Potion p) {
        this.ignoredPotions.add(p.field_76415_H);
    }

    public void applyEffectFromColor(int dura, int level, EntityLivingBase e, CrystalElement color, boolean doFX) {
        this.applyEffectFromColor(dura, level, e, color, doFX, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyEffectFromColor(int dura, int level, EntityLivingBase e, CrystalElement color, boolean doFX, boolean forceGood, boolean forceBad) {
        if (forceBad || !forceGood && this.shouldBeHostile(e, e.field_70170_p)) {
            switch (color) {
                case ORANGE: {
                    e.func_70015_d(2);
                    return;
                }
                case RED: {
                    e.func_70097_a(DamageSource.field_76376_m, 1.0f);
                    return;
                }
                case PURPLE: {
                    if (e.field_70170_p.field_72995_K) return;
                    if (e instanceof EntityPlayer) {
                        if (this.rand.nextInt(5) != 0) return;
                        EntityPlayer ep = (EntityPlayer)e;
                        if (ep.field_71068_ca > 0) {
                            ep.func_82242_a(-1);
                            return;
                        }
                        ep.field_71067_cb = 0;
                        ep.field_71106_cc = 0.0f;
                        return;
                    }
                    if (!(e instanceof EntityLiving)) return;
                    ++((EntityLiving)e).field_70728_aV;
                    return;
                }
                case BROWN: {
                    if (e.func_82165_m(Potion.field_76431_k.field_76415_H)) return;
                    CrystalPotionController.addPotionEffect(e, new PotionEffect(Potion.field_76431_k.field_76415_H, Math.max(100, (int)((double)dura * 1.8)), level, true));
                    return;
                }
                case LIME: {
                    CrystalPotionController.addPotionEffect(e, new PotionEffect(Potion.field_76430_j.field_76415_H, dura, -5, true));
                    return;
                }
                default: {
                    PotionEffect eff = this.getEffectFromColor(color, dura, level, true);
                    if (!forceBad && !this.isPotionAllowed(eff, e)) return;
                    CrystalPotionController.addPotionEffect(e, eff);
                }
            }
            return;
        } else {
            switch (color) {
                case BLACK: {
                    if (!(e instanceof EntityMob)) return;
                    EntityMob m = (EntityMob)e;
                    m.func_70624_b(null);
                    m.func_70661_as().func_75499_g();
                    return;
                }
                case WHITE: {
                    ReikaPotionHelper.clearBadPotions((EntityLivingBase)e, level > 0 ? null : this.ignoredBadPotionsForLevelZero());
                    return;
                }
                case PURPLE: {
                    if (!(e instanceof EntityPlayer) || e.field_70170_p.field_72995_K || level <= 0 && this.rand.nextInt(2) != 0) return;
                    EntityPlayer ep = (EntityPlayer)e;
                    if (doFX) {
                        ep.field_70170_p.func_72956_a((Entity)ep, "random.orb", 0.2f, this.rand.nextFloat() * 2.0f);
                    }
                    int amt = 1;
                    int lvl = ItemPendant.getActivePendantLevel(ep, CrystalElement.PURPLE);
                    if (lvl == 1) {
                        amt *= 3;
                    } else if (lvl == 0) {
                        amt *= 2;
                    }
                    ep.func_71023_q(amt);
                    return;
                }
                default: {
                    PotionEffect eff = this.getEffectFromColor(color, dura, level, false);
                    if (eff == null || !forceGood && !this.isPotionAllowed(eff, e)) return;
                    CrystalPotionController.addPotionEffect(e, eff);
                }
            }
        }
    }

    private static void addPotionEffect(EntityLivingBase e, PotionEffect eff) {
        PotionEffect cur = e.func_70660_b(Potion.field_76425_a[eff.func_76456_a()]);
        if (e instanceof EntityPlayer || cur == null || cur.func_76458_c() < eff.func_76458_c() || cur.func_76459_b() < 20 || eff.func_76459_b() < 80) {
            e.func_70690_d(eff);
        }
    }

    @Override
    public PotionEffect getEffectFromColor(CrystalElementAccessor.CrystalElementProxy color, int dura, int level, boolean evil) {
        return this.getEffectFromColor(CrystalElement.elements[color.ordinal()], dura, level, evil);
    }
}

