/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Lore.LoreManager;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Magic.Progression.ProgressAccess;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.lwjgl.opengl.GL11;

public enum ElementBufferCapacityBoost {
    ALLCOLORS(10000, (ProgressAccess)ProgressStage.ALLCOLORS),
    ABILITY(100000, (ProgressAccess)ProgressStage.ABILITY),
    ALLOYS(240000, (ProgressAccess)ProgressStage.ALLOY),
    DIMENSION(2.0f, (ProgressAccess)ProgressStage.DIMENSION),
    TURBOCHARGE(1.5f, (ProgressAccess)ProgressStage.TURBOCHARGE),
    CTM(2.0f, (ProgressAccess)ProgressStage.CTM),
    TOWER(100000, 1.0f, ProgressStage.TOWER),
    LORECOMPLETE(200000, 1.2f, LoreManager.instance);

    public final int increaseLinear;
    public final float increaseFactor;
    public final int maxValueIfNotPresent;
    private final ProgressAccess requirement;
    private ElementBufferCapacityBoost dependency;
    private ItemStack ingredient;
    private static final String NBT_TAG = "BufferBoosts";
    public static final ElementBufferCapacityBoost[] list;

    private ElementBufferCapacityBoost(int clamp, ProgressAccess req) {
        this(0, 1.0f, clamp, req);
    }

    private ElementBufferCapacityBoost(float fac, ProgressAccess req) {
        this(0, fac, req);
    }

    private ElementBufferCapacityBoost(int lin, float fac, ProgressAccess req) {
        this(lin, fac, Integer.MAX_VALUE, req);
    }

    private ElementBufferCapacityBoost(int lin, float fac, int max, ProgressAccess req) {
        this.increaseFactor = fac;
        this.increaseLinear = lin;
        this.maxValueIfNotPresent = max;
        this.requirement = req;
    }

    public void drawIcon(Tessellator v5, int x, int y, double s) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaRenderHelper.disableLighting();
        ReikaRenderHelper.disableEntityLighting();
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/infoicons.png");
        double u = 0.5 + 0.0625 * (double)this.ordinal();
        double v = 0.0625;
        double d = 0.0625;
        v5.func_78382_b();
        Tessellator.field_78398_a.func_78380_c(240);
        v5.func_78378_d(0xFFFFFF);
        v5.func_78374_a((double)x, (double)y + s, 0.0, u, v + d);
        v5.func_78374_a((double)x + s, (double)y + s, 0.0, u + d, v + d);
        v5.func_78374_a((double)x + s, (double)y, 0.0, u + d, v);
        v5.func_78374_a((double)x, (double)y, 0.0, u, v);
        v5.func_78381_a();
    }

    public boolean playerHas(EntityPlayer ep) {
        return this.isAvailableToPlayer(ep) && this.isTagPresent(ep);
    }

    public boolean isGrantedAutomatically() {
        return this.ingredient == null;
    }

    private NBTTagList getTag(EntityPlayer ep) {
        NBTTagCompound NBT = PlayerElementBuffer.instance.getTag(ep);
        NBTTagList tag = NBT.func_150295_c(NBT_TAG, ReikaNBTHelper.NBTTypes.STRING.ID);
        if (tag == null || tag.field_74747_a.isEmpty()) {
            NBT.func_74782_a(NBT_TAG, (NBTBase)tag);
        }
        return tag;
    }

    private boolean isTagPresent(EntityPlayer ep) {
        NBTTagList li = this.getTag(ep);
        if (li == null || li.field_74747_a.isEmpty()) {
            return false;
        }
        for (Object o : li.field_74747_a) {
            if (!((NBTTagString)o).func_150285_a_().equals(this.name())) continue;
            return true;
        }
        return false;
    }

    public boolean give(EntityPlayer ep) {
        if (this.isAvailableToPlayer(ep)) {
            return this.doGive(ep);
        }
        return false;
    }

    public void remove(EntityPlayer ep) {
        NBTTagList li = this.getTag(ep);
        Iterator it = li.field_74747_a.iterator();
        while (it.hasNext()) {
            NBTTagString tag = (NBTTagString)it.next();
            if (!tag.func_150285_a_().equals(this.name())) continue;
            it.remove();
            PlayerElementBuffer.instance.addToPlayer(ep, CrystalElement.BLACK, 0, true);
            break;
        }
    }

    private boolean doGive(EntityPlayer ep) {
        if (!this.isTagPresent(ep)) {
            this.getTag(ep).func_74742_a((NBTBase)new NBTTagString(this.name()));
            PlayerElementBuffer.instance.addToPlayer(ep, CrystalElement.BLACK, 0, true);
            return true;
        }
        return false;
    }

    public boolean isAvailableToPlayer(EntityPlayer ep) {
        boolean flag;
        boolean bl = flag = this.requirement.playerHas(ep) && (this.dependency == null || this.dependency.playerHas(ep));
        if (flag && this.isGrantedAutomatically()) {
            this.doGive(ep);
        }
        return flag;
    }

    public ItemStack getIngredient() {
        return this.ingredient != null ? this.ingredient.func_77946_l() : null;
    }

    public static ArrayList<ElementBufferCapacityBoost> getAvailableBoosts(EntityPlayer ep) {
        ArrayList<ElementBufferCapacityBoost> li = new ArrayList<ElementBufferCapacityBoost>();
        for (ElementBufferCapacityBoost e : list) {
            if (!e.isAvailableToPlayer(ep) || e.playerHas(ep)) continue;
            li.add(e);
        }
        return li;
    }

    public static int calculateCap(int base, EntityPlayer ep) {
        for (ElementBufferCapacityBoost e : list) {
            if (e.playerHas(ep)) {
                base = (int)((float)base * e.increaseFactor);
                base += e.increaseLinear;
                continue;
            }
            base = Math.min(base, e.maxValueIfNotPresent);
        }
        return base;
    }

    static {
        list = ElementBufferCapacityBoost.values();
        for (int i = 1; i <= CTM.ordinal(); ++i) {
            ElementBufferCapacityBoost.list[i].dependency = list[i - 1];
        }
        ElementBufferCapacityBoost.LORECOMPLETE.dependency = TOWER;
        ElementBufferCapacityBoost.ALLOYS.ingredient = ChromaStacks.etherBerries;
        ElementBufferCapacityBoost.DIMENSION.ingredient = ChromaStacks.glowcavedust;
        ElementBufferCapacityBoost.TURBOCHARGE.ingredient = ChromaStacks.boostroot;
        ElementBufferCapacityBoost.CTM.ingredient = ChromaStacks.echoCrystal;
        ElementBufferCapacityBoost.TOWER.ingredient = ChromaStacks.unknownFragments;
    }
}

