/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Enchantment;

import Reika.ChromatiCraft.Base.ChromaticEnchantment;
import Reika.ChromatiCraft.Registry.ChromaEnchants;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.IC2RubberLogHandler;
import Reika.DragonAPI.ModList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EnchantmentDataKeeper
extends ChromaticEnchantment {
    private static final HashMap<BlockKey, BlockHandler> handlers = new HashMap();

    public EnchantmentDataKeeper(int id) {
        super(id, EnumEnchantmentType.digger);
    }

    public int func_77325_b() {
        return 1;
    }

    @Override
    public boolean isVisibleToPlayer(EntityPlayer ep, int level) {
        return true;
    }

    public static boolean handleBreak(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep) {
        if (handlers.isEmpty()) {
            EnchantmentDataKeeper.initHandlers();
        }
        if (ep == null || ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return false;
        }
        ItemStack tool = ep.func_71045_bC();
        if (ChromaEnchants.DATAKEEP.getLevel(tool) <= 0) {
            return false;
        }
        BlockHandler h = handlers.get(new BlockKey(b, meta));
        if (h == null) {
            return false;
        }
        ItemStack is = h.getItem(world, x, y, z, b, meta, ep);
        if (is == null && ReikaBlockHelper.isOre((Block)b, (int)meta)) {
            is = new ItemStack(b, meta);
        }
        if (is == null) {
            return false;
        }
        if (ChromaEnchants.AUTOCOLLECT.getLevel(is) > 0) {
            ReikaPlayerAPI.addOrDropItem((ItemStack)is, (EntityPlayer)ep);
        } else {
            ReikaItemHelper.dropItem((World)world, (double)((double)x + world.field_73012_v.nextDouble()), (double)((double)y + world.field_73012_v.nextDouble()), (double)((double)z + world.field_73012_v.nextDouble()), (ItemStack)is);
        }
        return true;
    }

    private static void initHandlers() {
        handlers.put(new BlockKey(Blocks.field_150414_aQ, 0), new DirectDrop(Items.field_151105_aU));
        if (ModList.IC2.isLoaded()) {
            Block b = IC2RubberLogHandler.getInstance().logBlock;
            Item.func_150898_a((Block)b).func_77627_a(true);
            handlers.put(new BlockKey(b), new IC2LogDrop());
        }
    }

    private static abstract class BlockHandler {
        private BlockHandler() {
        }

        protected abstract ItemStack getItem(World var1, int var2, int var3, int var4, Block var5, int var6, EntityPlayer var7);
    }

    private static final class DirectDrop
    extends BlockHandler {
        private final ItemStack item;

        private DirectDrop(Item i) {
            this(new ItemStack(i));
        }

        private DirectDrop(ItemStack is) {
            this.item = is.func_77946_l();
        }

        @Override
        protected ItemStack getItem(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep) {
            return this.item.func_77946_l();
        }
    }

    private static final class IC2LogDrop
    extends BlockHandler {
        private IC2LogDrop() {
        }

        @Override
        protected ItemStack getItem(World world, int x, int y, int z, Block b, int meta, EntityPlayer ep) {
            if (IC2RubberLogHandler.getInstance().isCrop(b, meta)) {
                return new ItemStack(b, 1, IC2RubberLogHandler.getInstance().getMeta(ForgeDirection.EAST));
            }
            return null;
        }
    }
}

