/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Lore;

import Reika.ChromatiCraft.Auxiliary.Render.ChromaOverlays;
import Reika.ChromatiCraft.Magic.Lore.KeyAssemblyPuzzle;
import Reika.ChromatiCraft.Magic.Lore.RosettaStone;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressAccess;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.TileEntity.TileEntityDataNode;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class LoreManager
implements ProgressAccess {
    public static final LoreManager instance = new LoreManager();
    private static final String NBT_TAG = "loretowers";
    private KeyAssemblyPuzzle puzzle;
    private RosettaStone rosetta;
    private final MultiMap<Towers, KeyAssemblyPuzzle.TileGroup> towerGroups = new MultiMap().setNullEmpty();

    private LoreManager() {
    }

    public void triggerLore(EntityPlayer ep, Towers t) {
        this.setPlayerScanned(ep, t, true);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.LORENOTE.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{t.ordinal()});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addLoreNote(EntityPlayer ep, Towers t) {
        this.setPlayerScanned(ep, t, true);
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.LOREHEX, (Entity)ep, (float)1.0f, (float)1.0f, (boolean)false);
        ChromaOverlays.instance.addLoreNote(ep, t);
    }

    public Towers getTower(World world, int cx, int cz) {
        this.initTowers(world);
        return Towers.getTowerForChunk(cx, cz);
    }

    public void initTowers(World world) {
        if (!Towers.initialized(world)) {
            Towers.loadPositions(world, 2048.0);
        }
    }

    public Towers getNearestTower(World world, double x, double z) {
        this.initTowers(world);
        Towers ret = null;
        double mind = Double.POSITIVE_INFINITY;
        for (int i = 0; i < Towers.towerList.length; ++i) {
            Towers t = Towers.towerList[i];
            ChunkCoordIntPair p = t.getRootPosition();
            Coordinate p2 = t.getGeneratedLocation();
            double d1 = ReikaMathLibrary.py3d((double)(x - (double)p.field_77276_a), (double)0.0, (double)(z - (double)p.field_77275_b));
            double d2 = p2 != null ? p2.getDistanceTo(x, (double)p2.yCoord, z) : Double.POSITIVE_INFINITY;
            double d = Math.min(d1, d2);
            if (ret != null && !(d < mind)) continue;
            ret = t;
            mind = d;
        }
        return ret;
    }

    public Towers getNearestActiveTower(World world, double x, double z, EntityPlayer ep) {
        this.initTowers(world);
        Towers ret = null;
        double mind = Double.POSITIVE_INFINITY;
        for (int i = 0; i < Towers.towerList.length; ++i) {
            TileEntityDataNode te;
            Towers t = Towers.towerList[i];
            ChunkCoordIntPair p = t.getRootPosition();
            Coordinate p2 = t.getGeneratedLocation();
            if (p2 != null && (te = (TileEntityDataNode)p2.getTileEntity((IBlockAccess)world)).hasBeenScanned(ep)) continue;
            double d1 = ReikaMathLibrary.py3d((double)(x - (double)p.field_77276_a), (double)0.0, (double)(z - (double)p.field_77275_b));
            double d2 = p2 != null ? p2.getDistanceTo(x, (double)p2.yCoord, z) : Double.POSITIVE_INFINITY;
            double d = Math.min(d1, d2);
            if (ret != null && !(d < mind)) continue;
            ret = t;
            mind = d;
        }
        return ret;
    }

    public KeyAssemblyPuzzle getPuzzle(EntityPlayer ep) {
        this.initTowers(ep.field_70170_p);
        if (this.puzzle == null || this.puzzle.getSeed() != KeyAssemblyPuzzle.calcSeed(ep)) {
            this.puzzle = KeyAssemblyPuzzle.generatePuzzle(ep);
        }
        return this.puzzle;
    }

    public void preparePuzzle(EntityPlayer ep) {
        this.initTowers(ep.field_70170_p);
        if (this.towerGroups.isEmpty()) {
            for (int i = 0; i < Towers.towerList.length; ++i) {
                Towers t = Towers.towerList[i];
                this.getGroupsForTower(ep, t);
            }
        }
    }

    public Collection<KeyAssemblyPuzzle.TileGroup> getGroupsForTower(EntityPlayer ep, Towers t) {
        Collection<KeyAssemblyPuzzle.TileGroup> c = this.towerGroups.get((Object)t);
        if (c == null) {
            KeyAssemblyPuzzle p = this.getPuzzle(ep);
            c = p.getRandomGroupsForTower(t);
            this.towerGroups.put((Object)t, c);
        }
        return Collections.unmodifiableCollection(c);
    }

    public void setPlayerScanned(EntityPlayer ep, Towers t, boolean set) {
        NBTTagCompound NBT = ChromaResearchManager.instance.getRootNBTTag(ep);
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        tag.func_74757_a(t.name(), set);
        NBT.func_74782_a(NBT_TAG, (NBTBase)tag);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public boolean hasPlayerScanned(EntityPlayer ep, Towers t) {
        NBTTagCompound NBT = ChromaResearchManager.instance.getRootNBTTag(ep);
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        return tag.func_74767_n(t.name());
    }

    public boolean hasScannedAllTowers(EntityPlayer ep) {
        for (int i = 0; i < Towers.towerList.length; ++i) {
            Towers t = Towers.towerList[i];
            if (this.hasPlayerScanned(ep, t)) continue;
            return false;
        }
        return true;
    }

    public boolean hasPlayerCompletedBoard(EntityPlayer ep) {
        NBTTagCompound NBT = ChromaResearchManager.instance.getRootNBTTag(ep);
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        return tag.func_74767_n("complete");
    }

    public void setBoardCompletion(EntityPlayer ep, boolean set) {
        NBTTagCompound NBT = ChromaResearchManager.instance.getRootNBTTag(ep);
        NBTTagCompound tag = NBT.func_74775_l(NBT_TAG);
        tag.func_74757_a("complete", set);
        NBT.func_74782_a(NBT_TAG, (NBTBase)tag);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public void completeBoard(EntityPlayer ep) {
        this.setBoardCompletion(ep, true);
        if (ep.field_70170_p.field_72995_K) {
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.LORECOMPLETE, (Entity)ep, (float)1.0f, (float)1.0f, (boolean)false);
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.LOREPUZZLECOMPLETE.ordinal(), (PacketTarget)PacketTarget.server, (int[])new int[0]);
        } else {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public RosettaStone getOrCreateRosetta(EntityPlayer ep) {
        if (this.rosetta == null) {
            this.rosetta = new RosettaStone(ep);
        }
        return this.rosetta;
    }

    public void clearOnLogout() {
        this.rosetta = null;
        this.puzzle = null;
        this.towerGroups.clear();
    }

    public void sendTowersToClient(EntityPlayerMP ep) {
        this.initTowers((World)DimensionManager.getWorld((int)0));
        NBTTagCompound data = new NBTTagCompound();
        NBTTagList li = new NBTTagList();
        for (Towers t : Towers.towerList) {
            NBTTagCompound tag = new NBTTagCompound();
            ChunkCoordIntPair p = t.getRootPosition();
            tag.func_74768_a("x", ~p.field_77276_a);
            tag.func_74768_a("z", ~p.field_77275_b);
            tag.func_74768_a("idx", t.ordinal());
            li.func_74742_a((NBTBase)tag);
        }
        data.func_74782_a("list", (NBTBase)li);
        ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.TOWERLOC.ordinal(), (NBTTagCompound)data, (PacketTarget)new PacketTarget.PlayerTarget(ep));
    }

    @SideOnly(value=Side.CLIENT)
    public void readTowersFromServer(NBTTagCompound data) {
        NBTTagList li = data.func_150295_c("list", ReikaNBTHelper.NBTTypes.COMPOUND.ordinal());
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            int x = ~tag.func_74762_e("x");
            int z = ~tag.func_74762_e("z");
            int idx = tag.func_74762_e("idx");
            Towers.towerList[idx].setLocationFromServer(x, z);
        }
    }

    @Override
    public boolean playerHas(EntityPlayer ep) {
        return this.hasPlayerCompletedBoard(ep);
    }
}

