/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Lore;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class LoreScriptRenderer {
    public static final LoreScriptRenderer instance = new LoreScriptRenderer();
    public static final int CHAR_WIDTH = 10;
    public static final int CHAR_SPACING = -2;
    private final String texture = "Textures/precursorscript.png";
    private final HashMap<Character, Integer> characters = new HashMap();
    private int textColor;
    private int spaceColor;
    private int lineColor;

    private LoreScriptRenderer() {
        char c;
        int i;
        int k = 0;
        for (i = 0; i < 26; ++i) {
            c = (char)(97 + i);
            this.characters.put(Character.valueOf(c), k);
            ++k;
        }
        for (i = 0; i < 26; ++i) {
            c = (char)(65 + i);
            this.characters.put(Character.valueOf(c), k);
            ++k;
        }
        for (i = 0; i < 10; ++i) {
            c = (char)(48 + i);
            this.characters.put(Character.valueOf(c), k);
            ++k;
        }
        this.characters.put(Character.valueOf('.'), k + 1);
        this.characters.put(Character.valueOf('?'), k + 2);
    }

    public void startRendering(boolean additive, int color) {
        ReikaTextureHelper.bindFinalTexture(ChromatiCraft.class, (String)"Textures/precursorscript.png");
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        ReikaRenderHelper.disableEntityLighting();
        GL11.glEnable((int)3042);
        if (additive) {
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
        } else {
            ReikaGLHelper.BlendMode.DEFAULT.apply();
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        int alpha = ReikaColorAPI.getAlpha((int)color);
        if (alpha <= 0) {
            alpha = 255;
        }
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78384_a(color, alpha);
        this.textColor = color;
        this.spaceColor = additive ? alpha << 24 | ReikaColorAPI.getColorWithBrightnessMultiplier((int)color, (float)0.375f) : ReikaColorAPI.getColorWithAlpha((int)color, (float)(0.375f * (float)alpha));
        this.lineColor = additive ? alpha << 24 | ReikaColorAPI.getColorWithBrightnessMultiplier((int)color, (float)0.5f) : ReikaColorAPI.getColorWithAlpha((int)color, (float)(0.5f * (float)alpha));
        Tessellator.field_78398_a.func_78380_c(240);
    }

    public void stopRendering() {
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopAttrib();
    }

    public void renderCharacter(char c, double x, double y, boolean flipVertical) {
        if (c == ' ') {
            return;
        }
        if (!this.characters.containsKey(Character.valueOf(c))) {
            throw new IllegalArgumentException("Cannot render char '" + c + "'!");
        }
        int idx = this.characters.get(Character.valueOf(c));
        double u = (double)(idx % 8) / 8.0;
        double v = (double)(idx / 8) / 8.0;
        double du = u + 0.125;
        double dv = v + 0.125;
        if (flipVertical) {
            y += 1.1;
        }
        double y1 = flipVertical ? y + 10.0 : y;
        double y2 = flipVertical ? y : y + 10.0;
        Tessellator.field_78398_a.func_78374_a(x, y2, 0.0, u, dv);
        Tessellator.field_78398_a.func_78374_a(x + 10.0, y2, 0.0, du, dv);
        Tessellator.field_78398_a.func_78374_a(x + 10.0, y1, 0.0, du, v);
        Tessellator.field_78398_a.func_78374_a(x, y1, 0.0, u, v);
    }

    public void renderLine(String s, double x, double y, double width, boolean flipVertical) {
        String[] parts = s.split(" ");
        if (parts.length <= 1) {
            this.renderString(s, x, y, flipVertical);
        } else {
            double dx = x;
            int chars = 0;
            for (int i = 0; i < parts.length; ++i) {
                chars += parts[i].length();
            }
            double sp = (width - (double)(chars * 8)) / (double)(parts.length - 1);
            for (int i = 0; i < parts.length; ++i) {
                this.renderString(parts[i], dx, y, flipVertical);
                double dxp = dx;
                dx -= (double)(8 * parts[i].length());
                dx -= sp;
                if (i == parts.length - 1) continue;
                float f = GL11.glGetFloat((int)2849);
                GL11.glLineWidth((float)4.0f);
                double dx2 = dx + 10.0 + 0.5;
                double dy2 = y + 4.0;
                int h = 7;
                GL11.glPushAttrib((int)1048575);
                ReikaGuiAPI.instance.drawLine(dx2, dy2 - 1.0, dx2 + sp - 2.0, dy2 - 1.0, this.spaceColor);
                ReikaGuiAPI.instance.drawLine(dx2, dy2 + (double)(h / 2) + 1.0 + 0.225, dx2 + sp - 2.0, dy2 + (double)(h / 2) + 1.0 + 0.225, this.spaceColor);
                GL11.glPopAttrib();
                GL11.glLineWidth((float)f);
            }
        }
        float f = GL11.glGetFloat((int)2849);
        GL11.glLineWidth((float)2.0f);
        ReikaGuiAPI.instance.drawLine(x + 10.0, y + 1.5, x - width + 10.0 - 0.5, y + 1.5, this.lineColor);
        ReikaGuiAPI.instance.drawLine(x + 10.0, y - 0.5 + 10.0, x - width + 10.0 - 0.5, y - 0.5 + 10.0, this.lineColor);
        GL11.glLineWidth((float)f);
    }

    public void renderString(String s, double x, double y, boolean flipVertical) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            this.renderCharacter(c, x - (double)(8 * i), y, flipVertical);
        }
    }
}

