/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Lore;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Exception.RegistrationException;
import Reika.DragonAPI.Interfaces.DataProvider;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Random;

public class LoreScripts
implements DataProvider {
    public static final LoreScripts instance = new LoreScripts();
    private final File reroutePath;
    private final Collection<LorePanel> data = new ArrayList<LorePanel>();

    private LoreScripts() {
        File f = new File("C:/ChromatiCraftLoreDev");
        this.reroutePath = f.exists() && f.isDirectory() && f.listFiles().length == 2 ? f : null;
    }

    public boolean hasReroutePath() {
        return this.reroutePath != null;
    }

    public File getReroutedLoreFile() {
        return new File(this.reroutePath, "lore.xml");
    }

    public File getReroutedRosettaFile() {
        return new File(this.reroutePath, "rosetta.txt");
    }

    public InputStream getDataStream() throws IOException {
        return null;
    }

    public boolean canBeReloaded() {
        return true;
    }

    public Collection<LorePanel> getData() {
        return Collections.unmodifiableCollection(this.data);
    }

    public static enum ScriptLocations {
        BURROW(new PanelSize(24, 5), 3),
        CAVERN1(new PanelSize(40, 5), 2),
        CAVERN2(new PanelSize(16, 12), 2),
        CAVERN3(new PanelSize(16, 17), 2),
        DESERT(new PanelSize(24, 17), 4),
        OCEAN(new PanelSize(64, 17), 2),
        PYLON(new PanelSize(15, 5), 8),
        TOWER(new PanelSize(23, 5), 4),
        ALVEARY(new PanelSize(20, 7), 4),
        SNOWSTRUCT(new PanelSize(24, 5), 4);

        public final PanelSize size;
        public final int panelCount;
        private final ArrayList<LorePanel> panels = new ArrayList();
        public static final ScriptLocations[] list;

        private ScriptLocations(PanelSize s, int c) {
            this.panelCount = c;
            this.size = s;
        }

        public LorePanel getPanel(int i) {
            return this.panels.get(i);
        }

        public LorePanel getRandomPanel(Random rand) {
            return this.getPanel(rand.nextInt(this.panels.size()));
        }

        public ArrayList<LorePanel> getUniqueRandomPanels(Random rand, int number) {
            if (number > this.panels.size()) {
                throw new IllegalArgumentException("Cannot get " + number + " unique panels from a list of " + this.panels.size());
            }
            ArrayList<LorePanel> li = new ArrayList<LorePanel>();
            ArrayList indices = ReikaJavaLibrary.makeIntListFromArray((int[])ReikaArrayHelper.getLinearArray((int)this.panels.size()));
            for (int i = 0; i < number; ++i) {
                int idx0 = rand.nextInt(indices.size());
                int idx = (Integer)indices.get(idx0);
                li.add(this.panels.get(idx));
                indices.remove(idx0);
            }
            return li;
        }

        public void reload() {
            this.panels.clear();
        }

        public void loadText(String s) {
            try {
                this.panels.add(new LorePanel(this, this.size, s.split("\\n")));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not load lore panel for " + (Object)((Object)this) + " with data:\n----------\n" + s + "\n----------", e);
            }
        }

        public boolean isEnabled() {
            return this != PYLON;
        }

        static {
            list = ScriptLocations.values();
        }
    }

    public static final class PanelSize {
        public final int lineCount;
        public final int maxLength;

        private PanelSize(int l, int c) {
            this.lineCount = c;
            this.maxLength = l;
        }

        public String toString() {
            return this.maxLength + " chars x " + this.lineCount + " lines";
        }
    }

    public static final class LoreLine {
        public final String text;
        public final int length;

        private LoreLine(String s) {
            this.text = s;
            this.length = s.length();
        }

        public String toString() {
            return "L" + this.length + ": " + this.text;
        }
    }

    public static final class LorePanel {
        public final PanelSize size;
        private final LoreLine[] data;
        public final int longestStringLength;
        public final int lineCount;

        private LorePanel(ScriptLocations loc, PanelSize s, String[] text) {
            this.size = s;
            if (text.length == 0) {
                FMLLog.bigWarning((String)("Warning: Declared a lore panel for " + (Object)((Object)loc) + " of size " + s + " with no text!"), (Object[])new Object[0]);
            } else {
                if (text.length > this.size.lineCount) {
                    throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Invalid lore panel for " + (Object)((Object)loc) + "! Size (" + this.size + ") is too small for supplied string array: " + Arrays.toString(text));
                }
                if (text.length < this.size.lineCount && instance.reroutePath != null) {
                    FMLLog.bigWarning((String)("Warning: Declared a lore panel for " + (Object)((Object)loc) + " of size " + s + " but with not enough text (" + text.length + " lines) to fill it: " + Arrays.toString(text)), (Object[])new Object[0]);
                }
            }
            this.lineCount = Math.min(text.length, this.size.lineCount);
            this.data = new LoreLine[this.lineCount];
            for (int i = 0; i < text.length; ++i) {
                this.data[i] = new LoreLine(text[i]);
            }
            int l = 0;
            for (int i = 0; i < text.length; ++i) {
                l = Math.max(l, text[i].length());
            }
            this.longestStringLength = l;
            if (this.longestStringLength > this.size.maxLength) {
                throw new RegistrationException((DragonAPIMod)ChromatiCraft.instance, "Invalid lore panel for " + (Object)((Object)loc) + "! Longest string is length " + this.longestStringLength + ", but the panel only allows up to " + this.size.maxLength);
            }
        }

        public String toString() {
            return this.size + " x " + this.longestStringLength + ": " + Arrays.toString(this.data);
        }

        public LoreLine getLine(int i) {
            return this.data[i];
        }
    }
}

