/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Auxiliary.Render.AngleColorController;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Registry.ExtraChromaIDs;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.ChromatiCraft.Render.Particle.EntityFlareFX;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityDimensionCore;
import Reika.ChromatiCraft.TileEntity.Technical.TileEntityStructControl;
import Reika.ChromatiCraft.World.Dimension.ChromaDimensionTicker;
import Reika.ChromatiCraft.World.Dimension.ChunkProviderChroma;
import Reika.ChromatiCraft.World.Dimension.Structure.MonumentGenerator;
import Reika.DragonAPI.Auxiliary.Trackers.TickScheduler;
import Reika.DragonAPI.IO.Shaders.ShaderProgram;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Effects.EntityFloatingSeedsFX;
import Reika.DragonAPI.Instantiable.Effects.LightningBolt;
import Reika.DragonAPI.Instantiable.Event.ScheduledTickEvent;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.IO.SoundVariant;
import Reika.DragonAPI.Instantiable.Math.Vec4;
import Reika.DragonAPI.Instantiable.ParticleController.SpiralMotionController;
import Reika.DragonAPI.Interfaces.ColorController;
import Reika.DragonAPI.Interfaces.MotionController;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MonumentCompletionRitual {
    private static final Random rand = new Random();
    private final int FINAL_SOUND_COMPLETION_DELAY = 20000;
    private final int FINAL_SOUND_COMPLETION_DELAY_EXTRA = 4000;
    private final int COMPLETION_EXTRA = 3000;
    private final long[] SOUND_TIMINGS = new long[]{0L, 28000L, 66500L, 86000L, 104800L, 123500L};
    private final int BEAT_LENGTH = 2390;
    private final int EFFECT_RANGE = 256;
    private static final ArrayList<RayNote> melody = new ArrayList();
    private long startTime;
    private long startTick;
    private long runTime = -1L;
    private int tick;
    private long lastTickTime;
    private long nextSoundTime;
    private long lastSoundStart;
    private long completionTime;
    private long pauseTotal = 0L;
    private int currentSound = -1;
    private boolean running;
    private boolean complete;
    private final World world;
    private final int x;
    private final int y;
    private final int z;
    private final EntityPlayer ep;
    private final PacketTarget packetTarget;
    @SideOnly(value=Side.CLIENT)
    private ISound playingSound;
    private float vortexSize = 0.0f;
    private boolean vortexGrow = false;
    private final ArrayList<RingParticle> particleRing = new ArrayList();
    private final ArrayList<TimedEvent> events = new ArrayList();
    private static final float[] colorFade = new float[16];
    private static final Vec3[] shaderPositions = new Vec3[16];
    private static final Vec4[] shaderColors = new Vec4[16];
    private ReikaMusicHelper.MusicKey activeKey = null;
    private static boolean runningRituals;
    private static boolean reShowGui;
    private static boolean reBobView;

    private void addEvent(EventType e, int beats) {
        this.events.add(new TimedEvent(e, beats * 2390));
    }

    public static boolean areRitualsRunning() {
        return runningRituals;
    }

    public static void clearRituals() {
        runningRituals = false;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            for (int i = 0; i < 16; ++i) {
                MonumentCompletionRitual.colorFade[i] = 0.0f;
                MonumentCompletionRitual.shaderColors[i] = null;
                MonumentCompletionRitual.shaderPositions[i] = null;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static float getIntensity(CrystalElement e) {
        return colorFade[e.ordinal()];
    }

    @SideOnly(value=Side.CLIENT)
    public static void addShaderData(ShaderProgram p) {
        p.setField("glowLocations", (Object)shaderPositions);
        p.setField("glowColor", (Object)shaderColors);
    }

    public MonumentCompletionRitual(World world, int x, int y, int z, EntityPlayer ep) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.ep = ep;
        int t0 = 100;
        long off = 0L;
        this.events.add(new TimedEvent(EventType.FLARES, 0L));
        int nextOff = 0;
        boolean flag = false;
        boolean flag2 = false;
        boolean flag3 = false;
        for (int idx = 0; idx < melody.size(); ++idx) {
            RayNote n = melody.get(idx);
            EventType e = EventType.FLARES;
            if (n.length >= 6) {
                e = EventType.PARTICLECLOUD;
            } else if (n.length >= 4) {
                e = EventType.TWIRL;
            }
            if (n.isFirstInPhrase && n.startBeat > 0) {
                if (off == 0L) {
                    off -= 250L;
                } else if (off == -250L) {
                    off += 400L;
                }
                if (off == 150L) {
                    nextOff = 200;
                }
            }
            if (idx == 10) {
                nextOff = 250;
            }
            if (idx == 16) {
                off = 250L;
            }
            if (idx == 18) {
                off = 0L;
            }
            long t = (long)t0 + off + (long)nextOff;
            nextOff = 0;
            if (!n.isFirstInPhrase || n.startBeat > 0) {
                // empty if block
            }
            if (world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
                t -= n.isFirstInPhrase ? 500L : 900L;
            }
            TimedEvent te = new TimedEvent(e, t);
            this.events.add(te);
            this.events.add(new RayEvent(n, t - 250L));
            if (n.percussion && n.startBeat > 0) {
                this.events.add(new TimedEvent(EventType.PINWHEEL, t));
            }
            if (n.bell && n.startBeat > 0) {
                this.events.add(new TimedEvent(EventType.TWIRL, t));
            }
            if (n.isFirstInPhrase) {
                for (int i = 0; i <= 250; i += 50) {
                    this.events.add(new TimedEvent(EventType.PARTICLERING, t + (long)i));
                }
            }
            if ((t0 += n.length * 2390) >= 85000 && !flag) {
                t0 += 500;
                flag = true;
            }
            if (t0 >= 101000 && !flag2) {
                t0 += 750;
                flag2 = true;
            }
            if (t0 < 115000 || flag3) continue;
            t0 -= 1200;
            flag3 = true;
        }
        this.addEvent(EventType.VORTEXGROW, 12);
        this.addEvent(EventType.VORTEXGROW, 14);
        this.addEvent(EventType.VORTEXGROW, 24);
        this.addEvent(EventType.VORTEXGROW, 28);
        this.addEvent(EventType.VORTEXGROW, 44);
        Collections.sort(this.events);
        this.packetTarget = new PacketTarget.RadiusTarget(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 256.0);
        for (double a = 0.0; a < 360.0; a += 1.0) {
            double dx = Math.cos(Math.toRadians(a));
            double dz = Math.sin(Math.toRadians(a));
            int c = CrystalElement.getBlendedColor((int)((a + 180.0 - 12.25) * 2.0), 45);
            this.particleRing.add(new RingParticle(dx, dz, c));
        }
    }

    public void start() {
        this.disableCores();
        this.running = true;
        runningRituals = true;
        if (this.world.field_72995_K) {
            this.currentSound = 0;
            this.startClient();
        }
        this.completionTime = -1L;
        this.startTime = System.currentTimeMillis();
        this.startTick = this.world.func_82737_E();
        this.runTime = 0L;
        this.tick = 0;
        this.lastTickTime = this.startTime;
        this.pauseTotal = 0L;
    }

    private void disableCores() {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            Coordinate c = TileEntityDimensionCore.getLocation(e).offset(this.x, this.y, this.z);
            ((TileEntityDimensionCore)c.getTileEntity((IBlockAccess)this.world)).prime(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void startClient() {
        ISound s = ChromaDimensionTicker.instance.getCurrentMusic();
        if (s != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(s);
        }
        this.stepSound();
        reBobView = Minecraft.func_71410_x().field_71474_y.field_74336_f;
        reShowGui = !Minecraft.func_71410_x().field_71474_y.field_74319_N;
    }

    private void stepSound() {
        int idx = this.currentSound++;
        SoundVariant s = ChromaSounds.MONUMENT.getVariant(String.valueOf(idx + 1));
        this.playingSound = ReikaSoundHelper.playClientSound((SoundEnum)s, (double)((double)this.x + 0.5), (double)((double)this.y + 0.5), (double)((double)this.z + 0.5), (float)1.0f, (float)1.0f, (boolean)false);
        this.lastSoundStart = this.runTime;
        long l = this.nextSoundTime = this.currentSound >= this.SOUND_TIMINGS.length ? Long.MAX_VALUE : this.runTime + this.SOUND_TIMINGS[this.currentSound] - this.SOUND_TIMINGS[idx];
        if (this.world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue()) {
            // empty if block
        }
    }

    public void tick() {
        if (this.running) {
            long time = System.currentTimeMillis();
            long step = time - this.lastTickTime;
            if (step > 50L) {
                this.pauseTotal += step - 50L;
            }
            this.runTime = time - (this.startTime + this.pauseTotal);
            ++this.tick;
            if (this.world.field_72995_K) {
                this.manipulateCamera();
                this.doScriptedFX();
            } else if (this.isReadyToComplete()) {
                this.completeRitual();
            }
            this.lastTickTime = time;
        }
    }

    private boolean isReadyToComplete() {
        return this.runTime - this.SOUND_TIMINGS[this.SOUND_TIMINGS.length - 1] >= (long)(20000 - (this.world.field_73011_w.field_76574_g == ExtraChromaIDs.DIMID.getValue() ? 4000 : 0));
    }

    @SideOnly(value=Side.CLIENT)
    private void doScriptedFX() {
        boolean flag;
        this.doRingFX();
        this.doVortexFX();
        if (this.runTime >= this.nextSoundTime) {
            this.stepSound();
        }
        boolean bl = flag = !this.events.isEmpty();
        while (flag) {
            flag = false;
            TimedEvent e = this.events.get(0);
            if (e.millis > this.runTime) continue;
            this.events.remove(0);
            boolean bl2 = flag = !this.events.isEmpty();
            if (e instanceof RayEvent) {
                RayEvent r = (RayEvent)e;
                this.activeKey = r.ray.key;
                this.playRayNote(r.ray);
                continue;
            }
            e.type.doEventClient(this);
            this.onEvent(e.type);
        }
        if (this.complete) {
            this.activeKey = null;
        }
        Set<CrystalElement> set = this.activeKey == null ? null : CrystalMusicManager.instance.getColorsWithKeyAnyOctave(this.activeKey);
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            MonumentCompletionRitual.colorFade[i] = set != null && set.contains(e) ? Math.min(1.0f, colorFade[i] + 0.04f) : Math.max(0.0f, colorFade[i] - 0.015f);
            TileEntityDimensionCore te = this.getCore(e);
            MonumentCompletionRitual.shaderPositions[i] = Vec3.func_72443_a((double)((double)te.field_145851_c + 0.5), (double)((double)this.y - 3.5), (double)((double)te.field_145849_e + 0.5));
            MonumentCompletionRitual.shaderColors[i] = new Vec4((float)e.getRed() / 255.0f, (float)e.getGreen() / 255.0f, (float)e.getBlue() / 255.0f, colorFade[i] * 0.7f);
            te.shaderScale = 1.0f + colorFade[i] * 5.0f;
        }
    }

    private TileEntityDimensionCore getCore(CrystalElement e) {
        return (TileEntityDimensionCore)TileEntityDimensionCore.getLocation(e).offset(this.x, this.y, this.z).getTileEntity((IBlockAccess)this.world);
    }

    private void playRayNote(RayNote n) {
        this.doRays(n);
    }

    private void onEvent(EventType type) {
        switch (type) {
            case FLARES: {
                break;
            }
            case PARTICLECLOUD: {
                break;
            }
            case PARTICLERING: {
                break;
            }
            case PINWHEEL: {
                break;
            }
            case TWIRL: {
                break;
            }
            case VORTEXGROW: {
                this.vortexGrow = true;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doVortexFX() {
        double y0 = (double)this.y + 0.5 - 4.5;
        double h = 0.0;
        double vy = 0.25;
        double r = 2.25 - h / 3.0 + 0.5 * (double)this.vortexSize;
        for (double a = 0.0; a < 360.0; a += 30.0) {
            double ang = a + h * 30.0 + (double)System.currentTimeMillis() / 20.0 % 360.0;
            double dx = (double)this.x + 0.5 + r * Math.cos(Math.toRadians(ang));
            double dz = (double)this.z + 0.5 + r * Math.sin(Math.toRadians(ang));
            double vx = ((double)this.x + 0.5 - dx) * 0.01875 / (double)this.vortexSize;
            double vz = ((double)this.z + 0.5 - dz) * 0.01875 / (double)this.vortexSize;
            double dy = y0 + h;
            float s = 4.0f;
            int l = a % 60.0 == 0.0 ? 60 : 40;
            l = (int)((float)l * this.vortexSize);
            EntityCCBlurFX fx = new EntityCCBlurFX(this.world, dx, dy, dz, vx, vy, vz);
            fx.setIcon(ChromaIcons.CHROMA);
            fx.setScale(s).setLife(l).setRapidExpand();
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        if (this.vortexSize < 1.0f) {
            this.vortexSize = Math.min(1.0f, this.vortexSize + 0.02f);
        } else if (this.vortexGrow) {
            this.vortexSize = Math.min(2.0f, this.vortexSize + 0.05f);
            this.vortexGrow = this.vortexSize < 2.0f;
        } else if (this.vortexSize > 1.0f) {
            this.vortexSize = Math.max(1.0f, this.vortexSize * 0.998f - 0.01f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doRingFX() {
        int i;
        int n = 3;
        int di = this.particleRing.size() / n;
        for (i = 0; i < n; ++i) {
            int idx = (this.tick + di * i) % this.particleRing.size();
            RingParticle p = this.particleRing.get(idx);
            p.particleSizeFactorVelocity = 0.5f;
            p.particleSizeFactor = 1.0f;
        }
        for (i = 0; i < this.particleRing.size(); ++i) {
            RingParticle p = this.particleRing.get(i);
            p.particleSizeFactor = Math.min(1.0f, p.particleSizeFactor + p.particleSizeFactorVelocity);
            p.particleSizeFactorVelocity = Math.max(-0.1f, p.particleSizeFactorVelocity - 0.05f);
            if (p.particleSizeFactor <= 0.0f) continue;
            double r = 32.5 - 2.5 * Math.abs(Math.sin(Math.toRadians(i * 2)));
            double dx = (double)this.x + 0.5 + 0.5 * r * p.offsetX;
            double dz = (double)this.z + 0.5 + 0.5 * r * p.offsetZ;
            float s = p.particleSizeFactor * (1.0f + rand.nextFloat()) * 4.0f;
            int l = (int)(p.particleSizeFactor * (float)(60 + rand.nextInt(40)));
            float g = p.particleSizeFactor * p.particleSizeFactor * p.particleSizeFactor * (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
            EntityCCBlurFX fx = new EntityCCBlurFX(this.world, dx, (double)this.y + 6.5, dz);
            fx.setIcon(ChromaIcons.CENTER).forceIgnoreLimits().setScale(s).setColor(p.color).setLife(l).setRapidExpand().setGravity(g);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void manipulateCamera() {
        Minecraft.func_71410_x().field_71474_y.field_74319_N = true;
        Minecraft.func_71410_x().field_71474_y.field_74336_f = false;
        Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
        double ang = (double)(this.world.func_82737_E() + (long)(this.ep.func_110124_au().hashCode() % 8000)) / 2.0;
        double angPrev = (double)(this.world.func_82737_E() + (long)(this.ep.func_110124_au().hashCode() % 8000) - 1L) / 2.0;
        double r = 32.5;
        double R = 40.0;
        double d = 12.1875;
        double cx = (double)this.x + 0.5 + (R - r) * Math.cos(Math.toRadians(ang)) + d * Math.cos(Math.toRadians((R - r) / r * ang));
        double cz = (double)this.z + 0.5 + (R - r) * Math.sin(Math.toRadians(ang)) - d * Math.sin(Math.toRadians((R - r) / r * ang));
        double cxPrev = (double)this.x + 0.5 + (R - r) * Math.cos(Math.toRadians(angPrev)) + d * Math.cos(Math.toRadians((R - r) / r * angPrev));
        double czPrev = (double)this.z + 0.5 + (R - r) * Math.sin(Math.toRadians(angPrev)) - d * Math.sin(Math.toRadians((R - r) / r * angPrev));
        double dd = ReikaMathLibrary.py3d((double)(cx - (double)this.x - 0.5), (double)0.0, (double)(cz - (double)this.z - 0.5));
        double ddPrev = ReikaMathLibrary.py3d((double)(cxPrev - (double)this.x - 0.5), (double)0.0, (double)(czPrev - (double)this.z - 0.5));
        double cy = (double)(this.y + 15 + 4 + 4) - 0.25 * dd + 4.0 * Math.sin(Math.toRadians(ang / 4.0)) - 2.0;
        double cyPrev = (double)(this.y + 15 + 4 + 4) - 0.25 * ddPrev + 4.0 * Math.sin(Math.toRadians(angPrev / 4.0)) - 2.0;
        double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(cx - (double)this.x - 0.5), (double)(cy - (double)this.y - 0.5), (double)(cz - (double)this.z - 0.5));
        double[] angsPrev = ReikaPhysicsHelper.cartesianToPolar((double)(cxPrev - (double)this.x - 0.5), (double)(cyPrev - (double)this.y - 0.5), (double)(czPrev - (double)this.z - 0.5));
        double pitch = 90.0 - angs[1];
        double pitchPrev = 90.0 - angsPrev[1];
        double yaw = -angs[2];
        double yawPrev = -angsPrev[2];
        ReikaRenderHelper.setCameraPosition((EntityPlayer)this.ep, (double)cx, (double)cy, (double)cz, (double)cxPrev, (double)cyPrev, (double)czPrev, (double)yaw, (double)yawPrev, (double)pitch, (double)pitchPrev, (boolean)true, (boolean)true);
    }

    public boolean doChecks() {
        EntityPlayer ep = null;
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            Coordinate c = TileEntityDimensionCore.getLocation(e).offset(this.x, this.y, this.z);
            ChromaTiles t = ChromaTiles.getTileFromIDandMetadata(c.getBlock((IBlockAccess)this.world), c.getBlockMetadata((IBlockAccess)this.world));
            if (t != ChromaTiles.DIMENSIONCORE) {
                this.endRitual();
                return false;
            }
            TileEntityDimensionCore te = (TileEntityDimensionCore)c.getTileEntity((IBlockAccess)this.world);
            if (te.getColor() != e) {
                this.endRitual();
                return false;
            }
            EntityPlayer own = te.getPlacer();
            if (own == null || ReikaPlayerAPI.isFake((EntityPlayer)own)) continue;
            if (ep == null || own == ep) {
                ep = own;
                continue;
            }
            this.endRitual();
            return false;
        }
        if (ep == null) {
            this.endRitual();
            return false;
        }
        if (!this.doMineralChecks()) {
            this.endRitual();
            return false;
        }
        return true;
    }

    private boolean doMineralChecks() {
        if (this.world.field_72995_K) {
            return true;
        }
        MonumentGenerator gen = ChunkProviderChroma.getMonumentGenerator();
        if (this.world.field_73011_w.field_76574_g == 0) {
            gen = new MonumentGenerator();
            gen.startCalculate(this.x, this.z, rand);
        }
        Map<Coordinate, Block> map = gen.getMineralBlocks();
        for (Coordinate c : map.keySet()) {
            Block b = c.getBlock((IBlockAccess)this.world);
            if (b == map.get(c)) continue;
            return false;
        }
        return true;
    }

    private void completeRitual() {
        if (this.completionTime < 0L) {
            this.completionTime = this.runTime;
        }
        if (this.runTime - this.completionTime < 3000L) {
            if (!this.complete) {
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.MONUMENTCOMPLETE.ordinal(), (PacketTarget)this.packetTarget, (int[])new int[]{this.x, this.y, this.z});
            }
            double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(this.ep.field_70165_t - (double)this.x - 0.5), (double)(this.ep.field_70163_u - (double)this.y - 0.5), (double)(this.ep.field_70161_v - (double)this.z - 0.5));
            double pitch = 90.0 - angs[1];
            double yaw = -angs[2];
            this.ep.field_70758_at = this.ep.field_70126_B = (float)yaw;
            this.ep.field_70759_as = this.ep.field_70126_B;
            this.ep.field_70177_z = this.ep.field_70126_B;
            this.ep.field_70125_A = this.ep.field_70127_C = (float)pitch;
        } else {
            this.world.func_147465_d(this.x, this.y, this.z, ChromaTiles.AURAPOINT.getBlock(), ChromaTiles.AURAPOINT.getBlockMetadata(), 3);
            TileEntityAuraPoint te = (TileEntityAuraPoint)this.world.func_147438_o(this.x, this.y, this.z);
            te.setPlacer(this.ep);
            this.ep.func_70012_b((double)this.x + 0.5, (double)(this.y - 4), (double)this.z - 4.5, 0.0f, -25.0f);
            this.ep.field_70122_E = true;
            this.ep.field_70179_y = 0.0;
            this.ep.field_70181_x = 0.0;
            this.ep.field_70159_w = 0.0;
            ProgressStage.CTM.stepPlayerTo(this.ep);
            if (!this.world.field_72995_K) {
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.RESETMONUMENT.ordinal(), (PacketTarget)this.packetTarget, (int[])new int[]{this.x, this.y, this.z});
            }
            this.running = false;
        }
        this.complete = true;
    }

    public void endRitual() {
        this.running = false;
        this.runTime = -1L;
        this.currentSound = -1;
        runningRituals = false;
        ((TileEntityStructControl)this.world.func_147438_o(this.x, this.y, this.z)).endMonumentRitual();
        ChromaSounds.ERROR.playSoundNoAttenuation(this.world, this.x, this.y, this.z, 1.0f, 0.75f, Integer.MAX_VALUE);
        if (this.world.field_72995_K) {
            this.endSounds();
        } else {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.RESETMONUMENT.ordinal(), (PacketTarget)this.packetTarget, (int[])new int[]{this.x, this.y, this.z});
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void endSounds() {
        if (this.playingSound != null) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(this.playingSound);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isComplete() {
        return this.complete;
    }

    @SideOnly(value=Side.CLIENT)
    public static void completeMonumentClient(World world, int x, int y, int z) {
        int i;
        int n = 32 + rand.nextInt(64);
        for (i = 0; i < n; ++i) {
            double phi = rand.nextDouble() * 360.0;
            double theta = ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)90.0);
            double v = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.5);
            double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)v, (double)theta, (double)phi);
            int c = CrystalElement.randomElement().getColor();
            int l = 30 + rand.nextInt(40);
            EntityFloatingSeedsFX fx = (EntityFloatingSeedsFX)new EntityCCFloatingSeedsFX(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, phi, theta).setColor(c).setScale(6.0f).setLife(l);
            fx.particleVelocity *= 3.0;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
        }
        for (i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            Coordinate c = TileEntityDimensionCore.getLocation(e).offset(x, y, z);
            TileEntityDimensionCore.createBeamLine(world, x, y, z, c.xCoord, c.yCoord, c.zCoord, CrystalElement.WHITE, e);
        }
        Minecraft.func_71410_x().field_71474_y.field_74319_N = !reShowGui;
        Minecraft.func_71410_x().field_71474_y.field_74336_f = reBobView;
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetSettings(World world, int x, int y, int z) {
        Minecraft.func_71410_x().field_71474_y.field_74319_N = false;
        Minecraft.func_71410_x().field_71474_y.field_74320_O = 0;
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        double[] angs = ReikaPhysicsHelper.cartesianToPolar((double)(ep.field_70165_t - (double)x - 0.5), (double)(ep.field_70163_u - (double)y - 0.5), (double)(ep.field_70161_v - (double)z - 0.5));
        double pitch = 90.0 - angs[1];
        double yaw = -angs[2];
        ReikaRenderHelper.setCameraPosition((EntityPlayer)ep, (double)ep.field_70165_t, (double)ep.field_70163_u, (double)ep.field_70161_v, (double)ep.field_70165_t, (double)ep.field_70163_u, (double)ep.field_70161_v, (double)yaw, (double)yaw, (double)pitch, (double)pitch, (boolean)false, (boolean)true);
    }

    private void doRays(RayNote n) {
        float p = (float)CrystalMusicManager.instance.getPitchFactor(n.key);
        Set<CrystalElement> set = CrystalMusicManager.instance.getColorsWithKeyAnyOctave(n.key);
        for (CrystalElement e : set) {
            int time = ReikaRandomHelper.getRandomBetween((int)10, (int)(2390 * n.length / 50 - 15));
            TickScheduler.instance.scheduleEvent(new ScheduledTickEvent((ScheduledTickEvent.ScheduledEvent)new ScheduledRayEvent(e, this.world, this.x, this.y, this.z, p)), time);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void doRay(CrystalElement e, World world, int x, int y, int z, float p) {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.MONUMENTRAY, (double)((double)x + 0.5), (double)((double)y + 0.5), (double)((double)z + 0.5), (float)((float)ReikaRandomHelper.getRandomBetween((double)0.4, (double)0.8)), (float)p, (boolean)false);
        Coordinate c = TileEntityDimensionCore.getLocation(e).offset(x, y, z);
        DecimalPosition end = new DecimalPosition((double)c.xCoord + 0.5, (double)c.yCoord + 0.5, (double)c.zCoord + 0.5);
        LightningBolt b = new LightningBolt(new DecimalPosition((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), end, 8);
        b.scaleVariance(1.25);
        b.maximize();
        int l = 20 + rand.nextInt(40);
        for (int i = 0; i < b.nsteps; ++i) {
            DecimalPosition pos1 = b.getPosition(i);
            DecimalPosition pos2 = b.getPosition(i + 1);
            for (double r = 0.0; r <= 1.0; r += 0.03125) {
                float s = 5.0f;
                int clr = e.getColor();
                DecimalPosition dd = DecimalPosition.interpolate((DecimalPosition)pos1, (DecimalPosition)pos2, (double)r);
                EntityBlurFX fx = new EntityCCBlurFX(world, dd.xCoord, dd.yCoord, dd.zCoord).setScale(s).setColor(clr).setLife(l).setRapidExpand();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                EntityBlurFX fx2 = new EntityCCBlurFX(world, dd.xCoord, dd.yCoord, dd.zCoord).setScale(s / 2.5f).setColor(0xFFFFFF).setLife(l).setRapidExpand();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
            }
        }
    }

    static {
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.A4, 2, true, false, true));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.C5, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.B4, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.G4, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.A4, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.E4, 6, false, true));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.A4, 2, true, false, true));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.C5, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.B4, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.G5, 4, false, true));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.E5, 6));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.A5, 2, true, true, true));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.G5, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.E5, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.C5, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.D5, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.A4, 6, false, true));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.A4, 2, true, false, true));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.E5, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.D5, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.G4, 2));
        melody.add(new RayNote(ReikaMusicHelper.MusicKey.A4, 8, true, true));
    }

    public static enum EventType {
        FLARES,
        PARTICLECLOUD,
        PARTICLERING,
        TWIRL,
        PINWHEEL,
        VORTEXGROW;

        private static final EventType[] list;

        @SideOnly(value=Side.CLIENT)
        private void doEventClient(MonumentCompletionRitual m) {
            this.doEventClient(m.world, m.x, m.y, m.z);
        }

        @SideOnly(value=Side.CLIENT)
        public void doEventClient(World world, int x, int y, int z) {
            switch (this) {
                case FLARES: {
                    int n = 32 + rand.nextInt(48);
                    for (int i = 0; i < n; ++i) {
                        double phi = rand.nextDouble() * 360.0;
                        double theta = rand.nextDouble() * 360.0;
                        double v = ReikaRandomHelper.getRandomBetween((double)0.125, (double)0.5);
                        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)v, (double)theta, (double)phi);
                        EntityFlareFX fx = new EntityFlareFX(CrystalElement.WHITE, world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, xyz[0], xyz[1], xyz[2]).setScale(6.0f);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    break;
                }
                case PARTICLECLOUD: {
                    int n = ReikaRandomHelper.getRandomBetween((int)256, (int)384);
                    double mr = 25.0;
                    for (int i = 0; i < n; ++i) {
                        double angd = rand.nextDouble() * 360.0;
                        double ang = Math.toRadians(angd);
                        double fr = rand.nextDouble();
                        double r = fr * mr;
                        double dx = (double)x + 0.5 + r * Math.cos(ang);
                        double dz = (double)z + 0.5 + r * Math.sin(ang);
                        int h = rand.nextInt(rand.nextBoolean() ? 6 : 12);
                        double dy = 1 + world.func_72825_h(MathHelper.func_76128_c((double)dx), MathHelper.func_76128_c((double)dz)) + h;
                        int l = ReikaRandomHelper.getRandomBetween((int)120, (int)240);
                        float s = (float)ReikaRandomHelper.getRandomBetween((double)4.0, (double)12.0);
                        int c = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)((int)angd));
                        c = ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)Math.min(1.0f, (float)(fr * fr * 4.0)));
                        EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(world, dx, dy, dz, 0.0, 90.0);
                        fx.angleVelocity *= 7.0;
                        fx.freedom *= 1.5;
                        fx.tolerance *= 0.33;
                        fx.particleVelocity *= 0.5;
                        fx.setIcon(ChromaIcons.BIGFLARE).setScale(s).setColor(c).setLife(l).setRapidExpand();
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    break;
                }
                case PARTICLERING: {
                    double r = 16.5;
                    double dy = (double)y + 0.5 + 6.0;
                    for (double a = 0.0; a < 360.0; a += 1.0) {
                        double dx = (double)x + 0.5 + r * Math.cos(Math.toRadians(a));
                        double dz = (double)z + 0.5 + r * Math.sin(Math.toRadians(a));
                        float s = (1.0f + rand.nextFloat()) * 4.0f;
                        int c = CrystalElement.getBlendedColor((int)((a + 180.0 - 12.25) * 2.0), 45);
                        int l = 60 + rand.nextInt(40);
                        float g = (float)ReikaRandomHelper.getRandomPlusMinus((double)0.0, (double)0.125);
                        EntityBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz).setIcon(ChromaIcons.CENTER).setScale(s).setColor(c).setLife(l).setRapidExpand().setGravity(g);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    break;
                }
                case TWIRL: {
                    double dy = (double)y + 0.5 - 4.0;
                    for (int i = 0; i <= 8; i += 4) {
                        for (double a = 0.0; a < 360.0; a += (double)(30 / (1 + i / 4))) {
                            double r = 2 + i;
                            double ang = a + (double)i * 22.5;
                            double dx = (double)x + 0.5 + r * Math.cos(Math.toRadians(ang));
                            double dz = (double)z + 0.5 + r * Math.sin(Math.toRadians(ang));
                            float s = (float)((4.0 - r / 8.0) * 2.0) / 2.0f;
                            int c = ReikaColorAPI.getModifiedHue((int)0xFF0000, (int)((int)ang));
                            int l = 120 + rand.nextInt(120);
                            SpiralMotionController m = new SpiralMotionController((double)x + 0.5, (double)z + 0.5, 4.0 - (double)i / 4.0, 0.25 * (1.0 + (double)i / 4.0) / 4.0, r, 0.125, ang);
                            AngleColorController clr = new AngleColorController((double)x + 0.5, (double)z + 0.5, 5.0 - (double)i / 4.0, 0.25 * (1.0 + (double)i / 4.0) / 4.0, r, 0.0625, ang);
                            EntityBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz).setScale(s).setColor(c).setLife(l).setRapidExpand().setMotionController((MotionController)m).setPositionController((PositionController)m).setColorController((ColorController)clr);
                            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                        }
                    }
                    break;
                }
                case PINWHEEL: {
                    double dy = (double)y + 0.5 - 4.0;
                    for (double a = 0.0; a < 360.0; a += 24.0) {
                        for (double r = 3.0; r <= 15.0; r += 0.25) {
                            double ang = a - r * 6.0;
                            double dx = (double)x + 0.5 + r * Math.cos(Math.toRadians(ang));
                            double dz = (double)z + 0.5 + r * Math.sin(Math.toRadians(ang));
                            float s = (float)(7.5 - r / 2.5);
                            int l = 60;
                            SpiralMotionController m = new SpiralMotionController((double)x + 0.5, (double)z + 0.5, r / 3.0, 0.0, r, 0.0, ang);
                            EntityCCBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz);
                            fx.setScale(s).setLife(l).setAlphaFading();
                            fx.setMotionController((MotionController)m).setPositionController((PositionController)m);
                            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                        }
                    }
                    break;
                }
            }
        }

        static {
            list = EventType.values();
        }
    }

    private static class ScheduledRayEvent
    implements ScheduledTickEvent.ScheduledEvent {
        private final CrystalElement color;
        private final World world;
        private final int x;
        private final int y;
        private final int z;
        private final float pitch;

        public ScheduledRayEvent(CrystalElement e, World w, int x, int y, int z, float p) {
            this.color = e;
            this.world = w;
            this.x = x;
            this.y = y;
            this.z = z;
            this.pitch = p;
        }

        public void fire() {
            MonumentCompletionRitual.doRay(this.color, this.world, this.x, this.y, this.z, this.pitch);
        }

        public boolean runOnSide(Side s) {
            return s == Side.CLIENT;
        }
    }

    private static class TimedEvent
    implements Comparable<TimedEvent> {
        private final EventType type;
        private final long millis;

        private TimedEvent(EventType e, long s) {
            this.type = e;
            this.millis = s;
        }

        @Override
        public final int compareTo(TimedEvent o) {
            return Long.compare(this.millis, o.millis);
        }
    }

    private static class RayEvent
    extends TimedEvent {
        private final RayNote ray;

        private RayEvent(RayNote r, long s) {
            super(null, s);
            this.ray = r;
        }
    }

    private static class RingParticle {
        private final double offsetX;
        private final double offsetZ;
        private final int color;
        private float particleSizeFactor = 0.5f;
        private float particleSizeFactorVelocity = 0.0f;

        private RingParticle(double x, double z, int c) {
            this.offsetX = x;
            this.offsetZ = z;
            this.color = c;
        }
    }

    private static class RayNote {
        private final ReikaMusicHelper.MusicKey key;
        private final int length;
        private final int startBeat;
        private final boolean percussion;
        private final boolean bell;
        private final boolean isFirstInPhrase;

        private RayNote(ReikaMusicHelper.MusicKey k, int dur) {
            this(k, dur, false, false);
        }

        private RayNote(ReikaMusicHelper.MusicKey k, int dur, boolean p, boolean b) {
            this(k, dur, p, b, false);
        }

        private RayNote(ReikaMusicHelper.MusicKey k, int dur, boolean p, boolean b, boolean first) {
            this.key = k;
            this.startBeat = melody.isEmpty() ? 0 : ((RayNote)melody.get((int)(melody.size() - 1))).startBeat + ((RayNote)melody.get((int)(melody.size() - 1))).length;
            this.length = dur;
            this.percussion = p;
            this.bell = b;
            this.isFirstInPhrase = first;
        }

        public String toString() {
            return this.key.toString() + " @ " + this.startBeat + "-" + this.length + " [P=" + this.percussion + "/B=" + this.bell + "/F=" + this.isFirstInPhrase + "]";
        }
    }
}

