/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.DynamicRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.ReactiveRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.WrapperTile;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Magic.Network.PathNode;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import java.util.ArrayList;
import java.util.List;

public final class CrystalFlow
extends CrystalPath {
    private static final int MIN_THROUGHPUT = 10;
    public final int maxFlow;
    private final int requestedAmount;
    public final int totalCost;
    public final CrystalReceiver receiver;
    private final int throughputLimit;
    private int remainingAmount;
    private int throttle = Integer.MAX_VALUE;

    CrystalFlow(CrystalNetworker net, CrystalPath p, CrystalReceiver r, int amt, int maxthru) {
        this(net, r, p.element, amt, p.nodes, maxthru);
    }

    protected CrystalFlow(CrystalNetworker net, CrystalReceiver r, CrystalElement e, int amt, List li, int maxthru) {
        super(net, !(r instanceof WrapperTile), e, li);
        this.requestedAmount = amt;
        this.remainingAmount = this.totalCost = this.requestedAmount + this.getSignalLoss();
        this.receiver = r;
        CrystalNetworkLogger.logPathCalculation("maxthru", maxthru);
        this.throughputLimit = maxthru;
        this.maxFlow = this.calcEffectiveThroughput(maxthru);
        if (this.maxFlow > 0 || this.totalCost == 0) {
            this.buildLeyLines();
        }
        for (PathNode p : this.nodes) {
            p.flush();
        }
    }

    private int calcEffectiveThroughput(int maxthru) {
        int insured = 10;
        int bonus = 0;
        int base = Math.min(this.transmitter.maxThroughput(), this.receiver.maxThroughput());
        ArrayList<DynamicRepeater> dynamics = new ArrayList<DynamicRepeater>();
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            PathNode pn = (PathNode)this.nodes.get(i);
            CrystalNetworkTile te = ((PathNode)this.nodes.get(i)).getTile(true);
            base = Math.min(base, te.maxThroughput());
            if (!pn.isRepeater()) continue;
            insured = Math.max(insured, ((CrystalRepeater)te).getThoughputInsurance());
            bonus += ((CrystalRepeater)te).getThoughputBonus(this.hasLocus);
            if (!DynamicRepeater.class.isAssignableFrom(pn.tileClass)) continue;
            dynamics.add((DynamicRepeater)te);
        }
        if (base == 0) {
            return 0;
        }
        int result = Math.min(Math.max(insured, base - this.getThroughputPenalty(base) + bonus), Math.min(maxthru, base));
        if (CrystalNetworkLogger.getLogLevel().isAtLeast(CrystalNetworkLogger.LoggingLevel.PATHCALC)) {
            CrystalNetworkLogger.logPathCalculation("base", base);
            CrystalNetworkLogger.logPathCalculation("bonus", bonus);
            CrystalNetworkLogger.logPathCalculation("insured", insured);
            CrystalNetworkLogger.logPathCalculation("max/base", Math.min(maxthru, base));
            CrystalNetworkLogger.logPathCalculation("totalthru", result);
        }
        for (DynamicRepeater dr : dynamics) {
            result = dr.getModifiedThoughput(result, this.transmitter, this.receiver);
        }
        return result;
    }

    private int getThroughputPenalty(int rawthru) {
        int att = this.getSignalLoss();
        if (att <= 1) {
            return 0;
        }
        int amt = (int)Math.pow(att / 80, 1.5 + 0.5 * (double)(1.0f - this.getOptimizationFactor()));
        double x = rawthru / att - 1;
        if (att > rawthru) {
            double y = -Math.sqrt(-x) * (double)(rawthru - amt - 10);
            amt = (int)((long)amt + Math.round(y));
        } else if (att < rawthru) {
            x = Math.min(x, 1.0);
            double y = Math.sqrt(x) * (double)amt;
            amt = (int)((long)amt - Math.round(y));
        }
        return Math.max(0, amt);
    }

    CrystalPath asPath() {
        return new CrystalPath(this.network, this.hasRealTarget, this.element, this.nodes);
    }

    @Override
    protected void initialize() {
        super.initialize();
    }

    private void buildLeyLines() {
        PathNode locs = (PathNode)this.nodes.get(this.nodes.size() - 2);
        CrystalReceiver r = (CrystalReceiver)locs.getTile(true);
        DecimalPosition offset = r.getTargetRenderOffset(this.element);
        double sx = offset != null ? offset.xCoord : 0.0;
        double sy = offset != null ? offset.yCoord : 0.0;
        double sz = offset != null ? offset.zCoord : 0.0;
        CrystalSource src = (CrystalSource)((PathNode)this.nodes.get(this.nodes.size() - 1)).getTile(true);
        src.addTarget(locs.location, this.element, sx, sy, sz, r.getIncomingBeamRadius(), src.getMaximumBeamRadius());
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = ((PathNode)this.nodes.get(i)).getTile(true);
            if (!(te instanceof CrystalTransmitter)) continue;
            PathNode tg = (PathNode)this.nodes.get(i - 1);
            r = (CrystalReceiver)tg.getTile(true);
            offset = r.getTargetRenderOffset(this.element);
            double dx = offset != null ? offset.xCoord : 0.0;
            double dy = offset != null ? offset.yCoord : 0.0;
            double dz = offset != null ? offset.zCoord : 0.0;
            ((CrystalTransmitter)te).addTarget(tg.location, this.element, dx, dy, dz, r.getIncomingBeamRadius(), src.getMaximumBeamRadius());
        }
    }

    private String getTiles() {
        StringBuilder sb = new StringBuilder();
        sb.append("(0 is receiver, size-1 is source) N=");
        sb.append(this.nodes.size());
        sb.append("[");
        int i = 0;
        for (PathNode loc : this.nodes) {
            sb.append(i);
            sb.append("=");
            sb.append(loc.toString());
            sb.append(";");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    void resetTiles() {
        ((CrystalSource)((PathNode)this.nodes.get(this.nodes.size() - 1)).getTile(true)).removeTarget(((PathNode)this.nodes.get((int)(this.nodes.size() - 2))).location, this.element);
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = ((PathNode)this.nodes.get(i)).getTile(true);
            if (!(te instanceof CrystalTransmitter)) continue;
            WorldLocation tg = ((PathNode)this.nodes.get((int)(i - 1))).location;
            ((CrystalTransmitter)te).removeTarget(tg, this.element);
        }
    }

    public boolean isComplete() {
        return this.remainingAmount <= 0;
    }

    public int getRemainingLumens() {
        return this.remainingAmount;
    }

    public int estimateLifetime() {
        return this.getRemainingLumens() / this.getDrainThisTick();
    }

    int drain() {
        int ret = Math.min(this.transmitter.getEnergy(this.element), this.getDrainThisTick());
        if (ret <= 0) {
            return 0;
        }
        this.remainingAmount -= ret;
        return ret;
    }

    public int getDrainThisTick() {
        return Math.min(Math.min(Math.min(this.throttle, this.maxFlow), this.transmitter.maxThroughput()), this.remainingAmount);
    }

    void tickRepeaters(int amt) {
        if (this.hasReactiveRepeaters()) {
            for (int i = 1; i < this.nodes.size() - 1; ++i) {
                if (!ReactiveRepeater.class.isAssignableFrom(((PathNode)this.nodes.get((int)i)).tileClass)) continue;
                CrystalNetworkTile te = ((PathNode)this.nodes.get(i)).getTile(true);
                ((ReactiveRepeater)te).onTransfer(this.transmitter, this.receiver, this.element, amt);
            }
        }
    }

    @Override
    CrystalPath cleanExtraEndJumps() {
        return new CrystalFlow(this.network, super.cleanExtraEndJumps(), this.receiver, this.requestedAmount, this.throughputLimit);
    }
}

