/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.LinkWatchingRepeater;
import Reika.ChromatiCraft.Magic.Network.LOSData;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldChunk;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;

public final class CrystalLink {
    public final WorldLocation loc1;
    public final WorldLocation loc2;
    final HashSet<WorldChunk> chunks = new HashSet();
    private final HashSet<Coordinate> locations = new HashSet();
    boolean hasLOS = false;
    boolean isRainable = false;
    public final double length;
    private boolean activeEndpoint1 = false;
    private boolean activeEndpoint2 = false;
    boolean needsCalculation = true;

    CrystalLink(WorldLocation l1, WorldLocation l2) {
        this.loc1 = l1;
        this.loc2 = l2;
        double dd = l1.getDistanceTo(l2);
        World world = l1.getWorld();
        int i = 0;
        while ((double)i < dd) {
            int z;
            int x = MathHelper.func_76128_c((double)((double)l1.xCoord + (double)(i * (l2.xCoord - l1.xCoord)) / dd));
            WorldChunk ch = new WorldChunk(world, new ChunkCoordIntPair(x >> 4, (z = MathHelper.func_76128_c((double)((double)l1.zCoord + (double)(i * (l2.zCoord - l1.zCoord)) / dd))) >> 4));
            if (!this.chunks.contains(ch)) {
                this.chunks.add(ch);
            }
            ++i;
        }
        this.activeEndpoint1 = l1.getTileEntity() instanceof LinkWatchingRepeater;
        this.activeEndpoint2 = l2.getTileEntity() instanceof LinkWatchingRepeater;
        this.length = l1.getDistanceTo(l2);
    }

    private void recalculateLOS() {
        if (!this.needsCalculation) {
            return;
        }
        this.needsCalculation = false;
        LOSData los = PylonFinder.lineOfSight(this.loc1, this.loc2);
        this.hasLOS = los.hasLineOfSight;
        this.locations.clear();
        this.locations.addAll(los.blocks);
        this.isRainable = los.canRain;
        if (this.activeEndpoint1 || this.activeEndpoint2) {
            this.updateEndpoints();
        }
    }

    private void updateEndpoints() {
        TileEntity te2;
        TileEntity te1;
        if (this.activeEndpoint1 && (te1 = this.loc1.getTileEntity()) instanceof LinkWatchingRepeater) {
            ((LinkWatchingRepeater)te1).onLinkRecalculated(this);
        }
        if (this.activeEndpoint2 && (te2 = this.loc2.getTileEntity()) instanceof LinkWatchingRepeater) {
            ((LinkWatchingRepeater)te2).onLinkRecalculated(this);
        }
    }

    public boolean isChunkInPath(WorldChunk wc) {
        return this.chunks.contains(wc);
    }

    public boolean containsBlock(Coordinate c) {
        return this.locations.contains(c);
    }

    public final int hashCode() {
        return this.loc1.hashCode() ^ this.loc2.hashCode();
    }

    public final boolean equals(Object o) {
        if (o instanceof CrystalLink) {
            CrystalLink l = (CrystalLink)o;
            return l.loc1.equals((Object)this.loc1) && l.loc2.equals((Object)this.loc2) || l.loc1.equals((Object)this.loc2) && l.loc2.equals((Object)this.loc1);
        }
        return false;
    }

    public final String toString() {
        return "[" + this.loc1 + " > " + this.loc2 + "]";
    }

    final boolean hasLineOfSight() {
        if (this.needsCalculation) {
            this.recalculateLOS();
        }
        return this.hasLOS;
    }

    public boolean isRainable() {
        return this.isRainable;
    }

    public boolean hasLOS() {
        return this.hasLOS;
    }

    public CrystalNetworkTile getOtherEnd(CrystalNetworkTile te) {
        return PylonFinder.getNetTileAt(this.loc1.equals(te.getWorld(), te.getX(), te.getY(), te.getZ()) ? this.loc2 : this.loc1, true);
    }
}

