/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Magic.Interfaces.ConnectivityAction;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.ReactiveRepeater;
import Reika.ChromatiCraft.Magic.Network.CachedPathValidity;
import Reika.ChromatiCraft.Magic.Network.CrystalLink;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.JumpOptimizationCheck;
import Reika.ChromatiCraft.Magic.Network.PathNode;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldChunk;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CrystalPath
implements Comparable<CrystalPath> {
    protected final ArrayList<PathNode> nodes;
    public final CrystalSource transmitter;
    public final WorldLocation origin;
    public final CrystalElement element;
    private final HashSet<CrystalLink> links = new HashSet();
    protected final CrystalNetworker network;
    protected final boolean hasRealTarget;
    public final boolean hasLocus;
    private int attenuation;
    private int theoreticalRange;
    private double totalDistance;
    private boolean hasReactiveRepeaters;
    private boolean wasOptimized = false;

    protected CrystalPath(CrystalNetworker net, boolean real, CrystalElement e, List li) {
        this.nodes = li.get(0) instanceof PathNode ? new ArrayList(li) : CrystalPath.createNodeList(li);
        for (PathNode p : this.nodes) {
            p.cacheTile();
        }
        this.transmitter = (CrystalSource)this.nodes.get(this.nodes.size() - 1).getTile(true);
        this.origin = this.nodes.get((int)0).location;
        this.element = e;
        this.network = net;
        this.hasRealTarget = real;
        this.hasLocus = TileEntityAuraPoint.isPointWithin(this.transmitter.getWorld(), this.transmitter.getX(), this.transmitter.getY(), this.transmitter.getZ(), 1024);
        this.initialize();
        if (this.getClass() == CrystalPath.class) {
            for (PathNode p : this.nodes) {
                p.flush();
            }
        }
    }

    static ArrayList<PathNode> createNodeList(List<WorldLocation> li) {
        ArrayList<PathNode> ret = new ArrayList<PathNode>();
        for (int i = 0; i < li.size(); ++i) {
            ret.add(new PathNode(li.get(i), i, i == 0));
        }
        return ret;
    }

    private CrystalPath setOptimized() {
        this.wasOptimized = true;
        return this;
    }

    protected void initialize() {
        int loss = 0;
        int range = 0;
        double dist = 0.0;
        for (int i = 1; i < this.nodes.size(); ++i) {
            PathNode loc = this.nodes.get(i);
            PathNode prev = this.nodes.get(i - 1);
            CrystalLink l = this.network.getLink(prev.location, loc.location);
            CrystalNetworkTile te = loc.getTile(true);
            CrystalNetworkTile teprev = prev.getTile(true);
            range += Math.min(((CrystalReceiver)teprev).getReceiveRange(), ((CrystalTransmitter)te).getSendRange());
            dist += Math.sqrt(te.getDistanceSqTo((double)teprev.getX() + 0.5, (double)teprev.getY() + 0.5, (double)teprev.getZ() + 0.5));
            if (i < this.nodes.size() - 1 && te instanceof CrystalRepeater) {
                int atten = ((CrystalRepeater)te).getSignalDegradation(this.hasLocus);
                if (l.isRainable() && this.transmitter.getWorld().func_72896_J()) {
                    atten = (int)((double)atten * 1.15);
                }
                loss += atten;
                if (te instanceof ConnectivityAction) {
                    PathNode next = this.nodes.get(i + 1);
                    CrystalNetworkTile tenext = next.getTile(true);
                    ConnectivityAction ca = (ConnectivityAction)te;
                    ca.notifyReceivingFrom(this, (CrystalTransmitter)tenext);
                    ca.notifySendingTo(this, (CrystalReceiver)teprev);
                }
                if (te instanceof ReactiveRepeater) {
                    this.hasReactiveRepeaters = true;
                }
            }
            this.links.add(l);
        }
        this.attenuation = loss;
        this.totalDistance = dist;
        this.theoreticalRange = range;
    }

    public final void addBaseAttenuation(int amt) {
        if (amt > 0) {
            this.attenuation += amt;
        }
    }

    public final boolean containsLink(CrystalLink l) {
        return this.links.contains(l);
    }

    public final HashSet<WorldChunk> getRelevantChunks() {
        HashSet<WorldChunk> ret = new HashSet<WorldChunk>();
        for (CrystalLink l : this.links) {
            ret.addAll(l.chunks);
        }
        return ret;
    }

    public final int getSignalLoss() {
        return this.attenuation;
    }

    public final boolean canTransmit() {
        return true;
    }

    public final String toString() {
        return this.element + ": to " + this.origin + " from " + this.transmitter + ": " + this.nodes.size() + "x " + this.nodes.toString();
    }

    public final boolean contains(CrystalNetworkTile te) {
        return this.nodes.contains(new PathNode(te));
    }

    public final boolean checkLineOfSight() {
        return this.checkLineOfSight(null);
    }

    public final boolean checkLineOfSight(CrystalLink l) {
        for (int i = 0; i < this.nodes.size() - 2; ++i) {
            PathNode tgt = this.nodes.get(i);
            if (l != null && !tgt.location.equals((Object)l.loc1) && !tgt.location.equals((Object)l.loc2)) continue;
            PathNode src = this.nodes.get(i + 1);
            if (PylonFinder.lineOfSight((WorldLocation)src.location, (WorldLocation)tgt.location).hasLineOfSight) continue;
            CrystalReceiver rec = (CrystalReceiver)tgt.getTile(true);
            CrystalTransmitter sr = (CrystalTransmitter)src.getTile(true);
            if (!sr.needsLineOfSightToReceiver(rec) && !rec.needsLineOfSightFromTransmitter(sr)) continue;
            return false;
        }
        return true;
    }

    public final CachedPathValidity stillValid() {
        int i;
        if (this.transmitter.isRemoved() || this.hasRealTarget && PylonFinder.getNetTileAt(this.origin, false) == null) {
            return CachedPathValidity.BROKEN;
        }
        if (!this.transmitter.canConduct() || !this.transmitter.isConductingElement(this.element)) {
            return CachedPathValidity.DORMANT;
        }
        if (this.hasRealTarget) {
            CrystalReceiver tile = PylonFinder.getReceiverAt(this.origin, false);
            if (!tile.canConduct() || !tile.isConductingElement(this.element)) {
                return CachedPathValidity.DORMANT;
            }
            if (!tile.canBeSuppliedBy(this.transmitter, this.element) || !this.transmitter.canSupply(tile, this.element)) {
                return CachedPathValidity.DORMANT;
            }
        }
        int n = i = this.hasRealTarget ? 0 : 1;
        while (i < this.nodes.size() - 2) {
            CrystalLink l;
            PathNode tgt = this.nodes.get(i);
            PathNode src = this.nodes.get(i + 1);
            CrystalTransmitter sr = (CrystalTransmitter)src.getTile(false);
            CrystalReceiver rec = (CrystalReceiver)tgt.getTile(false);
            if (sr == null || rec == null) {
                return CachedPathValidity.BROKEN;
            }
            if (!sr.canConduct() || !sr.isConductingElement(this.element)) {
                return CachedPathValidity.DORMANT;
            }
            if ((sr.needsLineOfSightToReceiver(rec) || rec.needsLineOfSightFromTransmitter(sr)) && !(l = this.network.getLink(tgt.location, src.location)).hasLineOfSight()) {
                return CachedPathValidity.BLOCKED;
            }
            ++i;
        }
        return CachedPathValidity.VALID;
    }

    public final void blink(int ticks, CrystalReceiver r) {
        DecimalPosition offset;
        CrystalSource src = (CrystalSource)this.nodes.get(this.nodes.size() - 1).getTile(true);
        PathNode locs = this.nodes.get(this.nodes.size() - 2);
        if (r == null) {
            r = (CrystalReceiver)locs.getTile(true);
        }
        double sx = (offset = r.getTargetRenderOffset(this.element)) != null ? offset.xCoord : 0.0;
        double sy = offset != null ? offset.yCoord : 0.0;
        double sz = offset != null ? offset.zCoord : 0.0;
        src.addSelfTickingTarget(locs.location, this.element, sx, sy, sz, r.getIncomingBeamRadius(), this.transmitter.getMaximumBeamRadius(), ticks);
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = this.nodes.get(i).getTile(true);
            if (!(te instanceof CrystalTransmitter)) continue;
            PathNode tg = this.nodes.get(i - 1);
            r = (CrystalReceiver)tg.getTile(true);
            offset = r.getTargetRenderOffset(this.element);
            double dx = offset != null ? offset.xCoord : 0.0;
            double dy = offset != null ? offset.yCoord : 0.0;
            double dz = offset != null ? offset.zCoord : 0.0;
            ((CrystalTransmitter)te).addSelfTickingTarget(tg.location, this.element, dx, dy, dz, r.getIncomingBeamRadius(), this.transmitter.getMaximumBeamRadius(), ticks);
        }
    }

    public final void endBlink() {
        CrystalSource src = (CrystalSource)this.nodes.get(this.nodes.size() - 1).getTile(true);
        WorldLocation locs = this.nodes.get((int)(this.nodes.size() - 2)).location;
        src.removeTarget(locs, this.element);
        for (int i = 1; i < this.nodes.size() - 1; ++i) {
            CrystalNetworkTile te = this.nodes.get(i).getTile(false);
            if (!(te instanceof CrystalTransmitter)) continue;
            WorldLocation tg = this.nodes.get((int)(i - 1)).location;
            ((CrystalTransmitter)te).removeTarget(tg, this.element);
        }
    }

    public final float getOptimizationFactor() {
        return (float)((double)this.theoreticalRange / this.totalDistance);
    }

    @Override
    public final int compareTo(CrystalPath o) {
        return PylonFinder.getSourcePriority(o.transmitter, this.element) - PylonFinder.getSourcePriority(this.transmitter, this.element);
    }

    public final boolean equals(Object o) {
        if (o instanceof CrystalPath) {
            CrystalPath p = (CrystalPath)o;
            return p.element == this.element && p.nodes.equals(this.nodes);
        }
        return false;
    }

    public final int hashCode() {
        return this.nodes.hashCode() ^ this.element.ordinal();
    }

    public final ArrayList<CrystalNetworkTile> getTileList() {
        ArrayList<CrystalNetworkTile> li = new ArrayList<CrystalNetworkTile>();
        for (PathNode loc : this.nodes) {
            li.add(loc.getTile(true));
        }
        return li;
    }

    public final boolean hasSameEndpoints(CrystalPath p) {
        return PylonFinder.getLocation(this.transmitter).equals((Object)PylonFinder.getLocation(p.transmitter)) && this.origin.equals((Object)p.origin);
    }

    CrystalPath cleanExtraEndJumps() {
        return new CrystalPath(this.network, this.hasRealTarget, this.element, this.getCleanedNodePath());
    }

    protected final ArrayList<WorldLocation> getCleanedNodePath() {
        return CrystalPath.cleanRoute(this.network, this.element, this.nodes);
    }

    public final void optimize() {
        this.optimize(Integer.MAX_VALUE);
    }

    public final CrystalPath optimize(int nsteps) {
        ArrayList<PathNode> li = new ArrayList<PathNode>(this.nodes);
        boolean complete = PylonFinder.optimizeRoute(this.network, li, nsteps, JumpOptimizationCheck.always);
        CrystalPath p = new CrystalPath(this.network, this.hasRealTarget, this.element, li);
        if (complete) {
            p.setOptimized();
        }
        return p;
    }

    public final boolean isOptimized() {
        return this.wasOptimized;
    }

    protected final boolean hasReactiveRepeaters() {
        return this.hasReactiveRepeaters;
    }

    static final ArrayList<WorldLocation> cleanLocRoute(CrystalNetworker net, CrystalElement e, ArrayList<WorldLocation> nodes) {
        return CrystalPath.cleanRoute(net, e, CrystalPath.createNodeList(nodes));
    }

    static final ArrayList<WorldLocation> cleanRoute(CrystalNetworker net, CrystalElement e, ArrayList<PathNode> nodes) {
        ArrayList<WorldLocation> li = new ArrayList<WorldLocation>();
        li.add(0, nodes.get((int)(nodes.size() - 1)).location);
        for (int i = nodes.size() - 2; i > 0; --i) {
            li.add(0, nodes.get((int)i).location);
            CrystalTransmitter src = (CrystalTransmitter)nodes.get(i).getTile(true);
            CrystalReceiver tgt = (CrystalReceiver)nodes.get(0).getTile(true);
            if (net.canMakeConnection(src, tgt, e)) break;
        }
        li.add(0, nodes.get((int)0).location);
        return li;
    }
}

