/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import java.util.Comparator;

class NetworkSorters {
    static final SourcePrioritizer[] prioritizer = new SourcePrioritizer[16];

    NetworkSorters() {
    }

    static {
        for (int i = 0; i < 16; ++i) {
            NetworkSorters.prioritizer[i] = new SourcePrioritizer(CrystalElement.elements[i]);
        }
    }

    static class SourcePrioritizer
    implements Comparator<CrystalTransmitter> {
        private final CrystalElement color;

        private SourcePrioritizer(CrystalElement e) {
            this.color = e;
        }

        @Override
        public int compare(CrystalTransmitter o1, CrystalTransmitter o2) {
            if (o1 instanceof CrystalSource && o2 instanceof CrystalSource) {
                return -Integer.compare(PylonFinder.getSourcePriority((CrystalSource)o1, this.color), PylonFinder.getSourcePriority((CrystalSource)o2, this.color));
            }
            if (o1 instanceof CrystalSource) {
                return Integer.MIN_VALUE;
            }
            if (o2 instanceof CrystalSource) {
                return Integer.MAX_VALUE;
            }
            return -Integer.compare(o1.getPathPriority(), o2.getPathPriority());
        }
    }

    static class TransmitterDistanceSorter
    implements Comparator<CrystalTransmitter> {
        private final WorldLocation location;

        TransmitterDistanceSorter(CrystalReceiver r) {
            this.location = new WorldLocation(r.getWorld(), r.getX(), r.getY(), r.getZ());
        }

        @Override
        public int compare(CrystalTransmitter o1, CrystalTransmitter o2) {
            return (int)(o1.getDistanceSqTo(this.location.xCoord, this.location.yCoord, this.location.zCoord) - o2.getDistanceSqTo(this.location.xCoord, this.location.yCoord, this.location.zCoord));
        }
    }
}

