/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;

public class PathNode {
    public final WorldLocation location;
    public final Class<? extends CrystalNetworkTile> tileClass;
    public final int stepIndex;
    public final boolean isFinalTarget;
    private CrystalNetworkTile cachedTile;

    PathNode(WorldLocation loc, int i, boolean end) {
        this.location = loc;
        CrystalNetworkTile te = PylonFinder.getNetTileAt(this.location, false);
        if (te == null) {
            throw new IllegalStateException("CC Crystal Network: Created a path node from null?!");
        }
        this.tileClass = te != null ? te.getClass() : null;
        this.stepIndex = i;
        this.isFinalTarget = end;
    }

    PathNode(CrystalNetworkTile te) {
        this(new WorldLocation(te.getWorld(), te.getX(), te.getY(), te.getZ()), 0, false);
    }

    void cacheTile() {
        this.cachedTile = this.getTile(true);
    }

    void flush() {
        this.cachedTile = null;
    }

    public boolean isSource() {
        return CrystalSource.class.isAssignableFrom(this.tileClass);
    }

    public boolean isRepeater() {
        return CrystalRepeater.class.isAssignableFrom(this.tileClass);
    }

    CrystalNetworkTile getTile(boolean exception) {
        if (this.cachedTile != null) {
            return this.cachedTile;
        }
        if (this.isSource()) {
            return PylonFinder.getSourceAt(this.location, exception);
        }
        if (CrystalTransmitter.class.isAssignableFrom(this.tileClass)) {
            return PylonFinder.getTransmitterAt(this.location, exception);
        }
        if (CrystalReceiver.class.isAssignableFrom(this.tileClass)) {
            return PylonFinder.getReceiverAt(this.location, exception);
        }
        return PylonFinder.getNetTileAt(this.location, exception);
    }

    public String toString() {
        return "#" + this.stepIndex + ": " + this.tileClass + " @ " + this.location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof PathNode && this.location.equals((Object)((PathNode)o).location);
    }
}

