/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Auxiliary.CrystalNetworkLogger;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalNetworkTile;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalReceiver;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalRepeater;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalTransmitter;
import Reika.ChromatiCraft.Magic.Interfaces.WrapperTile;
import Reika.ChromatiCraft.Magic.Network.CachedPathValidity;
import Reika.ChromatiCraft.Magic.Network.CrystalFlow;
import Reika.ChromatiCraft.Magic.Network.CrystalLink;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.Network.CrystalPath;
import Reika.ChromatiCraft.Magic.Network.JumpOptimizationCheck;
import Reika.ChromatiCraft.Magic.Network.LOSData;
import Reika.ChromatiCraft.Magic.Network.NetworkSorters;
import Reika.ChromatiCraft.Magic.Network.PathNode;
import Reika.ChromatiCraft.Magic.Network.SourceValidityRule;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.NodeReceiverWrapper;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.NodeRecharger;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Decoration.TileEntityCrystalMusic;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCreativeSource;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntitySkypeater;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.RayTracer;
import Reika.DragonAPI.Libraries.World.ReikaBiomeHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ExtraUtilsHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.TinkerBlockHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import Reika.GeoStrata.Registry.GeoBlocks;
import Reika.RotaryCraft.Registry.BlockRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenDesert;

public class PylonFinder {
    public static final String LOGGER_ID = "PylonFinder";
    private final LinkedList<WorldLocation> nodes = new LinkedList();
    private final Collection<WorldLocation> blacklist = new HashSet<WorldLocation>();
    private final MultiMap<WorldLocation, WorldLocation> duplicates = new MultiMap(MultiMap.CollectionType.HASHSET);
    private final CrystalNetworker net;
    private static final RayTracer tracer;
    private final CrystalReceiver target;
    private final CrystalElement element;
    private final EntityPlayer user;
    private int maxSteps = Integer.MAX_VALUE;
    private int steps = 0;
    private int stepsThisTick = 0;
    private boolean suspended = false;
    public static final int MAX_STEPS_PER_TICK = 1000;
    private final boolean isValidWorld;
    private TileEntitySkypeater.NodeClass skypeaterEntry;
    private TileEntitySkypeater.NodeClass lastSkypeaterType;
    private static boolean invalid;
    private static final HashMap<WorldLocation, EnumMap<CrystalElement, ArrayList<CrystalPath>>> paths;

    PylonFinder(CrystalElement e, CrystalReceiver r, EntityPlayer ep) {
        this.element = e;
        this.target = r;
        this.net = CrystalNetworker.instance;
        this.blacklist.add(PylonFinder.getLocation(r));
        this.user = ep;
        this.isValidWorld = r.getWorld().field_73011_w.field_76574_g == 0 || PylonGenerator.instance.canGenerateIn(r.getWorld());
    }

    CrystalPath findPylon() {
        return this.findPylonWith(SourceValidityRule.ALWAYS);
    }

    CrystalPath findPylonWith(SourceValidityRule rule) {
        if (!this.isValidWorld) {
            return null;
        }
        invalid = false;
        CrystalPath p = this.checkExistingPaths();
        if (p != null) {
            return p;
        }
        if (!this.anyConnectedSources()) {
            return null;
        }
        this.findFrom(this.target, rule);
        if (this.isComplete()) {
            ArrayList<WorldLocation> li = new ArrayList<WorldLocation>(this.nodes);
            CrystalPath path = new CrystalPath(this.net, !(this.target instanceof WrapperTile), this.element, CrystalPath.cleanLocRoute(this.net, this.element, li));
            if (!(this.target instanceof WrapperTile)) {
                this.addValidPath(path);
            }
            return path;
        }
        return null;
    }

    CrystalFlow findPylon(int amount, int maxthru) {
        return this.findPylon(amount, maxthru, SourceValidityRule.ALWAYS);
    }

    CrystalFlow findPylon(int amount, int maxthru, SourceValidityRule rule) {
        if (!this.isValidWorld) {
            return null;
        }
        invalid = false;
        CrystalPath p = this.checkExistingPaths();
        if (p != null) {
            return new CrystalFlow(this.net, p, this.target, amount, maxthru);
        }
        if (!this.anyConnectedSources()) {
            return null;
        }
        this.findFrom(this.target, rule);
        if (this.isComplete()) {
            ArrayList<WorldLocation> li = new ArrayList<WorldLocation>(this.nodes);
            if (this.lastSkypeaterType != null) {
                this.optimizeSkypeaterRoute(li);
            }
            CrystalFlow flow = new CrystalFlow(this.net, this.target, this.element, amount, CrystalPath.cleanLocRoute(this.net, this.element, li), maxthru);
            if (!(this.target instanceof WrapperTile)) {
                this.addValidPath(flow.asPath());
            }
            return flow;
        }
        return null;
    }

    private void optimizeSkypeaterRoute(ArrayList<WorldLocation> path) {
        PylonFinder.optimizeRoute(this.net, CrystalPath.createNodeList(path), Integer.MAX_VALUE, new JumpOptimizationCheck(){

            @Override
            public boolean canDirectLink(CrystalNetworkTile t1, CrystalNetworkTile t2) {
                return t1 instanceof TileEntitySkypeater && t2 instanceof TileEntitySkypeater;
            }
        });
    }

    static boolean optimizeRoute(CrystalNetworker net, ArrayList<PathNode> path, int nsteps, JumpOptimizationCheck joc) {
        ArrayList<PathNode> li = new ArrayList<PathNode>(path);
        boolean flag = true;
        int cycles = 0;
        boolean limit = false;
        while (flag) {
            flag = false;
            for (int i = 0; i < li.size() && !flag; ++i) {
                for (int k = i; k < li.size() && !flag; ++k) {
                    if (i >= k || Math.abs(i - k) <= 1) continue;
                    PathNode loc = li.get(i);
                    PathNode loc2 = li.get(k);
                    CrystalNetworkTile te1 = PylonFinder.getNetTileAt(loc.location, true);
                    CrystalNetworkTile te2 = PylonFinder.getNetTileAt(loc2.location, true);
                    if (!(te1 instanceof CrystalReceiver) || !(te2 instanceof CrystalTransmitter) || !joc.canDirectLink(te1, te2)) continue;
                    double d = Math.min(((CrystalReceiver)te1).getReceiveRange(), ((CrystalTransmitter)te2).getSendRange());
                    if (!(te1.getDistanceSqTo(te2.getX(), te2.getY(), te2.getZ()) <= d * d) || !net.checkLOS((CrystalTransmitter)te2, (CrystalReceiver)te1)) continue;
                    while (k > i + 1) {
                        li.remove(k - 1);
                        --k;
                    }
                    flag = true;
                    ++cycles;
                }
            }
            if (cycles < nsteps) continue;
            flag = false;
            limit = true;
        }
        path.clear();
        path.addAll(li);
        return !limit;
    }

    private boolean anyConnectedSources() {
        if (this.net.size() > 100) {
            return true;
        }
        ArrayList<CrystalSource> li = this.net.getAllSourcesFor(this.element, true);
        if (ModularLogger.instance.isEnabled(LOGGER_ID)) {
            ModularLogger.instance.log(LOGGER_ID, "Found " + li.size() + " sources for " + this.element + ": " + li);
        }
        for (CrystalSource s : li) {
            if (!this.isSourceConnected(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isSourceConnected(CrystalSource s) {
        return this.target instanceof WrapperTile || s instanceof TileEntityCreativeSource || !this.net.getNearbyReceivers(s, this.element).isEmpty();
    }

    private CrystalPath checkExistingPaths() {
        ArrayList<CrystalPath> c;
        EnumMap<CrystalElement, ArrayList<CrystalPath>> map = paths.get(PylonFinder.getLocation(this.target));
        if (map != null && (c = map.get(this.element)) != null) {
            Iterator<CrystalPath> it = c.iterator();
            while (it.hasNext()) {
                CrystalPath p = it.next();
                CachedPathValidity state = p.stillValid();
                if (!state.shouldKeep()) {
                    it.remove();
                }
                if (!state.canConduct()) continue;
                return p;
            }
        }
        return null;
    }

    private void addValidPath(CrystalPath p) {
        ArrayList<Object> c;
        EnumMap<CrystalElement, ArrayList<CrystalPath>> map = paths.get(p.origin);
        if (map == null) {
            c = new ArrayList();
            map = new EnumMap(CrystalElement.class);
            c.add(p);
            map.put(this.element, c);
            paths.put(p.origin, map);
        } else {
            c = map.get(p.element);
            if (c == null) {
                c = new ArrayList();
                c.add(p);
                map.put(this.element, c);
            } else if (!c.contains(p)) {
                c.add(p);
            }
        }
        for (int i = 0; i < p.nodes.size(); ++i) {
            PathNode loc = p.nodes.get(i);
            CrystalNetworkTile te = loc.getTile(true);
            if (!(te instanceof CrystalRepeater)) continue;
            CrystalRepeater tile = (CrystalRepeater)te;
            tile.setSignalDepth(p.element, p.nodes.size() - 1 - i);
        }
        Collections.sort((List)paths.get(p.origin).get(p.element));
    }

    static void removePathsWithTile(CrystalNetworkTile te) {
        if (te == null) {
            return;
        }
        EnumMap<CrystalElement, ArrayList<CrystalPath>> map = paths.get(PylonFinder.getLocation(te));
        if (map != null) {
            for (CrystalElement e : map.keySet()) {
                ArrayList<CrystalPath> c = map.get(e);
                Iterator<CrystalPath> it = c.iterator();
                while (it.hasNext()) {
                    CrystalPath p = it.next();
                    if (!p.contains(te)) continue;
                    it.remove();
                }
            }
        }
    }

    public String toString() {
        return this.element + ": " + this.target;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isComplete() {
        if (this.nodes.size() < 2) return false;
        if (PylonFinder.getSourceAt(this.nodes.getLast(), false) == null) return false;
        return true;
    }

    private void findFrom(CrystalReceiver r, SourceValidityRule rule) {
        if (invalid) {
            return;
        }
        WorldLocation loc = PylonFinder.getLocation(r);
        if (this.nodes.contains(loc)) {
            return;
        }
        if (this.isComplete()) {
            return;
        }
        ++this.steps;
        ++this.stepsThisTick;
        if (this.steps > this.maxSteps) {
            // empty if block
        }
        this.nodes.add(loc);
        ArrayList<CrystalTransmitter> li = this.net.getTransmittersTo(r, this.element);
        if (CrystalNetworkLogger.getLogLevel().isAtLeast(CrystalNetworkLogger.LoggingLevel.PATHFIND)) {
            CrystalNetworkLogger.logPathFind(this.target, this.element, r, li.toString(), this.nodes.toString());
        }
        if (ChromaOptions.SHORTPATH.getState() || this.skypeaterEntry != null) {
            Collections.sort(li, new NetworkSorters.TransmitterDistanceSorter(r));
        }
        Collections.sort(li, NetworkSorters.prioritizer[this.element.ordinal()]);
        for (CrystalTransmitter te : li) {
            if (this.isComplete()) {
                return;
            }
            WorldLocation loc2 = PylonFinder.getLocation(te);
            if (this.blacklist.contains(loc2) || this.duplicates.containsValue((Object)loc2)) continue;
            CrystalLink l = this.net.getLink(loc2, loc);
            if (te == this.target || (te.needsLineOfSightToReceiver(r) || r.needsLineOfSightFromTransmitter(te)) && !l.hasLineOfSight()) continue;
            if (te instanceof CrystalSource && this.isConnectableSource((CrystalSource)te, rule)) {
                this.net.addLink(l, true);
                this.nodes.add(loc2);
                return;
            }
            if (!(te instanceof CrystalRepeater)) continue;
            this.net.addLink(l, true);
            ArrayList<CrystalTransmitter> others = new ArrayList<CrystalTransmitter>(li);
            others.remove(te);
            this.duplicates.put((Object)loc2, others);
            if (te instanceof TileEntitySkypeater) {
                TileEntitySkypeater.NodeClass c = ((TileEntitySkypeater)te).getNodeType();
                if (this.skypeaterEntry == null) {
                    this.skypeaterEntry = c;
                } else if (c.isAbove(this.skypeaterEntry)) {
                    // empty if block
                }
                this.lastSkypeaterType = c;
            } else if (this.lastSkypeaterType == null || this.skypeaterEntry == null || this.skypeaterEntry != this.lastSkypeaterType) {
                // empty if block
            }
            this.findFrom((CrystalRepeater)te, rule);
        }
        if (!this.isComplete()) {
            this.nodes.removeLast();
            this.blacklist.add(loc);
            this.duplicates.remove((Object)loc);
        }
    }

    private boolean isConnectableSource(CrystalSource te, SourceValidityRule rule) {
        if (te instanceof TileEntityCrystalPylon && ((TileEntityCrystalPylon)te).enhancing) {
            return false;
        }
        return te.canSupply(this.target, this.element) && this.target.canBeSuppliedBy(te, this.element) && (this.user == null || te.playerCanUse(this.user)) && rule.isValid(te, this.element);
    }

    static final CrystalReceiver getReceiverAt(WorldLocation loc, boolean exception) {
        NodeReceiverWrapper wrap;
        TileEntity te = loc.getTileEntity();
        if (te instanceof CrystalReceiver) {
            return (CrystalReceiver)te;
        }
        if (te instanceof TileEntityCrystalMusic) {
            return ((TileEntityCrystalMusic)te).createTemporaryReceiver();
        }
        if (ModList.THAUMCRAFT.isLoaded() && InterfaceCache.NODE.instanceOf((Object)te) && (wrap = NodeRecharger.instance.getWrapper(loc, true)) != null) {
            return wrap;
        }
        if (exception) {
            throw new IllegalStateException("How did a non-receiver tile (" + te + ") get put in the network here (" + loc + ")?");
        }
        return null;
    }

    static final CrystalTransmitter getTransmitterAt(WorldLocation loc, boolean exception) {
        TileEntity te = loc.getTileEntity();
        if (te instanceof CrystalTransmitter) {
            return (CrystalTransmitter)te;
        }
        if (exception) {
            throw new IllegalStateException("How did a non-transmitter tile (" + te + ") get put in the network here (" + loc + ")?");
        }
        return null;
    }

    static final CrystalSource getSourceAt(WorldLocation loc, boolean exception) {
        TileEntity te = loc.getTileEntity();
        if (te instanceof CrystalSource) {
            return (CrystalSource)te;
        }
        if (exception) {
            throw new IllegalStateException("How did a non-source tile (" + te + ") get put in the network here (" + loc + ")?");
        }
        return null;
    }

    static final CrystalNetworkTile getNetTileAt(WorldLocation loc, boolean exception) {
        NodeReceiverWrapper wrap;
        TileEntity te = loc.getTileEntity();
        if (te instanceof CrystalNetworkTile) {
            return (CrystalNetworkTile)te;
        }
        if (te instanceof TileEntityCrystalMusic) {
            return ((TileEntityCrystalMusic)te).createTemporaryReceiver();
        }
        if (ModList.THAUMCRAFT.isLoaded() && InterfaceCache.NODE.instanceOf((Object)te) && (wrap = NodeRecharger.instance.getWrapper(loc, true)) != null) {
            return wrap;
        }
        if (exception) {
            throw new IllegalStateException("How did a non-network tile (" + te + ") get put in the network here (" + loc + ")?");
        }
        return null;
    }

    public static CrystalPath convertTileListToPath(LinkedList<CrystalNetworkTile> li, CrystalElement e) {
        LinkedList<WorldLocation> li2 = new LinkedList<WorldLocation>();
        for (CrystalNetworkTile te : li) {
            li2.add(new WorldLocation(te.getWorld(), te.getX(), te.getY(), te.getZ()));
        }
        return new CrystalPath(CrystalNetworker.instance, false, e, li2);
    }

    static void replacePath(CrystalSource src, WorldLocation tgt, CrystalElement color, CrystalPath p) {
        EnumMap<CrystalElement, ArrayList<CrystalPath>> data = paths.get(tgt);
        ArrayList<CrystalPath> li = data.get(color);
        for (int i = 0; i < li.size(); ++i) {
            CrystalPath at = li.get(i);
            if (!at.hasSameEndpoints(p) || at.element != p.element) continue;
            li.set(i, p);
            return;
        }
        ChromatiCraft.logger.logError((Object)("Tried to replace a " + color + " path from " + src + " to " + tgt + ", but no such path exists!"));
    }

    static Collection<? extends CrystalPath> getCachedPaths(CrystalElement e) {
        ArrayList<CrystalPath> li = new ArrayList<CrystalPath>();
        for (EnumMap<CrystalElement, ArrayList<CrystalPath>> map : paths.values()) {
            ArrayList<CrystalPath> list = map.get(e);
            if (list == null) continue;
            li.addAll(list);
        }
        return li;
    }

    static LOSData lineOfSight(WorldLocation l1, WorldLocation l2) {
        return PylonFinder.lineOfSight(l1.getWorld(), l1.xCoord, l1.yCoord, l1.zCoord, l2.xCoord, l2.yCoord, l2.zCoord, new Block[0]);
    }

    private LOSData lineOfSight(CrystalNetworkTile te1, CrystalNetworkTile te) {
        return PylonFinder.lineOfSight(te1.getWorld(), te1.getX(), te1.getY(), te1.getZ(), te.getX(), te.getY(), te.getZ(), new Block[0]);
    }

    public static LOSData lineOfSight(World world, int x, int y, int z, Entity e, Block ... extra) {
        return PylonFinder.lineOfSight(world, x, y, z, MathHelper.func_76128_c((double)e.field_70165_t), (int)e.field_70163_u, MathHelper.func_76128_c((double)e.field_70161_v), extra);
    }

    public static LOSData lineOfSight(World world, int x1, int y1, int z1, int x2, int y2, int z2, Block ... extra) {
        tracer.setOrigins((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        tracer.offset(0.5, 0.5, 0.5);
        if (extra.length > 0) {
            for (Block b : extra) {
                tracer.addOneTimeIgnoredBlock(b);
            }
        }
        boolean los = tracer.isClearLineOfSight(world);
        Set set = tracer.getRayBlocks();
        return new LOSData(los, PylonFinder.canRainOn(world, set), set);
    }

    private static boolean canRainOn(World world, Set<Coordinate> set) {
        for (Coordinate c : set) {
            if (!PylonFinder.isRainableBiome(world.func_72807_a(c.xCoord, c.zCoord)) || world.func_72874_g(c.xCoord, c.zCoord) > c.yCoord) continue;
            return true;
        }
        return false;
    }

    public static boolean isRainableBiome(BiomeGenBase b) {
        return !BiomeGlowingCliffs.isGlowingCliffs(b) && (b instanceof BiomeGenDesert || ReikaBiomeHelper.doesBiomeHavePrecipitation((BiomeGenBase)b));
    }

    @DependentMethodStripper.ModDependent(value={ModList.ROTARYCRAFT})
    private static void addRCGlass() {
        tracer.addTransparentBlock(BlockRegistry.BLASTGLASS.getBlockInstance());
        tracer.addTransparentBlock(BlockRegistry.BLASTPANE.getBlockInstance());
    }

    @DependentMethodStripper.ModDependent(value={ModList.GEOSTRATA})
    private static void addGeoVines() {
        tracer.addTransparentBlock(GeoBlocks.GLOWVINE.getBlockInstance());
    }

    public static final WorldLocation getLocation(CrystalNetworkTile te) {
        return new WorldLocation(te.getWorld(), te.getX(), te.getY(), te.getZ());
    }

    static void stopAllSearches() {
        invalid = true;
    }

    public static boolean isBlockPassable(World world, int x, int y, int z) {
        return tracer.isBlockPassable(world, x, y, z);
    }

    public static int getSourcePriority(CrystalSource src, CrystalElement e) {
        return src.getEnergy(e);
    }

    static {
        Block b;
        invalid = false;
        paths = new HashMap();
        ModularLogger.instance.addLogger((DragonAPIMod)ChromatiCraft.instance, LOGGER_ID);
        tracer = new RayTracer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        PylonFinder.tracer.softBlocksOnly = true;
        PylonFinder.tracer.allowFluids = false;
        PylonFinder.tracer.uniDirectionalChecks = true;
        tracer.addTransparentBlock(Blocks.field_150359_w);
        tracer.addTransparentBlock(Blocks.field_150410_aZ);
        tracer.addTransparentBlock(Blocks.field_150431_aC, 0);
        tracer.addTransparentBlock(ChromaBlocks.SELECTIVEGLASS.getBlockInstance());
        if (ModList.ROTARYCRAFT.isLoaded()) {
            PylonFinder.addRCGlass();
        }
        if (ModList.GEOSTRATA.isLoaded()) {
            PylonFinder.addGeoVines();
        }
        if (ModList.EXTRAUTILS.isLoaded() && ExtraUtilsHandler.getInstance().initializedProperly()) {
            b = ExtraUtilsHandler.getInstance().deco2ID;
            if (b != null) {
                tracer.addTransparentBlock(b, 0);
                tracer.addTransparentBlock(b, 1);
                tracer.addTransparentBlock(b, 4);
                tracer.addTransparentBlock(b, 7);
            }
            if ((b = ExtraUtilsHandler.getInstance().etherealBlockID) != null) {
                ExtraUtilsHandler.getInstance().getClass();
                tracer.addTransparentBlock(b, 0);
                ExtraUtilsHandler.getInstance().getClass();
                tracer.addTransparentBlock(b, 3);
                ExtraUtilsHandler.getInstance().getClass();
                tracer.addTransparentBlock(b, 1);
                ExtraUtilsHandler.getInstance().getClass();
                tracer.addTransparentBlock(b, 4);
            }
        }
        if (ModList.TINKERER.isLoaded() && TinkerBlockHandler.getInstance().initializedProperly()) {
            tracer.addTransparentBlock(TinkerBlockHandler.getInstance().clearGlassID);
        }
        if (ModList.ENDERIO.isLoaded() && (b = GameRegistry.findBlock((String)ModList.ENDERIO.modLabel, (String)"blockFusedQuartz")) != null) {
            tracer.addTransparentBlock(b, 1);
        }
        tracer.addOpaqueBlock((Block)Blocks.field_150330_I);
        tracer.addOpaqueBlock((Block)Blocks.field_150329_H, 0);
        tracer.addOpaqueBlock((Block)Blocks.field_150329_H, 2);
        tracer.addOpaqueBlock((Block)Blocks.field_150480_ab);
        tracer.addOpaqueBlock(Blocks.field_150395_bd);
        PylonFinder.tracer.cacheBlockRay = true;
    }
}

