/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityPylonLink;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class PylonLinkNetwork {
    private static final String NBT_TAG = "pylonlinknet";
    public static final PylonLinkNetwork instance = new PylonLinkNetwork();
    private long lastUpdate;
    private final HashMap<UUID, PylonWeb> links = new HashMap();

    private PylonLinkNetwork() {
    }

    public PylonNode addLocation(TileEntityPylonLink te, TileEntityCrystalPylon p) {
        if (te.field_145850_b.field_72995_K) {
            return null;
        }
        PylonLinkData.initNetworkData(te.field_145850_b).func_76186_a(true);
        PylonWeb web = this.getOrCreateWeb(te.getUUID());
        PylonSubweb sw = web.getSubweb(p.getColor());
        PylonNode connection = sw.addNode(te, p);
        p.link(te);
        if (web.needsSync) {
            this.sync(null);
            ChromatiCraft.logger.log((Object)("Updating pylon link network: added a tile @ " + te));
        }
        return connection;
    }

    public void removeLocation(World world, PylonNode connection) {
        if (world.field_72995_K) {
            return;
        }
        PylonLinkData.initNetworkData(world).func_76186_a(true);
        TileEntity te = connection.pylon.getTileEntity();
        if (te instanceof TileEntityCrystalPylon) {
            ((TileEntityCrystalPylon)te).link(null);
        }
        connection.parent.remove(connection);
        ChromatiCraft.logger.log((Object)("Updating pylon link network: removed a tile @ " + connection));
        this.sync(null);
    }

    private PylonWeb getOrCreateWeb(UUID uid) {
        PylonWeb web = this.links.get(uid);
        if (web == null) {
            web = new PylonWeb(uid);
            this.links.put(uid, web);
        }
        return web;
    }

    public Collection<WorldLocation> getLinkedPylons(World world, UUID uid, CrystalElement color) {
        if (!world.field_72995_K && world.func_82737_E() - this.lastUpdate > 600L) {
            PylonLinkData.initNetworkData(world).func_76186_a(true);
        }
        ArrayList<WorldLocation> li = new ArrayList<WorldLocation>();
        PylonWeb w = this.links.get(uid);
        if (w == null) {
            return li;
        }
        if (w.data[color.ordinal()] != null) {
            li.addAll(w.data[color.ordinal()].pylonSet.keySet());
        }
        return li;
    }

    public void clear() {
        this.links.clear();
    }

    public void load(NBTTagCompound NBT) {
        ChromatiCraft.logger.log((Object)"Reloading pylon link data...");
        this.clear();
        NBTTagList li = NBT.func_150295_c("entries", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : li.field_74747_a) {
            NBTTagCompound tag = (NBTTagCompound)o;
            PylonWeb pw = PylonWeb.readFromNBT(tag);
            this.links.put(pw.owner, pw);
        }
        ChromatiCraft.logger.log((Object)"Updating pylon link network from disk");
        this.sync(null);
    }

    public NBTTagCompound save() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList li = new NBTTagList();
        tag.func_74782_a("entries", (NBTBase)li);
        for (PylonWeb pw : this.links.values()) {
            li.func_74742_a((NBTBase)pw.writeToNBT());
        }
        return tag;
    }

    public void sync(EntityPlayerMP ep) {
        if (ep != null) {
            ChromatiCraft.logger.log((Object)("Updating pylon link network for " + ep));
        } else {
            ChromatiCraft.logger.log((Object)"Updating pylon link network for all players");
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return;
        }
        PacketTarget pt = ep != null ? new PacketTarget.PlayerTarget(ep) : PacketTarget.allPlayers;
        NBTTagCompound nbt = this.save();
        ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.PYLONLINKCACHE.ordinal(), (NBTTagCompound)nbt, (PacketTarget)pt);
    }

    public static class PylonNode {
        private final PylonSubweb parent;
        private final WorldLocation tile;
        private final WorldLocation pylon;

        private PylonNode(PylonSubweb w, WorldLocation loc, WorldLocation py) {
            this.parent = w;
            this.tile = loc;
            this.pylon = py;
        }

        private static PylonNode readFromNBT(PylonSubweb pw, NBTTagCompound NBT) {
            WorldLocation loc = WorldLocation.readFromNBT((String)"loc", (NBTTagCompound)NBT);
            WorldLocation py = WorldLocation.readFromNBT((String)"pylon", (NBTTagCompound)NBT);
            return new PylonNode(pw, loc, py);
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound NBT = new NBTTagCompound();
            this.tile.writeToNBT("loc", NBT);
            this.pylon.writeToNBT("pylon", NBT);
            return NBT;
        }

        public String toString() {
            return this.getColor() + " : " + this.tile.toString();
        }

        public int hashCode() {
            return this.tile.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof PylonNode) {
                PylonNode pn = (PylonNode)o;
                return pn.tile.equals((Object)this.tile) && pn.pylon.equals((Object)this.pylon) && pn.getColor() == this.getColor();
            }
            return false;
        }

        public CrystalElement getColor() {
            return this.parent.color;
        }

        public void sync(NBTTagCompound tag) {
            tag.func_74768_a("color", this.parent.color.ordinal());
            tag.func_74778_a("id", this.parent.parent.owner.toString());
            this.tile.writeToNBT("loc", tag);
        }

        public static PylonNode fromSync(NBTTagCompound tag) {
            CrystalElement e = CrystalElement.elements[tag.func_74762_e("color")];
            UUID uid = UUID.fromString(tag.func_74779_i("id"));
            WorldLocation loc = WorldLocation.readFromNBT((String)"loc", (NBTTagCompound)tag);
            PylonWeb pw = instance.getOrCreateWeb(uid);
            PylonSubweb ps = pw.getSubweb(e);
            return (PylonNode)ps.linkSet.get(loc);
        }
    }

    private static class PylonSubweb {
        private final PylonWeb parent;
        private final CrystalElement color;
        private final HashMap<WorldLocation, PylonNode> pylonSet = new HashMap();
        private final HashMap<WorldLocation, PylonNode> linkSet = new HashMap();

        private PylonSubweb(PylonWeb w, CrystalElement e) {
            this.parent = w;
            this.color = e;
        }

        private PylonNode addNode(TileEntityPylonLink te, TileEntityCrystalPylon p) {
            return this.addNode(new WorldLocation((TileEntity)te), new WorldLocation((TileEntity)p));
        }

        private PylonNode addNode(WorldLocation loc, WorldLocation py) {
            PylonNode ret = this.linkSet.get(loc);
            if (ret != null) {
                return ret;
            }
            ret = new PylonNode(this, loc, py);
            this.linkSet.put(loc, ret);
            this.pylonSet.put(py, ret);
            this.parent.needsSync = true;
            return ret;
        }

        private void remove(PylonNode pn) {
            this.pylonSet.remove(pn.pylon);
            this.linkSet.remove(pn.tile);
            this.parent.needsSync = true;
        }

        private static PylonSubweb readFromNBT(PylonWeb pw, NBTTagCompound NBT) {
            int color = NBT.func_74762_e("color");
            PylonSubweb ps = new PylonSubweb(pw, CrystalElement.elements[color]);
            NBTTagList li = NBT.func_150295_c("nodes", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            for (Object o : li.field_74747_a) {
                NBTTagCompound tag = (NBTTagCompound)o;
                PylonNode pn = PylonNode.readFromNBT(ps, tag);
                ps.pylonSet.put(pn.pylon, pn);
                ps.linkSet.put(pn.tile, pn);
            }
            return ps;
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound NBT = new NBTTagCompound();
            NBT.func_74768_a("color", this.color.ordinal());
            NBTTagList li = new NBTTagList();
            for (PylonNode pn : this.linkSet.values()) {
                li.func_74742_a((NBTBase)pn.writeToNBT());
            }
            NBT.func_74782_a("nodes", (NBTBase)li);
            return NBT;
        }
    }

    private static class PylonWeb {
        private final UUID owner;
        private final PylonSubweb[] data = new PylonSubweb[16];
        private boolean needsSync = false;

        private PylonWeb(UUID uid) {
            this.owner = uid;
        }

        private PylonSubweb getSubweb(CrystalElement e) {
            if (this.data[e.ordinal()] == null) {
                this.data[e.ordinal()] = new PylonSubweb(this, e);
            }
            return this.data[e.ordinal()];
        }

        private static PylonWeb readFromNBT(NBTTagCompound NBT) {
            String uid = NBT.func_74779_i("owner");
            PylonWeb pw = new PylonWeb(UUID.fromString(uid));
            for (int i = 0; i < 16; ++i) {
                String key = "sub_" + i;
                if (!NBT.func_74764_b(key)) continue;
                pw.data[i] = PylonSubweb.readFromNBT(pw, NBT.func_74775_l(key));
            }
            return pw;
        }

        private NBTTagCompound writeToNBT() {
            NBTTagCompound NBT = new NBTTagCompound();
            NBT.func_74778_a("owner", this.owner.toString());
            for (int i = 0; i < 16; ++i) {
                if (this.data[i] == null) continue;
                String key = "sub_" + i;
                NBT.func_74782_a(key, (NBTBase)this.data[i].writeToNBT());
            }
            return NBT;
        }
    }

    public static class PylonLinkData
    extends WorldSavedData {
        private static final String IDENTIFIER = "pylonlinknet";

        public PylonLinkData() {
            super("pylonlinknet");
        }

        public PylonLinkData(String s) {
            super(s);
        }

        public void func_76184_a(NBTTagCompound NBT) {
            instance.load(NBT.func_74775_l("data"));
        }

        public void func_76187_b(NBTTagCompound NBT) {
            NBT.func_74782_a("data", (NBTBase)instance.save());
        }

        private static PylonLinkData initNetworkData(World world) {
            PylonLinkData data = (PylonLinkData)world.func_72943_a(PylonLinkData.class, "pylonlinknet");
            if (data == null) {
                data = new PylonLinkData();
                world.func_72823_a("pylonlinknet", (WorldSavedData)data);
            }
            return data;
        }
    }
}

