/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Network;

import Reika.ChromatiCraft.Block.Relay.BlockRelayBase;
import Reika.ChromatiCraft.Block.Relay.BlockRelayFilter;
import Reika.ChromatiCraft.Block.Worldgen.BlockDecoFlower;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Network.PylonFinder;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityRelaySource;
import Reika.ChromatiCraft.TileEntity.Transport.TileEntityRift;
import Reika.ChromatiCraft.World.IWG.PylonGenerator;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.BoPBlockHandler;
import Reika.DragonAPI.ModList;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public final class RelayNetworker {
    public static final RelayNetworker instance = new RelayNetworker(RelayNetworker.getConfigurableRange(), 48);
    private static final String LOGGER_ID = "lumenrelay";
    public final int maxRange;
    public final int maxDepth;

    private RelayNetworker(int r, int d) {
        this.maxRange = r;
        this.maxDepth = d;
    }

    private static int getConfigurableRange() {
        return MathHelper.func_76125_a((int)ChromaOptions.RELAYRANGE.getValue(), (int)8, (int)24);
    }

    public TileEntityRelaySource findRelaySource(World world, int x, int y, int z, ForgeDirection dir, CrystalElement e, int amt, int dist) {
        if (amt <= 0) {
            return null;
        }
        RelayFinder rf = new RelayFinder(new Coordinate(x, y, z), Math.min(dist, this.maxRange), this.maxDepth, e, amt);
        rf.look = dir;
        RelayPath path = rf.find(world);
        if (path != null) {
            if (path.source.getEnergy(e) > 0) {
                path.transmit(e);
            }
            return path.source;
        }
        return null;
    }

    static {
        ModularLogger.instance.addLogger((DragonAPIMod)ChromatiCraft.instance, LOGGER_ID);
    }

    private static class RelayFinder {
        private final Coordinate target;
        private final int maxRange;
        private final int maxDepth;
        private final CrystalElement color;
        private final int amount;
        private ForgeDirection look = ForgeDirection.UNKNOWN;
        private final LinkedList<Coordinate> path = new LinkedList();

        private RelayFinder(Coordinate loc, int r, int d, CrystalElement e, int amt) {
            this.target = loc;
            this.maxRange = r;
            this.maxDepth = d;
            this.color = e;
            this.amount = amt;
            this.path.addFirst(this.target);
            ModularLogger.instance.log(RelayNetworker.LOGGER_ID, "Relay pathfinding start @ " + loc + " for " + amt + " of " + e);
        }

        private RelayPath find(World world) {
            return this.findFrom(world, this.target, 0);
        }

        private RelayPath findFrom(World world, Coordinate start, int depth) {
            if (depth > this.maxDepth) {
                return null;
            }
            for (int i = 1; i < this.maxRange; ++i) {
                Object te;
                int meta;
                Coordinate c = start.offset(this.look, i);
                Block b = c.getBlock((IBlockAccess)world);
                if (ChromaTiles.getTileFromIDandMetadata(b, meta = c.getBlockMetadata((IBlockAccess)world)) == ChromaTiles.RELAYSOURCE) {
                    this.path.addLast(c);
                    return new RelayPath((TileEntityRelaySource)c.getTileEntity((IBlockAccess)world), this.target, this.color, this.path);
                }
                if (b instanceof BlockRelayBase) {
                    this.path.addLast(c);
                    te = (BlockRelayBase.TileRelayBase)c.getTileEntity((IBlockAccess)world);
                    if (te.canTransmit(this.color)) {
                        this.look = te.getInput();
                        return this.findFrom(world, c, depth + 1);
                    }
                } else if (b == ChromaBlocks.RELAYFILTER.getBlockInstance()) {
                    te = (BlockRelayFilter.TileEntityRelayFilter)c.getTileEntity((IBlockAccess)world);
                    if (te.canTransmit(this.color)) continue;
                    return null;
                }
                if (ChromaTiles.getTileFromIDandMetadata(b, meta) == ChromaTiles.RIFT) {
                    te = (TileEntityRift)c.getTileEntity((IBlockAccess)world);
                    WorldLocation loc = te.getLinkTarget();
                    if (loc != null) {
                        World world2 = loc.getWorld();
                        if (world2.field_73011_w.field_76574_g == world.field_73011_w.field_76574_g || PylonGenerator.instance.canGenerateIn(world2)) {
                            this.path.addLast(c);
                            return this.findFrom(world2, new Coordinate(loc), depth + 1);
                        }
                        return null;
                    }
                    return null;
                }
                if (PylonFinder.isBlockPassable(world, c.xCoord, c.yCoord, c.zCoord) || this.isBlockRelayTransparent(world, c.xCoord, c.yCoord, c.zCoord)) continue;
                return null;
            }
            return null;
        }

        private boolean isBlockRelayTransparent(World world, int x, int y, int z) {
            Block b = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (b == ChromaBlocks.ROUTERNODE.getBlockInstance()) {
                return true;
            }
            if (b == ChromaBlocks.DECOFLOWER.getBlockInstance() && (meta == BlockDecoFlower.Flowers.FLOWIVY.ordinal() || meta == BlockDecoFlower.Flowers.GLOWDAISY.ordinal())) {
                return true;
            }
            if (b == Blocks.field_150327_N || b == Blocks.field_150328_O) {
                return true;
            }
            return ModList.BOP.isLoaded() && BoPBlockHandler.getInstance().isFlower(b);
        }
    }

    private static class RelayPath {
        public final TileEntityRelaySource source;
        public final Coordinate target;
        public final CrystalElement color;
        private final ArrayList<Coordinate> path;

        private RelayPath(TileEntityRelaySource src, Coordinate c, CrystalElement e, LinkedList<Coordinate> li) {
            this.source = src;
            this.target = c;
            this.color = e;
            this.path = new ArrayList();
            while (!li.isEmpty()) {
                this.path.add(li.removeLast());
            }
            ModularLogger.instance.log(RelayNetworker.LOGGER_ID, "Relay pathfinding complete from " + this.source + " to " + this.target + " for " + e);
        }

        public void transmit(CrystalElement e) {
            if (!this.source.field_145850_b.field_72995_K) {
                ArrayList<Integer> dat = new ArrayList<Integer>();
                for (Coordinate c : this.path) {
                    dat.add(c.xCoord);
                    dat.add(c.yCoord);
                    dat.add(c.zCoord);
                }
                dat.add(e.ordinal());
                ReikaPacketHelper.sendNIntPacket((String)"ChromaData", (int)ChromaPackets.RELAYCONNECT.ordinal(), (PacketTarget)this.getTarget(), dat);
            }
        }

        private PacketTarget getTarget() {
            ArrayList<EntityPlayerMP> li = new ArrayList<EntityPlayerMP>();
            block0: for (Object o : this.source.field_145850_b.field_73010_i) {
                EntityPlayerMP ep = (EntityPlayerMP)o;
                for (Coordinate c : this.path) {
                    if (!(c.getDistanceTo((Entity)ep) <= 64.0)) continue;
                    li.add(ep);
                    continue block0;
                }
            }
            return new PacketTarget.CompoundPlayerTarget(li);
        }
    }
}

