/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.API.CrystalElementAccessor;
import Reika.ChromatiCraft.API.PlayerBufferAPI;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Items.Tools.ItemPendant;
import Reika.ChromatiCraft.Magic.ElementBufferCapacityBoost;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Maps.CountMap;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

public class PlayerElementBuffer
implements PlayerBufferAPI {
    public static final PlayerElementBuffer instance = new PlayerElementBuffer();
    private final CountMap<UUID> recentUpgrades = new CountMap();
    private static final String NBT_TAG = "CrystalBuffer";
    private static final int PLAYER_BASE_CAP = 400000;

    private PlayerElementBuffer() {
    }

    public float getAndDecrUpgradeTick(EntityPlayer ep) {
        UUID id = ep.func_110124_au();
        int get = this.recentUpgrades.get((Object)id);
        if (get > 0) {
            this.recentUpgrades.increment((Object)id, -1);
        }
        return (float)get / 2000.0f;
    }

    NBTTagCompound getTag(EntityPlayer ep) {
        NBTTagCompound tag = ep.getEntityData().func_74775_l(NBT_TAG);
        ep.getEntityData().func_74782_a(NBT_TAG, (NBTBase)tag);
        return tag;
    }

    public ElementTagCompound getPlayerBuffer(EntityPlayer ep) {
        NBTTagCompound tag = this.getTag(ep);
        return ElementTagCompound.createFromNBT(tag);
    }

    public int getPlayerContent(EntityPlayer ep, CrystalElement e) {
        NBTTagCompound tag = this.getTag(ep);
        return tag.func_74762_e(e.name());
    }

    public boolean playerHas(EntityPlayer ep, CrystalElement e, int amt) {
        return ep.field_71075_bZ.field_75098_d || this.getPlayerContent(ep, e) >= amt;
    }

    public boolean playerHas(EntityPlayer player, ElementTagCompound tag) {
        for (CrystalElement e : tag.elementSet()) {
            int amt;
            if (this.playerHas(player, e, amt = tag.getValue(e))) continue;
            return false;
        }
        return true;
    }

    public boolean addToPlayer(EntityPlayer ep, CrystalElement e, int amt, boolean notify) {
        NBTTagCompound tag = this.getTag(ep);
        int has = tag.func_74762_e(e.name());
        int val = Math.min(has + amt, this.getElementCap(ep));
        tag.func_74768_a(e.name(), val);
        this.setElementCap(ep, this.calcElementCap(ep), notify);
        return val > has;
    }

    private void setToPlayer(EntityPlayer ep, CrystalElement e, int amt) {
        NBTTagCompound tag = this.getTag(ep);
        tag.func_74768_a(e.name(), amt);
    }

    public boolean addToPlayer(EntityPlayer ep, ElementTagCompound tag, boolean notify) {
        boolean flag = false;
        for (CrystalElement e : tag.elementSet()) {
            flag |= this.addToPlayer(ep, e, tag.getValue(e), notify);
        }
        return flag;
    }

    @Override
    public void removeFromPlayer(EntityPlayer ep, CrystalElementAccessor.CrystalElementProxy e, int amt) {
        this.removeFromPlayer(ep, (CrystalElement)e, amt);
    }

    public void removeFromPlayer(EntityPlayer ep, CrystalElement e, int amt) {
        if (ep.field_71075_bZ.field_75098_d) {
            return;
        }
        int lvl = ItemPendant.getActivePendantLevel(ep, CrystalElement.BLACK);
        if (lvl == 1) {
            amt = Math.max(1, (int)((float)amt * 0.5f));
        } else if (lvl == 0) {
            amt = Math.max(1, (int)((float)amt * 0.8f));
        }
        NBTTagCompound tag = this.getTag(ep);
        int has = tag.func_74762_e(e.name());
        tag.func_74768_a(e.name(), Math.max(0, has - amt));
        this.checkAndWarnPlayer(ep, e, has);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    private void checkAndWarnPlayer(EntityPlayer ep, CrystalElement e, int prev) {
        float f1 = (float)prev / (float)this.getElementCap(ep);
        float f2 = (float)this.getPlayerContent(ep, e) / (float)this.getElementCap(ep);
        this.warnPlayer(ep, e, f1, f2);
    }

    private void warnPlayer(EntityPlayer ep, CrystalElement e, float f1, float f2) {
        if (f2 < f1) {
            int s1 = -1;
            int s2 = -1;
            if ((double)f1 < 0.015625) {
                s1 = 0;
            } else if ((double)f1 < 0.03125) {
                s1 = 1;
            } else if ((double)f1 < 0.0625) {
                s1 = 2;
            }
            if ((double)f2 < 0.015625) {
                s2 = 0;
            } else if ((double)f2 < 0.03125) {
                s2 = 1;
            } else if ((double)f2 < 0.0625) {
                s2 = 2;
            }
            if (s1 != s2) {
                ChromaSounds snd = null;
                switch (s2) {
                    case 0: {
                        snd = ChromaSounds.BUFFERWARNING;
                        break;
                    }
                    case 1: {
                        snd = ChromaSounds.BUFFERWARNING_LOW;
                        break;
                    }
                    case 2: {
                        snd = ChromaSounds.BUFFERWARNING_EMPTY;
                    }
                }
                if (snd != null) {
                    snd.playSound((Entity)ep, 1.0f, (float)CrystalMusicManager.instance.getDingPitchScale(e));
                }
            }
        }
    }

    public void removeFromPlayer(EntityPlayer player, ElementTagCompound tag) {
        for (CrystalElement e : tag.elementSet()) {
            this.removeFromPlayer(player, e, tag.getValue(e));
        }
    }

    public int getElementCap(EntityPlayer ep) {
        NBTTagCompound tag = this.getTag(ep);
        return Math.max(24, tag.func_74762_e("cap"));
    }

    public int getChargeSpeed(EntityPlayer ep) {
        return (int)Math.pow(this.getElementCap(ep) / 24, 0.667);
    }

    public double getPlayerFraction(EntityPlayer ep, CrystalElement e) {
        return (double)this.getPlayerContent(ep, e) / (double)this.getElementCap(ep);
    }

    public boolean setElementCap(EntityPlayer ep, int cap, boolean notify) {
        boolean flag;
        NBTTagCompound tag = this.getTag(ep);
        int prev = this.getElementCap(ep);
        int val = Math.min(cap, this.getPlayerMaximumCap(ep));
        tag.func_74768_a("cap", val);
        boolean bl = flag = val != prev;
        if (flag) {
            for (int i = 0; i < 16; ++i) {
                CrystalElement e = CrystalElement.elements[i];
                int amt = Math.min(val, this.getPlayerContent(ep, e));
                this.setToPlayer(ep, e, amt);
            }
            if (notify) {
                if (cap % 2 == 0) {
                    ChromaSounds.CRAFTDONE.playSound(ep.field_70170_p, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v, 0.1f, 0.5f);
                }
                this.recentUpgrades.set((Object)ep.func_110124_au(), 2000);
            }
        }
        if (ep instanceof EntityPlayerMP) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.BUFFERSET.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{val, notify ? 1 : 0});
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
        return flag;
    }

    private int calcElementCap(EntityPlayer ep) {
        int amt = this.getPlayerTotalEnergy(ep);
        double p = ProgressStage.CTM.isPlayerAtStage(ep) ? 0.875 : 0.75;
        double f = ProgressStage.CTM.isPlayerAtStage(ep) ? 0.9 : 0.8;
        double m = ProgressStage.CTM.isPlayerAtStage(ep) ? 6.0 : 4.0;
        return Math.max(this.getPlayerBuffer(ep).getMaximumValue(), MathHelper.func_76125_a((int)((int)Math.min((double)amt * f, m * Math.pow(amt, p))), (int)24, (int)this.getPlayerMaximumCap(ep)));
    }

    int getPlayerMaximumCap(EntityPlayer ep) {
        return ElementBufferCapacityBoost.calculateCap(400000, ep);
    }

    public int getChargeInefficiency(EntityPlayer ep) {
        return ProgressStage.CTM.isPlayerAtStage(ep) ? 1 : (ProgressStage.DIMENSION.isPlayerAtStage(ep) ? 2 : 4);
    }

    @SideOnly(value=Side.CLIENT)
    public void setPlayerCapOnClient(EntityPlayer ep, int cap, boolean notify) {
        this.setElementCap(ep, cap, notify);
    }

    public boolean canPlayerAccept(EntityPlayer ep, CrystalElement e, int amt) {
        return this.getPlayerContent(ep, e) + amt <= this.getElementCap(ep);
    }

    public boolean isMaxed(EntityPlayer player, CrystalElement e) {
        return this.getPlayerContent(player, e) == this.getElementCap(player);
    }

    public boolean isMaxedWithin(EntityPlayer player, CrystalElement e, float frac) {
        return (float)this.getPlayerContent(player, e) >= (float)this.getElementCap(player) * (1.0f - frac);
    }

    public boolean hasElement(EntityPlayer ep, CrystalElement e) {
        return this.getPlayerContent(ep, e) > 0;
    }

    public int getPlayerTotalEnergy(EntityPlayer ep) {
        int sum = 0;
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            sum += this.getPlayerContent(ep, e);
        }
        return sum;
    }

    public void copyTo(EntityPlayer from, EntityPlayer to) {
        NBTTagCompound data = this.getTag(from);
        to.getEntityData().func_74782_a(NBT_TAG, (NBTBase)data);
    }
}

