/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Progression;

import Reika.ChromatiCraft.API.Event.ProgressionEvent;
import Reika.ChromatiCraft.API.ProgressionAPI;
import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaOverlays;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.Tools.ItemChromaBook;
import Reika.ChromatiCraft.Magic.Progression.ProgressAccess;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionLoadHandler;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.SequenceMap;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.MinecraftForge;

public final class ChromaResearchManager
implements ProgressionAPI.ResearchRegistry {
    private final SequenceMap<ChromaResearch> data = new SequenceMap();
    private final MultiMap<ResearchLevel, ChromaResearchTarget> priority = new MultiMap();
    private static final Random rand = new Random();
    private static final String NBT_TAG = "Chroma_Research";
    public static final ChromaResearchManager instance = new ChromaResearchManager();
    public final Comparator researchComparator = new ChromaResearchComparator();
    private final HashBiMap<Integer, ProgressElement> progressIDs = HashBiMap.create();

    private ChromaResearchManager() {
        ProgressionAPI.instance.researchManager = this;
        this.priority.addValue((Object)ResearchLevel.ENTRY, (Object)new ChromaResearchTarget(ChromaResearch.FRAGMENT, -1));
        this.priority.addValue((Object)ResearchLevel.RUNECRAFT, (Object)new ChromaResearchTarget(ChromaResearch.CRAFTING, 10));
        this.priority.addValue((Object)ResearchLevel.RUNECRAFT, (Object)new ChromaResearchTarget(ChromaResearch.CASTING1, 5));
        this.priority.addValue((Object)ResearchLevel.MULTICRAFT, (Object)new ChromaResearchTarget(ChromaResearch.CASTING2, 10));
        this.priority.addValue((Object)ResearchLevel.PYLONCRAFT, (Object)new ChromaResearchTarget(ChromaResearch.CASTING3, 10));
        this.priority.addValue((Object)ResearchLevel.NETWORKING, (Object)new ChromaResearchTarget(ChromaResearch.REPEATER, 100));
        this.priority.addValue((Object)ResearchLevel.NETWORKING, (Object)new ChromaResearchTarget(ChromaResearch.COMPOUND, 10));
        this.priority.addValue((Object)ResearchLevel.NETWORKING, (Object)new ChromaResearchTarget(ChromaResearch.REPEATERSTRUCT, 25));
        this.priority.addValue((Object)ResearchLevel.NETWORKING, (Object)new ChromaResearchTarget(ChromaResearch.COMPOUNDSTRUCT, 2));
        this.priority.addValue((Object)ResearchLevel.ENERGY, (Object)new ChromaResearchTarget(ChromaResearch.ENERGY, 100));
        this.priority.addValue((Object)ResearchLevel.ENERGY, (Object)new ChromaResearchTarget(ChromaResearch.SELFCHARGE, 50));
        this.priority.addValue((Object)ResearchLevel.ENERGY, (Object)new ChromaResearchTarget(ChromaResearch.TRANSMISSION, 20));
        this.priority.addValue((Object)ResearchLevel.RUNECRAFT, (Object)new ChromaResearchTarget(ChromaResearch.NETHERKEY, 20));
        this.priority.shuffleValues();
        this.addLink(ChromaResearch.TELEGATELOCK, ChromaResearch.GATE);
        this.addLink(ChromaResearch.TRANSMISSION, ChromaResearch.ENERGY);
        this.addLink(ChromaResearch.RELAY, ChromaResearch.ENERGY);
    }

    private void addLink(ChromaResearch obj, ChromaResearch parent) {
        this.data.addChild((Object)parent, (Object)obj);
    }

    public Collection<ProgressAccess> getResearchLevelAdvancementBlocks(EntityPlayer ep) {
        HashSet<ChromaResearch> li = this.getResearchLevelMissingFragments(ep);
        HashSet<ProgressAccess> c = new HashSet<ProgressAccess>(li);
        for (ChromaResearch r : li) {
            for (ProgressStage s : r.getRequiredProgress()) {
                if (s.isPlayerAtStage(ep)) continue;
                c.add(s);
            }
        }
        return c;
    }

    public HashSet<ChromaResearch> getResearchLevelMissingFragments(EntityPlayer ep) {
        Collection<ChromaResearch> cp = instance.getFragments(ep);
        HashSet<ChromaResearch> missing = new HashSet<ChromaResearch>(instance.getResearchForLevel(this.getPlayerResearchLevel(ep)));
        missing.removeAll(cp);
        this.removeAllDummiedFragments(missing);
        Iterator<ChromaResearch> it = missing.iterator();
        while (it.hasNext()) {
            ChromaResearch r = it.next();
            if (r.isGating()) continue;
            it.remove();
        }
        return missing;
    }

    private ChromaResearch getPriorityResearchFor(EntityPlayer ep) {
        Collection c = this.priority.get((Object)this.getPlayerResearchLevel(ep));
        WeightedRandom wr = new WeightedRandom();
        for (ChromaResearchTarget t : c) {
            if (this.playerHasFragment(ep, t.fragment)) continue;
            if (t.weight < 0) {
                return t.fragment;
            }
            wr.addEntry((Object)t.fragment, (double)t.weight);
        }
        return !wr.isEmpty() ? (ChromaResearch)wr.getRandomEntry() : null;
    }

    public ArrayList<ChromaResearch> getNextResearchesFor(EntityPlayer ep) {
        return this.getNextResearchesFor(ep, false);
    }

    private ArrayList<ChromaResearch> getNextResearchesFor(EntityPlayer ep, boolean debug) {
        ChromaResearch pri = this.getPriorityResearchFor(ep);
        if (pri != null) {
            ArrayList<ChromaResearch> li = new ArrayList<ChromaResearch>();
            li.add(pri);
            return li;
        }
        this.checkForUpgrade(ep);
        ArrayList<ChromaResearch> li = new ArrayList<ChromaResearch>();
        for (ChromaResearch r : ChromaResearch.getAllObtainableFragments()) {
            if (this.playerHasFragment(ep, r)) continue;
            if (r.level == null || this.getPlayerResearchLevel(ep).isAtLeast(r.level)) {
                boolean missingdep = false;
                if (!r.canPlayerProgressTo(ep)) {
                    missingdep = true;
                    if (debug) {
                        ChromatiCraft.logger.log((Object)("Fragment " + r + " rejected; insufficient progress " + Arrays.toString(r.getRequiredProgress()) + "."));
                    }
                } else if (!this.playerHasDependencies(r, ep)) {
                    if (debug) {
                        ChromatiCraft.logger.log((Object)("Fragment " + r + " rejected; missing dependency."));
                    }
                    missingdep = true;
                }
                if (missingdep) continue;
                li.add(r);
                continue;
            }
            if (!debug) continue;
            ChromatiCraft.logger.log((Object)("Fragment " + r + " rejected; insufficient research level."));
        }
        return li;
    }

    public boolean playerHasDependencies(ChromaResearch r, EntityPlayer ep) {
        Collection deps = this.data.getParents((Object)r);
        if (deps != null && !deps.isEmpty()) {
            for (ChromaResearch p : deps) {
                if (this.playerHasFragment(ep, p)) continue;
                return false;
            }
        }
        return true;
    }

    public ChromaResearch getRandomNextResearchFor(EntityPlayer ep) {
        ArrayList<ChromaResearch> li = this.getNextResearchesFor(ep);
        return li.isEmpty() ? null : li.get(rand.nextInt(li.size()));
    }

    public Collection<ChromaResearch> getPreReqsFor(ChromaResearch r) {
        Collection c = this.data.getParents((Object)r);
        return c != null ? Collections.unmodifiableCollection(c) : new ArrayList<ChromaResearch>();
    }

    public void removeAllDummiedFragments(Collection<ChromaResearch> li) {
        Iterator<ChromaResearch> it = li.iterator();
        while (it.hasNext()) {
            ChromaResearch r = it.next();
            if (!r.isDummiedOut()) continue;
            it.remove();
        }
    }

    public boolean canPlayerStepTo(EntityPlayer ep, ChromaResearch r) {
        return !r.isDummiedOut() && this.getNextResearchesFor(ep).contains(r);
    }

    public boolean playerHasFragment(EntityPlayer ep, ChromaResearch r) {
        return r.isAlwaysPresent() || r == ChromaResearch.PACKCHANGES || this.getFragments(ep).contains(r);
    }

    public boolean removePlayerFragment(EntityPlayer ep, ChromaResearch r, boolean notify) {
        if (this.playerHasFragment(ep, r)) {
            NBTTagList li = this.getNBTFragments(ep);
            Iterator it = li.field_74747_a.iterator();
            while (it.hasNext()) {
                NBTTagString s = (NBTTagString)it.next();
                if (!s.func_150285_a_().equals(r.name())) continue;
                it.remove();
            }
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            ProgressionLoadHandler.instance.updateProgressCache(ep);
            ProgressionLoadHandler.instance.updateBackup(ep);
            return true;
        }
        return false;
    }

    public boolean givePlayerFragment(EntityPlayer ep, ChromaResearch r, boolean notify) {
        if (!this.playerHasFragment(ep, r)) {
            this.getNBTFragments(ep).func_74742_a((NBTBase)new NBTTagString(r.name()));
            this.checkForUpgrade(ep);
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            if (notify) {
                this.notifyPlayerOfProgression(ep, r);
            }
            ProgressionLoadHandler.instance.updateProgressCache(ep);
            ProgressionLoadHandler.instance.updateBackup(ep);
            MinecraftForge.EVENT_BUS.post((Event)new ProgressionEvent(ep, r.name(), ProgressionEvent.ResearchType.FRAGMENT));
            return true;
        }
        return false;
    }

    public void checkForUpgrade(EntityPlayer ep) {
        ResearchLevel next;
        ResearchLevel rl = this.getPlayerResearchLevel(ep);
        Collection<ChromaResearch> li = this.getResearchForLevel(rl);
        if (this.playerHasAllFragmentsThatMatter(ep, li) && rl.ordinal() < ResearchLevel.levelList.length - 1 && (next = ResearchLevel.levelList[rl.ordinal() + 1]).canProgressTo(ep)) {
            this.stepPlayerResearchLevel(ep, next);
        }
    }

    public Collection<ChromaResearch> getResearchForLevelAndBelow(ResearchLevel rl) {
        ArrayList<ChromaResearch> c = new ArrayList<ChromaResearch>();
        while (true) {
            c.addAll(ChromaResearch.getPagesFor(rl));
            if (rl == rl.pre()) break;
            rl = rl.pre();
        }
        return c;
    }

    public Collection<ChromaResearch> getResearchForLevel(ResearchLevel rl) {
        return Collections.unmodifiableCollection(ChromaResearch.getPagesFor(rl));
    }

    public Collection<ChromaResearch> getMissingResearch(EntityPlayer ep) {
        return this.getMissingResearch(ep, null);
    }

    public Collection<ChromaResearch> getMissingResearch(EntityPlayer ep, ProgressStage req) {
        ArrayList<ChromaResearch> ret = new ArrayList<ChromaResearch>();
        for (ChromaResearch r : ChromaResearch.getPagesFor(this.getPlayerResearchLevel(ep))) {
            if (!r.isGating() || this.playerHasFragment(ep, r) || req != null && !r.requiresProgress(req)) continue;
            ret.add(r);
        }
        return ret;
    }

    private boolean playerHasAllFragmentsThatMatter(EntityPlayer ep, Collection<ChromaResearch> li) {
        for (ChromaResearch r : li) {
            if (!r.isGating() || this.playerHasFragment(ep, r)) continue;
            return false;
        }
        return true;
    }

    private boolean playerHasAllFragments(EntityPlayer ep, Collection<ChromaResearch> li) {
        for (ChromaResearch r : li) {
            if (this.playerHasFragment(ep, r)) continue;
            return false;
        }
        return true;
    }

    public boolean stepPlayerResearchLevel(EntityPlayer ep, ResearchLevel r) {
        return this.getPlayerResearchLevel(ep).ordinal() == r.ordinal() - 1 && this.setPlayerResearchLevel(ep, r, true);
    }

    public boolean setPlayerResearchLevel(EntityPlayer ep, ResearchLevel r, boolean notify) {
        if (this.movePlayerTo(ep, r)) {
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            if (notify) {
                this.notifyPlayerOfProgression(ep, r);
            }
            ProgressionLoadHandler.instance.updateProgressCache(ep);
            ProgressionLoadHandler.instance.updateBackup(ep);
            return true;
        }
        return false;
    }

    public ResearchLevel getPlayerResearchLevel(EntityPlayer ep) {
        NBTTagCompound base = this.getRootProgressionNBT(ep);
        NBTBase tag = base.func_74781_a("research_level");
        if (tag instanceof NBTTagString) {
            return ResearchLevel.valueOf(((NBTTagString)tag).func_150285_a_());
        }
        int idx = base.func_74762_e("research_level");
        if (idx > ResearchLevel.ENERGY.ordinal()) {
            --idx;
        }
        ResearchLevel ret = ResearchLevel.levelList[idx];
        base.func_74778_a("research_level", ret.name());
        return ret;
    }

    public void maxPlayerResearch(EntityPlayer ep, boolean notify) {
        this.setPlayerResearchLevel(ep, ResearchLevel.levelList[ResearchLevel.levelList.length - 1], notify);
        for (ChromaResearch chromaResearch : ChromaResearch.getAllObtainableFragments()) {
            this.givePlayerFragment(ep, chromaResearch, notify);
        }
        for (CastingRecipe castingRecipe : RecipesCastingTable.instance.getAllRecipes()) {
            this.givePlayerRecipe(ep, castingRecipe);
        }
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public void resetPlayerResearch(EntityPlayer ep, boolean notify) {
        this.getRootNBTTag(ep).func_82580_o(NBT_TAG);
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
    }

    public Collection<ChromaResearch> getFragments(EntityPlayer ep) {
        HashSet<ChromaResearch> c = new HashSet<ChromaResearch>();
        NBTTagList li = this.getNBTFragments(ep);
        for (Object o : li.field_74747_a) {
            ChromaResearch r = ChromaResearch.getByName(((NBTTagString)o).func_150285_a_());
            if (r == null) continue;
            c.add(r);
        }
        return c;
    }

    private NBTTagList getNBTFragments(EntityPlayer ep) {
        String key = "fragments";
        NBTTagCompound tag = this.getRootProgressionNBT(ep);
        if (!tag.func_74764_b(key)) {
            tag.func_74782_a(key, (NBTBase)new NBTTagList());
        }
        NBTTagList li = tag.func_150295_c(key, ReikaNBTHelper.NBTTypes.STRING.ID);
        tag.func_74782_a(key, (NBTBase)li);
        return li;
    }

    public NBTTagCompound getRootProgressionNBT(EntityPlayer ep) {
        NBTTagCompound nbt = this.getRootNBTTag(ep);
        if (!nbt.func_74764_b(NBT_TAG)) {
            nbt.func_74782_a(NBT_TAG, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound li = nbt.func_74775_l(NBT_TAG);
        return li;
    }

    private boolean movePlayerTo(EntityPlayer ep, ResearchLevel rl) {
        ResearchLevel at = this.getPlayerResearchLevel(ep);
        if (at != rl) {
            NBTTagCompound tag = instance.getRootProgressionNBT(ep);
            tag.func_74778_a("research_level", rl.name());
            return true;
        }
        return false;
    }

    public NBTTagCompound getRootNBTTag(EntityPlayer ep) {
        NBTTagCompound repl;
        NBTTagCompound tag;
        NBTTagCompound nBTTagCompound = tag = ReikaPlayerAPI.isFake((EntityPlayer)ep) ? null : ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep);
        if ((tag == null || tag.func_82582_d()) && (repl = ProgressionLoadHandler.instance.attemptToLoadBackup(ep)) != null) {
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            ReikaNBTHelper.copyNBT((NBTTagCompound)repl, (NBTTagCompound)tag);
        }
        return tag;
    }

    public void notifyPlayerOfProgression(EntityPlayer ep, ProgressElement p) {
        if (ep.field_70170_p.field_72995_K) {
            ChromaOverlays.instance.addProgressionNote(p);
        } else if (ep instanceof EntityPlayerMP) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.PROGRESSNOTE.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{this.getID(p)});
            if (ChromaOptions.PROGRESSNOTIFY.getState()) {
                if (ChromaOptions.PROGRESSNOTIFY_SELF.getState()) {
                    ChromaAux.notifyServerPlayers(ep, p);
                } else {
                    ChromaAux.notifyServerPlayersExcept(ep, p);
                }
            }
        }
    }

    public boolean playerHasUsedRecipe(EntityPlayer ep, CastingRecipe cr) {
        return this.getPlayerRecipes(ep).contains(cr.getIDCode());
    }

    public boolean givePlayerRecipe(EntityPlayer ep, CastingRecipe cr) {
        if (!this.playerHasUsedRecipe(ep, cr)) {
            this.getNBTRecipes(ep).func_74742_a((NBTBase)new NBTTagInt(cr.getIDCode()));
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            return true;
        }
        return false;
    }

    private Collection<Integer> getPlayerRecipes(EntityPlayer ep) {
        HashSet<Integer> c = new HashSet<Integer>();
        NBTTagList li = this.getNBTRecipes(ep);
        for (Object o : li.field_74747_a) {
            int s = ((NBTTagInt)o).func_150287_d();
            c.add(s);
        }
        return c;
    }

    private NBTTagList getNBTRecipes(EntityPlayer ep) {
        String key = "recipes";
        NBTTagCompound tag = this.getRootProgressionNBT(ep);
        if (!tag.func_74764_b(key)) {
            tag.func_74782_a(key, (NBTBase)new NBTTagList());
        }
        NBTTagList li = tag.func_150295_c(key, ReikaNBTHelper.NBTTypes.INT.ID);
        tag.func_74782_a(key, (NBTBase)li);
        return li;
    }

    public void register(ProgressElement p) {
        this.progressIDs.put((Object)this.progressIDs.size(), (Object)p);
    }

    public ProgressElement getProgressForID(int id) {
        return (ProgressElement)this.progressIDs.get((Object)id);
    }

    public int getID(ProgressElement e) {
        return (Integer)this.progressIDs.inverse().get((Object)e);
    }

    @Override
    public boolean playerHasResearch(EntityPlayer ep, String key) {
        ChromaResearch r = ChromaResearch.getByName(key.toUpperCase());
        if (r == null) {
            ChromatiCraft.logger.logError((Object)("A mod tried to fetch the state of an invalid research '" + key + "'!"));
            Thread.dumpStack();
            return false;
        }
        return this.playerHasFragment(ep, r);
    }

    @Override
    public boolean lexiconHasFragment(ItemStack book, String key) {
        ChromaResearch r = ChromaResearch.getByName(key.toUpperCase());
        if (r == null) {
            ChromatiCraft.logger.logError((Object)("A mod tried to fetch the state of an invalid research '" + key + "'!"));
            Thread.dumpStack();
            return false;
        }
        return ItemChromaBook.hasPage(book, r);
    }

    @Override
    public HashSet<String> getAllResearches() {
        HashSet<String> c = new HashSet<String>();
        for (ChromaResearch r : ChromaResearch.getAllNonParents()) {
            c.add(r.name());
        }
        return c;
    }

    @Override
    public HashSet<String> getPrerequisites(String key) {
        ChromaResearch r = ChromaResearch.getByName(key.toUpperCase());
        if (r == null) {
            ChromatiCraft.logger.logError((Object)("A mod tried to fetch the state of an invalid research '" + key + "'!"));
            Thread.dumpStack();
            return null;
        }
        Collection<ChromaResearch> c = this.getPreReqsFor(r);
        HashSet<String> h = new HashSet<String>();
        for (ChromaResearch req : c) {
            h.add(req.name());
        }
        return h;
    }

    @Override
    public String getResearchLevelForPlayer(EntityPlayer ep) {
        return this.getPlayerResearchLevel(ep).name();
    }

    public ResearchLevel getEarliestResearchLevelRequiring(ProgressStage p) {
        ResearchLevel min = ProgressionManager.instance.getEarliestAllowedGate(p);
        ResearchLevel rl = null;
        for (ChromaResearch r : ChromaResearch.getAllObtainableFragments()) {
            if (!r.isGating() || !r.requiresProgress(p) || rl != null && !rl.isAtLeast(r.level)) continue;
            rl = r.level;
        }
        if (rl != null && min.isAtLeast(rl)) {
            rl = min;
        }
        return rl;
    }

    public static interface ProgressElement {
        public String getTitle();

        public String getShortDesc();

        @SideOnly(value=Side.CLIENT)
        public void renderIcon(RenderItem var1, FontRenderer var2, int var3, int var4);

        public String getFormatting();

        public boolean giveToPlayer(EntityPlayer var1, boolean var2);
    }

    private static class ChromaResearchTarget {
        private final ChromaResearch fragment;
        private final int weight;

        private ChromaResearchTarget(ChromaResearch r, int w) {
            this.fragment = r;
            this.weight = w;
        }
    }

    private static final class ChromaResearchComparator
    implements Comparator<ChromaResearch> {
        private ChromaResearchComparator() {
        }

        @Override
        public int compare(ChromaResearch o1, ChromaResearch o2) {
            return 1000 * (o1.level.ordinal() - o2.level.ordinal()) + o1.ordinal() - o2.ordinal();
        }
    }
}

