/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Progression;

import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemUnknownArtefact;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressAccess;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.lwjgl.opengl.GL11;

public enum ProgressStage implements ChromaResearchManager.ProgressElement,
ProgressAccess
{
    CASTING(Shareability.SELFONLY, Reloadability.NEVER, ChromaTiles.TABLE, new boolean[0]),
    CRYSTALS(Shareability.SELFONLY, Reloadability.NEVER, ChromaBlocks.CRYSTAL.getStackOfMetadata(CrystalElement.RED.ordinal()), new boolean[0]),
    DYETREE(Shareability.SELFONLY, Reloadability.NEVER, ChromaBlocks.DYELEAF.getStackOfMetadata(CrystalElement.YELLOW.ordinal()), new boolean[0]),
    MULTIBLOCK(Shareability.PROXIMITY, Reloadability.TRIGGER, ChromaTiles.STAND, new boolean[0]),
    RUNEUSE(Shareability.PROXIMITY, Reloadability.TRIGGER, ChromaBlocks.RUNE.getStackOfMetadata(CrystalElement.ORANGE.ordinal()), new boolean[0]),
    PYLON(Shareability.SELFONLY, Reloadability.NEVER, ChromaTiles.PYLON, new boolean[0]),
    LINK(Shareability.PROXIMITY, Reloadability.NEVER, ChromaTiles.COMPOUND, new boolean[0]),
    CHARGE(Shareability.SELFONLY, Reloadability.NEVER, ChromaItems.TOOL.getStackOf(), new boolean[0]),
    ABILITY(Shareability.SELFONLY, Reloadability.NEVER, ChromaTiles.RITUAL, new boolean[0]),
    RAINBOWLEAF(Shareability.PROXIMITY, Reloadability.ALWAYS, ChromaBlocks.RAINBOWLEAF.getStackOfMetadata(3), new boolean[0]),
    MAKECHROMA(Shareability.PROXIMITY, Reloadability.ALWAYS, ChromaTiles.COLLECTOR, new boolean[0]),
    SHARDCHARGE(Shareability.PROXIMITY, Reloadability.NEVER, ChromaStacks.chargedRedShard, new boolean[0]),
    ALLOY(Shareability.PROXIMITY, Reloadability.NEVER, ChromaStacks.chromaIngot, new boolean[0]),
    INFUSE(Shareability.PROXIMITY, Reloadability.NEVER, ChromaTiles.INFUSER, new boolean[0]),
    CHROMA(Shareability.SELFONLY, Reloadability.NEVER, ChromaBlocks.CHROMA.getBlockInstance(), new boolean[0]),
    SHOCK(Shareability.SELFONLY, Reloadability.NEVER, ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(5), new boolean[0]),
    HIVE(Shareability.ALWAYS, Reloadability.ALWAYS, new ItemStack(ChromaBlocks.HIVE.getBlockInstance()), ModList.FORESTRY.isLoaded()),
    NETHER(Shareability.SELFONLY, Reloadability.NEVER, (Block)Blocks.field_150427_aO, new boolean[0]),
    END(Shareability.SELFONLY, Reloadability.NEVER, Blocks.field_150378_br, new boolean[0]),
    TWILIGHT(Shareability.SELFONLY, Reloadability.NEVER, ModList.TWILIGHT.isLoaded() ? ModWoodList.CANOPY.getItem().asItemStack() : null, ModList.TWILIGHT.isLoaded()),
    BEDROCK(Shareability.PROXIMITY, Reloadability.ALWAYS, Blocks.field_150357_h, new boolean[0]),
    CAVERN(Shareability.ALWAYS, Reloadability.ALWAYS, ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CLOAK.metadata), new boolean[0]),
    BURROW(Shareability.ALWAYS, Reloadability.ALWAYS, ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.MOSS.metadata), new boolean[0]),
    OCEAN(Shareability.ALWAYS, Reloadability.ALWAYS, ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.GLASS.metadata), new boolean[0]),
    DESERTSTRUCT(Shareability.ALWAYS, Reloadability.ALWAYS, ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.COBBLE.metadata), new boolean[0]),
    SNOWSTRUCT(Shareability.ALWAYS, Reloadability.ALWAYS, ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.LIGHT.metadata), new boolean[0]),
    BIOMESTRUCT(Shareability.ALWAYS, Reloadability.ALWAYS, ChromaBlocks.COLORLOCK.getStackOf(), new boolean[0]),
    DIE(Shareability.SELFONLY, Reloadability.NEVER, Items.field_151144_bL, new boolean[0]),
    ALLCOLORS(Shareability.SELFONLY, Reloadability.NEVER, ChromaItems.ELEMENTAL.getStackOf(CrystalElement.CYAN), new boolean[0]),
    REPEATER(Shareability.ALWAYS, Reloadability.TRIGGER, ChromaTiles.REPEATER, new boolean[0]),
    RAINBOWFOREST(Shareability.PROXIMITY, Reloadability.ALWAYS, ChromaBlocks.RAINBOWSAPLING.getBlockInstance(), new boolean[0]),
    DIMENSION(Shareability.SELFONLY, Reloadability.NEVER, ChromaBlocks.PORTAL.getBlockInstance(), new boolean[0]),
    CTM(Shareability.SELFONLY, Reloadability.NEVER, ChromaTiles.AURAPOINT, new boolean[0]),
    STORAGE(Shareability.ALWAYS, Reloadability.TRIGGER, ChromaItems.STORAGE.getStackOf(), new boolean[0]),
    CHARGECRYSTAL(Shareability.ALWAYS, Reloadability.ALWAYS, ChromaTiles.CHARGER, new boolean[0]),
    BALLLIGHTNING(Shareability.PROXIMITY, Reloadability.ALWAYS, ChromaStacks.auraDust, new boolean[0]),
    POWERCRYSTAL(Shareability.PROXIMITY, Reloadability.TRIGGER, ChromaTiles.CRYSTAL, new boolean[0]),
    POWERTREE(Shareability.PROXIMITY, Reloadability.TRIGGER, ChromaBlocks.POWERTREE.getStackOfMetadata(CrystalElement.YELLOW.ordinal()), new boolean[0]),
    TURBOCHARGE(Shareability.PROXIMITY, Reloadability.NEVER, ChromaTiles.PYLONTURBO, new boolean[0]),
    FINDSPAWNER(Shareability.PROXIMITY, Reloadability.NEVER, new ItemStack(Blocks.field_150474_ac), new boolean[0]),
    BREAKSPAWNER(Shareability.ALWAYS, Reloadability.ALWAYS, new ItemStack(Items.field_151063_bx, 1, ((Integer)EntityList.field_75624_e.get(EntitySpider.class)).intValue()), new boolean[0]),
    KILLDRAGON(Shareability.PROXIMITY, Reloadability.ALWAYS, new ItemStack(Blocks.field_150380_bt), new boolean[0]),
    KILLWITHER(Shareability.PROXIMITY, Reloadability.ALWAYS, new ItemStack(Items.field_151156_bN), new boolean[0]),
    KILLMOB(Shareability.SELFONLY, Reloadability.NEVER, new ItemStack(Items.field_151144_bL, 1, 4), new boolean[0]),
    ALLCORES(Shareability.SELFONLY, Reloadability.NEVER, ChromaTiles.DIMENSIONCORE.getCraftedNBTProduct("color", CrystalElement.RED.ordinal()), new boolean[0]),
    USEENERGY(Shareability.PROXIMITY, Reloadability.NEVER, ChromaTiles.WEAKREPEATER, new boolean[0]),
    BLOWREPEATER(Shareability.PROXIMITY, Reloadability.ALWAYS, ChromaStacks.crystalPowder, new boolean[0]),
    STRUCTCOMPLETE(Shareability.SELFONLY, Reloadability.NEVER, ChromaBlocks.DIMDATA.getStackOf(), new boolean[0]),
    NETHERROOF(Shareability.SELFONLY, Reloadability.NEVER, Blocks.field_150424_aL, new boolean[0]),
    NETHERSTRUCT(Shareability.PROXIMITY, Reloadability.ALWAYS, new ItemStack(Blocks.field_150385_bj), new boolean[0]),
    VILLAGECASTING(Shareability.PROXIMITY, Reloadability.ALWAYS, new ItemStack(Blocks.field_150347_e), new boolean[0]),
    FOCUSCRYSTAL(Shareability.ALWAYS, Reloadability.TRIGGER, new ItemStack(Items.field_151166_bC), new boolean[0]),
    ANYSTRUCT(Shareability.SELFONLY, Reloadability.NEVER, ChromaTiles.STRUCTCONTROL, new boolean[0]),
    ARTEFACT(Shareability.SELFONLY, Reloadability.NEVER, ChromaItems.ARTEFACT.getStackOfMetadata(ItemUnknownArtefact.ArtefactTypes.FRAGMENT.ordinal()), new boolean[0]),
    TOWER(Shareability.SELFONLY, Reloadability.NEVER, ChromaTiles.DATANODE, new boolean[0]),
    STRUCTCHEAT(Shareability.SELFONLY, Reloadability.NEVER, Blocks.field_150335_W, new boolean[0]),
    VOIDMONSTER(Shareability.PROXIMITY, Reloadability.NEVER, (ItemStack)null, ModList.VOIDMONSTER.isLoaded()),
    VOIDMONSTERDIE(Shareability.PROXIMITY, Reloadability.ALWAYS, (ItemStack)null, ModList.VOIDMONSTER.isLoaded()),
    LUMA(Shareability.SELFONLY, Reloadability.NEVER, ChromaBlocks.LUMA.getBlockInstance(), new boolean[0]),
    WARPNODE(Shareability.SELFONLY, Reloadability.NEVER, ChromaBlocks.WARPNODE.getBlockInstance(), new boolean[0]),
    BYPASSWEAK(Shareability.ALWAYS, Reloadability.ALWAYS, (ItemStack)null, new boolean[0]),
    TUNECAST(Shareability.SELFONLY, Reloadability.TRIGGER, (ItemStack)null, new boolean[0]),
    PYLONLINK(Shareability.SELFONLY, Reloadability.TRIGGER, ChromaTiles.PYLONLINK.getCraftedProduct(), new boolean[0]),
    RELAYS(Shareability.PROXIMITY, Reloadability.TRIGGER, ChromaTiles.RELAYSOURCE.getCraftedProduct(), new boolean[0]),
    ENERGYIDEA(Shareability.SELFONLY, Reloadability.NEVER, (ItemStack)null, new boolean[0]),
    NODE(Shareability.PROXIMITY, Reloadability.NEVER, ModList.THAUMCRAFT.isLoaded() ? ThaumItemHelper.BlockEntry.NODE.getItem() : null, ModList.THAUMCRAFT.isLoaded()),
    POTION(Shareability.SELFONLY, Reloadability.NEVER, ReikaPotionHelper.getPotionItem((Potion)Potion.field_76428_l, (boolean)true, (boolean)true, (boolean)false), new boolean[0]),
    MINE(Shareability.PROXIMITY, Reloadability.NEVER, Blocks.field_150366_p, new boolean[0]),
    DEEPCAVE(Shareability.PROXIMITY, Reloadability.NEVER, Blocks.field_150353_l, new boolean[0]),
    HARVEST(Shareability.PROXIMITY, Reloadability.NEVER, Items.field_151015_O, new boolean[0]),
    MYST(Shareability.PROXIMITY, Reloadability.NEVER, ModList.MYSTCRAFT.isLoaded() ? MystCraftHandler.getInstance().bookID : null, ModList.MYSTCRAFT.isLoaded()),
    NEVER(Shareability.SELFONLY, Reloadability.NEVER, (ItemStack)null, false);

    private final ItemStack icon;
    public final boolean active;
    public final Shareability shareLevel;
    public final Reloadability reloadLevel;
    public static final ProgressStage[] list;

    private ProgressStage(Shareability s, Reloadability r, Block b, boolean ... cond) {
        this(s, r, new ItemStack(b), cond);
    }

    private ProgressStage(Shareability s, Reloadability r, Item b, boolean ... cond) {
        this(s, r, new ItemStack(b), cond);
    }

    private ProgressStage(Shareability s, Reloadability r, ChromaTiles t, boolean ... cond) {
        this(s, r, t.getCraftedProduct(), cond);
    }

    private ProgressStage(Shareability s, Reloadability r, ItemStack is, boolean ... cond) {
        this.icon = is;
        boolean flag = true;
        for (int i = 0; i < cond.length; ++i) {
            flag = flag && cond[i];
        }
        this.active = flag;
        ChromaResearchManager.instance.register(this);
        this.shareLevel = s;
        this.reloadLevel = r;
    }

    public boolean stepPlayerTo(EntityPlayer ep) {
        return ProgressionManager.instance.stepPlayerTo(ep, this, true, true);
    }

    public boolean stepPlayerTo(EntityPlayer ep, boolean syncToCoop) {
        return ProgressionManager.instance.stepPlayerTo(ep, this, true, syncToCoop);
    }

    public boolean isPlayerAtStage(EntityPlayer ep) {
        return ProgressionManager.instance.isPlayerAtStage(ep, this);
    }

    public boolean isPlayerAtStage(World world, UUID id) {
        EntityPlayer ep = world.func_152378_a(id);
        if (ep == null && world instanceof WorldServer) {
            ep = ReikaPlayerAPI.getFakePlayerByNameAndUUID((WorldServer)((WorldServer)world), (String)"Progress Backup", (UUID)id);
        }
        return ep != null && ProgressionManager.instance.isPlayerAtStage(ep, this);
    }

    public boolean playerHasPrerequisites(EntityPlayer ep) {
        return ProgressionManager.instance.playerHasPrerequisites(ep, this);
    }

    public boolean isOneStepAway(EntityPlayer ep) {
        return ProgressionManager.instance.isOneStepAway(ep, this);
    }

    @Override
    public String getTitle() {
        return this.getTitleString();
    }

    @Override
    public String getShortDesc() {
        return ChromaDescriptions.getProgressText((ProgressStage)this).desc;
    }

    public String getTitleString() {
        return ChromaDescriptions.getProgressText((ProgressStage)this).title;
    }

    public String getHintString() {
        return ChromaDescriptions.getProgressText((ProgressStage)this).hint;
    }

    public String getRevealedString() {
        return ChromaDescriptions.getProgressText((ProgressStage)this).reveal;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderIcon(RenderItem ri, FontRenderer fr, int x, int y) {
        if (this == ANYSTRUCT) {
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            ReikaGuiAPI.instance.func_94065_a(x, y, ChromaIcons.SPINFLARE.getIcon(), 16, 16);
            GL11.glPopAttrib();
        } else if (this == VOIDMONSTER || this == VOIDMONSTERDIE) {
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            ReikaGuiAPI.instance.renderStatic(x - 1, y - 1, x + 16, y + 16);
            if (this == VOIDMONSTERDIE) {
                ReikaGuiAPI.instance.drawItemStack(ri, fr, new ItemStack(Items.field_151144_bL), x, y);
            }
            GL11.glPopAttrib();
        } else if (this == WARPNODE) {
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/warpnode-small.png");
            int idx = (int)(System.currentTimeMillis() / 20L % 64L);
            double u = (double)(idx % 8) / 8.0;
            double v = (double)(idx / 8) / 8.0;
            double du = u + 0.125;
            double dv = v + 0.125;
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            int d = 2;
            int w = 16;
            int h = 16;
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            v5.func_78374_a((double)(x + 0 - d), (double)(y + h + d), 0.0, u, dv);
            v5.func_78374_a((double)(x + w + d), (double)(y + h + d), 0.0, du, dv);
            v5.func_78374_a((double)(x + w + d), (double)(y + 0 - d), 0.0, du, v);
            v5.func_78374_a((double)(x + 0 - d), (double)(y + 0 - d), 0.0, u, v);
            v5.func_78381_a();
            GL11.glPopAttrib();
        } else if (this == BYPASSWEAK) {
            ReikaGuiAPI.instance.drawItemStack(ri, fr, ChromaTiles.WEAKREPEATER.getCraftedProduct(), x, y);
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            boolean has = this.isPlayerAtStage((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (has) {
                ReikaGLHelper.BlendMode.DEFAULT.apply();
            } else {
                ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            }
            ChromaIcons ico = has ? ChromaIcons.X : ChromaIcons.QUESTION;
            ReikaGuiAPI.instance.func_94065_a(x + 2, y + 2, ico.getIcon(), 12, 12);
            GL11.glPopAttrib();
        } else if (this == TUNECAST) {
            ChromaResearch.CASTTUNING.renderIcon(ri, fr, x, y);
            double s = 0.6;
            GL11.glPushMatrix();
            GL11.glScaled((double)s, (double)s, (double)s);
            ReikaGuiAPI.instance.drawItemStack(ri, fr, ChromaTiles.TABLE.getCraftedProduct(), (int)((double)x / s + 12.0), (int)((double)y / s + 12.0));
            GL11.glPopMatrix();
        } else if (this == ENERGYIDEA) {
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/infoicons.png");
            int idx = 32;
            double u = (double)(idx % 16) / 16.0;
            double v = (double)(idx / 16) / 16.0;
            double du = u + 0.0625;
            double dv = v + 0.0625;
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVE2.apply();
            int d = 2;
            int w = 16;
            int h = 16;
            Tessellator v5 = Tessellator.field_78398_a;
            v5.func_78382_b();
            v5.func_78374_a((double)(x + 0 - d), (double)(y + h + d), 0.0, u, dv);
            v5.func_78374_a((double)(x + w + d), (double)(y + h + d), 0.0, du, dv);
            v5.func_78374_a((double)(x + w + d), (double)(y + 0 - d), 0.0, du, v);
            v5.func_78374_a((double)(x + 0 - d), (double)(y + 0 - d), 0.0, u, v);
            v5.func_78381_a();
            GL11.glPopAttrib();
        } else {
            ReikaGuiAPI.instance.drawItemStack(ri, fr, this.icon, x, y);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderIconInWorld(Tessellator v5, double s, int x, int y, float f) {
        if (this == ANYSTRUCT) {
            ReikaTextureHelper.bindTerrainTexture();
            GL11.glPushAttrib((int)1048575);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
            ReikaGuiAPI.instance.func_94065_a(x, y, ChromaIcons.SPINFLARE.getIcon(), 16, 16);
            IIcon ico = ChromaIcons.SPINFLARE.getIcon();
            v5.func_78382_b();
            v5.func_78378_d(ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)f));
            v5.func_78374_a(-s, s, 0.0, (double)ico.func_94209_e(), (double)ico.func_94210_h());
            v5.func_78374_a(s, s, 0.0, (double)ico.func_94212_f(), (double)ico.func_94210_h());
            v5.func_78374_a(s, -s, 0.0, (double)ico.func_94212_f(), (double)ico.func_94206_g());
            v5.func_78374_a(-s, -s, 0.0, (double)ico.func_94209_e(), (double)ico.func_94206_g());
            v5.func_78381_a();
            GL11.glPopAttrib();
            GL11.glPopMatrix();
        } else if (this != VOIDMONSTER) {
            if (this == WARPNODE) {
                ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/warpnode-small.png");
                int idx = (int)(System.currentTimeMillis() / 20L % 64L);
                double u = (double)(idx % 8) / 8.0;
                double v = (double)(idx / 8) / 8.0;
                double du = u + 0.125;
                double dv = v + 0.125;
                GL11.glPushAttrib((int)1048575);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)3042);
                ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
                double w = 1.0 * s;
                double h = 1.0 * s;
                v5.func_78382_b();
                v5.func_78378_d(ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)f));
                v5.func_78374_a((double)x - w, (double)y + h, 0.0, u, dv);
                v5.func_78374_a((double)x + w, (double)y + h, 0.0, du, dv);
                v5.func_78374_a((double)x + w, (double)y - h, 0.0, du, v);
                v5.func_78374_a((double)x - w, (double)y - h, 0.0, u, v);
                v5.func_78381_a();
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            } else if (this == ENERGYIDEA) {
                ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/infoicons.png");
                int idx = 32;
                double u = (double)(idx % 16) / 16.0;
                double v = (double)(idx / 16) / 16.0;
                double du = u + 0.0625;
                double dv = v + 0.0625;
                GL11.glPushAttrib((int)1048575);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glAlphaFunc((int)516, (float)0.03125f);
                GL11.glEnable((int)3042);
                ReikaGLHelper.BlendMode.ADDITIVEDARK.apply();
                double w = 1.0 * s;
                double h = 1.0 * s;
                v5.func_78382_b();
                v5.func_78378_d(ReikaColorAPI.getColorWithBrightnessMultiplier((int)0xFFFFFF, (float)f));
                v5.func_78374_a((double)x - w, (double)y - h, 0.0, u, dv);
                v5.func_78374_a((double)x + w, (double)y - h, 0.0, du, dv);
                v5.func_78374_a((double)x + w, (double)y + h, 0.0, du, v);
                v5.func_78374_a((double)x - w, (double)y + h, 0.0, u, v);
                v5.func_78381_a();
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            } else {
                GL11.glPopMatrix();
                ItemStack is = this.icon;
                if (this == BYPASSWEAK) {
                    is = ChromaTiles.WEAKREPEATER.getCraftedProduct();
                } else if (this == TUNECAST) {
                    // empty if block
                }
                ChromaItems r = ChromaItems.getEntry(is);
                boolean block = r != null && r.isPlacer() || Block.func_149634_a((Item)is.func_77973_b()) != Blocks.field_150350_a;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)f);
                GL11.glDepthMask((boolean)block);
                InertItem ei = new InertItem((World)Minecraft.func_71410_x().field_71441_e, is);
                ei.field_70292_b = 0;
                ei.field_70290_d = MathHelper.func_76126_a((float)((float)System.currentTimeMillis() / 100.0f));
                ei.field_70177_z = 0.0f;
                ReikaRenderHelper.disableEntityLighting();
                RenderItem.field_82407_g = true;
                this.setItemRBTintField(false);
                RenderManager.field_78727_a.func_147940_a((Entity)ei, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                this.setItemRBTintField(true);
                RenderItem.field_82407_g = false;
                ReikaRenderHelper.enableEntityLighting();
            }
        }
    }

    private void setItemRBTintField(boolean flag) {
        RenderItem ri = (RenderItem)RenderManager.field_78727_a.field_78729_o.get(EntityItem.class);
        ri.field_147913_i.field_147844_c = flag;
    }

    public boolean alwaysRenderFullBright() {
        return this == BYPASSWEAK;
    }

    public boolean isGatedAfter(ProgressStage p) {
        return ProgressionManager.instance.getRecursiveParents(this).contains(p);
    }

    @Override
    public String getFormatting() {
        return EnumChatFormatting.UNDERLINE.toString();
    }

    @Override
    public boolean giveToPlayer(EntityPlayer ep, boolean notify) {
        return ProgressionManager.instance.stepPlayerTo(ep, this, notify, true);
    }

    public void forceOnPlayer(EntityPlayer ep, boolean notify) {
    }

    public Shareability getShareability() {
        return this.shareLevel;
    }

    public boolean isGating(ResearchLevel level) {
        return ProgressionManager.instance.isProgressionGating(this, level);
    }

    @Override
    public boolean playerHas(EntityPlayer ep) {
        return this.isPlayerAtStage(ep);
    }

    static {
        list = ProgressStage.values();
    }

    public static enum Reloadability {
        NEVER,
        TRIGGER,
        ALWAYS;

    }

    public static enum Shareability {
        SELFONLY,
        PROXIMITY,
        ALWAYS;


        public boolean canShareTo(EntityPlayer from, EntityPlayer to) {
            switch (this) {
                case ALWAYS: {
                    return true;
                }
                case PROXIMITY: {
                    return from.field_70170_p.field_73011_w.field_76574_g == to.field_70170_p.field_73011_w.field_76574_g && to.func_70068_e((Entity)from) <= 576.0;
                }
                case SELFONLY: {
                    return false;
                }
            }
            return false;
        }
    }
}

