/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Progression;

import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionLinking;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingTable;
import Reika.DragonAPI.Base.TileEntityBase;
import Reika.DragonAPI.Instantiable.RayTracer;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class ProgressionCatchupHandling {
    public static final ProgressionCatchupHandling instance = new ProgressionCatchupHandling();
    private final RayTracer LOS = RayTracer.getVisualLOS();
    private int progressPacketCooldown = 0;

    private ProgressionCatchupHandling() {
    }

    public void attemptSync(TileEntityBase te, double maxDist, ProgressStage p) {
        this.attemptSync(te, maxDist, p, false);
    }

    public void attemptSync(TileEntityBase te, double maxDist, ProgressStage p, boolean ignoreTime) {
        if (ignoreTime || te.getTicksExisted() % 10 == 0) {
            if (this.progressPacketCooldown > 0) {
                --this.progressPacketCooldown;
            }
            if (this.progressPacketCooldown < 20) {
                this.triggerProgressCatchup((TileEntity)te, maxDist, p);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void triggerProgressCatchup(TileEntity te, double maxDist, ProgressStage p) {
        AxisAlignedBB box;
        double dist;
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        if (ProgressionLinking.instance.hasLinkedPlayers((EntityPlayer)ep) && ProgressionManager.instance.canStepPlayerTo((EntityPlayer)ep, p) && (dist = ep.func_70092_e((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5)) <= maxDist * maxDist && ReikaRenderHelper.renderFrustrum.func_78546_a(box = ReikaAABBHelper.getBlockAABB((TileEntity)te))) {
            this.LOS.setOrigins((double)te.field_145851_c + 0.5, (double)te.field_145848_d + 0.5, (double)te.field_145849_e + 0.5, ep.field_70165_t, ep.field_70163_u, ep.field_70161_v);
            if (this.LOS.isClearLineOfSight(te.field_145850_b)) {
                ReikaPacketHelper.sendPacketToServer((String)"ChromaData", (int)ChromaPackets.PROGSYNC.ordinal(), (TileEntity)te, (int[])new int[]{p.ordinal()});
                ++this.progressPacketCooldown;
            }
        }
    }

    public static enum CastingProgressSyncTriggers {
        FOCUS(ProgressStage.FOCUSCRYSTAL),
        MULTI(ProgressStage.MULTIBLOCK),
        RUNES(ProgressStage.RUNEUSE),
        TUNED(ProgressStage.TUNECAST);

        public final ProgressStage progress;

        private CastingProgressSyncTriggers(ProgressStage p) {
            this.progress = p;
        }

        public boolean isValid(TileEntityCastingTable te) {
            switch (this) {
                case FOCUS: {
                    return te.getAccelerationFactor() > 1.0f;
                }
                case MULTI: {
                    return te.isAtLeast(CastingRecipe.RecipeType.MULTIBLOCK);
                }
                case RUNES: {
                    return te.isAtLeast(CastingRecipe.RecipeType.TEMPLE) && te.hasRunes();
                }
                case TUNED: {
                    return te.isTuned();
                }
            }
            return false;
        }

        public static Collection<CastingProgressSyncTriggers> getTriggers() {
            return Collections.unmodifiableCollection(Arrays.asList(CastingProgressSyncTriggers.values()));
        }
    }
}

