/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Progression;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.DragonAPI.Auxiliary.IconLookupRegistry;
import Reika.DragonAPI.Instantiable.Rendering.TextureSlot;
import Reika.DragonAPI.Instantiable.Rendering.TextureSubImage;
import Reika.DragonAPI.Interfaces.IconEnum;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.lwjgl.opengl.GL11;

public class ProgressionLinking {
    private static final String COOPERATE_NBT_TAG = "Chroma_Cooperation";
    public static final ProgressionLinking instance = new ProgressionLinking();

    private ProgressionLinking() {
    }

    private Collection<UUID> getSlavedIDs(EntityPlayer ep) {
        HashSet<UUID> c = new HashSet<UUID>();
        for (NBTTagString s : this.getCooperatorList((EntityPlayer)ep).field_74747_a) {
            try {
                c.add(UUID.fromString(s.func_150285_a_()));
            }
            catch (IllegalArgumentException e) {
                ChromatiCraft.logger.logError((Object)("Could not load cooperator UUID " + s.func_150285_a_() + "' as a cooperator with " + ep.func_70005_c_()));
            }
        }
        return c;
    }

    public LinkFailure linkProgression(EntityPlayer from, EntityPlayer to) {
        return this.doLinkProgression(from, to, true);
    }

    public void unlinkProgression(EntityPlayer ep1, EntityPlayer ep2) {
        this.doLinkProgression(ep1, ep2, false);
    }

    public LinkFailure doLinkProgression(EntityPlayer ep1, EntityPlayer ep2, boolean link) {
        ProgressionRegion p2;
        if (link) {
            ChromatiCraft.logger.debug((Object)("Attempting to link progression from " + ep1.func_70005_c_() + " to " + ep2.func_70005_c_()));
        } else {
            ChromatiCraft.logger.debug((Object)("Attempting to unlink progression of " + ep1.func_70005_c_() + " and " + ep2.func_70005_c_()));
        }
        if (!this.canEverLinkProgression(ep1, ep2)) {
            ChromatiCraft.logger.debug((Object)"Failed to link progression; players are invalid/fake/etc!");
            return LinkFailure.INVALID;
        }
        ProgressionRegion p1 = this.getRegion(ep1);
        if (p1 != (p2 = this.getRegion(ep2))) {
            ChromatiCraft.logger.debug((Object)"Failed to link progression; players are in different progression regions!");
            return LinkFailure.REGIONS;
        }
        LinkFailure lf = p1.checkLinkValidity(ep1, ep2);
        if (lf != null) {
            ChromatiCraft.logger.debug((Object)("Failed to link progression: " + lf.toString()));
            return lf;
        }
        NBTTagString s1 = new NBTTagString(ep2.func_110124_au().toString());
        NBTTagString s2 = new NBTTagString(ep1.func_110124_au().toString());
        NBTTagList li1 = this.getCooperatorList(ep1);
        NBTTagList li2 = this.getCooperatorList(ep2);
        if (link) {
            li1.func_74742_a((NBTBase)s1);
            li2.func_74742_a((NBTBase)s2);
        } else {
            li1.field_74747_a.remove(s1);
            li2.field_74747_a.remove(s2);
        }
        ChromaResearchManager.instance.getRootProgressionNBT(ep1).func_74782_a(COOPERATE_NBT_TAG, (NBTBase)li1);
        ChromaResearchManager.instance.getRootProgressionNBT(ep2).func_74782_a(COOPERATE_NBT_TAG, (NBTBase)li2);
        p1.onLink(ep1, ep2);
        return null;
    }

    private ProgressionRegion getRegion(EntityPlayer ep) {
        if (ProgressStage.DIMENSION.isPlayerAtStage(ep)) {
            return ProgressionRegion.FINAL;
        }
        if (ProgressStage.MULTIBLOCK.isPlayerAtStage(ep) || ChromaResearchManager.instance.getPlayerResearchLevel(ep).isAtLeast(ResearchLevel.MULTICRAFT)) {
            return ProgressionRegion.LATE;
        }
        if (ProgressStage.RUNEUSE.isPlayerAtStage(ep) || ChromaResearchManager.instance.getPlayerResearchLevel(ep).isAtLeast(ResearchLevel.RUNECRAFT)) {
            return ProgressionRegion.MID;
        }
        return ProgressionRegion.EARLY;
    }

    private boolean canEverLinkProgression(EntityPlayer ep1, EntityPlayer ep2) {
        return ep1 != ep2 && !ReikaPlayerAPI.isFake((EntityPlayer)ep1) && !ReikaPlayerAPI.isFake((EntityPlayer)ep2);
    }

    private ProgressStage[] getLinkIgnoreList() {
        return new ProgressStage[]{ProgressStage.CAVERN, ProgressStage.BURROW, ProgressStage.OCEAN, ProgressStage.DESERTSTRUCT, ProgressStage.SNOWSTRUCT, ProgressStage.TOWER, ProgressStage.ARTEFACT, ProgressStage.STRUCTCHEAT, ProgressStage.DIE, ProgressStage.VOIDMONSTER};
    }

    private NBTTagList getCooperatorList(EntityPlayer ep) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootProgressionNBT(ep);
        if (!nbt.func_74764_b(COOPERATE_NBT_TAG)) {
            nbt.func_74782_a(COOPERATE_NBT_TAG, (NBTBase)new NBTTagList());
        }
        NBTTagList li = nbt.func_150295_c(COOPERATE_NBT_TAG, ReikaNBTHelper.NBTTypes.STRING.ID);
        return li;
    }

    public boolean hasLinkedPlayers(EntityPlayer ep) {
        return !this.getCooperatorList((EntityPlayer)ep).field_74747_a.isEmpty();
    }

    public Collection<EntityPlayer> getShareablePlayers(EntityPlayer ep, ProgressStage s) {
        ArrayList<EntityPlayer> players = new ArrayList<EntityPlayer>();
        Collection<UUID> coop = this.getSlavedIDs(ep);
        for (UUID u : coop) {
            EntityPlayer e = ep.field_70170_p.func_152378_a(u);
            if (e == null || ReikaPlayerAPI.isFake((EntityPlayer)e) || s != null && !s.getShareability().canShareTo(ep, e)) continue;
            players.add(e);
        }
        return players;
    }

    public void attemptSyncTo(EntityPlayer main, EntityPlayer follower) {
        boolean flag = true;
        while (flag) {
            flag = false;
            for (ProgressStage p : ProgressionManager.instance.getStagesFor(main)) {
                if (p.isPlayerAtStage(follower) || !p.playerHasPrerequisites(follower)) continue;
                switch (p.reloadLevel) {
                    case ALWAYS: {
                        if (!p.stepPlayerTo(follower, false)) break;
                        flag = true;
                        break;
                    }
                }
            }
        }
    }

    public void attemptSyncAllInGroup(EntityPlayer player) {
        for (EntityPlayer ep : this.getShareablePlayers(player, null)) {
            this.attemptSyncTo(ep, player);
            this.attemptSyncTo(player, ep);
        }
    }

    public void attemptSyncTriggerProgressFor(EntityPlayer ep, ProgressStage p) {
        for (EntityPlayer ep2 : this.getShareablePlayers(ep, p)) {
            if (!p.isPlayerAtStage(ep2)) continue;
            p.stepPlayerTo(ep);
        }
    }

    public static class LinkFailure {
        private static final LinkFailure INVALID = new LinkFailure("Invalid Players", ChromaIcons.NOENTER);
        private static final LinkFailure REGIONS = new LinkFailure("Progression Too Different", LinkFailure.getInfoIconSlot(1, 3));
        private static final LinkFailure LEVELS = new LinkFailure("Mismatched Levels", LinkFailure.getInfoIconSlot(0, 3));
        private static final LinkFailure TOO_LATE = new LinkFailure("Too Late", LinkFailure.getInfoIconSlot(2, 3));
        public final String text;
        private final String iconName;
        private TextureSubImage icon;
        private final ProgressStage progress;

        private LinkFailure(ProgressStage p) {
            this.text = p.getTitleString();
            this.progress = p;
            this.iconName = null;
        }

        private static TextureSlot getInfoIconSlot(int x, int y) {
            return TextureSlot.fromSpritesheet(ChromatiCraft.class, (String)"Textures/infoicons.png", (int)x, (int)y, (int)16);
        }

        private LinkFailure(String s, TextureSlot ico) {
            this.text = s;
            this.progress = null;
            this.iconName = null;
            if (ico == null) {
                throw new IllegalArgumentException("Null texture!");
            }
            this.icon = ico;
        }

        private LinkFailure(String s, IconEnum ico) {
            this.text = s;
            this.progress = null;
            if (ico == null) {
                throw new IllegalArgumentException("Null icon!");
            }
            if (ico.getIcon() == null && FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                throw new IllegalArgumentException("No-data icon!");
            }
            this.iconName = ico.name();
            this.icon = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? new TextureSubImage(ico.getIcon()) : null;
        }

        public String toString() {
            return this.text;
        }

        @SideOnly(value=Side.CLIENT)
        public void render(Tessellator v5, double s, float f) {
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            if (this.progress != null) {
                this.progress.renderIconInWorld(v5, s, 0, 0, f);
            } else {
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                this.bindTexture();
                v5.func_78382_b();
                int a = (int)Math.min(255.0, (double)f * ((double)(255.0f - 35.0f * f) + (double)(32.0f * f) * Math.sin((double)System.currentTimeMillis() / 250.0)));
                v5.func_78384_a(0xFFFFFF, a);
                TextureSubImage ico = this.icon != null ? this.icon : new TextureSubImage(ChromaIcons.X.getIcon());
                v5.func_78374_a(-s, s, 0.0, ico.minU, ico.maxV);
                v5.func_78374_a(s, s, 0.0, ico.maxU, ico.maxV);
                v5.func_78374_a(s, -s, 0.0, ico.maxU, ico.minV);
                v5.func_78374_a(-s, -s, 0.0, ico.minU, ico.minV);
                v5.func_78381_a();
                GL11.glPopMatrix();
            }
        }

        private void bindTexture() {
            if (this.icon instanceof TextureSlot) {
                ((TextureSlot)this.icon).bindTexture();
            } else {
                ReikaTextureHelper.bindTerrainTexture();
            }
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound ret = new NBTTagCompound();
            ret.func_74778_a("label", this.text);
            if (this.progress != null) {
                ret.func_74768_a("prog", this.progress.ordinal());
            }
            if (this.icon != null) {
                ret.func_74782_a("icon", (NBTBase)this.icon.writeToNBT());
            }
            if (this.iconName != null) {
                ret.func_74778_a("iconName", this.iconName);
            }
            return ret;
        }

        public static LinkFailure readFromNBT(NBTTagCompound NBT) {
            if (NBT.func_74764_b("prog")) {
                return new LinkFailure(ProgressStage.list[NBT.func_74762_e("prog")]);
            }
            if (NBT.func_74764_b("iconName")) {
                return new LinkFailure(NBT.func_74779_i("label"), IconLookupRegistry.instance.getIcon(NBT.func_74779_i("iconName")));
            }
            if (NBT.func_74764_b("icon")) {
                return new LinkFailure(NBT.func_74779_i("label"), TextureSlot.readFromNBT((NBTTagCompound)NBT.func_74775_l("icon")));
            }
            return new LinkFailure(NBT.func_74779_i("label") + " (+invalid data)", ChromaIcons.X);
        }
    }

    private static enum ProgressionRegion {
        EARLY,
        MID,
        LATE,
        FINAL;


        private LinkFailure checkLinkValidity(EntityPlayer ep1, EntityPlayer ep2) {
            List<ProgressStage> check = this.getCheckList();
            for (ProgressStage p : check) {
                if (this.match(p, ep1, ep2)) continue;
                return new LinkFailure(p);
            }
            ResearchLevel rl1 = ChromaResearchManager.instance.getPlayerResearchLevel(ep1);
            ResearchLevel rl2 = ChromaResearchManager.instance.getPlayerResearchLevel(ep2);
            switch (this) {
                case EARLY: {
                    if (rl1.getDifference(rl2) >= 2) {
                        return LinkFailure.LEVELS;
                    }
                    return null;
                }
                case MID: {
                    if (rl1 != rl2) {
                        return LinkFailure.LEVELS;
                    }
                    if (!ProgressionManager.instance.isProgressionEqual(ep1, ep2, instance.getLinkIgnoreList())) {
                        return new LinkFailure("Mismatched Progression", ChromaIcons.QUESTION);
                    }
                    return null;
                }
                case LATE: {
                    if (rl1.getDifference(rl2) > 2) {
                        return LinkFailure.LEVELS;
                    }
                    return null;
                }
                case FINAL: {
                    return LinkFailure.TOO_LATE;
                }
            }
            return LinkFailure.INVALID;
        }

        private List<ProgressStage> getCheckList() {
            switch (this) {
                case EARLY: {
                    return Arrays.asList(ProgressStage.PYLON, ProgressStage.CRYSTALS, ProgressStage.ALLCOLORS);
                }
                case MID: {
                    return new ArrayList<ProgressStage>();
                }
                case LATE: {
                    return Arrays.asList(ProgressStage.LINK);
                }
                case FINAL: {
                    return new ArrayList<ProgressStage>();
                }
            }
            return new ArrayList<ProgressStage>();
        }

        private boolean match(ProgressStage p, EntityPlayer ep1, EntityPlayer ep2) {
            return p.isPlayerAtStage(ep1) == p.isPlayerAtStage(ep2);
        }

        private void onLink(EntityPlayer from, EntityPlayer to) {
            switch (this) {
                case EARLY: {
                    ProgressionManager.instance.copyProgressStages(to, from);
                    break;
                }
                case MID: {
                    break;
                }
                case LATE: {
                    ProgressionManager.instance.copyProgressStages(from, to);
                    break;
                }
            }
        }
    }
}

