/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Progression;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.CastingTuning.CastingTuningManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionLinking;
import Reika.ChromatiCraft.Magic.Progression.ProgressionManager;
import Reika.DragonAPI.Auxiliary.Trackers.PlayerHandler;
import Reika.DragonAPI.IO.ReikaFileReader;
import Reika.DragonAPI.Instantiable.Data.Maps.PlayerMap;
import Reika.DragonAPI.Instantiable.IO.NBTFile;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class ProgressionLoadHandler
implements PlayerHandler.PlayerTracker {
    public static final ProgressionLoadHandler instance = new ProgressionLoadHandler();
    private String baseFilepath;
    private final HashMap<UUID, ProgressCache> progressCache = new HashMap();
    private final PlayerMap<NBTTagCompound> cachedBackup = new PlayerMap();

    private ProgressionLoadHandler() {
    }

    public void initLevelData(MinecraftServer instance) {
        this.baseFilepath = DimensionManager.getCurrentSaveRootDirectory() + "/ChromatiCraft_Data/ProgressionCache/";
        this.progressCache.clear();
    }

    private final String getFilepath(EntityPlayer ep) {
        return this.getFilepath(ep.func_110124_au());
    }

    private final String getFilepath(UUID uid) {
        return this.baseFilepath + uid.toString() + ".dat";
    }

    public void load() {
        File f = new File(this.baseFilepath);
        if (f.exists()) {
            ArrayList li = ReikaFileReader.getAllFilesInFolder((File)f, (String[])new String[]{".dat"});
            for (File in : li) {
                ProgressCache pc = ProgressCache.readFromFile(in);
                if (pc == null) continue;
                this.progressCache.put(pc.uid, pc);
            }
        } else {
            f.getParentFile().mkdirs();
            f.mkdir();
        }
    }

    public void saveAll() {
        ReikaFileReader.emptyDirectory((File)new File(this.baseFilepath));
        for (ProgressCache pc : this.progressCache.values()) {
            File f = new File(this.getFilepath(pc.uid));
            pc.writeToFile(f);
        }
    }

    private void savePlayer(EntityPlayer ep) {
        ProgressCache pc = this.progressCache.get(ep.func_110124_au());
        if (pc != null) {
            File f = new File(this.getFilepath(ep.func_110124_au()));
            ReikaFileReader.clearFile((File)f);
            pc.writeToFile(f);
        }
    }

    public void onPlayerLogin(EntityPlayer player) {
        this.updateProgressCache(player);
        ProgressionLinking.instance.attemptSyncAllInGroup(player);
        CastingTuningManager.instance.calculateAndCacheKey(player);
    }

    public void onPlayerLogout(EntityPlayer player) {
        this.updateProgressCache(player);
    }

    public void onPlayerChangedDimension(EntityPlayer player, int dimFrom, int dimTo) {
        this.updateProgressCache(player);
    }

    public void onPlayerRespawn(EntityPlayer player) {
        this.updateProgressCache(player);
    }

    public void clearProgressCache(EntityPlayer ep) {
        this.progressCache.remove(ep.func_110124_au());
    }

    public void updateProgressCache(EntityPlayer ep) {
        ProgressCache pc = this.progressCache.get(ep.func_110124_au());
        if (pc == null) {
            pc = new ProgressCache(ep);
            this.progressCache.put(ep.func_110124_au(), pc);
        } else {
            if (pc.hasMoreProgressionThan(ep)) {
                pc.copyTo(ep);
                ChromatiCraft.logger.log((Object)("Restoring progression for " + ep.func_70005_c_() + " from cache, as it had more progression than they did!"));
                FMLLog.bigWarning((String)"ChromatiCraft: Player %s just lost some of their progression!", (Object[])new Object[]{ep.func_70005_c_()});
            }
            pc.update(ep);
        }
        this.savePlayer(ep);
    }

    @Deprecated
    public ProgressCache getProgressCache(World world, UUID uid) {
        ProgressCache pc = this.progressCache.get(uid);
        if (pc == null) {
            EntityPlayer ep = world.func_152378_a(uid);
            if (ep != null) {
                pc = new ProgressCache(ep);
                this.progressCache.put(uid, pc);
            }
        } else if (!pc.uid.equals(uid)) {
            pc = null;
            this.progressCache.remove(uid);
        }
        return pc;
    }

    public NBTTagCompound attemptToLoadBackup(EntityPlayer ep) {
        File f;
        NBTTagCompound tag;
        if (!ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            ChromatiCraft.logger.log((Object)("Attempting to load backup progression for " + ep));
        }
        if ((tag = (NBTTagCompound)this.cachedBackup.get(ep)) == null && (f = this.getBackupFile(ep)).exists() && f.length() > 0L) {
            try {
                tag = ReikaFileReader.readUncompressedNBT((File)f);
                this.cachedBackup.put(ep, (Object)tag);
            }
            catch (Exception e) {
                e.printStackTrace();
                ChromatiCraft.logger.logError((Object)("Could not read progression data backup for " + ep.func_70005_c_() + "!"));
            }
        }
        return tag;
    }

    public void updateBackup(EntityPlayer ep) {
        File f = this.getBackupFile(ep);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
        }
        if (f.exists()) {
            f.delete();
        }
        try {
            f.createNewFile();
            this.cachedBackup.put(ep, (Object)ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep));
            ReikaFileReader.writeUncompressedNBT((NBTTagCompound)ReikaPlayerAPI.getDeathPersistentNBT((EntityPlayer)ep), (File)f);
        }
        catch (IOException e) {
            e.printStackTrace();
            ChromatiCraft.logger.logError((Object)("Could not save progression data backup for " + ep.func_70005_c_() + "!"));
        }
    }

    private File getBackupFile(EntityPlayer ep) {
        return new File(DimensionManager.getCurrentSaveRootDirectory() + "/ChromatiCraft_Data/ProgressionBackup", ep.func_110124_au().toString() + ".dat");
    }

    private static class ProgressFile
    extends NBTFile {
        private UUID uid;
        private final HashSet<String> entries = new HashSet();

        private ProgressFile(File f) {
            super(f);
            this.encryptData = true;
        }

        protected void readHeader(NBTTagCompound header) {
            this.uid = UUID.fromString(header.func_74779_i("id"));
        }

        protected void readData(NBTTagList li) {
            for (Object o : li.field_74747_a) {
                String s = ((NBTTagCompound)o).func_74779_i("tag");
                this.entries.add(s);
            }
        }

        protected void readExtraData(NBTTagCompound extra) {
        }

        protected void writeHeader(NBTTagCompound header) {
            header.func_74778_a("id", this.uid.toString());
        }

        protected void writeData(NBTTagList li) {
            for (String s : this.entries) {
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("tag", s);
                li.func_74742_a((NBTBase)tag);
            }
        }

        protected NBTTagCompound writeExtraData() {
            return null;
        }
    }

    public static class ProgressCache {
        private final HashSet<ProgressStage> cache = new HashSet();
        private final UUID uid;

        private ProgressCache(EntityPlayer ep) {
            this(ep.func_110124_au());
            this.update(ep);
        }

        private void copyTo(EntityPlayer ep) {
            HashSet<ProgressStage> set = new HashSet<ProgressStage>(this.cache);
            for (ProgressStage p : set) {
                p.forceOnPlayer(ep, false);
            }
        }

        private boolean hasMoreProgressionThan(EntityPlayer ep) {
            for (ProgressStage p : new HashSet<ProgressStage>(this.cache)) {
                if (p.isPlayerAtStage(ep)) continue;
                return true;
            }
            return false;
        }

        private ProgressCache(UUID id) {
            this.uid = id;
        }

        public void update(EntityPlayer ep) {
            this.cache.clear();
            this.cache.addAll(ProgressionManager.instance.getStagesFor(ep));
        }

        public boolean containsProgress(ProgressStage p) {
            return this.cache.contains(p);
        }

        private static ProgressCache readFromFile(File f) {
            ProgressFile pf = new ProgressFile(f);
            try {
                pf.load();
                ProgressCache pc = new ProgressCache(pf.uid);
                for (String s : pf.entries) {
                    ProgressStage p = ProgressStage.valueOf(s);
                    pc.cache.add(p);
                }
                return pc;
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)("Could not load cached player progress: " + f.getName()));
                e.printStackTrace();
                return null;
            }
        }

        private void writeToFile(File f) {
            ProgressFile pf = new ProgressFile(f);
            pf.uid = this.uid;
            for (ProgressStage p : this.cache) {
                pf.entries.add(p.name());
            }
            try {
                pf.save();
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)("Could not save cached player progress: " + f.getName()));
                e.printStackTrace();
            }
        }

        public String toString() {
            return this.uid + ": " + this.cache.toString();
        }
    }
}

