/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic.Progression;

import Reika.ChromatiCraft.API.CrystalElementAccessor;
import Reika.ChromatiCraft.API.Event.ProgressionEvent;
import Reika.ChromatiCraft.API.ProgressionAPI;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.CastingRecipe;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.RecipesCastingTable;
import Reika.ChromatiCraft.Auxiliary.Render.ChromaOverlays;
import Reika.ChromatiCraft.Base.DimensionStructureGenerator;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemInfoFragment;
import Reika.ChromatiCraft.Magic.Progression.ChromaResearchManager;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.Progression.ProgressionLinking;
import Reika.ChromatiCraft.Magic.Progression.ProgressionLoadHandler;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaResearch;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.SequenceMap;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaRenderHelper;
import Reika.DragonAPI.Objects.LineType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.MinecraftForge;

public class ProgressionManager
implements ProgressionAPI.ProgressRegistry {
    public static final ProgressionManager instance = new ProgressionManager();
    public static final String MAIN_NBT_TAG = "Chroma_Progression";
    private static final String COLOR_NBT_TAG = "Chroma_Element_Discovery";
    private static final String STRUCTURE_NBT_TAG = "Structure_Color_Completion";
    private final SequenceMap<ProgressLink> progressMap = new SequenceMap();
    private final MultiMap<ProgressStage, ProgressChain> chains = new MultiMap();
    private final MultiMap<String, ProgressStage> playerMap = new MultiMap(MultiMap.CollectionType.HASHSET);
    private final EnumMap<CrystalElement, ColorDiscovery> colorDiscoveries = new EnumMap(CrystalElement.class);
    private final EnumMap<CrystalElement, StructureComplete> structureFlags = new EnumMap(CrystalElement.class);
    private final EnumMap<ProgressStage, ChromaResearch> auxiliaryReference = new EnumMap(ProgressStage.class);
    private final HashMap<ProgressStage, ResearchLevel> nonGatingProgress = new HashMap();

    private ProgressionManager() {
        ProgressionAPI.instance.progressManager = this;
        this.load();
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            ColorDiscovery c = new ColorDiscovery(e);
            StructureComplete s = new StructureComplete(e);
            this.colorDiscoveries.put(e, c);
            this.structureFlags.put(e, s);
            ChromaResearchManager.instance.register(c);
            ChromaResearchManager.instance.register(s);
        }
    }

    public void reload() {
        this.progressMap.clear();
        this.load();
    }

    private void load() {
        this.addProgressPrereq(ProgressStage.CASTING, ProgressStage.CRYSTALS);
        this.addProgressPrereq(ProgressStage.ALLCOLORS, ProgressStage.PYLON);
        this.addProgressPrereq(ProgressStage.RUNEUSE, ProgressStage.ALLCOLORS);
        this.addProgressPrereq(ProgressStage.RUNEUSE, ProgressStage.CASTING);
        this.addProgressPrereq(ProgressStage.MULTIBLOCK, ProgressStage.RUNEUSE);
        this.addProgressPrereq(ProgressStage.MULTIBLOCK, ProgressStage.VILLAGECASTING);
        this.addProgressPrereq(ProgressStage.LINK, ProgressStage.PYLON);
        this.addProgressPrereq(ProgressStage.LINK, ProgressStage.REPEATER);
        this.addProgressPrereq(ProgressStage.USEENERGY, ProgressStage.PYLON);
        this.addProgressPrereq(ProgressStage.USEENERGY, ProgressStage.RUNEUSE);
        this.addProgressPrereq(ProgressStage.CHARGE, ProgressStage.PYLON);
        this.addProgressPrereq(ProgressStage.CHARGE, ProgressStage.CRYSTALS);
        this.addProgressPrereq(ProgressStage.FOCUSCRYSTAL, ProgressStage.CRYSTALS);
        this.addProgressPrereq(ProgressStage.BREAKSPAWNER, ProgressStage.FINDSPAWNER);
        this.addProgressPrereq(ProgressStage.ABILITY, ProgressStage.CHARGE);
        this.addProgressPrereq(ProgressStage.ABILITY, ProgressStage.LINK);
        this.addProgressPrereq(ProgressStage.SHOCK, ProgressStage.PYLON);
        this.addProgressPrereq(ProgressStage.MAKECHROMA, ProgressStage.CASTING);
        this.addProgressPrereq(ProgressStage.SHARDCHARGE, ProgressStage.MAKECHROMA);
        this.addProgressPrereq(ProgressStage.SHARDCHARGE, ProgressStage.RUNEUSE);
        this.addProgressPrereq(ProgressStage.SHARDCHARGE, ProgressStage.DYETREE);
        this.addProgressPrereq(ProgressStage.CHROMA, ProgressStage.MAKECHROMA);
        this.addProgressPrereq(ProgressStage.BIOMESTRUCT, ProgressStage.SHARDCHARGE);
        this.addProgressPrereq(ProgressStage.BIOMESTRUCT, ProgressStage.MULTIBLOCK);
        this.addProgressPrereq(ProgressStage.BIOMESTRUCT, ProgressStage.CHROMA);
        this.addProgressPrereq(ProgressStage.BIOMESTRUCT, ProgressStage.ENERGYIDEA);
        this.addProgressPrereq(ProgressStage.ALLOY, ProgressStage.SHARDCHARGE);
        this.addProgressPrereq(ProgressStage.ALLOY, ProgressStage.MULTIBLOCK);
        this.addProgressPrereq(ProgressStage.ALLOY, ProgressStage.CHROMA);
        this.addProgressPrereq(ProgressStage.INFUSE, ProgressStage.ALLOY);
        if (ProgressStage.VOIDMONSTER.active) {
            this.addProgressPrereq(ProgressStage.VOIDMONSTER, ProgressStage.BEDROCK);
            this.addProgressPrereq(ProgressStage.VOIDMONSTERDIE, ProgressStage.VOIDMONSTER);
        }
        if (ProgressStage.NODE.active) {
            // empty if block
        }
        this.addProgressPrereq(ProgressStage.DEEPCAVE, ProgressStage.MINE);
        this.addProgressPrereq(ProgressStage.BEDROCK, ProgressStage.DEEPCAVE);
        this.addProgressPrereq(ProgressStage.NETHER, ProgressStage.BEDROCK);
        this.addProgressPrereq(ProgressStage.NETHERROOF, ProgressStage.NETHER);
        this.addProgressPrereq(ProgressStage.NETHERROOF, ProgressStage.ANYSTRUCT);
        this.addProgressPrereq(ProgressStage.NETHERSTRUCT, ProgressStage.NETHERROOF);
        this.addProgressPrereq(ProgressStage.END, ProgressStage.NETHER);
        this.addProgressPrereq(ProgressStage.BLOWREPEATER, ProgressStage.USEENERGY);
        this.addProgressPrereq(ProgressStage.BYPASSWEAK, ProgressStage.TUNECAST);
        this.addProgressPrereq(ProgressStage.TUNECAST, ProgressStage.RUNEUSE);
        this.addProgressPrereq(ProgressStage.TUNECAST, ProgressStage.CHROMA);
        this.addProgressPrereq(ProgressStage.TUNECAST, ProgressStage.MULTIBLOCK);
        this.addProgressPrereq(ProgressStage.REPEATER, ProgressStage.BLOWREPEATER);
        this.addProgressPrereq(ProgressStage.REPEATER, ProgressStage.ENERGYIDEA);
        this.addProgressPrereq(ProgressStage.REPEATER, ProgressStage.TUNECAST);
        this.addProgressPrereq(ProgressStage.ENERGYIDEA, ProgressStage.USEENERGY);
        this.addProgressPrereq(ProgressStage.RELAYS, ProgressStage.USEENERGY);
        this.addProgressPrereq(ProgressStage.STORAGE, ProgressStage.MULTIBLOCK);
        this.addProgressPrereq(ProgressStage.CHARGECRYSTAL, ProgressStage.STORAGE);
        this.addProgressPrereq(ProgressStage.POWERCRYSTAL, ProgressStage.LINK);
        this.addProgressPrereq(ProgressStage.POWERCRYSTAL, ProgressStage.STORAGE);
        this.addProgressPrereq(ProgressStage.POWERCRYSTAL, ProgressStage.CHARGE);
        this.addProgressPrereq(ProgressStage.POWERCRYSTAL, ProgressStage.INFUSE);
        this.addProgressPrereq(ProgressStage.POWERTREE, ProgressStage.POWERCRYSTAL);
        this.addProgressPrereq(ProgressStage.DIE, ProgressStage.CHARGE);
        this.addProgressPrereq(ProgressStage.KILLDRAGON, ProgressStage.END);
        this.addProgressPrereq(ProgressStage.KILLWITHER, ProgressStage.NETHER);
        this.addProgressPrereq(ProgressStage.KILLDRAGON, ProgressStage.KILLMOB);
        this.addProgressPrereq(ProgressStage.KILLWITHER, ProgressStage.KILLMOB);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.ALLCOLORS);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.END);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.NETHERSTRUCT);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.POWERCRYSTAL);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.RAINBOWFOREST);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.CAVERN);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.BURROW);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.OCEAN);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.DESERTSTRUCT);
        this.addProgressPrereq(ProgressStage.DIMENSION, ProgressStage.SNOWSTRUCT);
        this.addProgressPrereq(ProgressStage.TURBOCHARGE, ProgressStage.DIMENSION);
        this.addProgressPrereq(ProgressStage.TURBOCHARGE, ProgressStage.POWERTREE);
        this.addProgressPrereq(ProgressStage.TURBOCHARGE, ProgressStage.STRUCTCOMPLETE);
        this.addProgressPrereq(ProgressStage.STRUCTCOMPLETE, ProgressStage.ABILITY);
        this.addProgressPrereq(ProgressStage.STRUCTCOMPLETE, ProgressStage.DIMENSION);
        this.addProgressPrereq(ProgressStage.STRUCTCHEAT, ProgressStage.DIMENSION);
        this.addProgressPrereq(ProgressStage.ALLCORES, ProgressStage.STRUCTCOMPLETE);
        this.addProgressPrereq(ProgressStage.CTM, ProgressStage.ALLCORES);
        this.addProgressPrereq(ProgressStage.PYLONLINK, ProgressStage.TOWER);
        for (int i = 0; i < ProgressStage.list.length; ++i) {
            ProgressStage p = ProgressStage.list[i];
            ProgressLink pl = new ProgressLink(p);
            if (!p.active || this.progressMap.hasElementAsParent((Object)pl) || this.progressMap.hasElementAsChild((Object)pl)) continue;
            this.progressMap.addChildless((Object)pl);
        }
        this.auxiliaryReference.put(ProgressStage.CRYSTALS, ChromaResearch.CRYSTALS);
        this.auxiliaryReference.put(ProgressStage.PYLON, ChromaResearch.PYLONS);
        this.auxiliaryReference.put(ProgressStage.BURROW, ChromaResearch.BURROW);
        this.auxiliaryReference.put(ProgressStage.CAVERN, ChromaResearch.CAVERN);
        this.auxiliaryReference.put(ProgressStage.OCEAN, ChromaResearch.OCEAN);
        this.auxiliaryReference.put(ProgressStage.RAINBOWLEAF, ChromaResearch.RAINBOWLEAVES);
        this.auxiliaryReference.put(ProgressStage.DYETREE, ChromaResearch.DYELEAVES);
        this.auxiliaryReference.put(ProgressStage.BALLLIGHTNING, ChromaResearch.BALLLIGHTNING);
        this.auxiliaryReference.put(ProgressStage.ALLCOLORS, ChromaResearch.RUNES);
        this.nonGatingProgress.put(ProgressStage.DIE, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.VOIDMONSTERDIE, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.TOWER, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.ARTEFACT, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.PYLONLINK, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.BALLLIGHTNING, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.FINDSPAWNER, ResearchLevel.PYLONCRAFT);
        this.nonGatingProgress.put(ProgressStage.BREAKSPAWNER, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.HIVE, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.STRUCTCHEAT, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.WARPNODE, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.LUMA, ResearchLevel.ENDGAME);
        this.nonGatingProgress.put(ProgressStage.NETHER, ResearchLevel.RUNECRAFT);
        this.nonGatingProgress.put(ProgressStage.END, ResearchLevel.MULTICRAFT);
        this.nonGatingProgress.put(ProgressStage.NODE, ResearchLevel.CTM);
        this.nonGatingProgress.put(ProgressStage.MYST, ResearchLevel.CTM);
        this.addChainedProgression(ProgressStage.BYPASSWEAK, ProgressStage.BLOWREPEATER, false, false, new ProgressStage[0]);
        this.addChainedProgression(ProgressStage.TUNECAST, ProgressStage.BYPASSWEAK, true, false, ProgressStage.BLOWREPEATER);
        this.addChainedProgression(ProgressStage.FOCUSCRYSTAL, ProgressStage.ENERGYIDEA, true, true, new ProgressStage[0]);
        this.addChainedProgression(ProgressStage.RELAYS, ProgressStage.ENERGYIDEA, true, false, new ProgressStage[0]);
    }

    private void addProgressPrereq(ProgressStage p, ProgressStage prereq) {
        this.progressMap.addParent((Object)new ProgressLink(p), (Object)new ProgressLink(prereq));
    }

    private void addChainedProgression(ProgressStage hook, ProgressStage chain, boolean notify, boolean retro, ProgressStage ... excl) {
        this.chains.addValue((Object)hook, (Object)new ProgressChain(hook, hook, chain, notify, retro, excl));
        Collection<ProgressStage> parents = this.getPrereqs(chain);
        if (!parents.contains(hook)) {
            this.progressMap.addParent((Object)new ProgressLink(chain), (Object)new ProgressLink(hook, LineType.DASHED));
        }
        if (retro) {
            for (ProgressStage par : parents) {
                this.chains.addValue((Object)par, (Object)new ProgressChain(par, hook, chain, notify, false, excl));
            }
        }
    }

    public boolean isProgressionGating(ProgressStage p, ResearchLevel level) {
        ResearchLevel get = this.nonGatingProgress.get(p);
        return get == null || level.isAtLeast(get);
    }

    public ResearchLevel getEarliestAllowedGate(ProgressStage p) {
        ResearchLevel get = this.nonGatingProgress.get(p);
        return get != null ? get : ResearchLevel.ENTRY;
    }

    public SequenceMap.Topology getTopology() {
        return this.progressMap.getTopology();
    }

    public HashMap<ProgressLink, ProgressTier> constructResearchLevelDepthMap() {
        HashMap<ProgressLink, ProgressTier> ret = new HashMap<ProgressLink, ProgressTier>();
        for (ProgressStage p : ProgressStage.list) {
            ResearchLevel rl = ChromaResearchManager.instance.getEarliestResearchLevelRequiring(p);
            if (rl == null) continue;
            ret.put(new ProgressLink(p), new ProgressTier(rl));
        }
        HashSet set = new HashSet(ret.values());
        ArrayList li = new ArrayList(set);
        Collections.sort(li);
        if (((ProgressTier)li.get(li.size() - 1)).index != li.size() - 1) {
            HashMap<Integer, Integer> convert = new HashMap<Integer, Integer>();
            for (int idx = 0; idx < li.size(); ++idx) {
                int val = ((ProgressTier)li.get(idx)).index;
                convert.put(val, idx);
            }
            for (ProgressTier pt : ret.values()) {
                pt.index = (Integer)convert.get(pt.index);
            }
        }
        return ret;
    }

    private Collection<ProgressStage> getPlayerData(EntityPlayer ep) {
        return this.loadFromNBT(ep);
    }

    private Collection<ProgressStage> loadFromNBT(EntityPlayer ep) {
        NBTTagList li = this.getNBTList(ep);
        HashSet<ProgressStage> c = new HashSet<ProgressStage>();
        Iterator it = li.field_74747_a.iterator();
        while (it.hasNext()) {
            String val = ((NBTTagString)it.next()).func_150285_a_();
            try {
                c.add(ProgressStage.valueOf(val));
            }
            catch (IllegalArgumentException e) {
                ChromatiCraft.logger.logError((Object)("Could not load progress stage from NBT String " + val + "; was it removed?"));
                it.remove();
            }
        }
        this.playerMap.put((Object)ep.func_70005_c_(), c);
        return c;
    }

    private void verify(EntityPlayer ep) {
        boolean changed = false;
        String s = ep.func_70005_c_();
        do {
            Collection c = this.playerMap.get((Object)s);
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ProgressStage p = (ProgressStage)it.next();
                if (this.playerHasPrerequisites(ep, p)) continue;
                it.remove();
                changed = true;
                ChromatiCraft.logger.logError((Object)("Player " + s + " had progress element " + p + " without its prereqs! Removing!"));
            }
        } while (changed);
    }

    private NBTTagList getNBTList(EntityPlayer ep) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootNBTTag(ep);
        if (nbt == null) {
            ChromatiCraft.logger.logError((Object)("Looking for progression data on player " + ep.func_70005_c_() + ", with no NBT?!"));
            return new NBTTagList();
        }
        if (!nbt.func_74764_b(MAIN_NBT_TAG)) {
            nbt.func_74782_a(MAIN_NBT_TAG, (NBTBase)new NBTTagList());
        }
        NBTTagList li = nbt.func_150295_c(MAIN_NBT_TAG, ReikaNBTHelper.NBTTypes.STRING.ID);
        return li;
    }

    boolean isPlayerAtStage(EntityPlayer ep, ProgressStage s) {
        return this.getPlayerData(ep).contains(s);
    }

    public Collection<ProgressStage> getStagesFor(EntityPlayer ep) {
        Collection<ProgressStage> c = this.getPlayerData(ep);
        return c != null ? Collections.unmodifiableCollection(c) : new ArrayList<ProgressStage>();
    }

    public Collection<ProgressStage> getStagesForFromNBT(EntityPlayer ep) {
        Collection<ProgressStage> c = this.getPlayerData(ep);
        return c != null ? Collections.unmodifiableCollection(c) : new ArrayList<ProgressStage>();
    }

    public boolean isProgressionEqual(EntityPlayer ep1, EntityPlayer ep2, ProgressStage ... ignore) {
        ArrayList<ProgressStage> c1 = new ArrayList<ProgressStage>(this.getStagesFor(ep1));
        ArrayList<ProgressStage> c2 = new ArrayList<ProgressStage>(this.getStagesFor(ep2));
        for (ProgressStage p : ignore) {
            c1.remove(p);
            c2.remove(p);
        }
        return c1.equals(c2);
    }

    boolean stepPlayerTo(EntityPlayer ep, ProgressStage s, boolean notify, boolean syncToCoop) {
        if (ep == null) {
            ChromatiCraft.logger.logError((Object)("Tried to give progress '" + s + "' to null player???"));
            return false;
        }
        if (!this.canStepPlayerTo(ep, s)) {
            return false;
        }
        this.setPlayerStage(ep, s, true, notify, syncToCoop);
        for (ProgressChain chained : this.chains.get((Object)s)) {
            this.chainProgressTo(ep, chained, notify, syncToCoop);
        }
        return true;
    }

    private boolean chainProgressTo(EntityPlayer ep, ProgressChain chained, boolean notify, boolean syncToCoop) {
        if (this.isPlayerAtStage(ep, chained.prereq)) {
            for (ProgressStage p : chained.exclusions) {
                if (!this.isPlayerAtStage(ep, p)) continue;
                return false;
            }
            this.stepPlayerTo(ep, chained.progress, notify && chained.notifyOnTrigger, syncToCoop);
            return true;
        }
        return false;
    }

    public boolean canStepPlayerTo(EntityPlayer ep, ProgressStage s) {
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return false;
        }
        if (this.isPlayerAtStage(ep, s)) {
            return false;
        }
        return this.playerHasPrerequisites(ep, s);
    }

    public boolean playerHasPrerequisites(EntityPlayer ep, ProgressStage s) {
        Collection c = this.progressMap.getParents((Object)new ProgressLink(s));
        if (c == null || c.isEmpty()) {
            return true;
        }
        for (ProgressLink s2 : c) {
            if (this.isPlayerAtStage(ep, s2.parent)) continue;
            return false;
        }
        return true;
    }

    public Collection<ProgressStage> getPrereqs(ProgressStage s) {
        ArrayList<ProgressStage> li = new ArrayList<ProgressStage>();
        Collection c = this.progressMap.getParents((Object)new ProgressLink(s));
        if (c != null) {
            for (ProgressLink l : c) {
                li.add(l.parent);
            }
        }
        return li;
    }

    public ProgressStage[] getPrereqsArray(ProgressStage s) {
        Collection<ProgressStage> c = this.getPrereqs(s);
        return c != null ? c.toArray(new ProgressStage[c.size()]) : new ProgressStage[]{};
    }

    Collection<ProgressLink> getRecursiveParents(ProgressStage p) {
        return this.progressMap.getRecursiveParents((Object)new ProgressLink(p));
    }

    boolean isOneStepAway(EntityPlayer ep, ProgressStage s) {
        if (this.isPlayerAtStage(ep, s)) {
            return false;
        }
        Collection c = this.progressMap.getParents((Object)new ProgressLink(s));
        if (c == null || c.isEmpty()) {
            return false;
        }
        for (ProgressLink par : c) {
            if (this.isPlayerAtStage(ep, par.parent)) {
                return false;
            }
            Collection c2 = this.progressMap.getParents((Object)par);
            for (ProgressLink par2 : c2) {
                if (this.isPlayerAtStage(ep, par.parent)) continue;
                return false;
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setPlayerStageClient(EntityPlayer ep, ProgressStage s, boolean set, boolean notify) {
        this.setPlayerStage(ep, s, set, true, notify, false);
    }

    public void setPlayerStage(EntityPlayer ep, ProgressStage s, boolean set, boolean notify, boolean syncToCoop) {
        this.setPlayerStage(ep, s, set, false, notify, syncToCoop);
    }

    private void setPlayerStage(EntityPlayer ep, ProgressStage s, boolean set, boolean allowClient, boolean notify, boolean syncToCoop) {
        this.setPlayerStage(ep, s, set, allowClient, notify, syncToCoop, new HashSet<UUID>());
    }

    private void setPlayerStage(EntityPlayer ep, ProgressStage s, boolean set, boolean allowClient, boolean notify, boolean syncToCoop, HashSet<UUID> activeList) {
        if (ReikaPlayerAPI.isFake((EntityPlayer)ep)) {
            return;
        }
        if (ep.field_70170_p.field_72995_K && !allowClient) {
            return;
        }
        if (activeList.contains(ep.func_110124_au())) {
            return;
        }
        activeList.add(ep.func_110124_au());
        if (syncToCoop) {
            ProgressionLinking.instance.attemptSyncAllInGroup(ep);
            Collection<EntityPlayer> players = ProgressionLinking.instance.getShareablePlayers(ep, s);
            for (EntityPlayer e : players) {
                ChromatiCraft.logger.debug((Object)("Sharing progression " + s + " from " + ep.func_70005_c_() + " to " + e.func_70005_c_()));
                this.setPlayerStage(ep, s, set, allowClient, notify, false, activeList);
            }
        }
        if (notify && ep instanceof EntityPlayerMP) {
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.GIVEPROGRESS.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{s.ordinal(), set ? 1 : 0});
        }
        NBTTagList li = this.getNBTList(ep);
        NBTTagString tag = new NBTTagString(s.name());
        boolean flag = false;
        ProgressLink ls = new ProgressLink(s);
        if (set) {
            if (!li.field_74747_a.contains(tag)) {
                flag = true;
                li.func_74742_a((NBTBase)tag);
                Collection c = this.progressMap.getRecursiveParents((Object)ls);
                for (ProgressLink s2 : c) {
                    NBTTagString tag2 = new NBTTagString(s2.parent.name());
                    if (li.field_74747_a.contains(tag2)) continue;
                    li.field_74747_a.add(tag2);
                }
            }
        } else if (li.field_74747_a.contains(tag)) {
            flag = true;
            li.field_74747_a.remove(tag);
            Collection c = this.progressMap.getRecursiveChildren((Object)ls);
            for (ProgressLink s2 : c) {
                NBTTagString tag2 = new NBTTagString(s2.parent.name());
                li.field_74747_a.remove(tag2);
            }
        }
        if (flag) {
            ChromaResearchManager.instance.getRootNBTTag(ep).func_74782_a(MAIN_NBT_TAG, (NBTBase)li);
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            if (set) {
                this.playerMap.addValue((Object)ep.func_70005_c_(), (Object)s);
                if (notify) {
                    ChromaResearchManager.instance.notifyPlayerOfProgression(ep, s);
                }
                this.giveAuxiliaryResearch(ep, s);
                MinecraftForge.EVENT_BUS.post((Event)new ProgressionEvent(ep, s.name(), ProgressionEvent.ResearchType.PROGRESS));
            } else {
                this.playerMap.remove((Object)ep.func_70005_c_(), (Object)s);
            }
            if (notify) {
                this.updateChunks(ep);
            }
            ProgressionLoadHandler.instance.updateProgressCache(ep);
            ProgressionLoadHandler.instance.updateBackup(ep);
        }
    }

    public void copyProgressStages(EntityPlayer from, EntityPlayer to) {
        NBTTagList li1 = this.getNBTList(from);
        NBTTagList li2 = this.getNBTList(to);
        li2.field_74747_a.clear();
        for (Object o : li1.field_74747_a) {
            li2.func_74742_a(((NBTBase)o).func_74737_b());
        }
        Collection c1 = this.playerMap.get((Object)from.func_70005_c_());
        Collection c2 = this.playerMap.get((Object)to.func_70005_c_());
        c2.clear();
        c2.addAll(c1);
        ChromaResearchManager.instance.getRootNBTTag(to).func_74782_a(MAIN_NBT_TAG, (NBTBase)li2);
        this.onProgressionChange(to, false);
    }

    public void resetPlayerProgression(EntityPlayer ep, boolean notify) {
        NBTTagList li = this.getNBTList(ep);
        li.field_74747_a.clear();
        Collection c = this.playerMap.remove((Object)ep.func_70005_c_());
        if (notify && ep instanceof EntityPlayerMP) {
            EntityPlayerMP emp = (EntityPlayerMP)ep;
            for (ProgressStage p : c) {
                ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.GIVEPROGRESS.ordinal(), (EntityPlayerMP)emp, (int[])new int[]{p.ordinal(), 0});
            }
        }
        ChromaResearchManager.instance.getRootNBTTag(ep).func_74782_a(MAIN_NBT_TAG, (NBTBase)li);
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            this.setPlayerDiscoveredColor(ep, CrystalElement.elements[i], false, notify);
            this.markPlayerCompletedStructureColor(ep, null, CrystalElement.elements[i], false, notify);
        }
        this.onProgressionChange(ep, notify);
    }

    private void onProgressionChange(EntityPlayer ep, boolean notify) {
        if (ep instanceof EntityPlayerMP) {
            ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
        }
        if (notify) {
            this.updateChunks(ep);
        }
        ProgressionLoadHandler.instance.updateProgressCache(ep);
        ProgressionLoadHandler.instance.updateBackup(ep);
    }

    public void maxPlayerProgression(EntityPlayer ep, boolean notify) {
        int i;
        for (i = 0; i < ProgressStage.list.length; ++i) {
            if (!ProgressStage.list[i].active) continue;
            this.setPlayerStage(ep, ProgressStage.list[i], true, notify, false);
        }
        for (i = 0; i < CrystalElement.elements.length; ++i) {
            this.setPlayerDiscoveredColor(ep, CrystalElement.elements[i], true, notify);
            this.markPlayerCompletedStructureColor(ep, null, CrystalElement.elements[i], true, notify);
        }
        for (i = 0; i < CastingRecipe.RecipeType.typeList.length; ++i) {
            CastingRecipe.RecipeType r = CastingRecipe.RecipeType.typeList[i];
            RecipesCastingTable.setPlayerHasCrafted(ep, r);
        }
    }

    public boolean setPlayerDiscoveredColor(EntityPlayer ep, CrystalElement e, boolean disc, boolean notify) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootNBTTag(ep);
        NBTTagCompound tag = nbt.func_74775_l(COLOR_NBT_TAG);
        boolean had = tag.func_74767_n(e.name());
        tag.func_74757_a(e.name(), disc);
        if (had != disc) {
            nbt.func_74782_a(COLOR_NBT_TAG, (NBTBase)tag);
            if (disc) {
                this.checkPlayerColors(ep);
            }
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            if (notify) {
                this.updateChunks(ep);
            }
            if (disc && notify) {
                ChromaResearchManager.instance.notifyPlayerOfProgression(ep, this.colorDiscoveries.get(e));
            }
            if (disc) {
                MinecraftForge.EVENT_BUS.post((Event)new ProgressionEvent(ep, e.name(), ProgressionEvent.ResearchType.COLOR));
            }
            ProgressionLoadHandler.instance.updateProgressCache(ep);
            ProgressionLoadHandler.instance.updateBackup(ep);
            return true;
        }
        return false;
    }

    private void checkPlayerColors(EntityPlayer ep) {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            if (this.hasPlayerDiscoveredColor(ep, CrystalElement.elements[i])) continue;
            return;
        }
        ProgressStage.ALLCOLORS.stepPlayerTo(ep);
    }

    public void updateChunks(EntityPlayer ep) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            ReikaRenderHelper.rerenderAllChunksLazily();
        } else {
            ReikaPacketHelper.sendUpdatePacket((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.RERENDER.ordinal(), (int)0, (int)0, (int)0, (PacketTarget)new PacketTarget.PlayerTarget((EntityPlayerMP)ep));
        }
    }

    public boolean hasPlayerDiscoveredColor(EntityPlayer ep, CrystalElement e) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootNBTTag(ep).func_74775_l(COLOR_NBT_TAG);
        return nbt.func_74767_n(e.name());
    }

    public Collection<CrystalElement> getColorsFor(EntityPlayer ep) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootNBTTag(ep).func_74775_l(COLOR_NBT_TAG);
        ArrayList<CrystalElement> c = new ArrayList<CrystalElement>();
        for (Object o : nbt.func_150296_c()) {
            String tag = (String)o;
            if (!nbt.func_74767_n(tag)) continue;
            c.add(CrystalElement.valueOf(tag));
        }
        return c;
    }

    public void giveAuxiliaryResearch(EntityPlayer ep, ProgressStage p) {
        ChromaResearch r;
        if (ChromaOptions.EASYFRAG.getState() && (r = this.auxiliaryReference.get(p)) != null && !ChromaResearchManager.instance.playerHasFragment(ep, r)) {
            ChromaResearchManager.instance.givePlayerFragment(ep, r, true);
            ItemStack is = ItemInfoFragment.getItem(r);
            ReikaPlayerAPI.addOrDropItem((ItemStack)is, (EntityPlayer)ep);
        }
    }

    @Override
    public boolean playerHasResearch(EntityPlayer ep, String key) {
        try {
            ProgressStage p = ProgressStage.valueOf(key.toUpperCase());
            return p.isPlayerAtStage(ep);
        }
        catch (IllegalArgumentException e) {
            ChromatiCraft.logger.logError((Object)("A mod tried to fetch an invalid progress stage '" + key + "'!"));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public HashSet<String> getAllResearches() {
        HashSet<String> c = new HashSet<String>();
        for (int i = 0; i < ProgressStage.list.length; ++i) {
            c.add(ProgressStage.list[i].name());
        }
        return c;
    }

    @Override
    public HashSet<String> getPrerequisites(String key) {
        try {
            ProgressStage p = ProgressStage.valueOf(key.toUpperCase());
            Collection<ProgressStage> c = this.getPrereqs(p);
            HashSet<String> h = new HashSet<String>();
            for (ProgressStage req : c) {
                h.add(req.name());
            }
            return h;
        }
        catch (IllegalArgumentException e) {
            ChromatiCraft.logger.logError((Object)("A mod tried to fetch the state of an invalid progress stage '" + key + "'!"));
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean canPlayerStepTo(EntityPlayer ep, String key) {
        try {
            ProgressStage p = ProgressStage.valueOf(key.toUpperCase());
            return this.canStepPlayerTo(ep, p);
        }
        catch (IllegalArgumentException e) {
            ChromatiCraft.logger.logError((Object)("A mod tried to fetch the state of an invalid progress stage '" + key + "'!"));
            e.printStackTrace();
            return false;
        }
    }

    public boolean hasPlayerDiscoveredAGeneratedStructure(EntityPlayer ep) {
        return ProgressStage.BURROW.isPlayerAtStage(ep) || ProgressStage.CAVERN.isPlayerAtStage(ep) || ProgressStage.OCEAN.isPlayerAtStage(ep) || ProgressStage.DESERTSTRUCT.isPlayerAtStage(ep);
    }

    @Override
    public boolean playerDiscoveredElement(EntityPlayer ep, CrystalElementAccessor.CrystalElementProxy e) {
        return this.hasPlayerDiscoveredColor(ep, (CrystalElement)e);
    }

    public boolean hasPlayerCompletedStructureColor(EntityPlayer ep, CrystalElement e) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootNBTTag(ep).func_74775_l(STRUCTURE_NBT_TAG);
        return nbt.func_74767_n(e.name());
    }

    public boolean markPlayerCompletedStructureColor(EntityPlayer ep, DimensionStructureGenerator gen, CrystalElement e, boolean set, boolean notify) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootNBTTag(ep);
        NBTTagCompound tag = nbt.func_74775_l(STRUCTURE_NBT_TAG);
        boolean had = tag.func_74767_n(e.name());
        tag.func_74757_a(e.name(), set);
        if (had != set) {
            if (set && gen != null && !gen.forcedOpen() && notify) {
                this.triggerStructurePassword(ep, gen);
            }
            nbt.func_74782_a(STRUCTURE_NBT_TAG, (NBTBase)tag);
            if (set) {
                ProgressStage.STRUCTCOMPLETE.stepPlayerTo(ep);
                this.checkPlayerStructures(ep);
            } else {
                this.setPlayerStage(ep, ProgressStage.ALLCORES, false, notify, true);
            }
            if (ep instanceof EntityPlayerMP) {
                ReikaPlayerAPI.syncCustomData((EntityPlayerMP)((EntityPlayerMP)ep));
            }
            if (notify) {
                this.updateChunks(ep);
            }
            if (set && notify) {
                ChromaResearchManager.instance.notifyPlayerOfProgression(ep, this.structureFlags.get(e));
            }
            if (set) {
                MinecraftForge.EVENT_BUS.post((Event)new ProgressionEvent(ep, e.name(), ProgressionEvent.ResearchType.DIMSTRUCT));
            }
            ProgressionLoadHandler.instance.updateProgressCache(ep);
            ProgressionLoadHandler.instance.updateBackup(ep);
            return true;
        }
        return false;
    }

    private void triggerStructurePassword(EntityPlayer ep, DimensionStructureGenerator gen) {
        if (ep instanceof EntityPlayerMP) {
            int hex = gen.getPassword(ep);
            ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.STRUCTPASSNOTE.ordinal(), (EntityPlayerMP)((EntityPlayerMP)ep), (int[])new int[]{hex});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addStructurePasswordNote(EntityPlayer ep, int hex) {
        ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.LOREHEX, (Entity)ep, (float)1.0f, (float)1.0f, (boolean)false);
        ChromaOverlays.instance.addStructurePasswordNote(ep, hex);
    }

    private void checkPlayerStructures(EntityPlayer ep) {
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            if (this.hasPlayerCompletedStructureColor(ep, CrystalElement.elements[i])) continue;
            return;
        }
        ProgressStage.ALLCORES.stepPlayerTo(ep);
    }

    public Collection<CrystalElement> getStructuresFor(EntityPlayer ep) {
        NBTTagCompound nbt = ChromaResearchManager.instance.getRootNBTTag(ep).func_74775_l(STRUCTURE_NBT_TAG);
        ArrayList<CrystalElement> c = new ArrayList<CrystalElement>();
        for (Object o : nbt.func_150296_c()) {
            String tag = (String)o;
            if (!nbt.func_74767_n(tag)) continue;
            c.add(CrystalElement.valueOf(tag));
        }
        return c;
    }

    private static class AlphabeticProgressComparator
    implements Comparator<ProgressStage> {
        private AlphabeticProgressComparator() {
        }

        @Override
        public int compare(ProgressStage o1, ProgressStage o2) {
            return o1.getTitleString().compareToIgnoreCase(o2.getTitleString());
        }
    }

    public static class ProgressTier
    implements Comparable<ProgressTier> {
        public final ResearchLevel level;
        private int index;

        private ProgressTier(ResearchLevel rl) {
            this.level = rl;
            this.index = rl.ordinal();
        }

        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            return this.level.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ProgressTier && ((ProgressTier)o).level == this.level;
        }

        @Override
        public int compareTo(ProgressTier o) {
            return this.level.compareTo(o.level);
        }
    }

    public static class ProgressLink {
        public final ProgressStage parent;
        public final LineType type;

        public ProgressLink(ProgressStage p) {
            this(p, LineType.SOLID);
        }

        public ProgressLink(ProgressStage p, LineType line) {
            this.parent = p;
            this.type = line;
        }

        public boolean equals(Object o) {
            return o instanceof ProgressLink && ((ProgressLink)o).parent == this.parent;
        }

        public int hashCode() {
            return this.parent.hashCode();
        }

        public String toString() {
            return this.parent.toString();
        }
    }

    private static class ProgressChain {
        public final ProgressStage progress;
        public final ProgressStage hook;
        public final ProgressStage prereq;
        private final ProgressStage[] exclusions;
        public final boolean notifyOnTrigger;
        public final boolean applyRetroactively;

        public ProgressChain(ProgressStage hook, ProgressStage req, ProgressStage p, boolean notify, boolean retro, ProgressStage ... excl) {
            this.progress = p;
            this.prereq = req;
            this.hook = hook;
            this.notifyOnTrigger = notify;
            this.applyRetroactively = retro;
            this.exclusions = excl;
        }

        public boolean equals(Object o) {
            return o instanceof ProgressChain && ((ProgressChain)o).progress == this.progress;
        }

        public int hashCode() {
            return this.progress.hashCode();
        }
    }

    public static class StructureComplete
    implements ChromaResearchManager.ProgressElement {
        public final CrystalElement color;

        private StructureComplete(CrystalElement e) {
            this.color = e;
        }

        @Override
        public String getTitle() {
            return this.color.displayName + " Core";
        }

        @Override
        public String getShortDesc() {
            return "Another piece of the puzzle";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderIcon(RenderItem ri, FontRenderer fr, int x, int y) {
            ItemStack is = ChromaTiles.DIMENSIONCORE.getCraftedProduct();
            is.field_77990_d = new NBTTagCompound();
            is.field_77990_d.func_74768_a("color", this.color.ordinal());
            ReikaGuiAPI.instance.drawItemStack(ri, fr, is, x, y);
        }

        public String toString() {
            return "Structure_" + this.color.name();
        }

        public int hashCode() {
            return this.color.ordinal();
        }

        public boolean equals(Object o) {
            return o instanceof StructureComplete && ((StructureComplete)o).color == this.color;
        }

        @Override
        public String getFormatting() {
            return this.color.getChatColorString();
        }

        @Override
        public boolean giveToPlayer(EntityPlayer ep, boolean notify) {
            return instance.markPlayerCompletedStructureColor(ep, null, this.color, true, notify);
        }
    }

    public static class ColorDiscovery
    implements ChromaResearchManager.ProgressElement {
        public final CrystalElement color;

        private ColorDiscovery(CrystalElement e) {
            this.color = e;
        }

        @Override
        public String getTitle() {
            return this.color.displayName;
        }

        @Override
        public String getShortDesc() {
            return "A new form of crystal energy";
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderIcon(RenderItem ri, FontRenderer fr, int x, int y) {
            ReikaGuiAPI.instance.drawItemStack(ri, fr, ChromaBlocks.RUNE.getStackOfMetadata(this.color.ordinal()), x, y);
        }

        public String toString() {
            return "Discover_" + this.color.name();
        }

        public int hashCode() {
            return this.color.ordinal();
        }

        public boolean equals(Object o) {
            return o instanceof ColorDiscovery && ((ColorDiscovery)o).color == this.color;
        }

        @Override
        public String getFormatting() {
            return this.color.getChatColorString();
        }

        @Override
        public boolean giveToPlayer(EntityPlayer ep, boolean notify) {
            return instance.setPlayerDiscoveredColor(ep, this.color, true, notify);
        }
    }
}

