/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.API.Interfaces.NonconvertibleBiome;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.TileEntity.Plants.TileEntityBiomeReverter;
import Reika.ChromatiCraft.World.BiomeGlowingCliffs;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Event.BlockTickEvent;
import Reika.DragonAPI.Instantiable.IO.NBTFile;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaChunkHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumIDHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class RainbowTreeEffects {
    public static final RainbowTreeEffects instance = new RainbowTreeEffects();
    private final HashMap<Integer, PersistentRainbowTreeFX> persistent = new HashMap();
    private boolean loaded = false;
    private static final ReikaNBTHelper.NBTIO<PersistentRainbowTreeFX> converter = new ReikaNBTHelper.NBTIO<PersistentRainbowTreeFX>(){

        public PersistentRainbowTreeFX createFromNBT(NBTBase nbt) {
            return PersistentRainbowTreeFX.readFromNBT((NBTTagCompound)nbt);
        }

        public NBTBase convertToNBT(PersistentRainbowTreeFX obj) {
            NBTTagCompound nbt = new NBTTagCompound();
            obj.writeToNBT(nbt);
            return nbt;
        }
    };

    private RainbowTreeEffects() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void save(World world) {
        NBTTagCompound tag = new NBTTagCompound();
        this.saveData(tag);
        NBTFile.SimpleNBTFile nf = new NBTFile.SimpleNBTFile(this.getFile(world));
        nf.data = tag;
        try {
            nf.save();
        }
        catch (IOException e) {
            ChromatiCraft.logger.logError((Object)"Failed to save rainbow tree FX cache!");
            e.printStackTrace();
        }
    }

    public void load(World world) {
        NBTFile.SimpleNBTFile nf = new NBTFile.SimpleNBTFile(this.getFile(world));
        try {
            nf.load();
        }
        catch (IOException e) {
            ChromatiCraft.logger.logError((Object)"Failed to load rainbow tree FX cache!");
            e.printStackTrace();
        }
        if (nf.data != null) {
            this.loadData(nf.data);
        }
    }

    private File getFile(World world) {
        return new File(world.func_72860_G().func_75765_b(), "ChromatiCraft_Data/RainbowTreeFX.dat");
    }

    private void saveData(NBTTagCompound tag) {
        NBTTagList li = new NBTTagList();
        ReikaNBTHelper.writeMapToNBT(this.persistent, (NBTTagList)li, null, converter);
        tag.func_74782_a("persistent", (NBTBase)tag);
    }

    private void loadData(NBTTagCompound tag) {
        NBTTagList li = tag.func_150295_c("persistent", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        ReikaNBTHelper.readMapFromNBT(this.persistent, (NBTTagList)li, null, converter);
    }

    @SubscribeEvent
    @DependentMethodStripper.ModDependent(value={ModList.MYSTCRAFT})
    public void dissolveDecay(BlockTickEvent evt) {
        if (!evt.world.field_72995_K && evt.getBlock() == MystCraftHandler.getInstance().decayID && this.isCoordinateClearing(evt.world, evt.xCoord, evt.yCoord, evt.zCoord)) {
            evt.setBlock(Blocks.field_150350_a);
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                int dx = evt.xCoord + dir.offsetX;
                int dy = evt.yCoord + dir.offsetY;
                int dz = evt.zCoord + dir.offsetZ;
                Block b = evt.world.func_147439_a(dx, dy, dz);
                if (b != MystCraftHandler.getInstance().decayID) continue;
                evt.world.func_147464_a(dx, dy, dz, b, 10);
            }
        }
    }

    private void loadIfNecessary(World world) {
        if (!this.loaded) {
            this.load(world);
            this.loaded = true;
        }
        if (!this.persistent.containsKey(world.field_73011_w.field_76574_g)) {
            this.persistent.put(world.field_73011_w.field_76574_g, new PersistentRainbowTreeFX(world));
        }
    }

    private boolean isCoordinateClearing(World world, int x, int y, int z) {
        this.loadIfNecessary(world);
        long time = world.func_82737_E();
        PersistentRainbowTreeFX fx = this.persistent.get(world.field_73011_w.field_76574_g);
        Iterator it = fx.decayCleaning.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            long val = (Long)e.getValue();
            if (val >= 0L && val < time) {
                it.remove();
                continue;
            }
            if (!((BlockBox)e.getKey()).isBlockInside(x, y, z)) continue;
            return true;
        }
        return false;
    }

    public void addDecayClearing(World world, long duration) {
        this.addDecayClearing(world, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, duration);
    }

    public void addDecayClearing(World world, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, long duration) {
        this.loadIfNecessary(world);
        PersistentRainbowTreeFX fx = this.persistent.get(world.field_73011_w.field_76574_g);
        fx.decayCleaning.put(new BlockBox(minX, minY, minZ, maxX, maxY, maxZ), duration >= 0L ? world.func_82737_E() + duration : -1L);
        this.save(world);
    }

    public void doRainbowTreeEffects(World world, int x, int y, int z, float chanceFactor, double rangeFactor, Random r, boolean spreadForest) {
        if (!world.field_72995_K) {
            if (ModList.THAUMCRAFT.isLoaded()) {
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 25.0f))) {
                    this.fightTaint(world, x, y, z, rangeFactor);
                }
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 20.0f))) {
                    this.fightEerie(world, x, y, z, rangeFactor);
                }
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 10.0f))) {
                    this.convertPureNodeMagic(world, x, y, z, rangeFactor);
                }
            }
            if (ModList.MYSTCRAFT.isLoaded() && ReikaMystcraftHelper.isMystAge((World)world)) {
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 20.0f))) {
                    this.fightInstability(world, x, y, z);
                }
                if (ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 10.0f))) {
                    this.fightDecay(world, x, y, z, rangeFactor);
                }
            }
            if (spreadForest && ChromaOptions.RAINBOWSPREAD.getState() && ReikaRandomHelper.doWithChance((double)(chanceFactor * 100.0f / 50.0f)) && world.func_72807_a(x, z) == ChromatiCraft.rainbowforest) {
                this.convertToRainbowForest(world, x, y, z, rangeFactor);
            }
        }
    }

    private void fightDecay(World world, int x, int y, int z, double rangeFactor) {
        if (MystCraftHandler.getInstance().decayID != null) {
            int r = (int)(64.0 * rangeFactor);
            int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
            int rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r);
            ReikaChunkHelper.removeBlocksFromChunk((World)world, (int)rx, (int)rz, (Block)MystCraftHandler.getInstance().decayID, (int)-1);
        }
    }

    private void fightInstability(World world, int x, int y, int z) {
        if (ModList.MYSTCRAFT.isLoaded()) {
            ReikaMystcraftHelper.decrInstabilityForAge((World)world, (int)1);
        }
    }

    public void addInstability(World world, int x, int y, int z) {
        if (ModList.MYSTCRAFT.isLoaded()) {
            ReikaMystcraftHelper.addInstabilityForAge((World)world, (short)1);
        }
    }

    private void convertPureNodeMagic(World world, int x, int y, int z, double rangeFactor) {
        int rz;
        int dr = (int)(64.0 * rangeFactor);
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
        if (world.func_72904_c(rx, 0, rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr), rx, 255, rz)) {
            int r = 3;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    BiomeGenBase natural;
                    int dx = rx + i;
                    int dz = rz + k;
                    BiomeGenBase biome = world.func_72807_a(dx, dz);
                    int id = biome.field_76756_M;
                    if (id != ThaumIDHandler.Biomes.MAGICFOREST.getID() || (natural = ReikaWorldHelper.getNaturalGennedBiomeAt((World)world, (int)dx, (int)dz)) == null || !ChromatiCraft.isRainbowForest(natural)) continue;
                    ReikaWorldHelper.setBiomeForXZ((World)world, (int)dx, (int)dz, (BiomeGenBase)natural);
                }
            }
        }
    }

    private void fightEerie(World world, int x, int y, int z, double rangeFactor) {
        int rz;
        int dr = (int)(32.0 * rangeFactor);
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
        if (world.func_72904_c(rx, 0, rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr), rx, 255, rz)) {
            int r = 3;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    BiomeGenBase natural;
                    int dx = rx + i;
                    int dz = rz + k;
                    BiomeGenBase biome = world.func_72807_a(dx, dz);
                    int id = biome.field_76756_M;
                    if (id != ThaumIDHandler.Biomes.EERIE.getID() || (natural = ReikaWorldHelper.getNaturalGennedBiomeAt((World)world, (int)dx, (int)dz)) == null) continue;
                    ReikaWorldHelper.setBiomeForXZ((World)world, (int)dx, (int)dz, (BiomeGenBase)natural);
                }
            }
        }
    }

    private void fightTaint(World world, int x, int y, int z, double rangeFactor) {
        int rz;
        int dr = (int)(32.0 * rangeFactor);
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
        if (world.func_72904_c(rx, 0, rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr), rx, 255, rz)) {
            int r = 3;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    BiomeGenBase natural;
                    int dx = rx + i;
                    int dz = rz + k;
                    BiomeGenBase biome = world.func_72807_a(dx, dz);
                    int id = biome.field_76756_M;
                    if (id != ThaumIDHandler.Biomes.TAINT.getID() || (natural = ReikaWorldHelper.getNaturalGennedBiomeAt((World)world, (int)dx, (int)dz)) == null) continue;
                    if (natural.field_76756_M == id) {
                        natural = BiomeGenBase.field_76767_f;
                    }
                    ReikaWorldHelper.setBiomeForXZ((World)world, (int)dx, (int)dz, (BiomeGenBase)natural);
                }
            }
        }
    }

    private void convertToRainbowForest(World world, int x, int y, int z, double rangeFactor) {
        int rz;
        int dr = (int)(32.0 * rangeFactor);
        int rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
        if (world.func_72904_c(rx, 0, rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr), rx, 255, rz)) {
            int r = 3;
            for (int i = -r; i <= r; ++i) {
                for (int k = -r; k <= r; ++k) {
                    BiomeGenBase biome;
                    int dx = rx + i;
                    int dz = rz + k;
                    if (TileEntityBiomeReverter.stopConversion(world, dx, dz) || (biome = world.func_72807_a(dx, dz)) == ChromatiCraft.rainbowforest || BiomeGlowingCliffs.isGlowingCliffs(biome) || biome instanceof NonconvertibleBiome) continue;
                    ReikaWorldHelper.setBiomeForXZ((World)world, (int)dx, (int)dz, (BiomeGenBase)ChromatiCraft.rainbowforest);
                }
            }
        }
    }

    private static class PersistentRainbowTreeFX {
        private final int dimensionID;
        private final HashMap<BlockBox, Long> decayCleaning = new HashMap();

        private PersistentRainbowTreeFX(World world) {
            this(world.field_73011_w.field_76574_g);
        }

        private PersistentRainbowTreeFX(int id) {
            this.dimensionID = id;
        }

        private void writeToNBT(NBTTagCompound NBT) {
            NBTTagList li = new NBTTagList();
            for (Map.Entry<BlockBox, Long> e : this.decayCleaning.entrySet()) {
                NBTTagCompound tag = new NBTTagCompound();
                e.getKey().writeToNBT(tag);
                tag.func_74772_a("time", e.getValue().longValue());
                li.func_74742_a((NBTBase)tag);
            }
            NBT.func_74782_a("cleaning", (NBTBase)li);
            NBT.func_74768_a("dimID", this.dimensionID);
        }

        private static PersistentRainbowTreeFX readFromNBT(NBTTagCompound NBT) {
            PersistentRainbowTreeFX fx = new PersistentRainbowTreeFX(NBT.func_74762_e("dimID"));
            NBTTagList li = NBT.func_150295_c("cleaning", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            for (Object o : li.field_74747_a) {
                NBTTagCompound tag = (NBTTagCompound)o;
                BlockBox box = BlockBox.readFromNBT((NBTTagCompound)tag);
                fx.decayCleaning.put(box, tag.func_74763_f("time"));
            }
            return fx;
        }
    }
}

