/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCastingInjector;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public final class RuneShape {
    private final HashMap<Coordinate, CrystalElement> runes = new HashMap();
    private final BlockArray blocks = new BlockArray();

    public RuneShape() {
    }

    public RuneShape(Map<Coordinate, CrystalElement> map) {
        for (Coordinate c : map.keySet()) {
            this.addRune(map.get(c), c.xCoord, c.yCoord, c.zCoord);
        }
    }

    public void addRune(CrystalElement e, int x, int y, int z) {
        this.runes.put(new Coordinate(x, y, z), e);
        this.blocks.addBlockCoordinate(x, y, z);
    }

    public CrystalElement getRuneAt(int x, int y, int z) {
        return this.runes.get(new Coordinate(x, y, z));
    }

    public void place(World world, int x, int y, int z) {
        for (Coordinate c : this.runes.keySet()) {
            world.func_147465_d(c.xCoord + x, c.yCoord + y, c.zCoord + z, ChromaBlocks.RUNE.getBlockInstance(), this.runes.get(c).ordinal(), 3);
        }
    }

    public boolean matchAt(World world, int x, int y, int z) {
        Set<Coordinate> foci = TileEntityCastingInjector.getFoci();
        for (Coordinate c : this.runes.keySet()) {
            int dx = x + c.xCoord;
            int dy = y + c.yCoord;
            int dz = z + c.zCoord;
            Block b = world.func_147439_a(dx, dy, dz);
            if (b == ChromaBlocks.RUNE.getBlockInstance()) {
                int meta = world.func_72805_g(dx, dy, dz);
                if (meta == this.runes.get(c).ordinal()) continue;
                return false;
            }
            if (b == ChromaBlocks.INJECTORAUX.getBlockInstance()) {
                if (foci.contains(c)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public int getMinX() {
        return this.blocks.getMinX();
    }

    public int getMaxX() {
        return this.blocks.getMaxX();
    }

    public int getMinY() {
        return this.blocks.getMinY();
    }

    public int getMaxY() {
        return this.blocks.getMaxY();
    }

    public int getMinZ() {
        return this.blocks.getMinZ();
    }

    public int getMaxZ() {
        return this.blocks.getMaxZ();
    }

    public int getSizeX() {
        return this.blocks.getSizeX();
    }

    public int getSizeY() {
        return this.blocks.getSizeY();
    }

    public int getSizeZ() {
        return this.blocks.getSizeZ();
    }

    public String toString() {
        return this.runes.toString();
    }

    public boolean isEmpty() {
        return this.runes.isEmpty();
    }

    public RuneViewer getView() {
        return new RuneViewer(this);
    }

    public boolean equals(Object o) {
        return o instanceof RuneShape && ((RuneShape)o).runes.equals(this.runes);
    }

    public static final class RuneViewer {
        private final RuneShape shape;

        private RuneViewer(RuneShape r) {
            this.shape = r;
        }

        public Map<Coordinate, CrystalElement> getRunes() {
            return Collections.unmodifiableMap(this.shape.runes);
        }

        public int getSizeX() {
            return this.shape.getSizeX();
        }

        public int getSizeY() {
            return this.shape.getSizeY();
        }

        public int getSizeZ() {
            return this.shape.getSizeZ();
        }

        public int getMinX() {
            return this.shape.getMinX();
        }

        public int getMinY() {
            return this.shape.getMinY();
        }

        public int getMinZ() {
            return this.shape.getMinZ();
        }

        public int getMaxX() {
            return this.shape.getMaxX();
        }

        public int getMaxY() {
            return this.shape.getMaxY();
        }

        public int getMaxZ() {
            return this.shape.getMaxZ();
        }

        public boolean isEmpty() {
            return this.shape.isEmpty();
        }
    }

    public static class RuneLocation {
        public final CrystalElement color;
        public final int xCoord;
        public final int yCoord;
        public final int zCoord;
        public final int dimensionID;

        public RuneLocation(CrystalElement e, World world, int x, int y, int z) {
            this.color = e;
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            this.dimensionID = world.field_73011_w.field_76574_g;
        }

        public RuneLocation(int meta, World world, int x, int y, int z) {
            this(CrystalElement.elements[meta], world, x, y, z);
        }
    }
}

