/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.ChromatiCraft.Auxiliary.TemporaryCrystalReceiver;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.Tools.ItemEfficiencyCrystal;
import Reika.ChromatiCraft.Magic.Interfaces.CrystalSource;
import Reika.ChromatiCraft.Magic.Interfaces.PoweredItem;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Magic.Progression.ResearchLevel;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Auxiliary.ChunkManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Interfaces.Entity.ChunkLoadingEntity;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Java.ReikaGLHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class ToolChargingSystem {
    public static final ToolChargingSystem instance = new ToolChargingSystem();
    private static final int CHARGE_RANGE = 32;

    private ToolChargingSystem() {
    }

    public int getChargeRate(ItemStack is) {
        int get = this.getCharge(is);
        int base = (int)(5.0 * Math.min(20.0, 1.0 + 100.0 * ReikaMathLibrary.cosInterpolation((double)0.0, (double)this.getItem(is).getMaxCharge(), (double)get)));
        return this.getItem(is).getChargeRate(is, base);
    }

    public <I extends Item> ItemStack getChargedItem(I item, int charge) {
        ItemStack is = new ItemStack(item);
        this.addCharge(is, charge);
        return is;
    }

    public int addCharge(ItemStack is, int amt) {
        int get = this.getCharge(is);
        amt = Math.min(amt, this.getItem(is).getMaxCharge() - get);
        this.setCharge(is, get + amt);
        return amt;
    }

    public int removeCharge(ItemStack is, int amt, EntityPlayer ep) {
        if (ItemEfficiencyCrystal.isActive(ep)) {
            amt = Math.max(1, amt / 3);
        }
        int get = this.getCharge(is);
        amt = Math.min(get, amt);
        this.setCharge(is, get - amt);
        return amt;
    }

    private void setCharge(ItemStack is, int amt) {
        if (is.field_77990_d == null) {
            is.field_77990_d = new NBTTagCompound();
        }
        int max = this.getItem(is).getMaxCharge();
        is.field_77990_d.func_74768_a("charge", MathHelper.func_76125_a((int)amt, (int)0, (int)max));
        if (this.getItem(is).hasChargeStates()) {
            is.func_77964_b(this.getItem(is).getChargeState((float)this.getCharge(is) / (float)max));
        }
    }

    public void tryChargeFromPlayer(ItemStack is, EntityPlayer ep) {
        CrystalElement ec;
        int get;
        int extr = this.getItem(is).getPlayerBufferExtractionRate(is);
        if (extr > 0 && (get = Math.min(extr, PlayerElementBuffer.instance.getPlayerContent(ep, ec = this.getItem(is).getColor(is)))) > 0) {
            int add = this.addCharge(is, get);
            PlayerElementBuffer.instance.removeFromPlayer(ep, ec, add);
        }
    }

    private PoweredItem getItem(ItemStack is) {
        return (PoweredItem)is.func_77973_b();
    }

    public final int getCharge(ItemStack is) {
        return is.field_77990_d != null ? is.field_77990_d.func_74762_e("charge") : 0;
    }

    public boolean tickItem(EntityItem ei) {
        ItemStack is = ei.func_92059_d();
        PoweredItem pi = this.getItem(is);
        int charge = this.getCharge(is);
        if (!ei.field_70170_p.field_72995_K) {
            if (charge < pi.getMaxCharge()) {
                float rate;
                WorldLocation loc = new WorldLocation((Entity)ei);
                TemporaryCrystalReceiver r = new TemporaryCrystalReceiver(loc, 0, 32, 0.0625, ResearchLevel.ENDGAME);
                CrystalElement e = pi.getColor(is);
                r.addColorRestriction(e);
                int amt = this.getChargeRate(is);
                CrystalSource s = CrystalNetworker.instance.getNearestTileOfType(r, CrystalSource.class, 32.0);
                if (s != null && s.isConductingElement(e) && (rate = s.getDroppedItemChargeRate(is)) > 0.0f) {
                    amt = (int)((float)amt * rate);
                    s.drain(e, amt * 4);
                    amt = this.scaleChargeRate(amt, ei, is, s, loc);
                    this.addCharge(is, amt);
                    ReikaPacketHelper.sendEntitySyncPacket((String)"DragonAPIData", (Entity)ei, (double)32.0);
                }
                r.destroy();
            }
        } else if (charge > 0) {
            pi.doChargeFX(ei, charge);
        }
        return false;
    }

    private int scaleChargeRate(int amt, EntityItem ei, ItemStack is, CrystalSource s, WorldLocation loc) {
        if (s instanceof TileEntityCrystalPylon) {
            amt = (int)((double)amt * 1.25);
            if (((TileEntityCrystalPylon)s).isEnhanced()) {
                amt = (int)((double)amt * 1.6);
            }
        }
        if (loc.getBlock() == ChromaBlocks.CHROMA.getBlockInstance() && loc.getBlockMetadata() == 0) {
            amt = (int)((double)amt * 1.25);
        }
        if (TileEntityAuraPoint.isPointWithin(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, 256)) {
            amt *= 2;
        }
        return amt;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItemAux(RenderItem ri, ItemStack is, IItemRenderer.ItemRenderType type) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY && Keyboard.isKeyDown((int)42)) {
            ReikaTextureHelper.bindTerrainTexture();
            CrystalElement e = this.getItem(is).getColor(is);
            GL11.glPushAttrib((int)1048575);
            GL11.glPushMatrix();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3042);
            ReikaGLHelper.BlendMode.DEFAULT.apply();
            GL11.glDisable((int)2896);
            double sc = 0.5;
            if (Keyboard.isKeyDown((int)29)) {
                sc = 1.0;
            }
            GL11.glScaled((double)sc, (double)sc, (double)sc);
            GL11.glTranslated((double)(0.5 / sc), (double)0.0, (double)0.0);
            if (Keyboard.isKeyDown((int)29)) {
                GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            }
            ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)"Textures/infoicons.png");
            double u = 0.375;
            double v = 0.0;
            double s = 0.0625;
            Tessellator v5 = Tessellator.field_78398_a;
            double z = 50.0;
            int c = e.getColor();
            int c1 = ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)0.65f);
            int c2 = e == CrystalElement.BLACK ? c1 : ReikaColorAPI.mixColors((int)c, (int)0, (float)0.75f);
            ColorBlendList cbl = new ColorBlendList(10.0f, new int[]{c, c2, c, c1});
            v5.func_78382_b();
            v5.func_78374_a(0.0, 0.0, z, u, v + s);
            v5.func_78374_a(1.0, 0.0, z, u + s, v + s);
            v5.func_78374_a(1.0, 1.0, z, u + s, v);
            v5.func_78374_a(0.0, 1.0, z, u, v);
            v5.func_78378_d(cbl.getColor((double)System.currentTimeMillis() / 40.0));
            v5.func_78374_a(0.0, 0.0, z, u + s, v + s);
            v5.func_78374_a(1.0, 0.0, z, u + s * 2.0, v + s);
            v5.func_78374_a(1.0, 1.0, z, u + s * 2.0, v);
            v5.func_78374_a(0.0, 1.0, z, u + s, v);
            v5.func_78381_a();
            ReikaTextureHelper.bindTerrainTexture();
            IIcon ico = e.getFaceRune();
            u = ico.func_94209_e();
            double du = ico.func_94212_f();
            v = ico.func_94206_g();
            double dv = ico.func_94210_h();
            double x = 0.5 / sc;
            v5.func_78382_b();
            v5.func_78374_a(0.0 - x, 0.0, z, u, dv);
            v5.func_78374_a(1.0 - x, 0.0, z, du, dv);
            v5.func_78374_a(1.0 - x, 1.0, z, du, v);
            v5.func_78374_a(0.0 - x, 1.0, z, u, v);
            v5.func_78381_a();
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }

    public static class EntityChargingTool
    extends EntityItem
    implements ChunkLoadingEntity {
        private boolean needsLoad = true;

        public EntityChargingTool(World world) {
            super(world);
        }

        public EntityChargingTool(World world, EntityItem e, ItemStack is) {
            super(world, e.field_70165_t, e.field_70163_u, e.field_70161_v, is);
            this.field_145804_b = e.field_145804_b;
            this.field_70159_w = e.field_70159_w;
            this.field_70181_x = e.field_70181_x;
            this.field_70179_y = e.field_70179_y;
            this.field_70133_I = true;
        }

        public EntityChargingTool(World world, double posX, double posY, double posZ, ItemStack is) {
            super(world, posX, posY, posZ, is);
        }

        public void func_70288_d() {
        }

        public void func_70071_h_() {
            super.func_70071_h_();
            if (this.needsLoad) {
                ChunkManager.instance.loadChunks((ChunkLoadingEntity)this);
                this.needsLoad = false;
            }
        }

        public boolean func_70112_a(double distsq) {
            return true;
        }

        public Collection<ChunkCoordIntPair> getChunksToLoad() {
            return ChunkManager.getChunkSquare((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)MathHelper.func_76128_c((double)this.field_70161_v), (int)2);
        }

        public void func_70106_y() {
            this.onDestroy();
            super.func_70106_y();
        }

        public void onDestroy() {
            ChunkManager.instance.unloadChunks((Entity)this);
        }
    }
}

