/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.Magic;

import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.AngleMap;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaVectorHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;

public class WarpNetwork {
    private static final String NBT_TAG = "warpnodenet";
    private final HashMap<WorldLocation, AngleMap<WorldLocation>> data = new HashMap();
    public static final WarpNetwork instance = new WarpNetwork();

    private WarpNetwork() {
    }

    public Collection<WorldLocation> getAllNodes() {
        return Collections.unmodifiableCollection(this.data.keySet());
    }

    public void addLocation(WorldLocation loc) {
        AngleMap<WorldLocation> map = this.calculateLinks(loc);
        this.data.put(loc, map);
        WarpNetworkData.initNetworkData(loc.getWorld()).func_76186_a(true);
    }

    public WorldLocation getLink(WorldLocation loc, double angle, double tolerance) {
        double d2;
        WarpNetworkData.initNetworkData(loc.getWorld());
        AngleMap<WorldLocation> map = this.data.get(loc);
        if (map == null || map.isEmpty()) {
            return null;
        }
        if (map.size() == 1) {
            Map.Entry e = map.firstEntry();
            return Math.abs(ReikaVectorHelper.getAngleDifference((double)((Double)e.getKey()), (double)angle)) <= tolerance ? (WorldLocation)e.getValue() : null;
        }
        Map.Entry e1 = map.floorEntry(angle);
        Map.Entry e2 = map.ceilingEntry(angle);
        if (e1 == null) {
            return Math.abs(ReikaVectorHelper.getAngleDifference((double)((Double)e2.getKey()), (double)angle)) <= tolerance ? (WorldLocation)e2.getValue() : null;
        }
        if (e2 == null) {
            return Math.abs(ReikaVectorHelper.getAngleDifference((double)((Double)e1.getKey()), (double)angle)) <= tolerance ? (WorldLocation)e1.getValue() : null;
        }
        double d1 = Math.abs(ReikaVectorHelper.getAngleDifference((double)((Double)e1.getKey()), (double)angle));
        boolean left = d1 < (d2 = Math.abs(ReikaVectorHelper.getAngleDifference((double)((Double)e2.getKey()), (double)angle)));
        return (left ? d1 : d2) <= tolerance ? (left ? (WorldLocation)e1.getValue() : (WorldLocation)e2.getValue()) : null;
    }

    private AngleMap<WorldLocation> calculateLinks(WorldLocation loc) {
        AngleMap ret = new AngleMap();
        for (WorldLocation key : this.data.keySet()) {
            if (key.dimensionID != loc.dimensionID || loc.equals((Object)key)) continue;
            AngleMap<WorldLocation> map = this.data.get(key);
            double phi = ReikaPhysicsHelper.cartesianToPolar((double)(loc.xCoord - key.xCoord), (double)0.0, (double)(loc.zCoord - key.zCoord))[2];
            map.put(phi, (Object)loc);
            ret.put((phi + 180.0) % 360.0, (Object)key);
        }
        return ret;
    }

    public void clear() {
        this.data.clear();
    }

    public void load(NBTTagCompound NBT) {
        this.data.clear();
        NBTTagList data = NBT.func_150295_c("data", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        for (Object o : data.field_74747_a) {
            NBTTagCompound entry = (NBTTagCompound)o;
            WorldLocation key = WorldLocation.readFromNBT((String)"location", (NBTTagCompound)entry);
            AngleMap map = new AngleMap();
            NBTTagList li = entry.func_150295_c("map", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
            for (Object o2 : li.field_74747_a) {
                NBTTagCompound tag = (NBTTagCompound)o2;
                WorldLocation loc = WorldLocation.readTag((NBTTagCompound)tag);
                double d = tag.func_74769_h("angle");
                map.put(d, (Object)loc);
            }
            this.data.put(key, (AngleMap<WorldLocation>)map);
        }
    }

    public void save(NBTTagCompound NBT) {
        NBTTagList data = new NBTTagList();
        for (WorldLocation key : this.data.keySet()) {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74782_a("location", (NBTBase)key.writeToTag());
            AngleMap<WorldLocation> map = this.data.get(key);
            NBTTagList li = new NBTTagList();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                double d = (Double)iterator.next();
                WorldLocation loc = (WorldLocation)map.get(d);
                NBTTagCompound tag = loc.writeToTag();
                tag.func_74780_a("angle", d);
                li.func_74742_a((NBTBase)tag);
            }
            entry.func_74782_a("map", (NBTBase)li);
            data.func_74742_a((NBTBase)entry);
        }
        NBT.func_74782_a("data", (NBTBase)data);
    }

    public static class WarpNetworkData
    extends WorldSavedData {
        private static final String IDENTIFIER = "warpnodenet";

        public WarpNetworkData() {
            super("warpnodenet");
        }

        public WarpNetworkData(String s) {
            super(s);
        }

        public void func_76184_a(NBTTagCompound NBT) {
            instance.load(NBT);
        }

        public void func_76187_b(NBTTagCompound NBT) {
            instance.save(NBT);
        }

        private static WarpNetworkData initNetworkData(World world) {
            WarpNetworkData data = (WarpNetworkData)world.func_72943_a(WarpNetworkData.class, "warpnodenet");
            if (data == null) {
                data = new WarpNetworkData();
                world.func_72823_a("warpnodenet", (WorldSavedData)data);
            }
            return data;
        }
    }
}

