/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.AE;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityChromaticBase;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.ItemElementCalculator;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.Collections.InventoryCache;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.ModInteract.BasicAEInterface;
import Reika.DragonAPI.Instantiable.ModInteract.DirectionalAEInterface;
import Reika.DragonAPI.Instantiable.ModInteract.MEWorkTracker;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.SidePlacedTile;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.MESystemReader;
import Reika.DragonAPI.ModList;
import appeng.api.AEApi;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"appeng.api.networking.security.IActionHost"})
public class TileEntityMEDistributor
extends TileEntityChromaticBase
implements IActionHost,
SidePlacedTile {
    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    private MESystemReader network;
    private Object aeGridBlock;
    private Object aeGridNode;
    private int AEPowerCost = 1;
    private final InventoryCache output = new InventoryCache();
    private StepTimer checkTimer = new StepTimer(10);
    private StepTimer cacheTimer = new StepTimer(40);
    public static final int NSLOTS = 10;
    private ItemStack[] filter = new ItemStack[20];
    private int[] threshold = new int[10];
    private MESystemReader.MatchMode[] match = new MESystemReader.MatchMode[10];
    private MEWorkTracker hasWork = new MEWorkTracker();

    public TileEntityMEDistributor() {
        if (ModList.APPENG.isLoaded()) {
            this.aeGridBlock = new DirectionalAEInterface((TileEntity)this, this.getTile().getCraftedProduct());
            this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
        }
        for (int i = 0; i < this.match.length; ++i) {
            this.match[i] = MESystemReader.MatchMode.EXACT;
        }
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.APPENG.isLoaded() && this.aeGridNode != null) {
            ((IGridNode)this.aeGridNode).destroy();
        }
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.MEDISTRIBUTOR;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        if (world.field_72995_K) {
            this.spawnParticles(world, x, y, z, meta);
        } else {
            this.cacheTimer.update();
            if (this.cacheTimer.checkCap()) {
                this.buildCache();
            }
            if (this.aeGridBlock != null && !world.field_72995_K) {
                ((BasicAEInterface)this.aeGridBlock).setPowerCost((double)this.AEPowerCost);
            }
            if (this.AEPowerCost > 1) {
                this.AEPowerCost -= Math.max(1, this.AEPowerCost / 40);
            }
            if (this.network != null) {
                this.hasWork.tick();
                this.checkTimer.update();
                if (this.hasWork.hasWork() && this.checkTimer.checkCap()) {
                    this.checkTimer.setCap(Math.min(40, this.checkTimer.getCap() + 2));
                    this.output.clear();
                    TileEntity te = this.getAdjacentTileEntity(this.getFacing().getOpposite());
                    if (te instanceof IInventory) {
                        this.output.addInventory((IInventory)te);
                    }
                    for (int i = 0; i < 10; ++i) {
                        int fit;
                        ItemStack f1 = this.filter[i];
                        ItemStack f2 = this.filter[i + 10];
                        if (f1 == null || f2 == null || (fit = f2.func_77976_d() - this.output.addItemsToUnderlyingInventories(ReikaItemHelper.getSizedItemStack((ItemStack)f2, (int)f2.func_77976_d()), true)) <= 0) continue;
                        this.hasWork.reset();
                        MESystemReader.MatchMode mode = this.getMode(i);
                        long has = mode.countItems(this.network, f1);
                        int missing = this.getThreshold(i) - (has > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)has);
                        if (missing <= 0) continue;
                        this.transferItem(ReikaItemHelper.getSizedItemStack((ItemStack)f2, (int)Math.min(Math.min(fit, missing), f2.func_77976_d())), (IInventory)te, mode);
                    }
                }
            }
        }
    }

    public int getThreshold(int i) {
        return this.threshold[i];
    }

    public MESystemReader.MatchMode getMode(int i) {
        return this.match[i];
    }

    private void buildCache() {
        if (ModList.APPENG.isLoaded()) {
            ((DirectionalAEInterface)this.aeGridBlock).disconnectAll().connect(this.getFacing());
            Object oldNode = this.aeGridNode;
            if (this.aeGridNode == null) {
                Object object = this.aeGridNode = FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER ? AEApi.instance().createGridNode((IGridBlock)this.aeGridBlock) : null;
            }
            if (this.aeGridNode != null) {
                ((IGridNode)this.aeGridNode).updateState();
            }
            if (oldNode != this.aeGridNode || this.network == null) {
                this.network = this.aeGridNode == null ? null : (this.network == null ? new MESystemReader((IGridNode)this.aeGridNode, (IActionHost)this) : new MESystemReader((IGridNode)this.aeGridNode, this.network));
                this.buildCallbacks();
            }
        }
    }

    private void buildCallbacks() {
        if (this.network != null) {
            this.network.clearCallbacks();
            for (int i = 0; i < this.filter.length; ++i) {
                ItemStack pattern = this.filter[i];
                if (pattern == null) continue;
                this.network.addCallback(pattern, (MESystemReader.ChangeCallback)this.hasWork);
            }
        }
        this.hasWork.markDirty();
    }

    private void transferItem(ItemStack is, IInventory ii, MESystemReader.MatchMode mode) {
        MESystemReader.ExtractedItemGroup rem = mode.removeItems(this.network, is, true, false);
        if (rem != null) {
            ItemStack add = rem.getBiggest().getItem();
            add.field_77994_a = Math.min(add.field_77994_a, is.field_77994_a);
            if (ReikaInventoryHelper.addToIInv((ItemStack)add, (IInventory)ii)) {
                mode.removeItems(this.network, add, false, false);
            }
            ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.METRANSFER.ordinal(), (TileEntity)this, (int)32, (int[])new int[]{Item.func_150891_b((Item)add.func_77973_b()), add.func_77960_j()});
            this.AEPowerCost = Math.min(500, this.AEPowerCost + Math.max(1, add.field_77994_a / 4));
            this.checkTimer.setCap(Math.max(4, this.checkTimer.getCap() - 4));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        int i;
        super.func_145841_b(NBT);
        NBTTagCompound fil = new NBTTagCompound();
        for (i = 0; i < this.filter.length; ++i) {
            ItemStack is = this.filter[i];
            if (is == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            is.func_77955_b(tag);
            if (i < 9) {
                tag.func_74768_a("thresh", this.threshold[i]);
            }
            fil.func_74782_a("filter_" + i, (NBTBase)tag);
        }
        for (i = 0; i < this.threshold.length; ++i) {
            fil.func_74768_a("thresh_" + i, this.threshold[i]);
            fil.func_74768_a("match_" + i, this.match[i].ordinal());
        }
        NBT.func_74782_a("filter", (NBTBase)fil);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        String name;
        int i;
        super.func_145839_a(NBT);
        this.filter = new ItemStack[this.filter.length];
        NBTTagCompound fil = NBT.func_74775_l("filter");
        for (i = 0; i < this.filter.length; ++i) {
            ItemStack is;
            name = "filter_" + i;
            if (!fil.func_74764_b(name)) continue;
            NBTTagCompound tag = fil.func_74775_l(name);
            this.filter[i] = is = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.threshold = new int[this.threshold.length];
        this.match = new MESystemReader.MatchMode[this.match.length];
        for (i = 0; i < this.threshold.length; ++i) {
            name = "filter_" + i;
            this.threshold[i] = fil.func_74762_e("thresh_" + i);
            this.match[i] = MESystemReader.MatchMode.list[fil.func_74762_e("match_" + i)];
        }
    }

    public void setMapping(int slot, ItemStack is) {
        this.filter[slot] = is;
        if (ModList.APPENG.isLoaded()) {
            this.buildCallbacks();
        }
        this.syncAllData(true);
    }

    public ItemStack getMapping(int slot) {
        return this.filter[slot] != null ? this.filter[slot].func_77946_l() : null;
    }

    public void setThreshold(int slot, int thresh) {
        this.threshold[slot] = thresh;
        if (ModList.APPENG.isLoaded()) {
            this.buildCallbacks();
        }
        this.syncAllData(true);
    }

    public void toggleFuzzy(int slot) {
        this.match[slot] = this.match[slot].next();
        if (ModList.APPENG.isLoaded()) {
            this.buildCallbacks();
        }
        this.syncAllData(true);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles(World world, int x, int y, int z, int meta) {
        ForgeDirection dir = this.getFacing();
        double r = 0.475;
        double v = -ReikaRandomHelper.getRandomPlusMinus((double)0.03125, (double)0.015);
        double dx = (double)x + 0.5 + (double)dir.offsetX * r;
        double dy = (double)y + 0.5 + (double)dir.offsetY * r;
        double dz = (double)z + 0.5 + (double)dir.offsetZ * r;
        double vx = v * (double)dir.offsetX;
        double vy = v * (double)dir.offsetY;
        double vz = v * (double)dir.offsetZ;
        dx = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)0.03125);
        dy = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)0.03125);
        dz = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)0.03125);
        vx = ReikaRandomHelper.getRandomPlusMinus((double)vx, (double)0.008);
        vy = ReikaRandomHelper.getRandomPlusMinus((double)vy, (double)0.008);
        vz = ReikaRandomHelper.getRandomPlusMinus((double)vz, (double)0.008);
        float s = (float)ReikaRandomHelper.getRandomPlusMinus((double)1.25, (double)0.25);
        int l = 40 + rand.nextInt(30);
        EntityBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz, vx, vy, vz).setRapidExpand().setLife(l).setScale(s).setColor(135, 90, 165);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnTransferParticles(World world, int x, int y, int z, int id, int meta) {
        ItemStack is = new ItemStack(Item.func_150899_d((int)id), 1, meta);
        ForgeDirection dir = this.getFacing();
        ElementTagCompound tag = ItemElementCalculator.instance.getValueForItem(is);
        float s = ReikaRandomHelper.getRandomPlusMinus((int)6, (int)2);
        int l = 20 + rand.nextInt(20);
        if (tag == null || tag.isEmpty()) {
            int n = 1 + rand.nextInt(5);
            for (int i = 0; i < n; ++i) {
                double dx = (double)(x - dir.offsetX) + rand.nextDouble();
                double dy = (double)(y - dir.offsetY) + rand.nextDouble();
                double dz = (double)(z - dir.offsetZ) + rand.nextDouble();
                EntityBlurFX fx = new EntityCCBlurFX(world, dx, dy, dz).setRapidExpand().setLife(l).setScale(s).setColor(32, 150, 255);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        } else {
            for (CrystalElement e : tag.elementSet()) {
                double dx = (double)(x - dir.offsetX) + rand.nextDouble();
                double dy = (double)(y - dir.offsetY) + rand.nextDouble();
                double dz = (double)(z - dir.offsetZ) + rand.nextDouble();
                EntityBlurFX fx = new EntityCCBlurFX(e, world, dx, dy, dz, 0.0, 0.0, 0.0).setRapidExpand().setLife(l).setScale(s);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public IGridNode getGridNode(ForgeDirection dir) {
        return dir == this.getFacing() ? (IGridNode)this.aeGridNode : null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return dir == this.getFacing() ? AECableType.GLASS : null;
    }

    private ForgeDirection getFacing() {
        return this.dirs[this.func_145832_p()];
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public void securityBreak() {
    }

    @DependentMethodStripper.ModDependent(value={ModList.APPENG})
    public IGridNode getActionableNode() {
        return (IGridNode)this.aeGridNode;
    }

    public void placeOnSide(int s) {
        this.setBlockMetadata(s);
    }

    public boolean checkLocationValidity() {
        return true;
    }

    public void drop() {
        ReikaItemHelper.dropItem((World)this.field_145850_b, (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (ItemStack)this.getTile().getCraftedProduct());
        this.delete();
    }
}

