/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.ModInterface.Bees.ProductChecks;
import Reika.ChromatiCraft.ModInterface.Bees.TileEntityLumenAlveary;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.GUI.StatusLogger;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.EnumTolerance;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IAlvearyController;
import forestry.api.multiblock.IMultiblockComponent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChromaBeeHelpers {
    private static HashMap<SelectionKey, EntitySelection> entityLists = new HashMap();
    private static HashMap<ChunkCoordinates, Coordinate> alvearyControllerLocations = new HashMap();
    private static HashMap<ChunkCoordinates, CachedTerritory> territoryCache = new HashMap();

    static List<WeakReference<EntityLivingBase>> getEntityList(AxisAlignedBB box, long time, World world, ChunkCoordinates c, Class ce, IEntitySelector s) {
        if (EntityPlayer.class.isAssignableFrom(ce) || s == ReikaEntityHelper.playerSelector) {
            ArrayList<WeakReference<EntityLivingBase>> li = new ArrayList<WeakReference<EntityLivingBase>>();
            for (EntityPlayer ep : world.field_73010_i) {
                if (!ep.field_70121_D.func_72326_a(box)) continue;
                li.add(new WeakReference<EntityPlayer>(ep));
            }
            return li;
        }
        SelectionKey sk = new SelectionKey(world, c, ce, s);
        EntitySelection e = entityLists.get(sk);
        if (e == null || e.age > 5) {
            if (e == null) {
                e = new EntitySelection();
                entityLists.put(sk, e);
            }
            e.updateList(box, world, ce, s);
        } else if (time > e.lastTick) {
            e.lastTick = time;
            e.age++;
        }
        return e.entityList;
    }

    public static boolean isBestPossibleBee(IBeeGenome ibg) {
        if (!(ibg.getNocturnal() && ibg.getCaveDwelling() && ibg.getTolerantFlyer())) {
            return false;
        }
        if (ibg.getToleranceHumid() != EnumTolerance.BOTH_5 || ibg.getToleranceTemp() != EnumTolerance.BOTH_5) {
            return false;
        }
        if (ibg.getFertility() < CrystalBees.superFertility.getAllele().getValue()) {
            return false;
        }
        if (ibg.getFlowering() < CrystalBees.superFlowering.getAllele().getValue()) {
            return false;
        }
        if (ibg.getLifespan() < CrystalBees.superLife.getAllele().getValue()) {
            return false;
        }
        if (ibg.getSpeed() < CrystalBees.superSpeed.getAllele().getValue()) {
            return false;
        }
        return Arrays.equals(ibg.getTerritory(), CrystalBees.superTerritory.getAllele().getValue());
    }

    static int[] getSearchRange(IBeeGenome ibg, IBeeHousing ibh) {
        int r;
        IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(ibh);
        int tr = (int)((float)ibg.getTerritory()[0] * 3.0f * beeModifier.getTerritoryModifier(ibg, 1.0f));
        int n = r = tr >= 64 ? 128 : MathHelper.func_76125_a((int)(16 * ReikaMathLibrary.intpow2((int)2, (int)((tr - 9) / 2))), (int)16, (int)96);
        int r2 = r >= 64 ? 24 : (r >= 32 ? 16 : (r >= 16 ? 12 : 8));
        return new int[]{r, r2};
    }

    public static WorldLocation getLocation(IBeeHousing ibh) {
        ChunkCoordinates c = ibh.getCoordinates();
        return new WorldLocation(ibh.getWorld(), c.field_71574_a, c.field_71572_b, c.field_71573_c);
    }

    public static UUID getOwner(IBeeHousing ibh) {
        GameProfile p = ibh.getOwner();
        return p != null && p.getId() != null ? p.getId() : null;
    }

    public static EntityPlayer getOwnerAsPlayer(IBeeHousing ibh) {
        GameProfile p = ibh.getOwner();
        return p != null && p.getId() != null ? ibh.getWorld().func_152378_a(p.getId()) : null;
    }

    public static boolean isLumenAlvearyEffectSelectedAndActive(IBeeHousing ibh, TileEntityLumenAlveary.AlvearyEffect e) {
        TileEntityLumenAlveary te = ChromaBeeHelpers.getLumenAlvearyController(ibh, ibh.getWorld(), ibh.getCoordinates());
        return te != null && te.isEffectSelectedAndActive(e);
    }

    public static boolean isLumenAlvearyInfSight(IBeeHousing ibh) {
        TileEntityLumenAlveary te = ChromaBeeHelpers.getLumenAlvearyController(ibh, ibh.getWorld(), ibh.getCoordinates());
        return te != null && te.hasInfiniteAwareness();
    }

    public static TileEntityLumenAlveary getLumenAlvearyController(IBeeHousing ibh, World world, ChunkCoordinates cc) {
        if (ibh instanceof IAlvearyComponent) {
            ibh = ((IAlvearyComponent)ibh).getMultiblockLogic().getController();
        }
        if (ibh instanceof IAlvearyController) {
            Coordinate loc = alvearyControllerLocations.get(cc);
            if (loc != null) {
                TileEntity te = loc.getTileEntity((IBlockAccess)world);
                if (te instanceof TileEntityLumenAlveary) {
                    return (TileEntityLumenAlveary)te;
                }
                alvearyControllerLocations.remove(cc);
            }
            for (IMultiblockComponent ib : ((IAlvearyController)ibh).getComponents()) {
                if (!(ib instanceof TileEntityLumenAlveary)) continue;
                TileEntityLumenAlveary te = (TileEntityLumenAlveary)ib;
                alvearyControllerLocations.put(cc, new Coordinate((TileEntity)te));
                return te;
            }
        }
        return null;
    }

    public static boolean checkProgression(World world, IBeeHousing ibh, ProgressStage p) {
        TileEntityLumenAlveary te = ChromaBeeHelpers.getLumenAlvearyController(ibh, world, ibh.getCoordinates());
        if (te != null) {
            return p.isPlayerAtStage(te.getPlacer());
        }
        GameProfile gp = ibh.getOwner();
        return gp != null && p.isPlayerAtStage(world, gp.getId());
    }

    public static int[] getEffectiveTerritory(IBeeHousing ibh, ChunkCoordinates c, IBeeGenome ibg, long time) {
        CachedTerritory t = territoryCache.get(c);
        if (t == null || t.territory == null || t.age >= 20) {
            if (t == null) {
                t = new CachedTerritory();
                territoryCache.put(c, t);
            }
            t.recalculate(ibg, ibh);
        } else if (time > t.lastTick) {
            t.lastTick = time;
            t.age++;
        }
        return t.territory;
    }

    private static class CachedTerritory {
        private int[] territory;
        private int age;
        private long lastTick;

        private CachedTerritory() {
        }

        private void recalculate(IBeeGenome ibg, IBeeHousing ibh) {
            this.age = 0;
            this.territory = ReikaBeeHelper.getFinalTerritory((IBeeGenome)ibg, (IBeeHousing)ibh);
        }
    }

    private static class EntitySelection {
        private int age;
        private long lastTick;
        private ArrayList<WeakReference<EntityLivingBase>> entityList = new ArrayList();

        private EntitySelection() {
        }

        private void updateList(AxisAlignedBB box, World world, Class ce, IEntitySelector s) {
            this.entityList = new ArrayList();
            for (EntityLivingBase e : world.func_82733_a(ce, box, s)) {
                this.entityList.add(new WeakReference<EntityLivingBase>(e));
            }
            this.age = 0;
        }
    }

    private static class SelectionKey {
        private final int dimension;
        private final ChunkCoordinates location;
        private final Class classType;
        private final IEntitySelector selector;

        private SelectionKey(World world, ChunkCoordinates c, Class ce, IEntitySelector s) {
            this.dimension = world.field_73011_w.field_76574_g;
            this.location = c;
            this.classType = ce;
            this.selector = s;
        }

        public int hashCode() {
            return this.dimension ^ this.location.hashCode() - this.classType.hashCode() ^ (this.selector != null ? this.selector.hashCode() : 0);
        }

        public boolean equals(Object o) {
            if (o instanceof SelectionKey) {
                SelectionKey sk = (SelectionKey)o;
                return sk.dimension == this.dimension && this.classType == sk.classType && (this.selector == sk.selector || this.selector != null && sk.selector != null && this.selector.getClass() == sk.selector.getClass()) && this.location.equals((Object)sk.location);
            }
            return false;
        }
    }

    public static class CompoundConditionalProductProvider
    implements ConditionalProductProvider {
        private Collection<ConditionalProductProvider> list = new ArrayList<ConditionalProductProvider>();
        private Collection<ProductChecks.ProductCondition> extras = new ArrayList<ProductChecks.ProductCondition>();

        public void add(ConditionalProductProvider p) {
            this.list.add(p);
        }

        public void addGeneral(ProductChecks.ProductCondition c) {
            this.extras.add(c);
        }

        @Override
        public ItemHashMap<ProductChecks.ProductCondition> getConditions() {
            ItemHashMap map = new ItemHashMap();
            for (ConditionalProductProvider p : this.list) {
                map.putAll(p.getConditions());
            }
            return map;
        }

        @Override
        public ArrayList<String> getGeneralRequirements() {
            ArrayList<String> li = new ArrayList<String>();
            for (ConditionalProductProvider p : this.list) {
                li.addAll(p.getGeneralRequirements());
            }
            for (ProductChecks.ProductCondition c : this.extras) {
                li.add(c.getDescription());
            }
            return li;
        }

        @Override
        public void sendStatusInfo(World world, int x, int y, int z, StatusLogger log, IBeeGenome ibg, IBeeHousing ibh) {
            for (ConditionalProductProvider conditionalProductProvider : this.list) {
                conditionalProductProvider.sendStatusInfo(world, x, y, z, log, ibg, ibh);
            }
            for (ProductChecks.ProductCondition productCondition : this.extras) {
                log.addStatus(productCondition.getDescription(), productCondition.check(world, x, y, z, ibg, ibh));
            }
        }

        public boolean isEmpty() {
            return this.list.isEmpty() && this.extras.isEmpty();
        }

        public boolean checkGeneral(IBeeGenome ibg, IBeeHousing ibh) {
            ChunkCoordinates cc = ibh.getCoordinates();
            for (ProductChecks.ProductCondition p : this.extras) {
                if (p.check(ibh.getWorld(), cc.field_71574_a, cc.field_71572_b, cc.field_71573_c, ibg, ibh)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface ConditionalProductBee {
        public ConditionalProductProvider getProductProvider();
    }

    public static interface ConditionalProductProvider {
        public ItemHashMap<ProductChecks.ProductCondition> getConditions();

        public ArrayList<String> getGeneralRequirements();

        public void sendStatusInfo(World var1, int var2, int var3, int var4, StatusLogger var5, IBeeGenome var6, IBeeHousing var7);
    }
}

