/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Auxiliary.ChromaDescriptions;
import Reika.ChromatiCraft.Auxiliary.Structure.RainbowTreeBlueprint;
import Reika.ChromatiCraft.Block.Dye.BlockDyeLeaf;
import Reika.ChromatiCraft.Block.Dye.BlockDyeSapling;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.ModInterface.Bees.DyeTreeTypes;
import Reika.ChromatiCraft.ModInterface.Bees.EffectAlleles;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.RainbowTreeGenerator;
import Reika.ChromatiCraft.World.TreeShaper;
import Reika.DragonAPI.IO.DirectResourceManager;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Interfaces.Registry.TreeType;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaDyeHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.ButterflyAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.ButterflySpecies;
import Reika.DragonAPI.ModInteract.Bees.TreeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.TreeSpecies;
import Reika.DragonAPI.ModInteract.Bees.TreeTraits;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumFruitFamily;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.world.ITreeGenData;
import java.awt.Color;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;

public class ChromaTrees {
    static EffectAlleles.RainbowEffect rainbowEffect;
    static TreeSpecies.TreeBranch dyeBranch;
    static ButterflySpecies.ButterflyBranch dyeFlyBranch;
    private static TreeSpecies rainbowTree;
    private static TreeSpecies[] dyeTrees;
    private static TreeSpecies[] hybridDyeTrees;
    private static ButterflySpecies[] butterflies;
    private static ButterflySpecies rainbowButterfly;
    private static ButterflyAlleleRegistry.Fertility superFertility;
    private static ButterflyAlleleRegistry.Life superLife;
    private static final IAlleleFruit[] berryFruit;
    private static final IFruitFamily berryFamily;

    public static void register() {
        dyeBranch = new TreeSpecies.TreeBranch("branch.ccdye", "Dye", "Pigmentum", "These leaves shimmer one or more colors, and seem to be associated with crystal energy.");
        rainbowEffect = new EffectAlleles.RainbowEffect();
        superFertility = ButterflyAlleleRegistry.Fertility.createNewFromBee((BeeAlleleRegistry.Fertility)CrystalBees.getSuperFertility());
        superLife = ButterflyAlleleRegistry.Life.createNewFromBee((BeeAlleleRegistry.Life)CrystalBees.getSuperLife());
        for (int i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement color = CrystalElement.elements[i];
            ChromaTrees.berryFruit[i] = new BerryFruit(color);
            DyeTree tree = new DyeTree(color, DyeTreeTypes.list[i].traits);
            tree.register();
            ITree ii = tree.constructIndividual();
            AlleleManager.ersatzSaplings.put(ChromaBlocks.DECAY.getStackOf(color), ii);
            AlleleManager.ersatzSpecimen.put(ChromaBlocks.DECAY.getStackOf(color), ii);
            AlleleManager.ersatzSaplings.put(ChromaBlocks.DYESAPLING.getStackOf(color), ii);
            AlleleManager.ersatzSpecimen.put(ChromaBlocks.DYESAPLING.getStackOf(color), ii);
            ChromaTrees.dyeTrees[i] = tree;
            DyeButterfly fly = new DyeButterfly(color);
            fly.register();
            ChromaTrees.butterflies[i] = fly;
            HybridDyeTree tree2 = new HybridDyeTree(color, ChromaTrees.getHybridParents(color));
            tree2.register();
            ChromaTrees.hybridDyeTrees[i] = tree2;
        }
        rainbowTree = new RainbowTree();
        rainbowTree.register();
        ITree tree = rainbowTree.constructIndividual();
        AlleleManager.ersatzSaplings.put(ChromaBlocks.RAINBOWLEAF.getStackOfMetadata(0), tree);
        AlleleManager.ersatzSpecimen.put(ChromaBlocks.RAINBOWLEAF.getStackOfMetadata(0), tree);
        AlleleManager.ersatzSaplings.put(ChromaBlocks.RAINBOWSAPLING.getStackOf(), tree);
        AlleleManager.ersatzSpecimen.put(ChromaBlocks.RAINBOWSAPLING.getStackOf(), tree);
        rainbowButterfly = new RainbowButterfly();
        rainbowButterfly.register();
    }

    public static TreeSpecies getRainbowTree() {
        return rainbowTree;
    }

    public static TreeSpecies getDyeTree(CrystalElement e, boolean hybrid) {
        TreeSpecies[] arr = hybrid ? hybridDyeTrees : dyeTrees;
        return arr[e.ordinal()];
    }

    public static boolean isDyeTree(IAlleleTreeSpecies ie) {
        return ie instanceof DyeTreeBase;
    }

    public static ButterflySpecies getRainbowButterfly() {
        return rainbowButterfly;
    }

    public static ButterflySpecies getDyeButterfly(CrystalElement e) {
        return butterflies[e.ordinal()];
    }

    private static String[] getHybridParents(CrystalElement color) {
        switch (color) {
            case BLACK: {
                return new String[]{"forestry.treeDate"};
            }
            case RED: {
                return new String[]{"extratrees.species.redmaple", "forestry.treeBaobab"};
            }
            case GREEN: {
                return new String[]{"forestry.treeBalsa"};
            }
            case BROWN: {
                return new String[]{"forestry.treeChestnut"};
            }
            case BLUE: {
                return new String[]{"forestry.treeWillow"};
            }
            case PURPLE: {
                return new String[]{"forestry.treePlum"};
            }
            case CYAN: {
                return new String[]{"forestry.treeMahoe"};
            }
            case LIGHTGRAY: {
                return new String[]{"forestry.treePoplar"};
            }
            case GRAY: {
                return new String[]{"extratrees.species.locust", "forestry.treeZebrawood"};
            }
            case PINK: {
                return new String[]{"forestry.treeCherry"};
            }
            case LIME: {
                return new String[]{"forestry.treeSipiri"};
            }
            case YELLOW: {
                return new String[]{"forestry.treeLemon"};
            }
            case LIGHTBLUE: {
                return new String[]{"forestry.treeWillow"};
            }
            case MAGENTA: {
                return new String[]{"forestry.treeBalsa"};
            }
            case ORANGE: {
                return new String[]{"forestry.treeSequioa"};
            }
            case WHITE: {
                return new String[]{"forestry.treeBalsa"};
            }
        }
        return new String[0];
    }

    static {
        dyeTrees = new TreeSpecies[16];
        hybridDyeTrees = new TreeSpecies[16];
        butterflies = new ButterflySpecies[16];
        berryFruit = new IAlleleFruit[16];
        berryFamily = new IFruitFamily(){

            public String getUID() {
                return "chromaberry";
            }

            public String getName() {
                return "Chroma Berries";
            }

            public String getScientific() {
                return "pigmentum elementum";
            }

            public String getDescription() {
                return "Chroma Berries";
            }
        };
    }

    private static class RainbowButterfly
    extends ChromaButterflySpecies {
        private RainbowButterfly() {
            super("Shimmering Leaflet", "chroma.rainbowfly", "Pigmentum Pluralis");
        }

        public float getRarity() {
            return 0.75f;
        }

        public String getDescription() {
            return "Shining every color of the spectrum, there is clearly something special about this butterfly.";
        }

        @Override
        protected String getTextureName() {
            return "rainbow";
        }

        public int getMetabolism() {
            return 2;
        }

        public int getTemperatureTolerance() {
            return 0;
        }

        public int getHumidityTolerance() {
            return 0;
        }

        public BeeAlleleRegistry.Tolerance getHumidityToleranceDir() {
            return BeeAlleleRegistry.Tolerance.NONE;
        }

        public BeeAlleleRegistry.Tolerance getTemperatureToleranceDir() {
            return BeeAlleleRegistry.Tolerance.NONE;
        }

        public ButterflyAlleleRegistry.Speeds getSpeed() {
            return ButterflyAlleleRegistry.Speeds.NORMAL;
        }

        public ButterflyAlleleRegistry.Size getSize() {
            return ButterflyAlleleRegistry.Size.LARGER;
        }

        public ButterflyAlleleRegistry.Fertility getFertility() {
            return ButterflyAlleleRegistry.Fertility.HIGH;
        }

        public ButterflyAlleleRegistry.Life getLifespan() {
            return ButterflyAlleleRegistry.Life.SHORT;
        }
    }

    private static class DyeButterfly
    extends ChromaButterflySpecies {
        private final CrystalElement color;

        private DyeButterfly(CrystalElement e) {
            super(e.displayName + " Dye Leaflet", "chroma.dyefly" + e.name().toLowerCase(Locale.ENGLISH), "Pigmentum " + e.displayName);
            this.color = e;
        }

        public boolean isFireproof() {
            return this.color == CrystalElement.ORANGE;
        }

        public boolean isTolerantFlyer() {
            return this.color == CrystalElement.CYAN;
        }

        public boolean isNocturnal() {
            return this.color == CrystalElement.BLUE;
        }

        public float getRarity() {
            return 0.4f;
        }

        public String getDescription() {
            return "Vibrantly glowing " + ReikaDyeHelper.dyes[this.color.ordinal()].colorName + ", this butterfly seems to have adapted itself to " + this.color.displayName + ".";
        }

        @Override
        protected String getTextureName() {
            return this.color.name();
        }

        public int getMetabolism() {
            if (this.color == CrystalElement.LIGHTBLUE) {
                return 5;
            }
            if (this.color == CrystalElement.LIGHTGRAY) {
                return 1;
            }
            return 3;
        }

        public int getTemperatureTolerance() {
            if (this.color == CrystalElement.GRAY) {
                return 3;
            }
            return 0;
        }

        public int getHumidityTolerance() {
            if (this.color == CrystalElement.GRAY) {
                return 3;
            }
            return 0;
        }

        public BeeAlleleRegistry.Tolerance getHumidityToleranceDir() {
            if (this.color == CrystalElement.GRAY) {
                return BeeAlleleRegistry.Tolerance.BOTH;
            }
            return BeeAlleleRegistry.Tolerance.NONE;
        }

        public BeeAlleleRegistry.Tolerance getTemperatureToleranceDir() {
            if (this.color == CrystalElement.GRAY) {
                return BeeAlleleRegistry.Tolerance.BOTH;
            }
            return BeeAlleleRegistry.Tolerance.NONE;
        }

        public ButterflyAlleleRegistry.Speeds getSpeed() {
            if (this.color == CrystalElement.LIME) {
                return ButterflyAlleleRegistry.Speeds.FASTEST;
            }
            return ButterflyAlleleRegistry.Speeds.NORMAL;
        }

        public ButterflyAlleleRegistry.Size getSize() {
            return ButterflyAlleleRegistry.Size.AVERAGE;
        }

        public ButterflyAlleleRegistry.Fertility getFertility() {
            if (this.color == CrystalElement.MAGENTA) {
                return superFertility;
            }
            return ButterflyAlleleRegistry.Fertility.NORMAL;
        }

        public ButterflyAlleleRegistry.Life getLifespan() {
            if (this.color == CrystalElement.RED) {
                return superLife;
            }
            return ButterflyAlleleRegistry.Life.NORMAL;
        }
    }

    private static abstract class ChromaButterflySpecies
    extends ButterflySpecies.BasicButterflySpecies {
        private ChromaButterflySpecies(String name, String uid, String sci) {
            super(name, uid, sci, "Reika", (IClassification)dyeFlyBranch);
        }

        public final EnumSet<BiomeDictionary.Type> getSpawnBiomes() {
            return EnumSet.of(BiomeDictionary.Type.MAGICAL);
        }

        public final boolean strictSpawnMatch() {
            return false;
        }

        public boolean isDominant() {
            return false;
        }

        public final EnumTemperature getTemperature() {
            return EnumTemperature.NORMAL;
        }

        public final EnumHumidity getHumidity() {
            return EnumHumidity.NORMAL;
        }

        public float getFlightDistance() {
            return 0.0f;
        }

        public ButterflyAlleleRegistry.Territory getTerritorySize() {
            return ButterflyAlleleRegistry.Territory.DEFAULT;
        }

        @SideOnly(value=Side.CLIENT)
        public final String getEntityTexture() {
            return DirectResourceManager.getResource((String)("Reika/ChromatiCraft/Textures/Butterflies/" + this.getTextureName().toLowerCase(Locale.ENGLISH) + ".png")).toString();
        }

        protected abstract String getTextureName();
    }

    private static class BerryProvider
    implements IFruitProvider,
    TreeSpecies.NoLocaleDescriptionFruit {
        private final CrystalElement color;

        private BerryProvider(CrystalElement e) {
            this.color = e;
        }

        public IFruitFamily getFamily() {
            return berryFamily;
        }

        public int getColour(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime) {
            float f = (float)ripeningTime / (float)this.getRipeningPeriod();
            int c = this.color.getColor();
            if ((double)f <= 0.625) {
                return 0xFFFFFF;
            }
            if (f >= 1.0f) {
                return c;
            }
            return ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)((f - 0.625f) / 0.375f));
        }

        public boolean markAsFruitLeaf(ITreeGenome genome, World world, int x, int y, int z) {
            return true;
        }

        public int getRipeningPeriod() {
            return 5;
        }

        public ItemStack[] getProducts() {
            return new ItemStack[]{ChromaItems.BERRY.getStackOf(this.color)};
        }

        public ItemStack[] getSpecialty() {
            return new ItemStack[0];
        }

        public ItemStack[] getFruits(ITreeGenome genome, World world, int x, int y, int z, int ripeningTime) {
            float f = (float)ripeningTime / (float)this.getRipeningPeriod();
            if (f >= 1.0f) {
                f = (float)((double)f + 0.05);
            }
            double fnum = Math.min(12.0, Math.pow(f, 2.0) + (double)ReikaRandomHelper.getRandomBetween((int)0, (int)5));
            int num = 0;
            while (fnum > 0.0) {
                if (fnum >= 1.0) {
                    ++num;
                    fnum -= 1.0;
                    continue;
                }
                if (ReikaRandomHelper.doWithChance((double)fnum)) {
                    ++num;
                }
                fnum = 0.0;
            }
            if (num <= 0) {
                return new ItemStack[0];
            }
            return new ItemStack[]{ReikaItemHelper.getSizedItemStack((ItemStack)ChromaItems.BERRY.getStackOf(this.color), (int)num)};
        }

        public String getDescription() {
            return this.color.displayName;
        }

        public String getDirectDescription() {
            return this.color.displayName + " Chroma Berries";
        }

        public short getIconIndex(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime, boolean fancy) {
            return 1000;
        }

        public boolean requiresFruitBlocks() {
            return false;
        }

        public boolean trySpawnFruitBlock(ITreeGenome genome, World world, int x, int y, int z) {
            return false;
        }

        public void registerIcons(IIconRegister register) {
        }
    }

    private static class BerryFruit
    implements IAlleleFruit {
        private final CrystalElement color;
        private final IFruitProvider fruit;

        private BerryFruit(CrystalElement e) {
            this.color = e;
            this.fruit = new BerryProvider(e);
            AlleleManager.alleleRegistry.registerAllele((IAllele)this, new IChromosomeType[]{EnumTreeChromosome.FRUITS});
        }

        public String getUID() {
            return "fruit.chromaberry." + this.color.name().toLowerCase(Locale.ENGLISH);
        }

        public boolean isDominant() {
            return false;
        }

        public String getName() {
            return this.color.displayName + " Berries";
        }

        public String getUnlocalizedName() {
            return this.getName();
        }

        public IFruitProvider getProvider() {
            return this.fruit;
        }
    }

    private static abstract class DyeTreeBase
    extends TreeSpecies.TraitsTree {
        public final CrystalElement color;

        protected DyeTreeBase(CrystalElement e, String name, String uid, String latinName, TreeTraits traits) {
            super(name, uid, latinName, "Reika", (IClassification)dyeBranch, traits);
            this.color = e;
            this.addSuitableFruit((IFruitFamily)EnumFruitFamily.POMES);
        }

        protected final String getIconMod(boolean pollen) {
            return "chromaticraft";
        }

        protected final String getIconFolderRoot(boolean pollen) {
            return "forestry/trees";
        }

        protected final String getSaplingIconName() {
            return "sapling";
        }

        public final int getLeafColour(boolean pollinated) {
            return BlockDyeLeaf.getColor(this.color.ordinal(), false);
        }

        public final IIcon getLeafIcon(boolean pollinated, boolean fancy) {
            return ChromaBlocks.DYELEAF.getBlockInstance().func_149691_a(0, 0);
        }

        public int getGermlingColour(EnumGermlingType type, int renderPass) {
            return this.getLeafColour(false);
        }

        public String getDescription() {
            return ChromaDescriptions.getHoverText("dyeleaf");
        }

        public final int getIconColour(int renderPass) {
            return this.getLeafColour(false);
        }

        public final boolean isDominant() {
            return false;
        }

        protected final BlockKey getLogBlock(ITreeGenome genes, World world, int x, int y, int z, Random rand, ITreeGenData data) {
            return ReikaTreeHelper.OAK.getLog();
        }

        protected final boolean generate(World world, int x, int y, int z, Random rand, ITreeGenData data) {
            if (BlockDyeSapling.canGrowAt(world, x, y, z, false)) {
                this.placeTree(world, x, y, z, null, data);
                return true;
            }
            return false;
        }

        protected abstract void placeTree(World var1, int var2, int var3, int var4, GameProfile var5, ITreeGenData var6);

        public final IAlleleFruit getFruitAllele() {
            return berryFruit[this.color.ordinal()];
        }

        public final IAlleleLeafEffect getEffectAllele() {
            return this.getNoEffect();
        }

        public final IAlleleGrowth getGrowthAllele() {
            return this.getLightGrowth();
        }

        public final boolean isSecret() {
            return false;
        }

        public final boolean isCounted() {
            return true;
        }
    }

    private static class DyeTree
    extends DyeTreeBase {
        protected DyeTree(CrystalElement e, TreeTraits t) {
            super(e, e.displayName + " Dye", "chroma.dye" + e.name().toLowerCase(Locale.ENGLISH), "Pigmentum " + e.displayName, t);
        }

        @Override
        protected void placeTree(World world, int x, int y, int z, GameProfile owner, ITreeGenData data) {
            TreeShaper.getInstance().generateRandomWeightedTree(world, x, y, z, this.rand, ReikaDyeHelper.dyes[this.color.ordinal()], true, 0.0f, 0.0f);
        }

        public boolean hasEffect() {
            return false;
        }
    }

    private static class HybridDyeTree
    extends DyeTreeBase {
        private final String[] breedParents;

        public HybridDyeTree(CrystalElement e, String ... other) {
            super(e, e.displayName + " Hybrid", "chroma.hybrid" + e.name().toLowerCase(Locale.ENGLISH), "Pigmentum Hybridus " + e.displayName, DyeTreeTypes.list[e.ordinal()].traitsHybrid);
            this.breedParents = other;
        }

        protected void onRegister() {
            for (String s : this.breedParents) {
                IAllele ia = AlleleManager.alleleRegistry.getAllele(s);
                if (!(ia instanceof IAlleleTreeSpecies)) continue;
                this.addBreeding((IAlleleTreeSpecies)ia, (IAlleleTreeSpecies)dyeTrees[this.color.ordinal()], 5);
                break;
            }
        }

        public boolean hasEffect() {
            return true;
        }

        @Override
        protected void placeTree(World world, int x, int y, int z, GameProfile owner, ITreeGenData data) {
            int h0 = 2 + this.rand.nextInt(3);
            int h = h0 + MathHelper.func_76123_f((float)(data.getHeightModifier() * (float)(5 + this.rand.nextInt(7))));
            for (int i = 1; i <= h; ++i) {
                if (world.func_147439_a(x, y + i, z) == Blocks.field_150350_a) continue;
                h = i;
                break;
            }
            while (h > 2 && world.func_147439_a(x, y + h + 4, z) != Blocks.field_150350_a) {
                --h;
            }
            if (h <= 3) {
                return;
            }
            h0 = Math.min(h0, h / 2);
            int w = 0;
            int maxw = 2 + data.getGirth(world, x, y, z);
            for (int j = 0; j < h; ++j) {
                boolean up;
                int dy = y + j;
                data.setLogBlock(world, x, dy, z, ForgeDirection.UP);
                if (j < h0) continue;
                boolean canUp = w < maxw && h - j - 1 > w;
                boolean canDown = w > 1;
                boolean bl = up = this.rand.nextBoolean() && canUp || !canDown;
                if (!up) {
                    --w;
                }
                int r = ++w;
                for (int i = -r; i <= r; ++i) {
                    for (int k = -r; k <= r; ++k) {
                        int dz;
                        int dx;
                        if (i == 0 && k == 0 || Math.abs(i) + Math.abs(k) > w + 1 || !world.func_147439_a(dx = x + i, dy, dz = z + k).canBeReplacedByLeaves((IBlockAccess)world, dx, dy, dz)) continue;
                        data.setLeaves(world, owner, dx, dy, dz);
                    }
                }
            }
            for (int i = -1; i <= 1; ++i) {
                for (int k = -1; k <= 1; ++k) {
                    int dz;
                    int dx;
                    if (i != 0 && k != 0 || !world.func_147439_a(dx = x + i, y + h, dz = z + k).canBeReplacedByLeaves((IBlockAccess)world, dx, y + h, dz)) continue;
                    data.setLeaves(world, owner, dx, y + h, dz);
                }
            }
            if (world.func_147439_a(x, y + h + 1, z).canBeReplacedByLeaves((IBlockAccess)world, x, y + h + 1, z)) {
                data.setLeaves(world, owner, x, y + h + 1, z);
            }
        }
    }

    private static class RainbowTree
    extends TreeSpecies.BasicTreeSpecies {
        protected RainbowTree() {
            super("Rainbow", "chroma.rainbow", "Pigmentum Pluralis", "Reika", (IClassification)dyeBranch);
            this.addSuitableFruit((IFruitFamily)EnumFruitFamily.POMES);
            this.addSuitableFruit((IFruitFamily)EnumFruitFamily.NUX);
            this.addSuitableFruit((IFruitFamily)EnumFruitFamily.PRUNES);
        }

        protected final String getIconMod(boolean pollen) {
            return "chromaticraft";
        }

        protected final String getIconFolderRoot(boolean pollen) {
            return "forestry/trees";
        }

        protected final String getSaplingIconName() {
            return "sapling";
        }

        public String getDescription() {
            return ChromaDescriptions.getHoverText("rainbowleaf");
        }

        public boolean hasEffect() {
            return true;
        }

        public boolean isDominant() {
            return false;
        }

        public IAlleleLeafEffect getEffectAllele() {
            return rainbowEffect;
        }

        public TreeAlleleRegistry.Yield getYield() {
            return TreeAlleleRegistry.Yield.LOWER;
        }

        public TreeAlleleRegistry.Heights getHeight() {
            return TreeAlleleRegistry.Heights.LARGER;
        }

        public int getGirth() {
            return 2;
        }

        public TreeAlleleRegistry.Sappiness getSappiness() {
            return TreeAlleleRegistry.Sappiness.LOW;
        }

        public TreeAlleleRegistry.Maturation getMaturation() {
            return TreeAlleleRegistry.Maturation.SLOW;
        }

        public TreeAlleleRegistry.Saplings getSaplingRate() {
            return TreeAlleleRegistry.Saplings.LOWEST;
        }

        public BeeAlleleRegistry.Territory getTerritorySize() {
            return BeeAlleleRegistry.Territory.LARGER;
        }

        public int getLeafColour(boolean pollinated) {
            return Color.HSBtoRGB((float)((int)(System.currentTimeMillis() / 10L % 360L)) / 360.0f, 0.7f, 1.0f);
        }

        public IIcon getLeafIcon(boolean pollinated, boolean fancy) {
            return ChromaBlocks.RAINBOWLEAF.getBlockInstance().func_149691_a(0, 0);
        }

        public int getGermlingColour(EnumGermlingType type, int renderPass) {
            return CrystalBees.getRainbowBee().getOutlineColor();
        }

        public int getIconColour(int renderPass) {
            return this.getLeafColour(false);
        }

        protected BlockKey getLogBlock(ITreeGenome genes, World world, int x, int y, int z, Random rand, ITreeGenData data) {
            return ReikaTreeHelper.OAK.getLog();
        }

        protected boolean generate(World world, int x, int y, int z, Random rand, ITreeGenData data) {
            boolean big;
            boolean bl = big = data.getGirth(world, x, y, z) >= 2 && (double)data.getHeightModifier() >= 1.5;
            if (big) {
                if (RainbowTreeGenerator.getInstance().checkRainbowTreeSpace(world, x, y, z)) {
                    FilledBlockArray arr = RainbowTreeBlueprint.getBlueprint(world, x - 5, y - 2, z - 5, (TreeType)ReikaTreeHelper.OAK);
                    for (Coordinate c : arr.keySet()) {
                        BlockKey bk = arr.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord);
                        if (bk.blockID == Blocks.field_150364_r) {
                            ForgeDirection dir = ForgeDirection.UP;
                            if (bk.metadata == 4) {
                                dir = ForgeDirection.EAST;
                            } else if (bk.metadata == 8) {
                                dir = ForgeDirection.SOUTH;
                            }
                            data.setLogBlock(world, c.xCoord, c.yCoord, c.zCoord, dir);
                            continue;
                        }
                        data.setLeaves(world, null, c.xCoord, c.yCoord, c.zCoord);
                    }
                    return true;
                }
                return false;
            }
            return RainbowTreeGenerator.getInstance().tryGenerateSmallRainbowTree(world, x, y, z, rand, data.getHeightModifier());
        }
    }
}

