/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Block.Dimension.BlockDimensionDeco;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredPlant;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.ModInterface.Bees.ChromaBeeHelpers;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBeeTypes;
import Reika.ChromatiCraft.ModInterface.Bees.EffectAlleles;
import Reika.ChromatiCraft.ModInterface.Bees.FlowerAlleles;
import Reika.ChromatiCraft.ModInterface.Bees.HiveGenerator;
import Reika.ChromatiCraft.ModInterface.Bees.ProductChecks;
import Reika.ChromatiCraft.ModInterface.ItemColoredModInteract;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.ChromaOptions;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Base.DragonAPIMod;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.GUI.StatusLogger;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.IO.ReikaChatHelper;
import Reika.DragonAPI.Libraries.Java.ReikaStringParser;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.BeeSpecies;
import Reika.DragonAPI.ModInteract.Bees.BeeTraits;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ForestryHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.OreBerryBushHandler;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorState;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class CrystalBees {
    static final String LOGGER_TAG = "CrystalBees";
    static final Random rand = new Random();
    static RawBee feedstock;
    static BasicBee protective;
    static BasicBee luminous;
    static BasicBee hostile;
    static BasicBee magical;
    static BasicBee sparkle;
    static BasicBee crystal;
    static BasicBee purity;
    static PrecursorBee tower;
    static PrecursorBee ua;
    static PrecursorBee precursor;
    static AdvancedBee chroma;
    static AdvancedBee lumen;
    static AdvancedBee aura;
    static AdvancedBee multi;
    static BeeAlleleRegistry.Fertility superFertility;
    static BeeAlleleRegistry.Territory superTerritory;
    static BeeAlleleRegistry.Speeds superSpeed;
    static BeeAlleleRegistry.Flowering superFlowering;
    static BeeAlleleRegistry.Fertility noFertility;
    static BeeAlleleRegistry.Territory noTerritory;
    static BeeAlleleRegistry.Speeds noWork;
    static BeeAlleleRegistry.Flowering noFlowering;
    static BeeAlleleRegistry.Life superLife;
    static BeeAlleleRegistry.Life blinkLife;
    static BeeSpecies.BeeBranch crystalBranch;
    static BeeSpecies.BeeBranch precursorBranch;
    static BeeSpecies.BeeBranch advancedCrystalBranch;
    static FlowerAlleles.MultiAllele multiFlower;
    static EffectAlleles.PolychromaEffect multiEffect;
    static EffectAlleles.ChromaEffect chromaEffect;
    static EffectAlleles.RechargeEffect rechargeEffect;
    static EffectAlleles.SparklifyEffect sparkleEffect;
    static FlowerAlleles.MetaAlloyAllele metaFlower;
    static EffectAlleles.ArtefactEffect uaEffect;
    static EffectAlleles.PrecursorEffect precursorEffect;
    private static ColorBlendList chromaColor;
    private static ColorBlendList auraColor;
    private static ColorBlendList lumenColor;
    private static ColorBlendList sparkleColor;
    private static ColorBlendList[] crystalColors;
    private static ColorBlendList multiColor;
    private static ColorBlendList towerColor;
    private static ColorBlendList uaColor;
    private static ColorBlendList precursorColor;
    static final IErrorState conditionalsUnavailable;
    static final EnumMap<CrystalElement, CrystalBee> beeMap;
    static final EnumMap<CrystalElement, EffectAlleles.CrystalEffect> effectMap;
    static final EnumMap<CrystalElement, FlowerAlleles.CrystalAllele> flowerMap;
    static final EnumMap<CrystalElement, ItemHashMap<ProductChecks.ProductCondition>> productConditions;
    static final Collection<ChromaBeeHelpers.ConditionalProductBee> conditionalBees;
    private static final ArrayList<BeeSpecies> basicBees;
    private static final ArrayList<BeeSpecies> advancedBees;

    @SideOnly(value=Side.CLIENT)
    private static void loadColorData() {
        chromaColor = new ColorBlendList(5.0f, ChromaFX.getChromaColorTiles());
        auraColor = new ColorBlendList(18.0f, new int[]{0xFFFF00, 0xFFFFFF, 0, 0x8000FF, 0xFF0000});
        lumenColor = new ColorBlendList(10.0f, new int[]{255, 0xFFFFFF, 0x22AAFF});
        crystalColors = new ColorBlendList[16];
        multiColor = new ColorBlendList(20.0f);
        sparkleColor = new ColorBlendList(6.0f, new int[]{0xFFFFFF, 13546239, 0xFFFFFF, 11718399});
        uaColor = new ColorBlendList(10.0f, new int[]{8029337, 8012629, 8029337, 8029337, 8029337, 8029337, 8151669, 8012629, 12342314, 0xFFFF7F, 12418874, 8029337, 8029337, 8012629, 12342314, 0xFFFF7F, 0xFFFF00, 11992832, 0xF1FF00, 11992832, 15531776, 11202304, 8364106, 8029337});
        precursorColor = new ColorBlendList(25.0f, new int[]{0xFFFFFF, 0x404040, 0x22AAFF, 0x404040, 14322943, 0x404040, 16773549, 0x404040});
        towerColor = new ColorBlendList(15.0f, new int[]{7201279, 7201279, 0xFFFFFF, 7201160, 7201160, 0xFFFFFF});
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            int c = e.getColor();
            int c1 = ReikaColorAPI.mixColors((int)c, (int)0, (float)0.5f);
            int c2 = ReikaColorAPI.mixColors((int)c, (int)0xFFFFFF, (float)0.5f);
            CrystalBees.crystalColors[i] = new ColorBlendList(40.0f, new int[]{c, c, c, c1, c, c, c, c2});
            multiColor.addColor(c);
        }
    }

    public static void register() {
        int i;
        superFertility = BeeAlleleRegistry.Fertility.createNew((String)"multiply", (int)8, (boolean)false);
        superSpeed = BeeAlleleRegistry.Speeds.createNew((String)"accelerated", (float)4.0f, (boolean)false);
        superFlowering = BeeAlleleRegistry.Flowering.createNew((String)"naturalistic", (int)240, (boolean)false);
        superTerritory = BeeAlleleRegistry.Territory.createNew((String)"exploratory", (int)32, (int)16, (boolean)false);
        noFertility = BeeAlleleRegistry.Fertility.createNew((String)"sterile", (int)0, (boolean)false);
        noWork = BeeAlleleRegistry.Speeds.createNew((String)"unproductive", (float)0.0f, (boolean)false);
        noFlowering = BeeAlleleRegistry.Flowering.createNew((String)"nonpollinating", (int)0, (boolean)false);
        noTerritory = BeeAlleleRegistry.Territory.createNew((String)"lethargic", (int)1, (int)1, (boolean)false);
        superLife = BeeAlleleRegistry.Life.createNew((String)"eon", (int)600, (boolean)false);
        blinkLife = BeeAlleleRegistry.Life.createNew((String)"blink", (int)2, (boolean)false);
        crystalBranch = new BeeSpecies.BeeBranch("branch.cccrystal", "Crystal", "Vitreus", "These bees can sense and sometimes field the crystal elements.");
        advancedCrystalBranch = new BeeSpecies.BeeBranch("branch.ccadvcrystal", "PolyCrystal", "Vitreus Corona", "These bees are masters of elemental manipulation and harnessing.");
        precursorBranch = new BeeSpecies.BeeBranch("branch.ccprecursor", "Forerunner", "Praeministri", "Something feels strange about these bees, almost as if they are a link to the past, or some long-lost knowledge.");
        feedstock = new RawBee("Raw", "Imperitus Materia", 0x888888);
        feedstock.register();
        for (i = 0; i < CrystalElement.elements.length; ++i) {
            CrystalElement color = CrystalElement.elements[i];
            BeeTraits traits = CrystalBeeTypes.list[i].getTraits();
            CrystalBee bee = new CrystalBee(color, traits);
            EffectAlleles.CrystalEffect eff = new EffectAlleles.CrystalEffect(color);
            FlowerAlleles.CrystalAllele flw = new FlowerAlleles.CrystalAllele(color);
            effectMap.put(color, eff);
            flowerMap.put(color, flw);
            bee.register();
            beeMap.put(color, bee);
        }
        multiFlower = new FlowerAlleles.MultiAllele();
        multiEffect = new EffectAlleles.PolychromaEffect();
        rechargeEffect = new EffectAlleles.RechargeEffect();
        chromaEffect = new EffectAlleles.ChromaEffect();
        sparkleEffect = new EffectAlleles.SparklifyEffect();
        metaFlower = new FlowerAlleles.MetaAlloyAllele();
        uaEffect = new EffectAlleles.ArtefactEffect();
        precursorEffect = new EffectAlleles.PrecursorEffect();
        ForestryAPI.errorStateRegistry.registerErrorState(conditionalsUnavailable);
        crystal = new BasicBee("Crystalline", "Vitreus Crystallum", BeeAlleleRegistry.Speeds.NORMAL, BeeAlleleRegistry.Life.SHORTEST, BeeAlleleRegistry.Flowering.SLOWEST, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.DEFAULT, 4630527, crystalBranch);
        purity = new BasicBee("Pure", "Purus Mundi", BeeAlleleRegistry.Speeds.SLOWER, BeeAlleleRegistry.Life.NORMAL, BeeAlleleRegistry.Flowering.AVERAGE, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, 0xFFFFFF, crystalBranch);
        protective = new BasicBee("Protective", "Vitreus Auxilium", BeeAlleleRegistry.Speeds.SLOWER, BeeAlleleRegistry.Life.ELONGATED, BeeAlleleRegistry.Flowering.SLOWER, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, 16734611, crystalBranch);
        luminous = new BasicBee("Luminous", "Vitreus Lumens", BeeAlleleRegistry.Speeds.SLOW, BeeAlleleRegistry.Life.SHORTER, BeeAlleleRegistry.Flowering.SLOWER, BeeAlleleRegistry.Fertility.HIGH, BeeAlleleRegistry.Territory.DEFAULT, 12250111, crystalBranch);
        hostile = new BasicBee("Hostile", "Vitreus Inimicus", BeeAlleleRegistry.Speeds.SLOWEST, BeeAlleleRegistry.Life.SHORT, BeeAlleleRegistry.Flowering.SLOW, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.DEFAULT, 16738816, crystalBranch);
        magical = new BasicBee("Proximal", "Vitreus Proxima", BeeAlleleRegistry.Speeds.NORMAL, BeeAlleleRegistry.Life.NORMAL, BeeAlleleRegistry.Flowering.SLOW, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, 13975039, crystalBranch);
        sparkle = new SparkleBee("Shimmering", "Vitreus Nitidus", BeeAlleleRegistry.Speeds.SLOW, BeeAlleleRegistry.Life.SHORTENED, BeeAlleleRegistry.Flowering.AVERAGE, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, 13546239, crystalBranch);
        tower = new PrecursorBee("Communicative", "Monumentum Vitreus Notitia", BeeAlleleRegistry.Speeds.SLOWER, BeeAlleleRegistry.Life.LONG, BeeAlleleRegistry.Flowering.SLOWEST, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.LARGER, towerColor, EnumTemperature.NORMAL, ProgressStage.TOWER);
        crystal.register();
        purity.register();
        protective.register();
        luminous.register();
        hostile.register();
        magical.register();
        sparkle.register();
        tower.register();
        chroma = (AdvancedBee)new AdvancedBee("Iridescent", "Auram Stellans", BeeAlleleRegistry.Speeds.SLOWER, BeeAlleleRegistry.Life.NORMAL, BeeAlleleRegistry.Flowering.SLOWEST, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, chromaColor, EnumTemperature.COLD, ProgressStage.ALLOY).setEffect(chromaEffect);
        lumen = new AdvancedBee("Luminescent", "Auram Ardens", BeeAlleleRegistry.Speeds.NORMAL, BeeAlleleRegistry.Life.SHORTENED, BeeAlleleRegistry.Flowering.SLOWER, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, lumenColor, EnumTemperature.NORMAL, ProgressStage.DIMENSION);
        aura = (AdvancedBee)new AdvancedBee("Radiant", "Auram Pharus", BeeAlleleRegistry.Speeds.SLOW, BeeAlleleRegistry.Life.LONG, BeeAlleleRegistry.Flowering.SLOW, BeeAlleleRegistry.Fertility.NORMAL, BeeAlleleRegistry.Territory.DEFAULT, auraColor, EnumTemperature.ICY, ProgressStage.CTM).setEffect(rechargeEffect);
        multi = (AdvancedBee)new AdvancedBee("Polychromatic", "Pigmentum Pluralis", BeeAlleleRegistry.Speeds.SLOWEST, BeeAlleleRegistry.Life.ELONGATED, BeeAlleleRegistry.Flowering.AVERAGE, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.DEFAULT, multiColor, EnumTemperature.WARM, ProgressStage.CTM).setEffect(multiEffect);
        precursor = (PrecursorBee)new PrecursorBee("Forerunner", "Populus Antecessoris", BeeAlleleRegistry.Speeds.NORMAL, BeeAlleleRegistry.Life.NORMAL, BeeAlleleRegistry.Flowering.AVERAGE, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.LARGE, precursorColor, EnumTemperature.NORMAL, ProgressStage.TOWER).setEffect(precursorEffect);
        ua = (PrecursorBee)new PrecursorBee("Monumental", "Peritia Incognita", BeeAlleleRegistry.Speeds.SLOWER, BeeAlleleRegistry.Life.SHORTEST, BeeAlleleRegistry.Flowering.SLOWER, BeeAlleleRegistry.Fertility.LOW, BeeAlleleRegistry.Territory.DEFAULT, uaColor, EnumTemperature.COLD, ProgressStage.ARTEFACT).setEffect(uaEffect);
        chroma.register();
        lumen.register();
        aura.register();
        multi.register();
        precursor.register();
        ua.register();
        CrystalBees.addBreeding(CrystalElement.RED, CrystalElement.YELLOW, CrystalElement.ORANGE);
        CrystalBees.addBreeding(CrystalElement.WHITE, CrystalElement.GREEN, CrystalElement.LIME);
        CrystalBees.addBreeding(CrystalElement.RED, CrystalElement.WHITE, CrystalElement.PINK);
        CrystalBees.addBreeding(CrystalElement.RED, CrystalElement.BLUE, CrystalElement.PURPLE);
        CrystalBees.addBreeding(CrystalElement.WHITE, CrystalElement.BLACK, CrystalElement.GRAY);
        CrystalBees.addBreeding(CrystalElement.BLUE, CrystalElement.GREEN, CrystalElement.CYAN);
        CrystalBees.addBreeding(CrystalElement.BLUE, CrystalElement.WHITE, CrystalElement.LIGHTBLUE);
        CrystalBees.addBreeding(CrystalElement.WHITE, CrystalElement.GRAY, CrystalElement.LIGHTGRAY);
        CrystalBees.addBreeding(CrystalElement.PINK, CrystalElement.PURPLE, CrystalElement.MAGENTA);
        CrystalBees.addBreeding((BeeSpecies)purity, (BeeSpecies)crystal, CrystalElement.WHITE);
        CrystalBees.addBreeding((BeeSpecies)magical, (BeeSpecies)crystal, CrystalElement.BLACK);
        CrystalBees.addBreeding((BeeSpecies)protective, (BeeSpecies)crystal, CrystalElement.RED);
        CrystalBees.addBreeding((BeeSpecies)luminous, (BeeSpecies)crystal, CrystalElement.BLUE);
        CrystalBees.addBreeding("Rural", (BeeSpecies)crystal, CrystalElement.BROWN);
        CrystalBees.addBreeding("Industrious", (BeeSpecies)crystal, CrystalElement.YELLOW);
        CrystalBees.addBreeding("Tropical", (BeeSpecies)hostile, CrystalElement.GREEN);
        protective.addBreeding("Heroic", (BeeSpecies)crystal, 10);
        hostile.addBreeding("Demonic", (BeeSpecies)crystal, 10);
        luminous.addBreeding("Ended", (BeeSpecies)purity, 5);
        if (ModList.MAGICBEES.isLoaded()) {
            sparkle.addBreeding("Transmuting", ModList.MAGICBEES, (BeeSpecies)luminous, 8);
        } else {
            sparkle.addBreeding("Exotic", ModList.FORESTRY, (BeeSpecies)luminous, 8);
        }
        if (ModList.MAGICBEES.isLoaded()) {
            magical.addBreeding("Imperial", ModList.FORESTRY, "Arcane", ModList.MAGICBEES, 4);
            ua.addBreeding("Savant", ModList.MAGICBEES, (BeeSpecies)tower, 3);
        } else {
            magical.addBreeding("Imperial", "Wintry", 4);
            ua.addBreeding((BeeSpecies)purity, (BeeSpecies)tower, 2);
        }
        precursor.addBreeding((BeeSpecies)magical, (BeeSpecies)tower, 3);
        chroma.addBreeding(beeMap.get(CrystalElement.PURPLE), beeMap.get(CrystalElement.WHITE), 5);
        lumen.addBreeding(beeMap.get(CrystalElement.BLUE), beeMap.get(CrystalElement.BLACK), 5);
        aura.addBreeding((BeeSpecies)lumen, beeMap.get(CrystalElement.YELLOW), 3);
        multi.addBreeding((BeeSpecies)aura, (BeeSpecies)chroma, 2);
        protective.addSpecialty(new ItemStack(Blocks.field_150343_Z), 2.0f);
        hostile.addSpecialty(new ItemStack(Items.field_151016_H), 4.0f);
        luminous.addSpecialty(new ItemStack(Items.field_151114_aO), 5.0f);
        magical.addSpecialty(ChromaStacks.chromaDust, 5.0f);
        protective.addProduct(ForestryHandler.Combs.HONEY.getItem(), 10.0f);
        hostile.addProduct(ForestryHandler.Combs.HONEY.getItem(), 10.0f);
        luminous.addProduct(ForestryHandler.Combs.HONEY.getItem(), 10.0f);
        sparkle.addProduct(ForestryHandler.Combs.HONEY.getItem(), 10.0f);
        magical.addProduct(ForestryHandler.Combs.HONEY.getItem(), 10.0f);
        crystal.addSpecialty(ChromaStacks.crystalPowder, 5.0f);
        purity.addSpecialty(new ItemStack(Items.field_151073_bk), 1.0f);
        sparkle.addSpecialty(new ItemStack(Items.field_151114_aO), 7.0f);
        sparkle.addSpecialty(new ItemStack(Items.field_151074_bl), 2.0f);
        chroma.addSpecialty(ChromaStacks.iridCrystal, 2.0f);
        CrystalBees.chroma.otherChecks.add(new ProductChecks.IridescentShardCheck());
        aura.addSpecialty(ChromaStacks.lumaDust, 2.0f);
        CrystalBees.lumen.otherChecks.add(new ProductChecks.AreaBlockCheck((BlockCheck)new BlockKey(ChromaBlocks.POWERTREE.getBlockInstance()), 2, 1));
        lumen.addProduct(new ItemStack(Items.field_151114_aO), 15.0f);
        lumen.addSpecialty(ChromaStacks.glowbeans, 4.0f);
        CrystalBees.aura.otherChecks.add(new ProductChecks.AuraLocusCheck());
        if (ModList.MAGICBEES.isLoaded()) {
            tower.addProduct(ReikaItemHelper.lookupItem((String)"MagicBees:comb:8"), 4.0f);
            tower.addProduct(ReikaItemHelper.lookupItem((String)"MagicBees:comb:10"), 4.0f);
            precursor.addProduct(ReikaItemHelper.lookupItem((String)"MagicBees:comb:8"), 10.0f);
            precursor.addProduct(ReikaItemHelper.lookupItem((String)"MagicBees:comb:10"), 10.0f);
        } else {
            tower.addProduct(ForestryHandler.Combs.HONEY.getItem(), 8.0f);
            tower.addProduct(ChromaStacks.crystalPowder, 4.0f);
            precursor.addProduct(ForestryHandler.Combs.HONEY.getItem(), 8.0f);
            precursor.addProduct(ForestryHandler.Combs.MELLOW.getItem(), 4.0f);
        }
        ua.addProduct(ChromaStacks.crystalPowder, 10.0f);
        tower.addSpecialty(new ItemStack(ChromaBlocks.METAALLOYLAMP.getBlockInstance()), 1.0f);
        ua.addSpecialty(ChromaStacks.unknownFragments, 0.25f);
        for (i = 0; i < BlockDimensionDeco.DimDecoTypes.list.length; ++i) {
            precursor.addSpecialty(ChromaItems.DIMGEN.getStackOfMetadata(i), 0.5f);
            if (!BlockDimensionDeco.DimDecoTypes.list[i].canSilkTouch()) continue;
        }
        CrystalBees.precursor.otherChecks.add(new ProductChecks.ProgressionCheck(ProgressStage.DIMENSION));
        ProductChecks.RainbowTreeCheck tree = new ProductChecks.RainbowTreeCheck();
        for (int i2 = 0; i2 < 16; ++i2) {
            CrystalElement e = CrystalElement.elements[i2];
            ItemStack shard = ChromaStacks.getChargedShard(e);
            multi.addSpecialty(shard, 4.0f);
            ItemStack is = ChromaItems.BERRY.getStackOfMetadata(i2);
            multi.addSpecialty(is, 1.25f);
            FlowerAlleles.FlowerProviderMulti.conditions.put(is, (Object)tree);
            FlowerAlleles.FlowerProviderMulti.conditions.put(shard, (Object)new ProductChecks.ChargedShardCheck(e));
        }
        chroma.initConditions();
        lumen.initConditions();
        aura.initConditions();
        multi.initConditions();
        tower.initConditions();
        precursor.initConditions();
        ua.initConditions();
        GameRegistry.registerWorldGenerator((IWorldGenerator)HiveGenerator.instance, (int)-5);
    }

    public static BeeSpecies getElementalBee(CrystalElement e) {
        return beeMap.get(e);
    }

    public static BeeSpecies getCrystalBee() {
        return crystal;
    }

    public static BeeSpecies getPureBee() {
        return purity;
    }

    public static BeeSpecies getTowerBee() {
        return tower;
    }

    public static BeeSpecies getUABee() {
        return ua;
    }

    public static BeeSpecies getPrecursorBee() {
        return precursor;
    }

    public static BeeSpecies getRainbowBee() {
        return multi;
    }

    public static int beeCount() {
        return 16 + basicBees.size() + advancedBees.size();
    }

    public static BeeSpecies getBeeByIndex(int idx) {
        if (idx < basicBees.size()) {
            return basicBees.get(idx);
        }
        if ((idx -= basicBees.size()) < 16) {
            return beeMap.get(CrystalElement.elements[idx]);
        }
        if ((idx -= 16) < advancedBees.size()) {
            return advancedBees.get(idx);
        }
        return null;
    }

    public static ArrayList<String> getBeeDescription(BeeSpecies b) {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(b.getName());
        ret.add("");
        if (b instanceof CrystalBee) {
            CrystalBee cb = (CrystalBee)b;
            ret.add("This bee has one extremely powerful gene.");
        }
        if (b.getClass() == BasicBee.class) {
            ret.add("This bee is a breeding intermediate, not");
            ret.add("particularly valuable on its own.");
            ret.add("");
            ret.add("It may, however, be the first step towards");
            ret.add("something that is.");
        }
        if (b instanceof ChromaBeeHelpers.ConditionalProductBee) {
            ChromaBeeHelpers.ConditionalProductProvider p = ((ChromaBeeHelpers.ConditionalProductBee)b).getProductProvider();
            ret.add("Special Products:");
            ret.add("");
            ret.add("General Conditions:");
            ArrayList<String> li = p.getGeneralRequirements();
            for (String s : li) {
                ret.add(s);
            }
            ItemHashMap<ProductChecks.ProductCondition> map = p.getConditions();
            if (!map.isEmpty()) {
                ret.add("");
                ret.add("Specific Conditions:");
                for (ItemStack is : map.keySet()) {
                    ProductChecks.ProductCondition c = (ProductChecks.ProductCondition)map.get(is);
                    String d = c.getDescription();
                    ArrayList dl = ReikaStringParser.splitStringByNewlines((String)d);
                    if (dl.size() > 1) {
                        ret.add(is.func_82833_r() + ":");
                        for (String in : dl) {
                            ret.add(in);
                        }
                        ret.add("");
                        continue;
                    }
                    ret.add(is.func_82833_r() + ": " + d);
                }
            }
        }
        return ret;
    }

    public static Collection<BeeSpecies> getBasicBees() {
        return Collections.unmodifiableCollection(basicBees);
    }

    public static Collection<BeeSpecies> getAdvancedBees() {
        return Collections.unmodifiableCollection(advancedBees);
    }

    public static Collection<ChromaBeeHelpers.ConditionalProductBee> getConditionalBees() {
        return Collections.unmodifiableCollection(conditionalBees);
    }

    private static final void addBreeding(String in1, BeeSpecies in2, CrystalElement out) {
        CrystalBee cb = beeMap.get(out);
        cb.addBreeding(in1, in2, 8);
    }

    private static final void addBreeding(BeeSpecies in1, BeeSpecies in2, CrystalElement out) {
        CrystalBee cb = beeMap.get(out);
        cb.addBreeding(in1, in2, 8);
    }

    private static final void addBreeding(CrystalElement in1, CrystalElement in2, CrystalElement out) {
        CrystalBee p1 = beeMap.get(in1);
        CrystalBee p2 = beeMap.get(in2);
        CrystalBee cb = beeMap.get(out);
        cb.addBreeding(p1, p2, 8);
    }

    public static BeeAlleleRegistry.Flowering getNoFlowering() {
        return noFlowering;
    }

    public static BeeAlleleRegistry.Flowering getSuperFlowering() {
        return superFlowering;
    }

    public static BeeAlleleRegistry.Fertility getSuperFertility() {
        return superFertility;
    }

    public static BeeAlleleRegistry.Life getSuperLife() {
        return superLife;
    }

    public static void showConditionalStatuses(World world, int x, int y, int z, EntityPlayer ep, IBeeHousing ibh) {
        IBeeGenome ibg;
        IAlleleBeeSpecies sp;
        IIndividual ii;
        ItemStack is = ibh.getBeeInventory().getQueen();
        if (is != null && (ii = AlleleManager.alleleRegistry.getIndividual(is)) instanceof IBee && (sp = (ibg = ((IBee)ii).getGenome()).getPrimary()) instanceof ChromaBeeHelpers.ConditionalProductBee) {
            ReikaChatHelper.sendChatToPlayer((EntityPlayer)ep, (String)("Product Conditions for " + EnumChatFormatting.GOLD + sp.getName() + EnumChatFormatting.RESET + " Bee:"));
            ChromaBeeHelpers.ConditionalProductBee cb = (ChromaBeeHelpers.ConditionalProductBee)sp;
            ChromaBeeHelpers.ConditionalProductProvider cp = cb.getProductProvider();
            StatusLogger log = new StatusLogger();
            cp.sendStatusInfo(world, x, y, z, log, ibg, ibh);
            log.sendToPlayer(ep);
        }
    }

    static {
        conditionalsUnavailable = new IErrorState(){
            private IIcon icon;

            public short getID() {
                return 1600;
            }

            public String getUniqueName() {
                return "ChromatiCraft:noconditionals";
            }

            public String getDescription() {
                return "Conditionals Unavailable";
            }

            public String getHelp() {
                return "Specialized products are unavailable due to their conditions not being met.";
            }

            @SideOnly(value=Side.CLIENT)
            public void registerIcons(IIconRegister register) {
                this.icon = register.func_94245_a("chromaticraft:forestry/no-conditionals");
            }

            @SideOnly(value=Side.CLIENT)
            public IIcon getIcon() {
                return this.icon;
            }
        };
        beeMap = new EnumMap(CrystalElement.class);
        effectMap = new EnumMap(CrystalElement.class);
        flowerMap = new EnumMap(CrystalElement.class);
        productConditions = new EnumMap(CrystalElement.class);
        conditionalBees = new ArrayList<ChromaBeeHelpers.ConditionalProductBee>();
        basicBees = new ArrayList();
        advancedBees = new ArrayList();
        ModularLogger.instance.addLogger((DragonAPIMod)ChromatiCraft.instance, LOGGER_TAG);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            CrystalBees.loadColorData();
        }
    }

    static final class CrystalBee
    extends BeeSpecies
    implements ChromaBeeHelpers.ConditionalProductBee {
        public final CrystalElement color;
        public final BeeAlleleRegistry.Speeds speed;
        public final BeeAlleleRegistry.Fertility fertility;
        public final BeeAlleleRegistry.Flowering flowering;
        public final BeeAlleleRegistry.Life lifespan;
        public final BeeAlleleRegistry.Territory area;
        public final BeeAlleleRegistry.Tolerance tempDir;
        public final BeeAlleleRegistry.Tolerance humidDir;
        public final int tempTol;
        public final int humidTol;
        public final EnumTemperature temperature;
        public final EnumHumidity humidity;

        public CrystalBee(CrystalElement color, BeeTraits traits) {
            super(color.displayName + " Crystal", "bee.crystal." + color.name().toLowerCase(Locale.ENGLISH), "Vitreus " + color.displayName, "Reika", (IClassification)crystalBranch);
            this.color = color;
            this.speed = traits.speed;
            this.fertility = traits.fertility;
            this.flowering = traits.flowering;
            this.lifespan = traits.lifespan;
            this.area = traits.area;
            this.tempDir = traits.tempDir;
            this.humidDir = traits.humidDir;
            this.tempTol = traits.tempTol;
            this.humidTol = traits.humidTol;
            this.temperature = traits.temperature;
            this.humidity = traits.humidity;
            this.addConditionalProduct(ChromaItems.BERRY.getStackOf(color), 25, true, new ProductChecks.LeafCheck(color));
            this.addConditionalProduct(ItemColoredModInteract.ColoredModItems.COMB.getItem(color), 8, true, new ProductChecks.CrystalPlantCheck(color));
            this.addProduct(ForestryHandler.Combs.HONEY.getItem(), 15.0f);
            this.addConditionalProduct(ChromaOptions.isVanillaDyeMoreCommon(color) ? new ItemStack(Items.field_151100_aR, 1, color.ordinal()) : ChromaItems.DYE.getStackOf(color), 20, false, new ProductChecks.FlowerCheck(color));
            switch (color) {
                case BLACK: {
                    this.addConditionalProduct(ChromaStacks.auraDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredPlant.TieredPlants.FLOWER.level));
                    break;
                }
                case RED: {
                    this.addSpecialty(ChromaStacks.etherBerries, 5.0f);
                    break;
                }
                case GREEN: {
                    this.addSpecialty(ForestryHandler.Combs.SILKY.getItem(), 10.0f);
                    this.addSpecialty(ChromaStacks.livingEssence, 5.0f);
                    break;
                }
                case PURPLE: {
                    if (ModList.TINKERER.isLoaded()) {
                        this.addSpecialty(OreBerryBushHandler.BerryTypes.XP.getStack(), 3.0f);
                    }
                    this.addSpecialty(ChromaStacks.voidDust, 10.0f);
                    break;
                }
                case BROWN: {
                    ArrayList li = OreDictionary.getOres((String)"nuggetIron");
                    if (li.isEmpty()) break;
                    this.addSpecialty((ItemStack)li.get(0), 5.0f);
                    break;
                }
                case ORANGE: {
                    this.addSpecialty(new ItemStack(Items.field_151065_br), 10.0f);
                    this.addConditionalProduct(ChromaStacks.fireEssence, 5, true, new ProductChecks.ProgressionCheck(BlockTieredOre.TieredOres.FIRESTONE.level));
                    break;
                }
                case BLUE: {
                    this.addConditionalProduct(ChromaStacks.beaconDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredPlant.TieredPlants.DESERT.level));
                    break;
                }
                case YELLOW: {
                    this.addSpecialty(ChromaStacks.energyPowder, 5.0f);
                    break;
                }
                case WHITE: {
                    this.addConditionalProduct(ChromaStacks.purityDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredPlant.TieredPlants.CAVE.level));
                    break;
                }
                case CYAN: {
                    this.addConditionalProduct(ChromaStacks.waterDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredOre.TieredOres.WATERY.level));
                    break;
                }
                case LIME: {
                    this.addConditionalProduct(ChromaStacks.spaceDust, 5, true, new ProductChecks.ProgressionCheck(BlockTieredOre.TieredOres.SPACERIFT.level));
                    break;
                }
                case GRAY: {
                    this.addSpecialty(ChromaStacks.teleDust, 5.0f);
                    break;
                }
                case LIGHTGRAY: {
                    this.addSpecialty(ChromaStacks.icyDust, 5.0f);
                    break;
                }
                case MAGENTA: {
                    ItemStack is = ReikaBeeHelper.getBeeItem((String)feedstock.getUID(), (EnumBeeType)EnumBeeType.PRINCESS);
                    this.addSpecialty(is, 1.0f);
                }
            }
            conditionalBees.add(this);
        }

        private void addConditionalProduct(ItemStack is, int chance, boolean specialty, ProductChecks.ProductCondition c) {
            if (specialty) {
                this.addSpecialty(is, chance);
            } else {
                this.addProduct(is, chance);
            }
            ItemHashMap map = productConditions.get(this.color);
            if (map == null) {
                map = new ItemHashMap();
                productConditions.put(this.color, (ItemHashMap<ProductChecks.ProductCondition>)map);
            }
            map.put(is, (Object)c);
        }

        public boolean isNocturnal() {
            return this.color == CrystalElement.BLUE;
        }

        public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
            World world = ibh.getWorld();
            int x = ibh.getCoordinates().field_71574_a;
            int y = ibh.getCoordinates().field_71572_b;
            int z = ibh.getCoordinates().field_71573_c;
            if (!(ibg.getFlowerProvider() instanceof FlowerAlleles.FlowerProviderCrystal)) {
                return false;
            }
            if (((FlowerAlleles.FlowerProviderCrystal)ibg.getFlowerProvider()).color != this.color) {
                return false;
            }
            if (this.rand.nextFloat() > ibg.getSpeed()) {
                return false;
            }
            if (ibg.getFlowering() < BeeAlleleRegistry.Flowering.AVERAGE.getAllele().getValue()) {
                return false;
            }
            if (!ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)) && this.rand.nextInt(2) > 0) {
                return false;
            }
            if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z))) {
                return false;
            }
            return this.rand.nextInt(3) > 0 || ProgressStage.SHARDCHARGE.isPlayerAtStage(world, ibh.getOwner().getId());
        }

        public String getDescription() {
            return "These bees seem to enjoy the magic aura of the cave crystals. So much so, in fact, that they will only thrive around their corresponding color.";
        }

        public EnumTemperature getTemperature() {
            return this.temperature;
        }

        public EnumHumidity getHumidity() {
            return this.humidity;
        }

        public boolean hasEffect() {
            return true;
        }

        public boolean isSecret() {
            return false;
        }

        public boolean isCounted() {
            return false;
        }

        public boolean isDominant() {
            return true;
        }

        public IAlleleFlowers getFlowerAllele() {
            return flowerMap.get(this.color);
        }

        public BeeAlleleRegistry.Speeds getProductionSpeed() {
            return this.speed;
        }

        public BeeAlleleRegistry.Fertility getFertility() {
            return this.fertility;
        }

        public BeeAlleleRegistry.Flowering getFloweringRate() {
            return this.flowering;
        }

        public BeeAlleleRegistry.Life getLifespan() {
            return this.lifespan;
        }

        public BeeAlleleRegistry.Territory getTerritorySize() {
            return this.area;
        }

        public boolean isCaveDwelling() {
            return true;
        }

        public int getTemperatureTolerance() {
            return this.tempTol;
        }

        public int getHumidityTolerance() {
            return this.humidTol;
        }

        public BeeAlleleRegistry.Tolerance getHumidityToleranceDir() {
            return this.humidDir;
        }

        public BeeAlleleRegistry.Tolerance getTemperatureToleranceDir() {
            return this.tempDir;
        }

        public boolean isTolerantFlyer() {
            return this.color == CrystalElement.CYAN;
        }

        public int getOutlineColor() {
            return crystalColors != null ? crystalColors[this.color.ordinal()].getColor((double)DragonAPICore.getSystemTimeAsInt() / 5.0 - (double)(this.color.ordinal() * 32)) : this.color.getColor();
        }

        public IAlleleBeeEffect getEffectAllele() {
            return effectMap.get(this.color);
        }

        @Override
        public ChromaBeeHelpers.ConditionalProductProvider getProductProvider() {
            return (FlowerAlleles.FlowerProviderCrystal)flowerMap.get(this.color).getProvider();
        }

        protected String getIconMod() {
            return "chromaticraft";
        }

        protected String getIconCategory() {
            return "crystal";
        }

        protected String getIconFolderRoot() {
            return "forestry/bees";
        }

        protected boolean simplifiedIconSystem() {
            return true;
        }

        public int getBeeStripeColor() {
            return ReikaColorAPI.mixColors((int)this.color.getColor(), (int)0xFFFFFF, (float)0.5f);
        }
    }

    static class SparkleBee
    extends BasicBee {
        private SparkleBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, int color, BeeSpecies.BeeBranch branch) {
            super(name, latin, s, l, f, f2, a, color, branch);
            this.setEffect(sparkleEffect);
        }

        @Override
        public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
            return super.isJubilant(ibg, ibh) && ChromatiCraft.isRainbowForest(ibh.getBiome());
        }

        @Override
        public String getDescription() {
            return "This bee makes its surroundings glitter like itself.";
        }

        @Override
        public boolean isDominant() {
            return false;
        }

        @Override
        public int getOutlineColor() {
            return sparkleColor != null ? sparkleColor.getColor((double)DragonAPICore.getSystemTimeAsInt() / 30.0) : 0xFFFFFF;
        }

        @Override
        public IAlleleBeeEffect getEffectAllele() {
            return sparkleEffect;
        }
    }

    static class BasicBee
    extends BeeSpecies.TraitsBee {
        public final int outline;
        private IAlleleBeeEffect effect;

        private BasicBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, int color, BeeSpecies.BeeBranch branch) {
            this(name, latin, s, l, f, f2, a, color, EnumTemperature.NORMAL, branch);
        }

        private BasicBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, int color, EnumTemperature t, BeeSpecies.BeeBranch branch) {
            super(name, "bee." + name.toLowerCase(Locale.ENGLISH), latin, "Reika", (IClassification)branch, new BeeTraits());
            this.traits.speed = s;
            this.traits.lifespan = l;
            this.traits.flowering = f;
            this.traits.fertility = f2;
            this.traits.area = a;
            this.traits.tempDir = BeeAlleleRegistry.Tolerance.NONE;
            this.traits.humidDir = BeeAlleleRegistry.Tolerance.NONE;
            this.traits.tempTol = 0;
            this.traits.humidTol = 0;
            this.traits.temperature = t;
            this.traits.humidity = EnumHumidity.NORMAL;
            this.traits.temperature = t;
            this.outline = color;
            if (((Object)((Object)this)).getClass() == BasicBee.class) {
                basicBees.add(this);
            }
        }

        protected BasicBee setEffect(IAlleleBeeEffect eff) {
            this.effect = eff;
            return this;
        }

        public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
            return ReikaBeeHelper.isDefaultJubilance((IAlleleBeeSpecies)this, (IBeeGenome)ibg, (IBeeHousing)ibh);
        }

        public String getDescription() {
            return "These bees do little on their own, but perhaps they could be purified into something stronger.";
        }

        public boolean hasEffect() {
            return false;
        }

        public boolean isSecret() {
            return false;
        }

        public boolean isCounted() {
            return false;
        }

        public boolean isDominant() {
            return true;
        }

        public IAlleleFlowers getFlowerAllele() {
            return BeeAlleleRegistry.Flower.VANILLA.getAllele();
        }

        public IAlleleBeeEffect getEffectAllele() {
            return this.effect != null ? this.effect : BeeAlleleRegistry.Effect.NONE.getAllele();
        }

        public int getOutlineColor() {
            return this.outline;
        }
    }

    static class RawBee
    extends BasicBee {
        private RawBee(String name, String latin, int color) {
            super(name, latin, noWork, BeeAlleleRegistry.Life.NORMAL, noFlowering, noFertility, noTerritory, color, crystalBranch);
        }

        @Override
        public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
            return false;
        }

        @Override
        public String getDescription() {
            return "With no traits or utility of their own, completely worthless as anything but raw feedstock.";
        }
    }

    static class AdvancedBee
    extends BasicBee
    implements ChromaBeeHelpers.ConditionalProductBee {
        private final ColorBlendList colorList;
        private final ProductChecks.ProgressionCheck progress;
        protected final Collection<ProductChecks.ProductCondition> otherChecks = new ArrayList<ProductChecks.ProductCondition>();
        private final ChromaBeeHelpers.CompoundConditionalProductProvider manager = new ChromaBeeHelpers.CompoundConditionalProductProvider();

        protected AdvancedBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, ColorBlendList c, EnumTemperature t, ProgressStage p) {
            this(name, latin, s, l, f, f2, a, c, t, p, advancedCrystalBranch);
        }

        protected AdvancedBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, ColorBlendList c, EnumTemperature t, ProgressStage p, BeeSpecies.BeeBranch branch) {
            super(name, latin, s, l, f, f2, a, 0xFFFFFF, t, branch);
            this.colorList = c;
            this.progress = new ProductChecks.ProgressionCheck(p);
            conditionalBees.add(this);
            advancedBees.add(this);
        }

        protected final void initConditions() {
            if (this == multi) {
                this.manager.add((FlowerAlleles.FlowerProviderMulti)multiFlower.getProvider());
            }
            this.manager.addGeneral(this.progress);
            for (ProductChecks.ProductCondition p : this.otherChecks) {
                this.manager.addGeneral(p);
            }
        }

        @Override
        public String getDescription() {
            return "Hybridized from the crystal bees, these bees are mysterious and have unknown but surely significant beneficial effects.";
        }

        @Override
        public boolean isJubilant(IBeeGenome ibg, IBeeHousing ibh) {
            if (!super.isJubilant(ibg, ibh)) {
                return false;
            }
            World world = ibh.getWorld();
            int x = ibh.getCoordinates().field_71574_a;
            int y = ibh.getCoordinates().field_71572_b;
            int z = ibh.getCoordinates().field_71573_c;
            for (ProductChecks.ProductCondition p : this.otherChecks) {
                if (p.check(world, x, y, z, ibg, ibh)) continue;
                return false;
            }
            return this.progress.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public boolean hasEffect() {
            return true;
        }

        @Override
        public IAlleleFlowers getFlowerAllele() {
            return this == multi ? multiFlower : super.getFlowerAllele();
        }

        @Override
        public int getOutlineColor() {
            return this.colorList != null ? this.colorList.getColor((double)DragonAPICore.getSystemTimeAsInt() / 30.0) : 0xFFFFFF;
        }

        @Override
        public ChromaBeeHelpers.ConditionalProductProvider getProductProvider() {
            return this.manager;
        }

        protected String getIconMod() {
            return "chromaticraft";
        }

        protected String getIconCategory() {
            return "crystal";
        }

        protected String getIconFolderRoot() {
            return "forestry/bees";
        }

        protected boolean simplifiedIconSystem() {
            return true;
        }

        public int getBeeStripeColor() {
            return ReikaColorAPI.mixColors((int)this.getOutlineColor(), (int)0xFFFFFF, (float)0.375f);
        }
    }

    static class PrecursorBee
    extends AdvancedBee {
        private static final String description = "Something feels strange about these bees, almost as if they are a link to the past, or some long-lost knowledge.";

        private PrecursorBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, ColorBlendList c, EnumTemperature t, ProgressStage p) {
            super(name, latin, s, l, f, f2, a, c, t, p, precursorBranch);
        }

        private PrecursorBee(String name, String latin, BeeAlleleRegistry.Speeds s, BeeAlleleRegistry.Life l, BeeAlleleRegistry.Flowering f, BeeAlleleRegistry.Fertility f2, BeeAlleleRegistry.Territory a, int c, EnumTemperature t, ProgressStage p) {
            this(name, latin, s, l, f, f2, a, new ColorBlendList(1.0f, new int[]{c}), t, p);
        }

        @Override
        public String getDescription() {
            return description;
        }

        @Override
        public IAlleleFlowers getFlowerAllele() {
            return metaFlower;
        }

        @Override
        public String getIconMod() {
            return "chromaticraft";
        }

        @Override
        public String getIconCategory() {
            return "precursor";
        }

        @Override
        protected String getIconFolderRoot() {
            return "forestry/bees";
        }

        @Override
        public boolean simplifiedIconSystem() {
            return true;
        }

        @Override
        public int getBeeStripeColor() {
            return ReikaColorAPI.mixColors((int)this.getOutlineColor(), (int)0xFFFFFF, (float)0.5f);
        }
    }
}

