/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.CrystalMusicManager;
import Reika.ChromatiCraft.Block.Worldgen.BlockSparkle;
import Reika.ChromatiCraft.Items.ItemUnknownArtefact;
import Reika.ChromatiCraft.Magic.Artefact.ArtefactSpawner;
import Reika.ChromatiCraft.Magic.Artefact.UABombingEffects;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Magic.Lore.Towers;
import Reika.ChromatiCraft.Magic.Network.CrystalNetworker;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.Magic.RainbowTreeEffects;
import Reika.ChromatiCraft.ModInterface.Bees.ChromaBeeHelpers;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.ModInterface.Bees.TileEntityLumenAlveary;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.ChromatiCraft.Render.Particle.EntityCCFloatingSeedsFX;
import Reika.ChromatiCraft.Render.Particle.EntityChromaFluidFX;
import Reika.ChromatiCraft.Render.Particle.EntityFlareFX;
import Reika.ChromatiCraft.Render.Particle.EntityLaserFX;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.ChromatiCraft.TileEntity.Networking.TileEntityCrystalPylon;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.Math.Noise.Simplex3DGenerator;
import Reika.DragonAPI.Interfaces.Registry.SoundEnum;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMusicHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BasicGene;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IEffectData;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IAlvearyController;
import forestry.api.multiblock.IMultiblockComponent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class EffectAlleles {

    static final class RainbowEffect
    extends ChromaTreeEffect {
        RainbowEffect() {
            super("effect.rainbowleaf", "Protective Aura");
        }

        public IEffectData doEffect(ITreeGenome genome, IEffectData storedData, World world, int x, int y, int z) {
            if (world.field_73012_v.nextInt(20) > 0) {
                return storedData;
            }
            double r = Math.min(4.0, 0.125 * Math.pow(1.25 * (double)genome.getHeight() * (double)genome.getGirth(), 2.0));
            RainbowTreeEffects.instance.doRainbowTreeEffects(world, x, y, z, 1.0f, r, world.field_73012_v, false);
            return storedData;
        }

        public boolean isCombinable() {
            return false;
        }

        public IEffectData validateStorage(IEffectData storedData) {
            return storedData;
        }
    }

    static final class SparklifyEffect
    extends ChromaBeeEffect {
        private Simplex3DGenerator sparkleNoise;

        public SparklifyEffect() {
            super("effect.sparkle", "Glittering");
        }

        public boolean isCombinable() {
            return true;
        }

        public IEffectData validateStorage(IEffectData ied) {
            return ied;
        }

        public IEffectData doEffect(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                ChunkCoordinates c = ibh.getCoordinates();
                if (world.field_73012_v.nextInt(200) == 0) {
                    Block b;
                    BlockSparkle.BlockTypes type;
                    int[] r = ChromaBeeHelpers.getEffectiveTerritory(ibh, c, ibg, world.func_82737_E());
                    BlockBox box = BlockBox.block((ChunkCoordinates)c).expand(r[0], r[1], r[2]);
                    Coordinate loc = box.getRandomContainedCoordinate(world.field_73012_v);
                    if (this.canSparklify(world, loc) && (type = BlockSparkle.getByProxy(b = loc.getBlock((IBlockAccess)world))) != null) {
                        loc.setBlock(world, ChromaBlocks.SPARKLE.getBlockInstance(), type.ordinal());
                        ReikaSoundHelper.playBreakSound((World)world, (int)loc.xCoord, (int)loc.yCoord, (int)loc.zCoord, (Block)b);
                    }
                }
            }
            return ied;
        }

        private boolean canSparklify(World world, Coordinate loc) {
            if (this.sparkleNoise == null || this.sparkleNoise.seed != world.func_72905_C()) {
                this.sparkleNoise = new Simplex3DGenerator(world.func_72905_C());
                this.sparkleNoise.clampEdge = true;
                this.sparkleNoise.setFrequency(0.125);
                this.sparkleNoise.addOctave(1.75, 0.25, 0.65);
                this.sparkleNoise.addOctave(3.0, 0.125, 0.2);
            }
            return this.sparkleNoise.getValue((double)loc.xCoord, (double)loc.yCoord, (double)loc.zCoord) > 0.0 && ReikaWorldHelper.isExposedToAir((World)world, (int)loc.xCoord, (int)loc.yCoord, (int)loc.zCoord);
        }

        private boolean isValidBeeForEffect(IAlleleBeeSpecies bee) {
            return true;
        }

        public IEffectData doFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.doClientFX(ibg, ied, ibh);
            }
            return ied;
        }

        @SideOnly(value=Side.CLIENT)
        private IEffectData doClientFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                if (world.field_73012_v.nextInt(4) == 0) {
                    ChunkCoordinates c = ibh.getCoordinates();
                    double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)c.field_71574_a + 0.5), (double)2.0);
                    double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)c.field_71573_c + 0.5), (double)2.0);
                    double py = ReikaRandomHelper.getRandomBetween((double)((double)c.field_71572_b - 1.5), (double)(c.field_71572_b + 4));
                    EntityFlareFX fx = new EntityFlareFX(CrystalElement.WHITE, world, px, py, pz);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
            }
            return ied;
        }
    }

    static final class ArtefactEffect
    extends ChromaBeeEffect {
        public ArtefactEffect() {
            super("effect.artefact", "Mysterious Aura");
        }

        public boolean isCombinable() {
            return true;
        }

        public IEffectData validateStorage(IEffectData ied) {
            return ied;
        }

        public IEffectData doEffect(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                ChunkCoordinates c = ibh.getCoordinates();
                if (world.field_73012_v.nextInt(500) == 0) {
                    int[] r = ChromaBeeHelpers.getEffectiveTerritory(ibh, c, ibg, world.func_82737_E());
                    TileEntityLumenAlveary te = ChromaBeeHelpers.getLumenAlvearyController(ibh, world, c);
                    AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)c.field_71574_a, (int)c.field_71572_b, (int)c.field_71573_c).func_72314_b((double)r[0], (double)r[1], (double)r[2]);
                    List<WeakReference<EntityLivingBase>> li = ChromaBeeHelpers.getEntityList(box, world.func_82737_E(), world, c, EntityPlayer.class, null);
                    for (WeakReference<EntityLivingBase> w : li) {
                        EntityLivingBase e = (EntityLivingBase)w.get();
                        if (!(e instanceof EntityPlayer)) continue;
                        if (!(world.field_73012_v.nextInt(4) != 0 || te != null && te.effectsOnlyOnPlayers())) {
                            UABombingEffects.instance.trigger((Entity)e);
                        }
                        if (world.field_73012_v.nextInt(100) != 0) continue;
                        int dx = ReikaRandomHelper.getRandomPlusMinus((int)c.field_71574_a, (int)r[0]);
                        int dz = ReikaRandomHelper.getRandomPlusMinus((int)c.field_71573_c, (int)r[2]);
                        ArtefactSpawner.instance.addArtefact(dx, dz, (EntityPlayer)e, 72000);
                    }
                }
            }
            return ied;
        }

        private boolean isValidBeeForEffect(IAlleleBeeSpecies bee) {
            return bee instanceof CrystalBees.PrecursorBee;
        }

        public IEffectData doFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.doClientFX(ibg, ied, ibh);
            }
            return ied;
        }

        @SideOnly(value=Side.CLIENT)
        private IEffectData doClientFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                ChunkCoordinates c = ibh.getCoordinates();
                double d = Minecraft.func_71410_x().field_71439_g.func_70092_e((double)c.field_71574_a + 0.5, (double)c.field_71572_b + 0.5, (double)c.field_71573_c + 0.5);
                if (d < 4096.0) {
                    double f = 1.0;
                    if (d >= 1024.0) {
                        f = 4.0 * (1.0 - d / 4096.0);
                    }
                    if (f >= 1.0 || ReikaRandomHelper.doWithChance((double)f)) {
                        ItemUnknownArtefact.doUA_FX(world, (double)c.field_71574_a + 0.5, (double)c.field_71572_b + 0.5, (double)c.field_71573_c + 0.5, d <= 256.0);
                    }
                }
            }
            return ied;
        }
    }

    static final class PrecursorEffect
    extends ChromaBeeEffect {
        public PrecursorEffect() {
            super("effect.precursor", "Ancient Knowledge");
        }

        public boolean isCombinable() {
            return true;
        }

        public IEffectData validateStorage(IEffectData ied) {
            return ied;
        }

        public IEffectData doEffect(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            return ied;
        }

        private boolean isValidBeeForEffect(IAlleleBeeSpecies bee) {
            return bee instanceof CrystalBees.PrecursorBee;
        }

        public IEffectData doFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.doClientFX(ibg, ied, ibh);
            }
            return ied;
        }

        @SideOnly(value=Side.CLIENT)
        private IEffectData doClientFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                if (world.field_73012_v.nextInt(4) == 0) {
                    ChunkCoordinates c = ibh.getCoordinates();
                    double px = ReikaRandomHelper.getRandomPlusMinus((double)((double)c.field_71574_a + 0.5), (double)2.0);
                    double pz = ReikaRandomHelper.getRandomPlusMinus((double)((double)c.field_71573_c + 0.5), (double)2.0);
                    double py = ReikaRandomHelper.getRandomBetween((double)((double)c.field_71572_b - 1.5), (double)(c.field_71572_b + 4));
                    Towers t1 = Towers.towerList[(int)(world.func_82737_E() / 1200L % (long)Towers.towerList.length)];
                    if (t1.getRootPosition() != null) {
                        double dx = (double)(t1.getRootPosition().field_77276_a - c.field_71574_a) - 0.5;
                        double dz = (double)(t1.getRootPosition().field_77275_b - c.field_71573_c) - 0.5;
                        double a = -ReikaPhysicsHelper.cartesianToPolarFast((double)dx, (double)0.0, (double)dz)[2] - 90.0;
                        float s = world.field_73012_v.nextFloat() + 0.25f;
                        EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(world, px, py, pz, a, 0.0);
                        fx.freedom *= 0.5;
                        fx.setIcon(ChromaIcons.FADE).setColor(10543359).setLife(120).setScale(s);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                }
            }
            return ied;
        }
    }

    static final class ChromaEffect
    extends ChromaBeeEffect {
        public ChromaEffect() {
            super("effect.pylonrecharge", "Power Aura");
        }

        public boolean isCombinable() {
            return true;
        }

        public IEffectData validateStorage(IEffectData ied) {
            return ied;
        }

        public IEffectData doEffect(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            int[] r;
            ChunkCoordinates c;
            World world;
            ArrayList<TileEntityCrystalPylon> li;
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary()) && (li = CrystalNetworker.instance.getAllNearbyPylons(world = ibh.getWorld(), c.field_71574_a, c.field_71572_b, c.field_71573_c, (r = ChromaBeeHelpers.getEffectiveTerritory(ibh, c = ibh.getCoordinates(), ibg, world.func_82737_E()))[0], true)) != null && !li.isEmpty()) {
                li.get(CrystalBees.rand.nextInt(li.size())).speedRegenShortly(8);
            }
            return ied;
        }

        private boolean isValidBeeForEffect(IAlleleBeeSpecies bee) {
            return bee == CrystalBees.chroma;
        }

        public IEffectData doFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.doClientFX(ibg, ied, ibh);
            }
            return ied;
        }

        @SideOnly(value=Side.CLIENT)
        private IEffectData doClientFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                ChunkCoordinates c = ibh.getCoordinates();
                Random rand = CrystalBees.rand;
                if (ibh instanceof IAlvearyComponent) {
                    ibh = ((IAlvearyComponent)ibh).getMultiblockLogic().getController();
                }
                if (ibh instanceof IAlvearyController) {
                    IAlvearyController iac = (IAlvearyController)ibh;
                    Collection li = iac.getComponents();
                    IMultiblockComponent imc = (IMultiblockComponent)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, (Collection)li);
                    c = imc.getCoordinates();
                }
                int x = c.field_71574_a;
                int y = c.field_71572_b;
                int z = c.field_71573_c;
                double[] v = ReikaPhysicsHelper.polarToCartesian((double)ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.125), (double)(rand.nextDouble() * 90.0), (double)(rand.nextDouble() * 360.0));
                EntityChromaFluidFX fx = new EntityChromaFluidFX(world, (double)x + rand.nextDouble(), (double)y + rand.nextDouble() * 3.0, (double)z + rand.nextDouble(), v[0], v[1], v[2]).setGravity(0.125f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            return ied;
        }
    }

    static final class RechargeEffect
    extends ChromaBeeEffect {
        public RechargeEffect() {
            super("effect.playerbuffer", "Lumen Balance");
        }

        public boolean isCombinable() {
            return true;
        }

        public IEffectData validateStorage(IEffectData ied) {
            return ied;
        }

        public IEffectData doEffect(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                EntityPlayer owner;
                World world = ibh.getWorld();
                ChunkCoordinates c = ibh.getCoordinates();
                int[] r = ChromaBeeHelpers.getEffectiveTerritory(ibh, c, ibg, world.func_82737_E());
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)c.field_71574_a, (int)c.field_71572_b, (int)c.field_71573_c).func_72314_b((double)r[0], (double)r[1], (double)r[2]);
                List<WeakReference<EntityLivingBase>> li = ChromaBeeHelpers.getEntityList(box, world.func_82737_E(), world, c, EntityPlayer.class, null);
                TileEntityLumenAlveary te = ChromaBeeHelpers.getLumenAlvearyController(ibh, world, c);
                if (te != null && te.hasOmnipresence() && (owner = te.getPlacer()) != null && !ReikaPlayerAPI.isFake((EntityPlayer)owner)) {
                    li.add(new WeakReference<EntityPlayer>(owner));
                }
                for (WeakReference<EntityLivingBase> w : li) {
                    EntityPlayer ep;
                    EntityLivingBase e = (EntityLivingBase)w.get();
                    if (!(e instanceof EntityPlayer) || CrystalBees.rand.nextInt(36) != 0 || !ProgressStage.CHARGE.isPlayerAtStage(ep = (EntityPlayer)e) || !ProgressStage.USEENERGY.isPlayerAtStage(ep) || !ProgressStage.INFUSE.isPlayerAtStage(ep)) continue;
                    int max = -1;
                    int min = Integer.MAX_VALUE;
                    CrystalElement most = null;
                    CrystalElement least = null;
                    int cap = PlayerElementBuffer.instance.getElementCap(ep);
                    for (int i = 0; i < 16; ++i) {
                        CrystalElement clr = CrystalElement.elements[i];
                        int has = PlayerElementBuffer.instance.getPlayerContent(ep, clr);
                        if (has < min) {
                            least = clr;
                            min = has;
                        }
                        if (has <= max) continue;
                        most = clr;
                        max = has;
                    }
                    int diff = max - min;
                    if (max <= 0 || min >= cap / 2 || diff <= cap / 4) continue;
                    PlayerElementBuffer.instance.addToPlayer(ep, least, Math.max(1, Math.min(500, diff / 2000)), false);
                }
            }
            return ied;
        }

        private boolean isValidBeeForEffect(IAlleleBeeSpecies bee) {
            return bee == CrystalBees.aura;
        }

        public IEffectData doFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.doClientFX(ibg, ied, ibh);
            }
            return ied;
        }

        @SideOnly(value=Side.CLIENT)
        private IEffectData doClientFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                ChunkCoordinates c = ibh.getCoordinates();
                int n = 6 + CrystalBees.rand.nextInt(6);
                for (int i = 0; i < n; ++i) {
                    double v = ReikaRandomHelper.getRandomPlusMinus((double)0.0625, (double)0.03125);
                    double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)v, (double)(CrystalBees.rand.nextDouble() * 360.0), (double)(CrystalBees.rand.nextDouble() * 360.0));
                    float s = ReikaRandomHelper.getRandomBetween((int)3, (int)6);
                    double px = (double)c.field_71574_a + 0.5;
                    double py = (double)c.field_71572_b + 0.5;
                    double pz = (double)c.field_71573_c + 0.5;
                    CrystalElement e = CrystalElement.randomElement();
                    EntityLaserFX fx = new EntityLaserFX(e, world, px, py, pz, xyz[0], xyz[1], xyz[2]).setScale(s);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    fx = new EntityLaserFX(e, world, px, py, pz, -xyz[0], -xyz[1], -xyz[2]).setScale(s);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
            }
            return ied;
        }
    }

    static final class PolychromaEffect
    extends ChromaBeeEffect {
        private long lastWorldTick = -1L;
        private long lastWorldTickClient = -1L;
        private ReikaMusicHelper.MusicKey lastKey;
        private int currentChord;
        private long nextNoteTime;
        private int currentBarTime;
        private static final Random musicRand = new Random();
        private static final ReikaMusicHelper.MusicKey[] chords = new ReikaMusicHelper.MusicKey[]{ReikaMusicHelper.MusicKey.C5, ReikaMusicHelper.MusicKey.G4, ReikaMusicHelper.MusicKey.A4, ReikaMusicHelper.MusicKey.E4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.C4, ReikaMusicHelper.MusicKey.F4, ReikaMusicHelper.MusicKey.G4};
        private static final ArrayList<ReikaMusicHelper.MusicKey>[] validNotes = new ArrayList[chords.length];
        private static final WeightedRandom<Integer> noteLengths = new WeightedRandom();

        public PolychromaEffect() {
            super("effect.polychroma", "Polychromatic Aura");
        }

        public boolean isCombinable() {
            return true;
        }

        public IEffectData validateStorage(IEffectData ied) {
            return ied;
        }

        public IEffectData doEffect(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                long time = world.func_82737_E();
                ChunkCoordinates c = ibh.getCoordinates();
                int[] r = ChromaBeeHelpers.getEffectiveTerritory(ibh, c, ibg, time);
                RainbowTreeEffects.instance.doRainbowTreeEffects(world, c.field_71574_a, c.field_71572_b, c.field_71573_c, 1.0f, (float)r[0] / 16.0f, CrystalBees.rand, false);
                CrystalElement e = CrystalElement.randomElement();
                CrystalEffect.spawnBallLightnings = false;
                CrystalBees.effectMap.get(e).doEffect(ibg, ied, ibh);
                CrystalEffect.spawnBallLightnings = true;
                this.lastWorldTick = time;
            }
            return ied;
        }

        private boolean isValidBeeForEffect(IAlleleBeeSpecies bee) {
            return bee == CrystalBees.multi;
        }

        private boolean keyIsCurrentlyValid(ReikaMusicHelper.MusicKey key) {
            if (this.lastKey == null) {
                return true;
            }
            int diff = key.ordinal() - this.lastKey.ordinal();
            if (diff > 12 || diff < -12) {
                return false;
            }
            int mod = diff % 12;
            if (mod == 11) {
                return false;
            }
            return mod != 6;
        }

        public IEffectData doFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.doClientFX(ibg, ied, ibh);
            }
            return ied;
        }

        @SideOnly(value=Side.CLIENT)
        private IEffectData doClientFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            World world;
            long wtime;
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary()) && this.lastWorldTickClient != (wtime = (world = ibh.getWorld()).func_82737_E())) {
                ChunkCoordinates c = ibh.getCoordinates();
                int[] r = ChromaBeeHelpers.getEffectiveTerritory(ibh, c, ibg, wtime);
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)c.field_71574_a, (int)c.field_71572_b, (int)c.field_71573_c).func_72314_b((double)r[0], (double)r[1], (double)r[2]);
                int n = (int)(Math.sqrt(ReikaAABBHelper.getVolume((AxisAlignedBB)box) / 480.0) / 2.0);
                int n2 = (int)(Math.pow((double)n * 1.5, 1.5) / 4.0);
                for (int i = 0; i < n2; ++i) {
                    double pz;
                    double py;
                    double px = ReikaRandomHelper.getRandomBetween((double)box.field_72340_a, (double)box.field_72336_d);
                    if (!ReikaWorldHelper.isPositionEmpty((World)world, (double)px, (double)(py = ReikaRandomHelper.getRandomBetween((double)box.field_72338_b, (double)box.field_72337_e)), (double)(pz = ReikaRandomHelper.getRandomBetween((double)box.field_72339_c, (double)box.field_72334_f)))) continue;
                    EntityCCFloatingSeedsFX fx = new EntityCCFloatingSeedsFX(world, px, py, pz, 0.0, 90.0);
                    fx.angleVelocity *= 2.0;
                    fx.freedom *= 4.0;
                    fx.setCyclingColor(0.2f).setScale(2.0f + CrystalBees.rand.nextFloat());
                    Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                }
                GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                String cl = gui != null ? gui.getClass().getName().toLowerCase(Locale.ENGLISH) : "";
                boolean open = gui != null && (cl.contains("apiculture") || cl.contains("gendustry"));
                float vol = open ? 0.3f : 0.125f;
                long time = System.currentTimeMillis();
                if (time >= this.nextNoteTime) {
                    musicRand.setSeed(wtime ^ 0x7524D083L);
                    noteLengths.setSeed(wtime ^ 0xFFFFFFFFA929666BL);
                    ReikaMusicHelper.MusicKey key = this.randomKey(this.currentChord);
                    float f = (float)key.getRatio(ReikaMusicHelper.MusicKey.C5);
                    this.playSound(c, box, vol, f);
                    int len = Math.min((Integer)noteLengths.getRandomEntry(), 48 - this.currentBarTime) * 50 * 2;
                    this.nextNoteTime = time + (long)len;
                    this.currentBarTime += len;
                    if (this.currentBarTime >= 48) {
                        this.currentBarTime = 0;
                        this.currentChord = (this.currentChord + 1) % chords.length;
                    }
                }
                this.lastWorldTickClient = wtime;
            }
            return ied;
        }

        private ReikaMusicHelper.MusicKey randomKey(int chord) {
            ReikaMusicHelper.MusicKey key = validNotes[chord].get(musicRand.nextInt(validNotes[chord].size()));
            while (!this.keyIsCurrentlyValid(key)) {
                key = validNotes[chord].get(musicRand.nextInt(validNotes[chord].size()));
            }
            this.lastKey = key;
            return key;
        }

        @SideOnly(value=Side.CLIENT)
        private void playSound(ChunkCoordinates c, AxisAlignedBB box, float vol, float f) {
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            boolean atten = !ep.field_70121_D.func_72326_a(box);
            if ((f *= 2.0f) > 1.0f) {
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DRONE_HI, (double)((double)c.field_71574_a + 0.5), (double)((double)c.field_71572_b + 0.5), (double)((double)c.field_71573_c + 0.5), (float)vol, (float)f, (boolean)atten);
            } else {
                ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DRONE, (double)((double)c.field_71574_a + 0.5), (double)((double)c.field_71572_b + 0.5), (double)((double)c.field_71573_c + 0.5), (float)vol, (float)(f *= 2.0f), (boolean)atten);
            }
        }

        static {
            for (int k = 0; k < chords.length; ++k) {
                ReikaMusicHelper.MusicKey cur = chords[k];
                PolychromaEffect.validNotes[k] = new ArrayList();
                for (int i = 0; i <= 12; ++i) {
                    ReikaMusicHelper.KeySignature chordKey;
                    ReikaMusicHelper.MusicKey key = cur.getInterval(i);
                    ReikaMusicHelper.KeySignature keySignature = chordKey = cur.getNote() == ReikaMusicHelper.Note.A || cur.getNote() == ReikaMusicHelper.Note.E ? ReikaMusicHelper.KeySignature.getByMinorTonic((ReikaMusicHelper.MusicKey)cur) : ReikaMusicHelper.KeySignature.getByTonic((ReikaMusicHelper.MusicKey)cur);
                    if (!ReikaMusicHelper.KeySignature.C.isNoteValid(key.getNote()) || !chordKey.isNoteValid(key.getNote())) continue;
                    validNotes[k].add(key);
                }
            }
            noteLengths.addEntry((Object)12, 100.0);
            noteLengths.addEntry((Object)6, 50.0);
            noteLengths.addEntry((Object)3, 5.0);
            noteLengths.addEntry((Object)24, 25.0);
            noteLengths.addEntry((Object)36, 15.0);
            noteLengths.addEntry((Object)48, 8.0);
            noteLengths.addEntry((Object)18, 15.0);
        }
    }

    static final class CrystalEffect
    extends ChromaBeeEffect {
        public final CrystalElement color;
        private long lastWorldTick = -1L;
        private long lastWorldTickClient = -1L;
        private static boolean spawnBallLightnings = true;

        public CrystalEffect(CrystalElement color) {
            super("effect.cavecrystal." + color.name().toLowerCase(Locale.ENGLISH), color.displayName + " Aura");
            this.color = color;
        }

        public boolean isCombinable() {
            return true;
        }

        public IEffectData validateStorage(IEffectData ied) {
            return ied;
        }

        public IEffectData doEffect(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary())) {
                World world = ibh.getWorld();
                ChunkCoordinates c = ibh.getCoordinates();
                long time = world.func_82737_E();
                if (this.canApplyEffect(world, c.field_71574_a, c.field_71572_b, c.field_71573_c)) {
                    EntityPlayer owner;
                    int[] r = ChromaBeeHelpers.getEffectiveTerritory(ibh, c, ibg, time);
                    AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)c.field_71574_a, (int)c.field_71572_b, (int)c.field_71573_c).func_72314_b((double)r[0], (double)r[1], (double)r[2]);
                    IEntitySelector s = null;
                    TileEntityLumenAlveary te = ChromaBeeHelpers.getLumenAlvearyController(ibh, world, c);
                    Class ce = te != null && te.effectsOnlyOnPlayers() ? EntityPlayer.class : EntityLivingBase.class;
                    switch (this.color) {
                        case MAGENTA: 
                        case CYAN: 
                        case LIGHTBLUE: 
                        case ORANGE: 
                        case PINK: 
                        case LIME: 
                        case RED: {
                            s = ReikaEntityHelper.nonMobSelector;
                            break;
                        }
                        case GREEN: 
                        case PURPLE: {
                            ce = EntityPlayer.class;
                            break;
                        }
                        case BLACK: 
                        case GRAY: 
                        case LIGHTGRAY: {
                            s = ReikaEntityHelper.hostileOrPlayerSelector;
                            break;
                        }
                    }
                    List<WeakReference<EntityLivingBase>> li = ChromaBeeHelpers.getEntityList(box, time, world, c, ce, s);
                    if (te != null && te.hasOmnipresence() && (owner = te.getPlacer()) != null && !ReikaPlayerAPI.isFake((EntityPlayer)owner)) {
                        li.add(new WeakReference<EntityPlayer>(owner));
                    }
                    boolean boost = te != null && te.isColorBoosted(this.color);
                    int dur = boost ? 900 : 400;
                    HashSet<Integer> ticked = new HashSet<Integer>();
                    for (WeakReference<EntityLivingBase> w : li) {
                        EntityLivingBase e = (EntityLivingBase)w.get();
                        if (e == null || ticked.contains(e.func_145782_y())) continue;
                        ticked.add(e.func_145782_y());
                        CrystalPotionController.instance.applyEffectFromColor(dur, boost ? 1 : 0, e, this.color, CrystalBees.rand.nextInt(240) == 0 && e.func_70092_e((double)c.field_71574_a + 0.5, (double)c.field_71572_b + 0.5, (double)c.field_71573_c + 0.5) < 256.0);
                    }
                }
                if (spawnBallLightnings && this.lastWorldTick != time && CrystalBees.rand.nextInt(8000) == 0) {
                    ChromaAux.spawnInteractionBallLightning(world, c.field_71574_a, c.field_71572_b, c.field_71573_c, this.color);
                }
                this.lastWorldTick = time;
            }
            return ied;
        }

        private boolean canApplyEffect(World world, int x, int y, int z) {
            if (this.color == CrystalElement.BLUE) {
                return world.func_72937_j(x, y + 1, z);
            }
            return true;
        }

        private boolean isValidBeeForEffect(IAlleleBeeSpecies bee) {
            return bee == CrystalBees.multi || bee instanceof CrystalBees.CrystalBee && ((CrystalBees.CrystalBee)bee).color == this.color;
        }

        public IEffectData doFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                return this.doClientFX(ibg, ied, ibh);
            }
            return ied;
        }

        @SideOnly(value=Side.CLIENT)
        private IEffectData doClientFX(IBeeGenome ibg, IEffectData ied, IBeeHousing ibh) {
            World world;
            long time;
            if (this.isValidBeeForEffect(ibg.getPrimary()) && this.isValidBeeForEffect(ibg.getSecondary()) && this.lastWorldTickClient != (time = (world = ibh.getWorld()).func_82737_E())) {
                ChunkCoordinates c = ibh.getCoordinates();
                int delay = 12;
                ImmutablePair<CrystalElement, Integer> p = this.getActiveFXColor(world, delay);
                if (p.left == this.color) {
                    float vol;
                    int[] r = ChromaBeeHelpers.getEffectiveTerritory(ibh, c, ibg, time);
                    AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)c.field_71574_a, (int)c.field_71572_b, (int)c.field_71573_c).func_72314_b((double)r[0], (double)r[1], (double)r[2]);
                    int n = (int)(0.625 * Math.sqrt(ReikaAABBHelper.getVolume((AxisAlignedBB)box) / 480.0) / 2.0);
                    for (int i = 0; i < n; ++i) {
                        double pz;
                        double py;
                        double px = ReikaRandomHelper.getRandomBetween((double)box.field_72340_a, (double)box.field_72336_d);
                        if (!ReikaWorldHelper.isPositionEmpty((World)world, (double)px, (double)(py = ReikaRandomHelper.getRandomBetween((double)box.field_72338_b, (double)box.field_72337_e)), (double)(pz = ReikaRandomHelper.getRandomBetween((double)box.field_72339_c, (double)box.field_72334_f)))) continue;
                        float s = 1.0f + CrystalBees.rand.nextFloat();
                        EntityRuneFX fx = new EntityRuneFX(world, px, py, pz, this.color).setGravity(0.0f).setScale(s).setFading();
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    int n2 = (int)(Math.pow((double)n * 1.5, 1.5) / 4.0);
                    for (int i = 0; i < n2; ++i) {
                        double px = ReikaRandomHelper.getRandomBetween((double)box.field_72340_a, (double)box.field_72336_d);
                        double py = ReikaRandomHelper.getRandomBetween((double)box.field_72338_b, (double)box.field_72337_e);
                        double pz = ReikaRandomHelper.getRandomBetween((double)box.field_72339_c, (double)box.field_72334_f);
                        int s = CrystalBees.rand.nextInt(6);
                        switch (s) {
                            case 0: {
                                px = box.field_72340_a;
                                break;
                            }
                            case 1: {
                                px = box.field_72336_d;
                                break;
                            }
                            case 2: {
                                py = box.field_72338_b;
                                break;
                            }
                            case 3: {
                                py = box.field_72337_e;
                                break;
                            }
                            case 4: {
                                pz = box.field_72339_c;
                                break;
                            }
                            case 5: {
                                pz = box.field_72334_f;
                            }
                        }
                        if (!ReikaWorldHelper.isPositionEmpty((World)world, (double)px, (double)py, (double)pz)) continue;
                        EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.FADE_RAY).setColor(this.color.getColor()).setScale(2.0f);
                        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                    }
                    GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
                    String cl = gui != null ? gui.getClass().getName().toLowerCase(Locale.ENGLISH) : "";
                    boolean open = gui != null && (cl.contains("apiculture") || cl.contains("gendustry"));
                    float f = vol = open ? 1.5f : 0.45f;
                    if (world.func_82737_E() % (long)delay == 0L) {
                        int sound = (Integer)p.right;
                        if (sound == 0 || sound == 5) {
                            for (int i = 0; i <= 3; ++i) {
                                float f2 = CrystalMusicManager.instance.getScaledDing(this.color, i);
                                this.playSound(c, box, vol / 3.0f, f2);
                            }
                        } else {
                            float f3 = CrystalMusicManager.instance.getScaledDing(this.color, sound - 1);
                            this.playSound(c, box, vol, f3);
                        }
                    }
                }
                this.lastWorldTickClient = world.func_82737_E();
            }
            return ied;
        }

        @SideOnly(value=Side.CLIENT)
        private void playSound(ChunkCoordinates c, AxisAlignedBB box, float vol, float f) {
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            ReikaSoundHelper.playClientSound((SoundEnum)ChromaSounds.DING, (double)((double)c.field_71574_a + 0.5), (double)((double)c.field_71572_b + 0.5), (double)((double)c.field_71573_c + 0.5), (float)vol, (float)f, (!ep.field_70121_D.func_72326_a(box) ? 1 : 0) != 0);
        }

        private ImmutablePair<CrystalElement, Integer> getActiveFXColor(World world, int delay) {
            long tick = world.func_82737_E() / (long)delay;
            int steps = 6;
            int active = (int)(tick / (long)steps % 16L);
            int sound = (int)(tick % (long)steps);
            return new ImmutablePair((Object)CrystalElement.elements[active], (Object)sound);
        }
    }

    private static abstract class ChromaTreeEffect
    extends BasicGene
    implements IAlleleLeafEffect {
        protected ChromaTreeEffect(String uid, String name) {
            super(uid, name, (IChromosomeType)EnumTreeChromosome.EFFECT);
        }
    }

    private static abstract class ChromaBeeEffect
    extends BasicGene
    implements IAlleleBeeEffect {
        protected ChromaBeeEffect(String uid, String name) {
            super(uid, name, (IChromosomeType)EnumBeeChromosome.EFFECT);
        }
    }
}

