/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.ModInterface.Bees.TileEntityLumenAlveary;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockBox;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.FlowerManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.multiblock.IAlvearyController;
import forestry.apiculture.HasFlowersCache;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class EfficientFlowerCache
extends HasFlowersCache {
    private long lastScanTick;
    private int searchCooldown;
    private Coordinate flowerCoord;
    private int id = lastAssignedID % 128;
    private String cachedFlowerType;
    private BlockBox cachedTerritory;
    private final BlockCheck flowerMatch;
    private FlowerSearch search;
    private static int lastAssignedID;
    private static final HashSet<String> blacklistedAcceptanceCaching;
    private static final MultiMap<String, BlockKey> cachedAcceptedBlocks;
    private static final MutableBlockKey blockKey;

    public EfficientFlowerCache() {
        ++lastAssignedID;
        this.flowerMatch = new FlowerMatch();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagCompound tag = nbt.func_74775_l("hasFlowerCache");
        this.flowerCoord = Coordinate.readFromNBT((String)"loc", (NBTTagCompound)tag);
        this.searchCooldown = tag.func_74762_e("age");
        this.lastScanTick = tag.func_74763_f("lastTick");
        this.id = tag.func_74762_e("id");
        this.cachedFlowerType = tag.func_74779_i("cachedFlower");
        if (this.cachedFlowerType.isEmpty()) {
            this.cachedFlowerType = null;
        }
        this.cachedTerritory = tag.func_74764_b("territory") ? BlockBox.readFromNBT((NBTTagCompound)tag.func_74775_l("territory")) : null;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.flowerCoord != null) {
            this.flowerCoord.writeToNBT("loc", tag);
        }
        tag.func_74768_a("age", this.searchCooldown);
        tag.func_74772_a("lastTick", this.lastScanTick);
        tag.func_74768_a("id", this.id);
        if (this.cachedFlowerType != null) {
            tag.func_74778_a("cachedFlower", this.cachedFlowerType);
        }
        if (this.cachedTerritory != null) {
            NBTTagCompound dat = new NBTTagCompound();
            this.cachedTerritory.writeToNBT(dat);
            tag.func_74782_a("territory", (NBTBase)dat);
        }
        nbt.func_74782_a("hasFlowerCache", (NBTBase)tag);
    }

    public boolean hasFlowers(IBee bee, IBeeHousing ibh) {
        World world = ibh.getWorld();
        long time = world.func_82737_E();
        if (time <= this.lastScanTick) {
            return this.flowerCoord != null;
        }
        IBeeGenome ibg = bee.getGenome();
        if (this.cachedFlowerType == null || this.cachedTerritory == null || time % 256L == (long)this.id) {
            this.cachedFlowerType = ibg.getFlowerProvider().getFlowerType();
            if (this.cachedTerritory == null || time % 512L == (long)this.id) {
                this.cachedTerritory = this.calcTerritory(ibg, ibh);
            }
        }
        if (this.isStillValid(world, time)) {
            return true;
        }
        if (this.searchCooldown >= 550) {
            this.findFlower(world, false);
        } else {
            ++this.searchCooldown;
        }
        this.lastScanTick = time;
        return this.flowerCoord != null;
    }

    public void forceUpdate(TileEntityLumenAlveary te) {
        if (te.field_145850_b.field_72995_K) {
            return;
        }
        if (this.flowerCoord != null) {
            return;
        }
        if (!te.isAlvearyComplete() || !te.hasQueen()) {
            return;
        }
        IAlvearyController ibh = te.getMultiblockLogic().getController();
        IBee bee = ReikaBeeHelper.getBee((ItemStack)ibh.getBeeInventory().getQueen());
        if (bee == null) {
            return;
        }
        IBeeGenome ibg = bee.getGenome();
        this.cachedFlowerType = ibg.getFlowerProvider().getFlowerType();
        this.cachedTerritory = this.calcTerritory(ibg, (IBeeHousing)ibh);
        this.findFlower(te.field_145850_b, true);
    }

    private BlockBox calcTerritory(IBeeGenome ibg, IBeeHousing ibh) {
        int[] base = ibg.getTerritory();
        IBeeModifier ibm = BeeManager.beeRoot.createBeeHousingModifier(ibh);
        float f = ibm.getTerritoryModifier(ibg, 1.0f);
        float fx = 1.5f * f * (float)base[0];
        float fy = 1.5f * f * (float)base[1];
        float fz = 1.5f * f * (float)base[2];
        ChunkCoordinates cc = ibh.getCoordinates();
        int nx = Math.round((float)cc.field_71574_a - fx);
        int px = Math.round((float)cc.field_71574_a + fx);
        int ny = Math.round((float)cc.field_71572_b - fy);
        int py = Math.round((float)cc.field_71572_b + fy);
        int nz = Math.round((float)cc.field_71573_c - fz);
        int pz = Math.round((float)cc.field_71573_c + fz);
        return new BlockBox(nx, ny, nz, px, py, pz);
    }

    private boolean isStillValid(World world, long time) {
        return this.flowerCoord != null && (time % 128L == (long)this.id || this.cachedTerritory.isBlockInside(this.flowerCoord) && EfficientFlowerCache.checkFlowerAcceptance(this.cachedFlowerType, world, this.flowerCoord.xCoord, this.flowerCoord.yCoord, this.flowerCoord.zCoord));
    }

    private void findFlower(World world, boolean runFullScan) {
        if (runFullScan) {
            this.flowerCoord = this.cachedTerritory.findBlock(world, this.flowerMatch);
        } else {
            if (this.search == null) {
                this.search = new FlowerSearch();
            }
            if (this.search.tick(world)) {
                this.searchCooldown = 0;
                this.flowerCoord = this.search.getCoordinate();
                this.search = null;
            }
        }
    }

    private static boolean checkFlowerAcceptance(String type, World world, int x, int y, int z) {
        if (!blacklistedAcceptanceCaching.contains(type)) {
            EfficientFlowerCache.blockKey.read(world, x, y, z);
            Collection c = cachedAcceptedBlocks.get((Object)type);
            if (c != null && c.contains(blockKey)) {
                return true;
            }
        }
        if (FlowerManager.flowerRegistry.isAcceptedFlower(type, world, x, y, z)) {
            if (!blacklistedAcceptanceCaching.contains(type)) {
                EfficientFlowerCache.blockKey.read(world, x, y, z);
                if (blockKey.block.hasTileEntity(blockKey.metadata)) {
                    blacklistedAcceptanceCaching.add(type);
                } else {
                    cachedAcceptedBlocks.addValue((Object)type, (Object)EfficientFlowerCache.blockKey.asBlockKey());
                }
            }
            return true;
        }
        return false;
    }

    static {
        blacklistedAcceptanceCaching = new HashSet();
        cachedAcceptedBlocks = new MultiMap(MultiMap.CollectionType.HASHSET).setNullEmpty();
        blockKey = new MutableBlockKey();
    }

    private static class MutableBlockKey {
        private Block block;
        private int metadata;

        private MutableBlockKey() {
        }

        private void read(World world, int x, int y, int z) {
            this.block = world.func_147439_a(x, y, z);
            this.metadata = world.func_72805_g(x, y, z);
        }

        public int hashCode() {
            return this.block.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof BlockKey) {
                BlockKey b = (BlockKey)o;
                return b.blockID == this.block && (!this.hasMetadata() || !b.hasMetadata() || b.metadata == this.metadata);
            }
            if (o instanceof MutableBlockKey) {
                MutableBlockKey b = (MutableBlockKey)o;
                return b.block == this.block && (!this.hasMetadata() || !b.hasMetadata() || b.metadata == this.metadata);
            }
            return false;
        }

        private boolean hasMetadata() {
            return this.metadata >= 0 && this.metadata != Short.MAX_VALUE;
        }

        private BlockKey asBlockKey() {
            return new BlockKey(this.block, this.metadata);
        }
    }

    private class FlowerSearch {
        private static final int TICKSTEP = 512;
        private int readX;
        private int readY;
        private int readZ;
        private Coordinate found = null;

        private FlowerSearch() {
            this.readX = ((EfficientFlowerCache)EfficientFlowerCache.this).cachedTerritory.minX;
            this.readY = ((EfficientFlowerCache)EfficientFlowerCache.this).cachedTerritory.minY;
            this.readZ = ((EfficientFlowerCache)EfficientFlowerCache.this).cachedTerritory.minZ;
        }

        private boolean tick(World world) {
            for (int i = 0; i < 512; ++i) {
                if (EfficientFlowerCache.checkFlowerAcceptance(EfficientFlowerCache.this.cachedFlowerType, world, this.readX, this.readY, this.readZ)) {
                    this.found = new Coordinate(this.readX, this.readY, this.readZ);
                    return true;
                }
                this.updateReadPosition();
                if (this.readY <= ((EfficientFlowerCache)EfficientFlowerCache.this).cachedTerritory.maxY) continue;
                return true;
            }
            return false;
        }

        private void updateReadPosition() {
            boolean flag1 = false;
            boolean flag2 = false;
            ++this.readX;
            if (this.readX > ((EfficientFlowerCache)EfficientFlowerCache.this).cachedTerritory.maxX) {
                this.readX = ((EfficientFlowerCache)EfficientFlowerCache.this).cachedTerritory.minX;
                flag1 = true;
            }
            if (flag1) {
                ++this.readZ;
                if (this.readZ > ((EfficientFlowerCache)EfficientFlowerCache.this).cachedTerritory.maxZ) {
                    this.readZ = ((EfficientFlowerCache)EfficientFlowerCache.this).cachedTerritory.minZ;
                    flag2 = true;
                }
                if (flag2) {
                    ++this.readY;
                }
            }
        }

        private Coordinate getCoordinate() {
            return this.found;
        }
    }

    private class FlowerMatch
    implements BlockCheck {
        private FlowerMatch() {
        }

        public boolean matchInWorld(World world, int x, int y, int z) {
            return EfficientFlowerCache.checkFlowerAcceptance(EfficientFlowerCache.this.cachedFlowerType, world, x, y, z);
        }

        public boolean match(Block b, int meta) {
            return false;
        }

        public boolean match(BlockCheck bc) {
            return false;
        }

        public void place(World world, int x, int y, int z, int flags) {
        }

        public ItemStack asItemStack() {
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack getDisplay() {
            return null;
        }

        public BlockKey asBlockKey() {
            return null;
        }
    }
}

