/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Block.Dye.BlockRainbowLeaf;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.ModInterface.Bees.ChromaBeeHelpers;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.ModInterface.Bees.ProductChecks;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Auxiliary.ModularLogger;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.GUI.StatusLogger;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BasicGene;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.BlockCheckFlowerProvider;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAlleleFlowers;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFlowerProvider;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FlowerAlleles {

    static abstract class ConditionalProductFlowerProvider
    extends BlockCheckFlowerProvider
    implements ChromaBeeHelpers.ConditionalProductProvider {
        protected ConditionalProductFlowerProvider(Block b, int meta, String name) {
            super(b, meta, name);
        }

        protected ConditionalProductFlowerProvider(BlockCheck bk, String name) {
            super(bk, name);
        }

        public final ItemStack[] affectProducts(World world, IIndividual individual, int x, int y, int z, ItemStack[] products) {
            IBeeGenome ibg = ((IBee)individual).getGenome();
            IAlleleBeeSpecies bee1 = ibg.getPrimary();
            IAlleleBeeSpecies bee2 = ibg.getSecondary();
            IBeeHousing ibh = (IBeeHousing)world.func_147438_o(x, y, z);
            ArrayList li = ReikaJavaLibrary.makeListFromArray((Object[])products);
            ItemHashMap map = this.getConditions();
            ModularLogger.instance.log("CrystalBees", "Flower provider " + this.getDescription() + " affecting products " + li + " for " + bee1.getName() + "; map=" + map);
            if (map != null) {
                Iterator it = li.iterator();
                while (it.hasNext()) {
                    ItemStack is = (ItemStack)it.next();
                    ProductChecks.ProductCondition c = (ProductChecks.ProductCondition)map.get(is);
                    ModularLogger.instance.log("CrystalBees", "Check for " + is.func_82833_r() + ": " + c);
                    if (c == null) continue;
                    boolean flag = false;
                    if (bee1.getUID().equals(bee2.getUID()) && this.isBeeAllowed(bee1.getUID())) {
                        if (this.areConditionalsAvailable(world, x, y, z, ibg, ibh)) {
                            ibh.getErrorLogic().setCondition(false, CrystalBees.conditionalsUnavailable);
                            if (c.check(world, x, y, z, ibg, ibh)) {
                                ModularLogger.instance.log("CrystalBees", "Check " + c.toString() + " for " + is.func_82833_r() + " passed.");
                                flag = true;
                            } else {
                                ModularLogger.instance.log("CrystalBees", "Check " + c.toString() + " for " + is.func_82833_r() + " failed.");
                            }
                        } else {
                            ModularLogger.instance.log("CrystalBees", "Conditionals unavailable. Removing.");
                            ibh.getErrorLogic().setCondition(true, CrystalBees.conditionalsUnavailable);
                        }
                    }
                    if (flag) continue;
                    ModularLogger.instance.log("CrystalBees", "Check for " + is.func_82833_r() + " failed. Removing.");
                    it.remove();
                }
            }
            ItemStack[] ret = li.toArray(new ItemStack[li.size()]);
            return ret;
        }

        protected abstract boolean areConditionalsAvailable(World var1, int var2, int var3, int var4, IBeeGenome var5, IBeeHousing var6);

        protected abstract boolean isBeeAllowed(String var1);
    }

    static class FlowerProviderCrystal
    extends ConditionalProductFlowerProvider {
        public final CrystalElement color;

        private FlowerProviderCrystal(CrystalElement color) {
            super(ChromaBlocks.CRYSTAL.getBlockInstance(), color.ordinal(), color.name().toLowerCase(Locale.ENGLISH));
            this.color = color;
        }

        public String getDescription() {
            return this.color.displayName;
        }

        @Override
        protected boolean areConditionalsAvailable(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            if (!this.matchFlowerGene(ibg)) {
                return false;
            }
            if (CrystalBees.rand.nextFloat() > ibg.getSpeed()) {
                return false;
            }
            if (ibg.getFlowering() < BeeAlleleRegistry.Flowering.AVERAGE.getAllele().getValue()) {
                return false;
            }
            if (!ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)) && CrystalBees.rand.nextInt(2) > 0) {
                return false;
            }
            if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z))) {
                return false;
            }
            if (CrystalBees.rand.nextInt(2) > 0 && !ChromaBeeHelpers.isBestPossibleBee(ibg)) {
                return false;
            }
            return CrystalBees.rand.nextInt(3) > 0 || ChromaBeeHelpers.checkProgression(world, ibh, ProgressStage.SHARDCHARGE);
        }

        private boolean matchFlowerGene(IBeeGenome ibg) {
            return ibg.getFlowerProvider() instanceof FlowerProviderCrystal && ((FlowerProviderCrystal)ibg.getFlowerProvider()).color == this.color;
        }

        @Override
        public ItemHashMap<ProductChecks.ProductCondition> getConditions() {
            return CrystalBees.productConditions.get(this.color);
        }

        @Override
        public ArrayList<String> getGeneralRequirements() {
            ArrayList<String> li = new ArrayList<String>();
            li.add("Unmodified flower allele");
            li.add("'" + BeeAlleleRegistry.Flowering.AVERAGE.getAllele().getName() + "' flowering");
            li.add("Ambient temperature between 8C and 32C");
            li.add("50% boost from Rainbow Forest");
            li.add("50% boost from genetic superiority");
            li.add("33% boost from '" + ProgressStage.SHARDCHARGE.getTitle() + "' progression");
            li.add("Linear gains from faster production speeds");
            return li;
        }

        @Override
        public void sendStatusInfo(World world, int x, int y, int z, StatusLogger log, IBeeGenome ibg, IBeeHousing ibh) {
            log.addStatus("Flower Allele", this.matchFlowerGene(ibg));
            log.addStatus("Flowering Level", ibg.getFlowering() >= BeeAlleleRegistry.Flowering.AVERAGE.getAllele().getValue());
            log.addStatus("Temperature", ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z)));
            log.addStatus("Rainbow Forest", ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)));
            log.addStatus("Gene Superiority", ChromaBeeHelpers.isBestPossibleBee(ibg));
            log.addStatus("Boosted Shard Progression", ChromaBeeHelpers.checkProgression(world, ibh, ProgressStage.SHARDCHARGE));
            for (ProductChecks.ProductCondition p : this.getConditions().values()) {
                log.addStatus(p.getDescription(), p.check(world, x, y, z, ibg, ibh));
            }
        }

        @Override
        protected boolean isBeeAllowed(String uid) {
            return uid.equals(CrystalBees.beeMap.get(this.color).getUID());
        }
    }

    static class FlowerProviderMulti
    extends ConditionalProductFlowerProvider
    implements ChromaBeeHelpers.ConditionalProductProvider {
        static final ItemHashMap<ProductChecks.ProductCondition> conditions = new ItemHashMap();

        private FlowerProviderMulti() {
            super(FlowerProviderMulti.createKey(), "Rainbow Leaves");
        }

        private static BlockCheck createKey() {
            FilledBlockArray.MultiKey mk = new FilledBlockArray.MultiKey();
            mk.add((BlockCheck)new BlockKey(ChromaBlocks.RAINBOWLEAF.getBlockInstance(), BlockRainbowLeaf.LeafMetas.BASIC.ordinal()));
            mk.add((BlockCheck)new BlockKey(ChromaBlocks.RAINBOWLEAF.getBlockInstance(), BlockRainbowLeaf.LeafMetas.SMALL.ordinal()));
            mk.add((BlockCheck)new BlockKey(ChromaBlocks.RAINBOWLEAF.getBlockInstance(), BlockRainbowLeaf.LeafMetas.TILE.ordinal()));
            return mk;
        }

        public String getDescription() {
            return "Shimmering, multicolored leaves";
        }

        @Override
        protected boolean areConditionalsAvailable(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            if (!this.matchFlowerGene(ibg)) {
                return false;
            }
            if (CrystalBees.rand.nextFloat() > ibg.getSpeed() / 4.0f) {
                return false;
            }
            if (ibg.getFlowering() < CrystalBees.superFlowering.getAllele().getValue()) {
                return false;
            }
            if (!ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)) && CrystalBees.rand.nextInt(2) > 0) {
                return false;
            }
            if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z))) {
                return false;
            }
            if (CrystalBees.rand.nextInt(2) > 0 && !ChromaBeeHelpers.isBestPossibleBee(ibg)) {
                return false;
            }
            return CrystalBees.rand.nextInt(3) > 0 || ChromaBeeHelpers.checkProgression(world, ibh, ProgressStage.DIMENSION);
        }

        private boolean matchFlowerGene(IBeeGenome ibg) {
            return ibg.getFlowerProvider() instanceof FlowerProviderMulti;
        }

        @Override
        public ItemHashMap<ProductChecks.ProductCondition> getConditions() {
            return conditions;
        }

        @Override
        public ArrayList<String> getGeneralRequirements() {
            ArrayList<String> li = new ArrayList<String>();
            li.add("Unmodified flower allele");
            li.add("'" + CrystalBees.superFlowering.getAllele().getName() + "' flowering");
            li.add("Ambient temperature between 8C and 32C");
            li.add("50% boost from Rainbow Forest");
            li.add("50% boost from genetic superiority");
            li.add("33% boost from '" + ProgressStage.DIMENSION.getTitle() + "' progression");
            li.add("Linear gains from faster production speeds");
            return li;
        }

        @Override
        public void sendStatusInfo(World world, int x, int y, int z, StatusLogger log, IBeeGenome ibg, IBeeHousing ibh) {
            log.addStatus("Flower Allele", this.matchFlowerGene(ibg));
            log.addStatus("Flowering Level", ibg.getFlowering() >= CrystalBees.superFlowering.getAllele().getValue());
            log.addStatus("Temperature", ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z)));
            log.addStatus("Rainbow Forest", ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)));
            log.addStatus("Gene Superiority", ChromaBeeHelpers.isBestPossibleBee(ibg));
            log.addStatus("Dimension Progression", ChromaBeeHelpers.checkProgression(world, ibh, ProgressStage.DIMENSION));
            for (ProductChecks.ProductCondition p : this.getConditions().values()) {
                log.addStatus(p.getDescription(), p.check(world, x, y, z, ibg, ibh));
            }
        }

        @Override
        protected boolean isBeeAllowed(String uid) {
            return uid.equals(CrystalBees.multi.getUID());
        }
    }

    static class MetaAlloyFlowers
    extends ConditionalProductFlowerProvider
    implements ChromaBeeHelpers.ConditionalProductProvider {
        static final ItemHashMap<ProductChecks.ProductCondition> conditions = new ItemHashMap();

        private MetaAlloyFlowers() {
            super(ChromaBlocks.METAALLOYLAMP.getBlockInstance(), 1, ChromaBlocks.METAALLOYLAMP.getBasicName());
        }

        public String getDescription() {
            return "Mysterious glowing pods";
        }

        @Override
        protected boolean areConditionalsAvailable(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            if (!this.matchFlowerGene(ibg)) {
                return false;
            }
            if (CrystalBees.rand.nextFloat() > ibg.getSpeed() / 4.0f) {
                return false;
            }
            if (ibg.getFlowering() < CrystalBees.superFlowering.getAllele().getValue()) {
                return false;
            }
            if (!ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)) && CrystalBees.rand.nextInt(2) > 0) {
                return false;
            }
            if (!ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z))) {
                return false;
            }
            return CrystalBees.rand.nextInt(2) <= 0 || ChromaBeeHelpers.isBestPossibleBee(ibg);
        }

        private boolean matchFlowerGene(IBeeGenome ibg) {
            return ibg.getFlowerProvider() instanceof FlowerProviderMulti;
        }

        @Override
        public ItemHashMap<ProductChecks.ProductCondition> getConditions() {
            return conditions;
        }

        @Override
        public ArrayList<String> getGeneralRequirements() {
            ArrayList<String> li = new ArrayList<String>();
            li.add("Unmodified flower allele");
            li.add("'" + CrystalBees.superFlowering.getAllele().getName() + "' flowering");
            li.add("Ambient temperature between 8C and 32C");
            li.add("50% boost from Rainbow Forest");
            li.add("50% boost from genetic superiority");
            li.add("33% boost from '" + ProgressStage.DIMENSION.getTitle() + "' progression");
            li.add("Linear gains from faster production speeds");
            return li;
        }

        @Override
        public void sendStatusInfo(World world, int x, int y, int z, StatusLogger log, IBeeGenome ibg, IBeeHousing ibh) {
            log.addStatus("Flower Allele", this.matchFlowerGene(ibg));
            log.addStatus("Flowering Level", ibg.getFlowering() >= CrystalBees.superFlowering.getAllele().getValue());
            log.addStatus("Temperature", ReikaMathLibrary.isValueInsideBoundsIncl((int)8, (int)32, (int)ReikaWorldHelper.getAmbientTemperatureAt((World)world, (int)x, (int)y, (int)z)));
            log.addStatus("Rainbow Forest", ChromatiCraft.isRainbowForest(world.func_72807_a(x, z)));
            log.addStatus("Gene Superiority", ChromaBeeHelpers.isBestPossibleBee(ibg));
            log.addStatus("Dimension Progression", ChromaBeeHelpers.checkProgression(world, ibh, ProgressStage.DIMENSION));
            for (ProductChecks.ProductCondition p : this.getConditions().values()) {
                log.addStatus(p.getDescription(), p.check(world, x, y, z, ibg, ibh));
            }
        }

        @Override
        protected boolean isBeeAllowed(String uid) {
            return uid.equals(CrystalBees.precursor) || uid.equals(CrystalBees.ua) || uid.equals(CrystalBees.tower);
        }
    }

    static final class MetaAlloyAllele
    extends BasicGene
    implements IAlleleFlowers {
        private final MetaAlloyFlowers provider = new MetaAlloyFlowers();

        public MetaAlloyAllele() {
            super("flower.metaalloy", ChromaBlocks.METAALLOYLAMP.getBasicName(), (IChromosomeType)EnumBeeChromosome.FLOWER_PROVIDER);
        }

        public IFlowerProvider getProvider() {
            return this.provider;
        }
    }

    static final class MultiAllele
    extends BasicGene
    implements IAlleleFlowers {
        private final FlowerProviderMulti provider = new FlowerProviderMulti();

        public MultiAllele() {
            super("flower.rainbowleaf", "Rainbow Leaves", (IChromosomeType)EnumBeeChromosome.FLOWER_PROVIDER);
        }

        public IFlowerProvider getProvider() {
            return this.provider;
        }
    }

    static final class CrystalAllele
    extends BasicGene
    implements IAlleleFlowers {
        public final CrystalElement color;
        private final FlowerProviderCrystal provider;

        public CrystalAllele(CrystalElement color) {
            super("flower.cavecrystal." + color.name().toLowerCase(Locale.ENGLISH), color.displayName, (IChromosomeType)EnumBeeChromosome.FLOWER_PROVIDER);
            this.color = color;
            this.provider = new FlowerProviderCrystal(color);
        }

        public IFlowerProvider getProvider() {
            return this.provider;
        }
    }
}

