/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.API.Event.CrystalGenEvent;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.World.IWG.CrystalGenerator;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.BlockFluidBase;

public class HiveGenerator
implements IWorldGenerator {
    public static final HiveGenerator instance = new HiveGenerator();
    public static final int PER_CHUNK = 5;

    private HiveGenerator() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onGenCrystal(CrystalGenEvent evt) {
        Block idb;
        int dim = evt.world.field_73011_w.field_76574_g;
        if (dim != -1 && dim != 1 && evt.color == CrystalElement.WHITE && evt.getRandomInt(4) == 0 && (idb = evt.world.func_147439_a(evt.xCoord, evt.yCoord - 1, evt.zCoord)).isReplaceableOreGen(evt.world, evt.xCoord, evt.yCoord - 1, evt.zCoord, Blocks.field_150348_b)) {
            evt.world.func_147465_d(evt.xCoord, evt.yCoord - 1, evt.zCoord, ChromaBlocks.HIVE.getBlockInstance(), 1, 3);
        }
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76577_b == WorldType.field_77138_c) {
            return;
        }
        int dim = world.field_73011_w.field_76574_g;
        if (dim != -1 && dim != 1) {
            for (int i = 0; i < 5; ++i) {
                int x = chunkX * 16 + random.nextInt(16);
                int z = chunkZ * 16 + random.nextInt(16);
                int maxy = 64;
                if (world.field_73011_w.field_76575_d) {
                    maxy = 128;
                }
                int posY = 4 + random.nextInt(maxy - 4);
                Block block = ChromaBlocks.HIVE.getBlockInstance();
                int meta = 0;
                if (!this.canGenerateAt(world, x, posY, z)) continue;
                world.func_147465_d(x, posY, z, block, meta, 3);
            }
        }
    }

    private boolean canGenerateAt(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b != Blocks.field_150350_a && !ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z)) {
            return false;
        }
        if (b instanceof BlockLiquid) {
            return false;
        }
        if (b instanceof BlockFluidBase) {
            return false;
        }
        Block idb = world.func_147439_a(x, y - 1, z);
        if (idb == Blocks.field_150350_a) {
            return false;
        }
        int metab = world.func_72805_g(x, y - 1, z);
        int metaa = world.func_72805_g(x, y + 1, z);
        if (!CrystalGenerator.canGenerateOn(world, x, y - 1, z)) {
            return false;
        }
        if (idb instanceof BlockLiquid) {
            return false;
        }
        if (idb instanceof BlockFluidBase) {
            return false;
        }
        return ReikaWorldHelper.checkForAdjBlock((World)world, (int)x, (int)y, (int)z, (Block)Blocks.field_150350_a) != null;
    }
}

