/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityLocusPoint;
import Reika.ChromatiCraft.Block.Dye.BlockRainbowLeaf;
import Reika.ChromatiCraft.Magic.Progression.ProgressStage;
import Reika.ChromatiCraft.ModInterface.Bees.ChromaBeeHelpers;
import Reika.ChromatiCraft.ModInterface.Bees.TileEntityLumenAlveary;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.AOE.TileEntityAuraPoint;
import Reika.ChromatiCraft.TileEntity.Plants.TileEntityCrystalPlant;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityAuraInfuser;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.Data.WeightedRandom;
import Reika.DragonAPI.Interfaces.BlockCheck;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ProductChecks {

    static class RainbowTreeCheck
    extends ProductCondition {
        private final AreaBlockCheck check;

        RainbowTreeCheck() {
            FilledBlockArray.MultiKey mk = new FilledBlockArray.MultiKey();
            for (BlockRainbowLeaf.LeafMetas lm : BlockRainbowLeaf.LeafMetas.list) {
                if (lm == BlockRainbowLeaf.LeafMetas.PLACED) continue;
                mk.add((BlockCheck)new BlockKey(ChromaBlocks.RAINBOWLEAF.getBlockInstance(), lm.ordinal()));
            }
            this.check = new AreaBlockCheck((BlockCheck)mk, 3, 2);
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.check.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public String getDescription() {
            return "Rainbow Leaves";
        }
    }

    static class ChargedShardCheck
    extends ProductCondition {
        private final CrystalElement color;
        private final AreaBlockCheck crystal;
        private final AreaBlockCheck chroma;
        private final LeafCheck leaf;
        private final ProgressionCheck progress;

        ChargedShardCheck(CrystalElement e) {
            this.color = e;
            this.leaf = new LeafCheck(e);
            this.chroma = new AreaBlockCheck((BlockCheck)new BlockKey(ChromaBlocks.CHROMA.getBlockInstance(), 0), 1);
            FilledBlockArray.MultiKey crys = new FilledBlockArray.MultiKey();
            crys.add((BlockCheck)new BlockKey(ChromaBlocks.CRYSTAL.getBlockInstance(), this.color.ordinal()));
            crys.add((BlockCheck)new BlockKey(ChromaBlocks.SUPER.getBlockInstance(), this.color.ordinal()));
            this.crystal = new AreaBlockCheck((BlockCheck)crys, 1);
            this.progress = new ProgressionCheck(ProgressStage.SHARDCHARGE);
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.progress.check(world, x, y, z, ibg, ibh) && this.crystal.check(world, x, y, z, ibg, ibh) && this.chroma.check(world, x, y, z, ibg, ibh) && this.leaf.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public String getDescription() {
            return "Liquid Chroma, " + this.color.displayName + " Tree and Crystal";
        }
    }

    static class LeafCheck
    extends ProductCondition {
        private final CrystalElement color;
        private final AreaBlockCheck check;

        LeafCheck(CrystalElement e) {
            this.color = e;
            FilledBlockArray.MultiKey mk = new FilledBlockArray.MultiKey();
            mk.add((BlockCheck)new BlockKey(ChromaBlocks.DECAY.getBlockInstance(), this.color.ordinal()));
            this.check = new AreaBlockCheck((BlockCheck)mk, 2, 2);
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.check.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public String getDescription() {
            return this.color.displayName + " Dye Leaves";
        }
    }

    static class FlowerCheck
    extends ProductCondition {
        private final CrystalElement color;
        private final AreaBlockCheck check;

        FlowerCheck(CrystalElement e) {
            this.color = e;
            this.check = new AreaBlockCheck((BlockCheck)new BlockKey(ChromaBlocks.DYEFLOWER.getBlockInstance(), this.color.ordinal()), 1);
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.check.check(world, x, y, z, ibg, ibh);
        }

        @Override
        public String getDescription() {
            return this.color.displayName + " Dye Flowers";
        }
    }

    static class CrystalPlantCheck
    extends ProductCondition {
        private final CrystalElement color;
        private final AreaBlockCheck check;

        CrystalPlantCheck(CrystalElement e) {
            this.color = e;
            this.check = new AreaBlockCheck((BlockCheck)new BlockKey(ChromaBlocks.PLANT.getBlockInstance(), this.color.ordinal()), 1);
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            if (this.check.check(world, x, y, z, ibg, ibh)) {
                if (world.field_73012_v.nextInt(30) == 0) {
                    WorldLocation loc = ChromaBeeHelpers.getLocation(ibh);
                    Coordinate plant = (Coordinate)this.check.successfulChecks.get(loc);
                    TileEntityCrystalPlant te = (TileEntityCrystalPlant)plant.getTileEntity((IBlockAccess)world);
                    te.setState(TileEntityCrystalPlant.Modifier.BOOSTED);
                    if (world.field_73012_v.nextInt(30) == 0) {
                        te.setState(TileEntityCrystalPlant.Modifier.PRIMAL);
                    }
                }
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.color.displayName + " Crystal Bloom";
        }
    }

    static class ProgressionCheck
    extends ProductCondition {
        private final ProgressStage progress;

        ProgressionCheck(ProgressStage p) {
            this.progress = p;
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            return this.progress.isPlayerAtStage(world, ibh.getOwner().getId());
        }

        @Override
        public String getDescription() {
            String s = this.progress.getTitle();
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                s = this.obfuscateIf(s);
            }
            return "Progression '" + s + "'";
        }

        @SideOnly(value=Side.CLIENT)
        private String obfuscateIf(String s) {
            EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
            if (!this.progress.isOneStepAway((EntityPlayer)ep) && !this.progress.playerHasPrerequisites((EntityPlayer)ep)) {
                s = EnumChatFormatting.OBFUSCATED.toString() + s;
            }
            return s;
        }
    }

    static class AreaBlockCheck
    extends ProductCondition {
        private final BlockCheck check;
        private final int stepSize;
        private final int stepSizeY;
        private final HashMap<WorldLocation, Coordinate> successfulChecks = new HashMap();
        private final HashSet<WorldLocation> testedCoordinates = new HashSet();
        private static final WeightedRandom<Double> rangeRandom = new WeightedRandom();
        private static final int SEARCH_LOCS = 16;

        AreaBlockCheck(BlockCheck bk, int s) {
            this(bk, s, s);
        }

        AreaBlockCheck(BlockCheck bk, int s, int sy) {
            this.check = bk;
            this.stepSize = s;
            this.stepSizeY = sy;
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            int[] r = ChromaBeeHelpers.getSearchRange(ibg, ibh);
            WorldLocation loc = ChromaBeeHelpers.getLocation(ibh);
            Coordinate c = this.successfulChecks.get(loc);
            if (c != null && !this.validate(world, loc, c, r[0], r[1])) {
                c = null;
            }
            if (c == null) {
                Coordinate find = this.check(world, x, y, z, loc, r[0], r[1]);
                this.testedCoordinates.add(loc);
                if (find != null) {
                    this.successfulChecks.put(loc, find);
                    c = find;
                } else {
                    this.successfulChecks.remove(loc);
                }
            }
            return c != null;
        }

        private boolean validate(World world, WorldLocation loc, Coordinate c, int r, int vr) {
            if (!c.isWithinSquare(new Coordinate(loc), r, vr, r)) {
                return false;
            }
            return this.check.matchInWorld(world, c.xCoord, c.yCoord, c.zCoord);
        }

        private Coordinate check(World world, int x, int y, int z, WorldLocation loc, int r, int vr) {
            double f;
            double d = f = this.testedCoordinates.contains(loc) ? (Double)rangeRandom.getRandomEntry() : -1.0;
            if (f == -1.0) {
                for (int i = -r; i <= r; i += this.stepSize) {
                    for (int k = -r; k <= r; k += this.stepSize) {
                        for (int h = -vr; h <= vr; h += this.stepSizeY) {
                            int dx = x + i;
                            int dy = y + h;
                            int dz = z + k;
                            if (!this.check.matchInWorld(world, dx, dy, dz)) continue;
                            return new Coordinate(dx, dy, dz);
                        }
                    }
                }
            } else {
                int dr = (int)(f * (double)r);
                int dvr = (int)(f * (double)vr);
                for (int i = 0; i < 16; ++i) {
                    int dz;
                    int dy;
                    int dx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)dr);
                    if (!this.check.matchInWorld(world, dx, dy = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)dvr), dz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)dr))) continue;
                    return new Coordinate(dx, dy, dz);
                }
            }
            return null;
        }

        @Override
        public String getDescription() {
            return this.check.asItemStack().func_82833_r();
        }

        static {
            rangeRandom.addEntry((Object)-1.0, 1.0);
            rangeRandom.addEntry((Object)1.0, 4.0);
            rangeRandom.addEntry((Object)0.75, 6.0);
            rangeRandom.addEntry((Object)0.5, 8.0);
            rangeRandom.addEntry((Object)0.25, 16.0);
            rangeRandom.addEntry((Object)0.125, 32.0);
        }
    }

    static class AuraLocusCheck
    extends ProductCondition {
        AuraLocusCheck() {
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            UUID ep = ChromaBeeHelpers.getOwner(ibh);
            if (ep == null) {
                return false;
            }
            if (!TileEntityLocusPoint.hasLoci(TileEntityAuraPoint.class, ep)) {
                return false;
            }
            TileEntityLumenAlveary tel = ChromaBeeHelpers.getLumenAlvearyController(ibh, world, ibh.getCoordinates());
            if (tel != null && tel.hasInfiniteAwareness()) {
                return true;
            }
            int[] r = ChromaBeeHelpers.getSearchRange(ibg, ibh);
            WorldLocation loc = TileEntityAuraPoint.getMatchFromCache(TileEntityAuraPoint.class, ep, te -> Math.abs(te.xCoord - x) <= r[0] && Math.abs(te.zCoord - z) <= r[0] && Math.abs(te.yCoord - y) <= r[1]);
            return loc != null;
        }

        @Override
        public String getDescription() {
            return "A nearby Aura Locus";
        }
    }

    static class IridescentShardCheck
    extends ProductCondition {
        IridescentShardCheck() {
        }

        @Override
        public boolean check(World world, int x, int y, int z, IBeeGenome ibg, IBeeHousing ibh) {
            int r;
            IBeeModifier beeModifier = BeeManager.beeRoot.createBeeHousingModifier(ibh);
            int tr = (int)((float)ibg.getTerritory()[0] * 3.0f * beeModifier.getTerritoryModifier(ibg, 1.0f));
            int n = r = tr >= 64 ? 128 : MathHelper.func_76125_a((int)(16 * ReikaMathLibrary.intpow2((int)2, (int)((tr - 9) / 2))), (int)16, (int)96);
            int r2 = r >= 64 ? 24 : (r >= 32 ? 16 : (r >= 16 ? 12 : 8));
            UUID id = ibh.getOwner().getId();
            if (id == null) {
                return false;
            }
            if (!ProgressStage.ALLOY.isPlayerAtStage(world, id)) {
                return false;
            }
            TileEntityAuraInfuser te = this.check(world, x, y, z, r2, r2, ibh);
            return te != null && te.hasStructure() && te.isOwnedByPlayer(id);
        }

        private TileEntityAuraInfuser check(World world, int x, int y, int z, int r, int vr, IBeeHousing ibh) {
            WorldLocation find = TileEntityAuraInfuser.searchForMatch(loc -> {
                if ((loc.isWithinSquare(world, x, y, z, r, vr, r) || ChromaBeeHelpers.isLumenAlvearyInfSight(ibh)) && ChromaTiles.getTile((IBlockAccess)world, loc.xCoord, loc.yCoord, loc.zCoord) == ChromaTiles.INFUSER) {
                    TileEntity te = loc.getTileEntity((IBlockAccess)world);
                    return te instanceof TileEntityAuraInfuser;
                }
                return false;
            });
            return find != null ? (TileEntityAuraInfuser)find.getTileEntity((IBlockAccess)world) : null;
        }

        @Override
        public String getDescription() {
            return "An operational infusion ring";
        }
    }

    public static abstract class ProductCondition {
        public abstract boolean check(World var1, int var2, int var3, int var4, IBeeGenome var5, IBeeHousing var6);

        public abstract String getDescription();

        public final String toString() {
            return this.getClass().getSimpleName() + ": " + this.getDescription();
        }
    }
}

