/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityMassStorage;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.ISpeciesType;
import java.util.Random;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityBeeStorage
extends TileEntityMassStorage {
    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    private GeneticsType filter;
    @SideOnly(value=Side.CLIENT)
    private InertItem render;

    public TileEntityBeeStorage() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.initClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initClient() {
        this.render = new InertItem((World)Minecraft.func_71410_x().field_71441_e, new ItemStack(Blocks.field_150348_b));
    }

    @SideOnly(value=Side.CLIENT)
    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public void setFilter(GeneticsType s) {
        this.filter = s;
    }

    @Override
    protected void onAddItem(ItemStack is) {
        if (ModList.FORESTRY.isLoaded() && this.filter == null) {
            this.filter = this.getGeneItemType(is);
        }
    }

    @Override
    protected void onRemoveItem(ItemStack is) {
        if (this.isEmpty()) {
            this.filter = null;
        }
    }

    @Override
    protected void onTick(World world, int x, int y, int z) {
        if (world.field_72995_K && this.getTicksExisted() % 20 == Math.abs(System.identityHashCode((Object)this)) % 20) {
            Set<KeyedItemStack> li = this.getItemTypes().keySet();
            KeyedItemStack is = li.isEmpty() ? null : (KeyedItemStack)ReikaJavaLibrary.getRandomCollectionEntry((Random)rand, li);
            this.render.func_92058_a(is != null ? is.getItemStack() : new ItemStack(Blocks.field_150348_b));
        }
    }

    @Override
    public InertItem getFilterItemRender() {
        return this.render;
    }

    @Override
    protected KeyedItemStack key(ItemStack is) {
        return new KeyedItemStack(this.filterKey(is)).setIgnoreMetadata(true).setIgnoreNBT(false).setSized(false).setSimpleHash(true);
    }

    private ItemStack filterKey(ItemStack is) {
        is = is.func_77946_l();
        if (is.field_77990_d != null) {
            is = ReikaBeeHelper.convertToBasicSpeciesTemplate((ItemStack)is);
        }
        return is;
    }

    @Override
    public boolean isItemValid(ItemStack is) {
        GeneticsType f = this.getGeneItemType(is);
        if (f == null) {
            return false;
        }
        return this.filter == null || f.comparator == this.filter.comparator;
    }

    private GeneticsType getGeneItemType(ItemStack is) {
        ISpeciesType type = ReikaBeeHelper.getSpeciesType((ItemStack)is);
        if (type != null) {
            return new SpeciesType(type);
        }
        if (is.func_77973_b() == ReikaBeeHelper.getGendustrySampleItem() || is.func_77973_b() == ReikaBeeHelper.getBinnieSampleItem()) {
            return new ItemType(is.func_77973_b());
        }
        return null;
    }

    @Override
    public int maxItemCount() {
        return 1000000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.BEESTORAGE;
    }

    @Override
    protected boolean canPullFromME() {
        return this.filter != null;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        if (this.filter != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("class", this.filter.getClass().getName());
            tag.func_74778_a("field", this.filter.lookupKey());
            NBT.func_74782_a("filtertype", (NBTBase)tag);
        }
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        if (NBT.func_74764_b("filtertype")) {
            NBTTagCompound tag = NBT.func_74775_l("filtertype");
            String cl = tag.func_74779_i("class");
            String f = tag.func_74779_i("field");
            Class<?> c = null;
            try {
                c = Class.forName(cl);
                if (c == SpeciesType.class) {
                    this.filter = SpeciesType.construct(f);
                } else if (ISpeciesType.class.isAssignableFrom(c)) {
                    this.filter = new SpeciesType((ISpeciesType)Enum.valueOf(c, f));
                } else if (c == ItemType.class) {
                    this.filter = ItemType.construct(f);
                }
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)"Failed to load genetics storage data from disk");
                e.printStackTrace();
            }
        }
    }

    private static abstract class GeneticsType<T> {
        protected final T comparator;

        protected GeneticsType(T obj) {
            this.comparator = obj;
        }

        protected abstract String lookupKey();

        public final boolean equals(Object o) {
            return o != null && o.getClass() == this.getClass() && this.comparator == ((GeneticsType)o).comparator;
        }
    }

    private static class ItemType
    extends GeneticsType<Item> {
        protected ItemType(Item obj) {
            super(obj);
        }

        @Override
        protected String lookupKey() {
            return Item.field_150901_e.func_148750_c(this.comparator);
        }

        private static ItemType construct(String s) {
            return new ItemType((Item)Item.field_150901_e.func_82594_a(s));
        }
    }

    private static class SpeciesType
    extends GeneticsType<ISpeciesType> {
        protected SpeciesType(ISpeciesType obj) {
            super(obj);
        }

        @Override
        protected String lookupKey() {
            return ((ISpeciesType)this.comparator).getClass().getName() + "#" + ((Enum)this.comparator).name();
        }

        private static SpeciesType construct(String s) throws Exception {
            String[] parts = s.split("#");
            return new SpeciesType((ISpeciesType)Enum.valueOf(Class.forName(parts[0]), parts[1]));
        }
    }
}

