/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.Bees;

import Reika.ChromatiCraft.Base.TileEntity.TileEntityRelayPowered;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.ModInterface.Bees.ChromaBeeHelpers;
import Reika.ChromatiCraft.ModInterface.Bees.CrystalBees;
import Reika.ChromatiCraft.ModInterface.Bees.EffectAlleles;
import Reika.ChromatiCraft.ModInterface.Bees.EfficientFlowerCache;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.InertItem;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Interfaces.TileEntity.CopyableSettings;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.Bees.BeeAlleleRegistry;
import Reika.DragonAPI.ModInteract.Bees.DummyEffectData;
import Reika.DragonAPI.ModInteract.Bees.ReikaBeeHelper;
import Reika.DragonAPI.ModInteract.DeepInteract.ForestryMultiblockControllerHandling;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModList;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IClimateControlled;
import forestry.api.core.INBTTagable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.api.multiblock.IAlvearyController;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogicAlveary;
import forestry.api.multiblock.MultiblockManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.visnet.VisNetHandler;

@APIStripper.Strippable(value={"forestry.api.multiblock.IAlvearyComponent", "forestry.api.multiblock.IAlvearyComponent$BeeModifier", "forestry.api.multiblock.IAlvearyComponent$BeeListener", "forestry.api.apiculture.IBeeModifier", "forestry.api.apiculture.IBeeListener", "thaumcraft.api.aspects.IEssentiaTransport", "thaumcraft.api.aspects.IAspectContainer"})
public class TileEntityLumenAlveary
extends TileEntityRelayPowered
implements GuiController,
IAlvearyComponent,
IAlvearyComponent.BeeModifier,
IAlvearyComponent.BeeListener,
IBeeModifier,
IBeeListener,
CopyableSettings<TileEntityLumenAlveary>,
IEssentiaTransport,
IAspectContainer {
    private static final HashMap<String, AlvearyEffect> effectSet = new HashMap();
    private static final HashSet<AlvearyEffect> continualSet = new HashSet();
    private static final HashSet<AlvearyEffect> clientSet = new HashSet();
    private static final GeneticRepairEffect geneRepair2;
    private static final AutomationEffect automation;
    private static final PlayerRestrictionEffect playerOnlyEffects;
    private static final InfiniteSightEffect infiniteRange;
    private static final OmnipresentEffectEffect omnipresence;
    private static final EnumMap<CrystalElement, ElementalBoostEffect> colorEffects;
    public static final Comparator<AlvearyEffect> effectSorter;
    private static Field tempField;
    private static Field humidField;
    private static Field flowerCacheField;
    private static Field beeField;
    private static Class beeLogicClass;
    private static Class fakeLogicClass;
    private static Class beeClass;
    private Object logic;
    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    private AspectList aspects;
    private static final int VIS_LIMIT = 200;
    private Coordinate relativeLocation;
    private int lightningTicks;
    private String movePrincess;
    private String moveDrone;
    private final HashSet<String> selectedEffects = new HashSet();
    private final Collection<AlvearyEffect> activeEffects = new HashSet<AlvearyEffect>();
    private EfficientFlowerCache flowerCache;
    private EntityItem renderItem;
    private boolean multipleBoosters = false;
    private IBee cachedQueen;
    private boolean workNeedsUpdate;
    private boolean canWork;

    public static String getEffectsAsString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<AlvearyEffect> li = new ArrayList<AlvearyEffect>(effectSet.values());
        Collections.sort(li, effectSorter);
        for (AlvearyEffect ae : li) {
            sb.append(ae.getDescription());
            sb.append(" - ");
            if (ae instanceof LumenAlvearyEffect) {
                sb.append(((LumenAlvearyEffect)ae).color.displayName);
                sb.append(" (");
                sb.append(((LumenAlvearyEffect)ae).requiredEnergy);
                sb.append(" L/cycle)");
            } else if (ae instanceof VisAlvearyEffect) {
                sb.append(((VisAlvearyEffect)ae).aspect.getLocalizedDescription());
                sb.append(" (");
                sb.append(((VisAlvearyEffect)ae).requiredVis);
                sb.append(" cv/cycle)");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public TileEntityLumenAlveary() {
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.aspects = new AspectList();
        }
        if (ModList.FORESTRY.isLoaded()) {
            this.logic = MultiblockManager.logicFactory.createAlvearyLogic();
        }
        this.resetSelectedEffects();
    }

    @Override
    protected boolean makeRequests() {
        return this.isAlvearyComplete();
    }

    @Override
    protected boolean canReceiveFrom(CrystalElement e, ForgeDirection dir) {
        return this.isAlvearyComplete() && this.isSideOpen(dir) && this.isAcceptingColor(e);
    }

    private boolean isSideOpen(ForgeDirection dir) {
        switch (dir) {
            case DOWN: {
                return this.relativeLocation.yCoord == 0;
            }
            case UP: {
                return this.relativeLocation.yCoord == 2;
            }
            case WEST: {
                return this.relativeLocation.xCoord == 0;
            }
            case EAST: {
                return this.relativeLocation.xCoord == 2;
            }
            case NORTH: {
                return this.relativeLocation.zCoord == 0;
            }
            case SOUTH: {
                return this.relativeLocation.zCoord == 2;
            }
        }
        return false;
    }

    public Coordinate getRelativeLocation() {
        return this.relativeLocation;
    }

    public Coordinate getAlvearyCenter() {
        return this.relativeLocation != null ? this.relativeLocation.negate().offset(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e + 1) : null;
    }

    public boolean isAlvearyComplete() {
        return this.relativeLocation != null && !this.multipleBoosters;
    }

    public boolean hasMultipleBoosters() {
        return this.multipleBoosters;
    }

    @Override
    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateEntity(world, x, y, z, meta);
        if (ModList.FORESTRY.isLoaded()) {
            if (this.multipleBoosters) {
                // empty if block
            }
            if (this.isAlvearyComplete()) {
                if (!world.field_72995_K && this.getTicksExisted() % 16 == Math.abs(System.identityHashCode(this)) % 16) {
                    this.canWork = this.calcCanWork();
                    this.workNeedsUpdate = false;
                    this.validateCachedQueen(true);
                }
                if (world.field_72995_K) {
                    this.doParticles(world, x, y, z);
                    for (AlvearyEffect ae : clientSet) {
                        if (!this.selectedEffects.contains(ae.ID) || !ae.ticksOnClient() || !ae.isActive(this) || ae.tickRate() != 1 && this.getTicksExisted() % ae.tickRate() != 0) continue;
                        ae.clientTick(this);
                    }
                    if (!this.canWork && this.cachedQueen != null && this.getTicksExisted() % 32 == 0) {
                        this.syncAllData(false);
                    }
                }
                if (this.hasQueen()) {
                    if (this.getTicksExisted() % 8 == 0) {
                        this.replaceFlowerCacher();
                    }
                    this.activeEffects.clear();
                    if (this.canQueenWork()) {
                        for (AlvearyEffect ae : effectSet.values()) {
                            if (this.selectedEffects.contains(ae.ID) && ae.isActive(this) && (ae.tickRate() == 1 || this.getTicksExisted() % ae.tickRate() == 0) && ae.tick(this)) {
                                this.activeEffects.add(ae);
                            }
                            if (!ModList.THAUMCRAFT.isLoaded()) continue;
                            AspectList cost = new AspectList();
                            if (ae instanceof VisAlvearyEffect) {
                                VisAlvearyEffect vae = (VisAlvearyEffect)ae;
                                cost.add(vae.aspect, 1);
                            }
                            for (Aspect a : cost.aspects.keySet()) {
                                if (this.aspects.getAmount(a) >= 200) continue;
                                if (DragonAPICore.debugtest) {
                                    this.aspects.add(a, 200 - this.aspects.getAmount(a));
                                    continue;
                                }
                                int get = VisNetHandler.drainVis((World)world, (int)x, (int)y, (int)z, (Aspect)a, (int)cost.getAmount(a));
                                if (get <= 0) continue;
                                this.aspects.add(a, get);
                            }
                        }
                    } else {
                        for (AlvearyEffect ae : continualSet) {
                            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this) || ae.tickRate() != 1 && this.getTicksExisted() % ae.tickRate() != 0 || !ae.tick(this)) continue;
                            this.activeEffects.add(ae);
                        }
                    }
                } else if (!Strings.isNullOrEmpty((String)this.movePrincess) && this.canRunAutomation() && this.cycleBees(this.movePrincess, EnumBeeType.PRINCESS)) {
                    this.movePrincess = null;
                    this.drainEnergy(TileEntityLumenAlveary.automation.color, TileEntityLumenAlveary.automation.requiredEnergy);
                }
                if (!Strings.isNullOrEmpty((String)this.moveDrone) && this.canRunAutomation() && this.cycleBees(this.moveDrone, EnumBeeType.DRONE)) {
                    this.moveDrone = null;
                    this.drainEnergy(TileEntityLumenAlveary.automation.color, TileEntityLumenAlveary.automation.requiredEnergy);
                }
            } else if (!world.field_72995_K) {
                this.canWork = false;
                this.workNeedsUpdate = false;
            }
        }
    }

    private boolean canRunAutomation() {
        return this.isEffectSelectedAndActive(automation) && this.energy.containsAtLeast(TileEntityLumenAlveary.automation.color, TileEntityLumenAlveary.automation.requiredEnergy);
    }

    private void replaceFlowerCacher() {
        IBeekeepingLogic bkl;
        if (this.flowerCache == null) {
            this.flowerCache = new EfficientFlowerCache();
        }
        if (this.field_145850_b != null && this.isTickingNaturally() && (bkl = this.getMultiblockLogic().getController().getBeekeepingLogic()).getClass() == beeLogicClass) {
            try {
                INBTTagable o = (INBTTagable)flowerCacheField.get(bkl);
                if (!(o instanceof EfficientFlowerCache)) {
                    flowerCacheField.set(bkl, (Object)this.flowerCache);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public EfficientFlowerCache getFlowerCache() {
        this.replaceFlowerCacher();
        return this.flowerCache;
    }

    public Collection<AlvearyEffect> getActiveEffects() {
        return Collections.unmodifiableCollection(this.activeEffects);
    }

    public Collection<AlvearyEffect> getSelectedEffects() {
        HashSet<AlvearyEffect> set = new HashSet<AlvearyEffect>();
        for (String id : this.selectedEffects) {
            set.add(AlvearyEffect.getEffectByID(id));
        }
        return set;
    }

    public void setEffectSelectionState(String id, boolean active) {
        if (active) {
            this.selectedEffects.add(id);
        } else {
            this.selectedEffects.remove(id);
        }
    }

    public boolean isEffectSelected(AlvearyEffect e) {
        return this.selectedEffects.contains(e.ID);
    }

    public boolean isEffectSelectedAndActive(AlvearyEffect e) {
        return this.selectedEffects.contains(e.ID) && e.isActive(this);
    }

    protected void onFirstTick(World world, int x, int y, int z) {
        super.onFirstTick(world, x, y, z);
        this.updateRenderItem();
    }

    @SideOnly(value=Side.CLIENT)
    private void doParticles(World world, int x, int y, int z) {
        int n = 2 + 2 * Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (rand.nextInt(n) == 0) {
            double o = 0.03125;
            int side = rand.nextInt(2);
            double dx = side == 0 ? rand.nextDouble() * 3.0 : (rand.nextBoolean() ? 0.0 - o : 3.0 + o);
            double dy = rand.nextDouble() * 3.5;
            double dz = side == 1 ? rand.nextDouble() * 3.0 : (rand.nextBoolean() ? 0.0 - o : 3.0 + o);
            double px = (double)(x - this.relativeLocation.xCoord) + dx;
            double py = (double)(y - this.relativeLocation.yCoord) + dy;
            double pz = (double)(z - this.relativeLocation.zCoord) + dz;
            int l = ReikaRandomHelper.getRandomBetween((int)5, (int)20);
            int c2 = 0xFFFFFF;
            int c1 = 10516288;
            float s = 1.5f * (float)ReikaRandomHelper.getRandomPlusMinus((double)1.0, (double)0.25);
            EntityBlurFX fx1 = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.HEXFLARE2).setLife(l).setColor(c1).setScale(s);
            EntityBlurFX fx2 = new EntityCCBlurFX(world, px, py, pz).setIcon(ChromaIcons.HEXFLARE2).setScale(s / 2.0f).setLife(l).setColor(c2);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx1);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
    }

    @Override
    public ElementTagCompound getRequiredEnergy() {
        ElementTagCompound tag = new ElementTagCompound();
        if (!this.isAlvearyComplete()) {
            return tag;
        }
        for (AlvearyEffect ae : effectSet.values()) {
            if (!(ae instanceof LumenAlvearyEffect)) continue;
            LumenAlvearyEffect lae = (LumenAlvearyEffect)ae;
            tag.addValueToColor(lae.color, lae.requiredEnergy * 10);
        }
        return tag;
    }

    @Override
    public boolean isAcceptingColor(CrystalElement e) {
        return this.getRequiredEnergy().contains(e);
    }

    @Override
    public int getMaxStorage(CrystalElement e) {
        return 15000;
    }

    @Override
    public ChromaTiles getTile() {
        return ChromaTiles.ALVEARY;
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    public ChunkCoordinates getCoordinates() {
        return new Coordinate((TileEntity)this).asChunkCoordinates();
    }

    public GameProfile getOwner() {
        return this.placerUUID != null ? new GameProfile(this.placerUUID, this.getPlacerName()) : null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public void onMachineAssembled(IMultiblockController controller, ChunkCoordinates minCoord, ChunkCoordinates maxCoord) {
        this.validateStructure(controller);
        this.triggerBlockUpdate();
        this.relativeLocation = new Coordinate((TileEntity)this).offset(new Coordinate(minCoord).negate());
        this.updateRenderItem();
        this.syncAllData(true);
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    private void validateStructure(IMultiblockController controller) {
        boolean flag = false;
        this.multipleBoosters = false;
        for (IMultiblockComponent com : controller.getComponents()) {
            if (!(com instanceof TileEntityLumenAlveary) || com == this) continue;
            this.multipleBoosters = true;
            this.syncAllData(true);
            break;
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public void onMachineBroken() {
        ReikaWorldHelper.causeAdjacentUpdates((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        this.triggerBlockUpdate();
        this.relativeLocation = null;
        this.updateRenderItem();
        this.syncAllData(true);
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public IBeeListener getBeeListener() {
        return this;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public IBeeModifier getBeeModifier() {
        return this;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public void wearOutEquipment(int amount) {
        this.workNeedsUpdate = true;
        this.validateCachedQueen(true);
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this)) continue;
            ae.consumeEnergy(this, amount);
            ae.onProductionTick(this);
        }
        this.updateRenderItem();
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public void onQueenDeath() {
        IAlleleBeeSpecies bee = this.getSpecies();
        if (bee == null) {
            ChromatiCraft.logger.logError((Object)"Alveary called onQueenDeath with a null queen!");
        }
        if (bee != null) {
            this.movePrincess = bee.getUID();
        }
        this.moveDrone = this.movePrincess;
        if (this.energy.containsAtLeast(TileEntityLumenAlveary.geneRepair2.color, TileEntityLumenAlveary.geneRepair2.requiredEnergy) && TileEntityLumenAlveary.geneRepair2.repairQueen(this)) {
            this.energy.subtract(TileEntityLumenAlveary.geneRepair2.color, TileEntityLumenAlveary.geneRepair2.requiredEnergy);
        }
        this.cachedQueen = null;
        this.canWork = false;
        this.workNeedsUpdate = false;
    }

    public void forceCycleBees() {
        if (this.movePrincess != null) {
            this.cycleBees(this.movePrincess, EnumBeeType.PRINCESS);
        }
        if (this.moveDrone != null) {
            this.cycleBees(this.moveDrone, EnumBeeType.DRONE);
        }
    }

    private boolean cycleBees(String species, EnumBeeType seek) {
        IBeeHousing ibh = this.getBeeHousing();
        IBeeHousingInventory ibhi = ibh.getBeeInventory();
        ISidedInventory inv = (ISidedInventory)ibhi;
        ItemStack drone = ibhi.getDrone();
        boolean flag2 = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack in = inv.func_70301_a(i);
            if (in != null) {
                boolean flag = false;
                for (int s = 0; s < 6; ++s) {
                    if (!inv.func_102008_b(i, in, s)) continue;
                    flag = true;
                }
                if (flag) {
                    EnumBeeType type = ReikaBeeHelper.getBeeRoot().getType(in);
                    if (type != seek) continue;
                    IAlleleBeeSpecies sp = (IAlleleBeeSpecies)ReikaBeeHelper.getSpecies((ItemStack)in);
                    if (type == EnumBeeType.PRINCESS && ibhi.getQueen() == null && sp.getUID().equals(species)) {
                        ibhi.setQueen(in);
                        inv.func_70299_a(i, null);
                        flag2 = true;
                    } else if (type == EnumBeeType.DRONE && ReikaItemHelper.areStacksCombinable((ItemStack)drone, (ItemStack)in, (int)inv.func_70297_j_())) {
                        int amt = Math.min(drone.func_77976_d() - drone.field_77994_a, in.field_77994_a);
                        drone.field_77994_a += amt;
                        ibhi.setDrone(drone);
                        in.field_77994_a -= amt;
                        if (in.field_77994_a == 0) {
                            inv.func_70299_a(i, null);
                        }
                        flag2 = true;
                    } else if (type == EnumBeeType.DRONE && drone == null && sp.getUID().equals(species)) {
                        ibhi.setDrone(in);
                        inv.func_70299_a(i, null);
                        flag2 = true;
                    }
                }
            }
            if (flag2) break;
        }
        return flag2;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public boolean onPollenRetrieved(IIndividual pollen) {
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public float getTerritoryModifier(IBeeGenome genome, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this)) continue;
            f *= ae.territoryFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this)) continue;
            f *= ae.mutationFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this)) continue;
            f *= ae.lifespanFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public float getProductionModifier(IBeeGenome genome, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this)) continue;
            f *= ae.productionFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public float getFloweringModifier(IBeeGenome genome, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this)) continue;
            f *= ae.pollinationFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public float getGeneticDecay(IBeeGenome genome, float current) {
        float f = 1.0f;
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this)) continue;
            f *= ae.decayFactor(this);
        }
        return f;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public boolean isSealed() {
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this) || !ae.isSealed(this)) continue;
            return true;
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public boolean isSelfLighted() {
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this) || !ae.isSelfLit(this)) continue;
            return true;
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public boolean isSunlightSimulated() {
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this) || !ae.isSkySimulated(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isHellish() {
        for (AlvearyEffect ae : effectSet.values()) {
            if (!this.selectedEffects.contains(ae.ID) || !ae.isActive(this) || !ae.isHellish(this)) continue;
            return true;
        }
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public IMultiblockLogicAlveary getMultiblockLogic() {
        return (IMultiblockLogicAlveary)this.logic;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    @Deprecated
    private void tickAlveary() {
        IAlvearyController iac = this.getMultiblockLogic().getController();
        ForestryMultiblockControllerHandling.tickMultiblock((IMultiblockController)iac, (Object)this);
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    private IBeeHousing getBeeHousing() {
        return this.getMultiblockLogic().getController();
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public IBeeGenome getBeeGenome() {
        this.validateCachedQueen(false);
        return this.cachedQueen != null ? this.cachedQueen.getGenome() : null;
    }

    public boolean hasQueen() {
        return ModList.FORESTRY.isLoaded() && this.getQueenItem() != null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public ItemStack getQueenItem() {
        IAlvearyController ibh = this.getMultiblockLogic().getController();
        if (ibh == null) {
            return null;
        }
        ItemStack is = ibh.getBeeInventory().getQueen();
        return is;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public boolean canQueenWork() {
        if (this.workNeedsUpdate) {
            this.canWork = this.calcCanWork();
        }
        return this.canWork;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    private boolean calcCanWork() {
        return this.hasQueen() && this.isAlvearyComplete() && this.getMultiblockLogic().getController().getBeekeepingLogic().canWork();
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    public IAlleleBeeSpecies getSpecies() {
        this.validateCachedQueen(false);
        return this.cachedQueen != null ? this.cachedQueen.getGenome().getPrimary() : null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    private void validateCachedQueen(boolean forceCalc) {
        ItemStack is = this.getQueenItem();
        if (is == null) {
            this.cachedQueen = null;
        } else if (this.cachedQueen == null || forceCalc) {
            this.calcSpecies();
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
    private void calcSpecies() {
        IBee repl = this.getBee();
        boolean flag = repl != this.cachedQueen;
        this.cachedQueen = repl;
        if (flag) {
            this.syncAllData(false);
        }
    }

    private IBee getBee() {
        if (!this.field_145850_b.field_72995_K) {
            try {
                return (IBee)beeField.get(this.getMultiblockLogic().getController().getBeekeepingLogic());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ReikaBeeHelper.getBee((ItemStack)this.getQueenItem());
    }

    @Override
    protected void readSyncTag(NBTTagCompound data) {
        super.readSyncTag(data);
        this.canWork = data.func_74767_n("canWork");
        this.workNeedsUpdate = false;
        this.validateCachedQueen(false);
    }

    @Override
    protected void writeSyncTag(NBTTagCompound data) {
        super.writeSyncTag(data);
        data.func_74757_a("canWork", this.canWork);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        if (ModList.FORESTRY.isLoaded()) {
            this.getMultiblockLogic().readFromNBT(data);
        }
        this.movePrincess = data.func_74779_i("move");
        if (this.movePrincess.isEmpty()) {
            this.movePrincess = null;
        }
        this.moveDrone = data.func_74779_i("movedr");
        if (this.moveDrone.isEmpty()) {
            this.moveDrone = null;
        }
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.aspects.readFromNBT(data);
        }
        if (ModList.FORESTRY.isLoaded()) {
            this.getFlowerCache().readFromNBT(data);
        }
        if (data.func_74764_b("effectsel")) {
            ReikaNBTHelper.readCollectionFromNBT(this.selectedEffects, (NBTTagCompound)data, (String)"effectsel");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        if (ModList.FORESTRY.isLoaded()) {
            this.getMultiblockLogic().writeToNBT(data);
        }
        data.func_74778_a("move", !Strings.isNullOrEmpty((String)this.movePrincess) ? this.movePrincess : "");
        data.func_74778_a("movedr", !Strings.isNullOrEmpty((String)this.moveDrone) ? this.moveDrone : "");
        if (ModList.THAUMCRAFT.isLoaded()) {
            this.aspects.writeToNBT(data);
        }
        if (ModList.FORESTRY.isLoaded()) {
            this.getFlowerCache().writeToNBT(data);
        }
        ReikaNBTHelper.writeCollectionToNBT(this.selectedEffects, (NBTTagCompound)data, (String)"effectsel");
    }

    public final void func_145829_t() {
        super.func_145829_t();
        if (ModList.FORESTRY.isLoaded()) {
            this.getMultiblockLogic().validate(this.field_145850_b, (IMultiblockComponent)this);
        }
    }

    protected void onInvalidateOrUnload(World world, int x, int y, int z, boolean invalid) {
        super.onInvalidateOrUnload(world, x, y, z, invalid);
        if (ModList.FORESTRY.isLoaded()) {
            if (invalid) {
                this.getMultiblockLogic().invalidate(world, (IMultiblockComponent)this);
            } else {
                this.getMultiblockLogic().onChunkUnload(world, (IMultiblockComponent)this);
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((TileEntity)this);
        if (this.isAlvearyComplete()) {
            Coordinate c = new Coordinate((TileEntity)this).offset(this.relativeLocation.negate());
            Coordinate c2 = c.offset(3, 6, 3);
            return AxisAlignedBB.func_72330_a((double)c.xCoord, (double)c.yCoord, (double)c.zCoord, (double)c2.xCoord, (double)c2.yCoord, (double)c2.zCoord);
        }
        return box;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityItem getRenderItem() {
        return this.renderItem;
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.updateRenderItem();
    }

    private void updateRenderItem() {
        this.renderItem = this.isAlvearyComplete() && this.getQueenItem() != null ? new InertItem(this.field_145850_b, this.getQueenItem()) : null;
    }

    public boolean effectsOnlyOnPlayers() {
        return this.isEffectSelectedAndActive(playerOnlyEffects);
    }

    public boolean hasInfiniteAwareness() {
        return this.isEffectSelectedAndActive(infiniteRange);
    }

    public boolean isIgnoble() {
        return this.cachedQueen != null && !this.cachedQueen.isNatural();
    }

    public boolean hasOmnipresence() {
        return this.isEffectSelectedAndActive(omnipresence);
    }

    public boolean isColorBoosted(CrystalElement e) {
        return colorEffects.get(e).isActive(this);
    }

    public int getPacketDelay() {
        return super.getPacketDelay() * 4;
    }

    public static final Collection<AlvearyEffect> getEffectSet() {
        return Collections.unmodifiableCollection(effectSet.values());
    }

    public static final Collection<? extends AlvearyEffect> getEffectSet(Class<? extends AlvearyEffect> c) {
        ArrayList<AlvearyEffect> li = new ArrayList<AlvearyEffect>();
        for (AlvearyEffect ae : effectSet.values()) {
            if (!c.isAssignableFrom(ae.getClass())) continue;
            li.add(ae);
        }
        return li;
    }

    public boolean copySettingsFrom(TileEntityLumenAlveary te) {
        this.selectedEffects.clear();
        this.selectedEffects.addAll(te.selectedEffects);
        this.syncAllData(true);
        return true;
    }

    public void clearSelectedEffects() {
        this.selectedEffects.clear();
    }

    public void resetSelectedEffects() {
        this.clearSelectedEffects();
        for (AlvearyEffect ae : effectSet.values()) {
            if (!ae.isOnByDefault()) continue;
            this.selectedEffects.add(ae.ID);
        }
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public boolean isConnectable(ForgeDirection face) {
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public boolean canInputFrom(ForgeDirection face) {
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public void setSuction(Aspect aspect, int amount) {
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public Aspect getSuctionType(ForgeDirection face) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public int getSuctionAmount(ForgeDirection face) {
        return 0;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public int takeEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return 0;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public int addEssentia(Aspect aspect, int amount, ForgeDirection face) {
        return this.addToContainer(aspect, amount);
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public Aspect getEssentiaType(ForgeDirection face) {
        return null;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public int getEssentiaAmount(ForgeDirection face) {
        return 0;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public int getMinimumSuction() {
        return 0;
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public boolean renderExtendedTube() {
        return false;
    }

    public AspectList getAspects() {
        return !this.aspects.aspects.isEmpty() ? this.aspects.copy() : null;
    }

    public void setAspects(AspectList al) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        return tag.isPrimal();
    }

    public int addToContainer(Aspect aspect, int amount) {
        if (!aspect.isPrimal()) {
            return 0;
        }
        int space = 200 - this.aspects.getAmount(aspect);
        int add = Math.min(space, amount);
        if (add > 0) {
            this.aspects.add(aspect, add);
        }
        return add;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        return this.aspects.getAmount(tag) >= amount;
    }

    public boolean doesContainerContain(AspectList ot) {
        return ReikaThaumHelper.aspectListContains((AspectList)this.aspects, (AspectList)ot);
    }

    public int containerContains(Aspect tag) {
        return this.aspects.getAmount(tag);
    }

    static {
        colorEffects = new EnumMap(CrystalElement.class);
        effectSorter = new Comparator<AlvearyEffect>(){

            @Override
            public int compare(AlvearyEffect o1, AlvearyEffect o2) {
                if (o1 instanceof LumenAlvearyEffect && o2 instanceof LumenAlvearyEffect) {
                    LumenAlvearyEffect l1 = (LumenAlvearyEffect)o1;
                    LumenAlvearyEffect l2 = (LumenAlvearyEffect)o2;
                    return Integer.compare(100000 * l1.color.ordinal() + l1.requiredEnergy, 100000 * l2.color.ordinal() + l2.requiredEnergy);
                }
                if (o1 instanceof VisAlvearyEffect && o2 instanceof VisAlvearyEffect) {
                    VisAlvearyEffect v1 = (VisAlvearyEffect)o1;
                    VisAlvearyEffect v2 = (VisAlvearyEffect)o2;
                    if (v1.aspect == v2.aspect) {
                        return Integer.compare(v1.requiredVis, v2.requiredVis);
                    }
                    return v1.aspect.getLocalizedDescription().compareToIgnoreCase(v2.aspect.getLocalizedDescription());
                }
                if (o1 instanceof LumenAlvearyEffect) {
                    return Integer.MAX_VALUE;
                }
                if (o2 instanceof LumenAlvearyEffect) {
                    return Integer.MIN_VALUE;
                }
                if (o1 instanceof VisAlvearyEffect) {
                    return Integer.MAX_VALUE;
                }
                if (o2 instanceof VisAlvearyEffect) {
                    return Integer.MIN_VALUE;
                }
                return o1.getDescription().compareToIgnoreCase(o2.getDescription());
            }
        };
        if (ModList.FORESTRY.isLoaded()) {
            try {
                Class<?> c = Class.forName("forestry.apiculture.multiblock.AlvearyController");
                tempField = c.getDeclaredField("tempChange");
                tempField.setAccessible(true);
                humidField = c.getDeclaredField("humidChange");
                humidField.setAccessible(true);
                beeLogicClass = Class.forName("forestry.apiculture.BeekeepingLogic");
                flowerCacheField = beeLogicClass.getDeclaredField("hasFlowersCache");
                flowerCacheField.setAccessible(true);
                beeField = beeLogicClass.getDeclaredField("queen");
                beeField.setAccessible(true);
                beeClass = Class.forName("forestry.apiculture.genetics.Bee");
                fakeLogicClass = Class.forName("forestry.apiculture.FakeBeekeepingLogic");
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)"Could not fetch alveary internal methods!");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.FORESTRY, e);
            }
        }
        new AccelerationEffectI();
        new AccelerationEffectII();
        new AccelerationEffectIII();
        new LightningProductionEffect();
        new HistoryRewriteEffect();
        new ExplorationEffect();
        new GeneticFluxEffect();
        new GeneticStabilityEffect();
        new GeneticImmutabilityEffect();
        new GeneticImprovementEffect();
        new TemperatureMatchingEffect();
        new HumidityMatchingEffect();
        new GeneticRepairEffectI();
        geneRepair2 = new GeneticRepairEffectII();
        new EternalEffect();
        automation = new AutomationEffect();
        playerOnlyEffects = new PlayerRestrictionEffect();
        for (int i = 0; i < 16; ++i) {
            CrystalElement e = CrystalElement.elements[i];
            colorEffects.put(e, new ElementalBoostEffect(e));
        }
        infiniteRange = new InfiniteSightEffect();
        omnipresence = new OmnipresentEffectEffect();
        if (ModList.THAUMCRAFT.isLoaded()) {
            new ProductionBoostEffect();
            new NoProductionEffect();
            new EnhancedEffectEffect();
            new MutationBoostEffect();
            new FloweringBoostEffect();
            new RainBoostEffect();
        }
    }

    private static class RareDropBoostEffect
    extends LumenAlvearyEffect {
        private RareDropBoostEffect() {
            super("rareboost", CrystalElement.PURPLE, 900);
        }

        @Override
        protected void onProductionTick(TileEntityLumenAlveary te) {
            IAlleleBeeSpecies bee = te.getSpecies();
            HashMap map = new HashMap(bee.getProductChances());
            map.putAll(bee.getSpecialtyChances());
        }

        @Override
        public String getDescription() {
            return "Rares Boost";
        }

        @Override
        public boolean isOnByDefault() {
            return false;
        }
    }

    private static class OmnipresentEffectEffect
    extends LumenAlvearyEffect {
        private OmnipresentEffectEffect() {
            super("omnipresent", CrystalElement.PURPLE, 1200);
        }

        @Override
        public String getDescription() {
            return "Omnipresence";
        }

        @Override
        protected boolean isActive(TileEntityLumenAlveary te) {
            return super.isActive(te) && te.hasQueen() && te.getBeeGenome() != null && te.getBeeGenome().getEffect() instanceof EffectAlleles.CrystalEffect;
        }
    }

    private static class InfiniteSightEffect
    extends LumenAlvearyEffect {
        private InfiniteSightEffect() {
            super("infsight", CrystalElement.BLUE, 600);
        }

        @Override
        public String getDescription() {
            return "Infinite View";
        }

        @Override
        protected boolean isActive(TileEntityLumenAlveary te) {
            return super.isActive(te) && te.getSpecies() instanceof ChromaBeeHelpers.ConditionalProductBee;
        }
    }

    private static class ElementalBoostEffect
    extends LumenAlvearyEffect {
        private final CrystalElement color;

        private ElementalBoostEffect(CrystalElement e) {
            super("elem_" + e.name().toLowerCase(Locale.ENGLISH) + "_boost", e, 240);
            this.color = e;
        }

        @Override
        public String getDescription() {
            return this.color.displayName + " Boost";
        }

        @Override
        protected boolean isActive(TileEntityLumenAlveary te) {
            return super.isActive(te) && te.getSpecies() == CrystalBees.getElementalBee(this.color);
        }
    }

    private static class PlayerRestrictionEffect
    extends LumenAlvearyEffect {
        private PlayerRestrictionEffect() {
            super("playeronly", CrystalElement.LIGHTGRAY, 20);
        }

        @Override
        public String getDescription() {
            return "Effect Restriction";
        }
    }

    private static class EternalEffect
    extends LumenAlvearyEffect {
        private EternalEffect() {
            super("inflife", CrystalElement.RED, 600);
        }

        @Override
        public String getDescription() {
            return "Eternal Life";
        }

        @Override
        protected float lifespanFactor(TileEntityLumenAlveary te) {
            BeeAlleleRegistry.Life l = (BeeAlleleRegistry.Life)ReikaBeeHelper.getGeneEnum((EnumBeeChromosome)EnumBeeChromosome.LIFESPAN, (IBeeGenome)te.cachedQueen.getGenome());
            if (l == CrystalBees.superLife) {
                return 10000.0f;
            }
            return 1.0f;
        }
    }

    private static class GeneticRepairEffectII
    extends GeneticRepairEffect {
        private GeneticRepairEffectII() {
            super(2);
        }

        @Override
        protected boolean doRepair(TileEntityLumenAlveary te) {
            return true;
        }
    }

    private static class GeneticRepairEffectI
    extends GeneticRepairEffect {
        private GeneticRepairEffectI() {
            super(1);
        }

        @Override
        protected boolean doRepair(TileEntityLumenAlveary te) {
            return rand.nextInt(40) == 0;
        }
    }

    private static abstract class GeneticRepairEffect
    extends LumenAlvearyEffect {
        private final int tier;

        private GeneticRepairEffect(int tier) {
            super("repair_" + tier, CrystalElement.MAGENTA, 100 * ReikaMathLibrary.intpow2((int)24, (int)(tier - 1)));
            this.tier = tier;
        }

        @Override
        public final String getDescription() {
            return "Genetic Repair " + this.tier;
        }

        @Override
        protected final void onProductionTick(TileEntityLumenAlveary te) {
            if (te.cachedQueen != null && this.doRepair(te)) {
                this.repairQueen(te);
            }
        }

        private boolean repairQueen(TileEntityLumenAlveary te) {
            te.cachedQueen.setIsNatural(true);
            te.updateRenderItem();
            return true;
        }

        protected abstract boolean doRepair(TileEntityLumenAlveary var1);

        @Override
        public final boolean isOnByDefault() {
            return true;
        }
    }

    private static class HumidityMatchingEffect
    extends LumenAlvearyEffect {
        private HumidityMatchingEffect() {
            super("humidmatch", CrystalElement.CYAN, 80);
        }

        @Override
        protected int tickRate() {
            return 1;
        }

        @Override
        public String getDescription() {
            return "Dynamic Humidity";
        }

        @Override
        protected boolean tick(TileEntityLumenAlveary te) {
            IAlvearyController ac = te.getMultiblockLogic().getController();
            IClimateControlled cc = (IClimateControlled)ac;
            IAlleleBeeSpecies queen = te.getSpecies();
            if (queen == null) {
                return false;
            }
            ChunkCoordinates loc = ac.getCoordinates();
            float cur = ac.getBiome().field_76751_G;
            float pref = ReikaBeeHelper.getHumidityRangeCenter((EnumHumidity)queen.getHumidity());
            if (pref != cur) {
                try {
                    humidField.set(ac, Float.valueOf(pref - cur));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        @Override
        protected boolean worksWhenBeesDoNot() {
            return false;
        }

        @Override
        public boolean isOnByDefault() {
            return true;
        }
    }

    private static class TemperatureMatchingEffect
    extends LumenAlvearyEffect {
        private TemperatureMatchingEffect() {
            super("tempmatch", CrystalElement.ORANGE, 80);
        }

        @Override
        protected int tickRate() {
            return 1;
        }

        @Override
        public String getDescription() {
            return "Dynamic Temperature";
        }

        @Override
        protected boolean tick(TileEntityLumenAlveary te) {
            IAlvearyController ac = te.getMultiblockLogic().getController();
            IClimateControlled cc = (IClimateControlled)ac;
            IAlleleBeeSpecies queen = te.getSpecies();
            if (queen == null) {
                return false;
            }
            ChunkCoordinates loc = ac.getCoordinates();
            float cur = ac.getBiome().func_150564_a(loc.field_71574_a, loc.field_71572_b, loc.field_71573_c);
            float pref = ReikaBeeHelper.getTemperatureRangeCenter((EnumTemperature)queen.getTemperature());
            if (pref != cur) {
                try {
                    tempField.set(ac, Float.valueOf(pref - cur));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        @Override
        protected boolean isHellish(TileEntityLumenAlveary te) {
            return te.getSpecies() != null && te.getSpecies().getTemperature() == EnumTemperature.HELLISH;
        }

        @Override
        protected boolean worksWhenBeesDoNot() {
            return false;
        }

        @Override
        public boolean isOnByDefault() {
            return true;
        }
    }

    private static class GeneticImprovementEffect
    extends LumenAlvearyEffect {
        private static final double geneImprovementChance = 0.002;

        private GeneticImprovementEffect() {
            super("geneboost", CrystalElement.BLACK, 120);
        }

        @Override
        protected boolean tick(TileEntityLumenAlveary te) {
            ItemStack queen;
            if (ReikaRandomHelper.doWithChance((double)0.002) && (queen = te.getBeeHousing().getBeeInventory().getQueen()) != null && AlleleManager.alleleRegistry.getIndividual(queen) instanceof IBee) {
                IBeeGenome ibg = te.getBeeGenome();
                if (ibg == null) {
                    return false;
                }
                EnumBeeChromosome gene = EnumBeeChromosome.values()[rand.nextInt(EnumBeeChromosome.values().length)];
                if (this.canImprove(gene, ibg)) {
                    this.improveGene(gene, ibg, queen);
                }
            }
            return true;
        }

        @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
        private void improveGene(EnumBeeChromosome gene, IBeeGenome ibg, ItemStack queen) {
            switch (gene) {
                case FERTILITY: 
                case FLOWERING: 
                case TERRITORY: 
                case SPEED: {
                    BeeAlleleRegistry.BeeGene g = ReikaBeeHelper.getGeneEnum((EnumBeeChromosome)gene, (IBeeGenome)ibg);
                    if (g == null || (g = g.oneBetter()) == null) break;
                    ReikaBeeHelper.setGene((ItemStack)queen, (IBeeGenome)ibg, (EnumBeeChromosome)gene, (IAllele)g.getAllele(), (boolean)true);
                    break;
                }
                case TEMPERATURE_TOLERANCE: {
                    EnumTolerance next;
                    if (ibg.getToleranceTemp() == EnumTolerance.NONE || (next = ReikaBeeHelper.getOneBetterTolerance((EnumTolerance)ibg.getToleranceTemp())) == null) break;
                    ReikaBeeHelper.setGene((ItemStack)queen, (IBeeGenome)ibg, (EnumBeeChromosome)gene, (IAllele)ReikaBeeHelper.getToleranceGene((EnumTolerance)next), (boolean)true);
                    break;
                }
                case HUMIDITY_TOLERANCE: {
                    EnumTolerance next;
                    if (ibg.getToleranceHumid() == EnumTolerance.NONE || (next = ReikaBeeHelper.getOneBetterTolerance((EnumTolerance)ibg.getToleranceHumid())) == null) break;
                    ReikaBeeHelper.setGene((ItemStack)queen, (IBeeGenome)ibg, (EnumBeeChromosome)gene, (IAllele)ReikaBeeHelper.getToleranceGene((EnumTolerance)next), (boolean)true);
                    break;
                }
            }
        }

        @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
        private boolean canImprove(EnumBeeChromosome gene, IBeeGenome ibg) {
            switch (gene) {
                case FERTILITY: {
                    return ibg.getFertility() < BeeAlleleRegistry.Fertility.MAXIMUM.getAllele().getValue();
                }
                case FLOWERING: {
                    return ibg.getFlowering() < BeeAlleleRegistry.Flowering.FASTEST.getAllele().getValue();
                }
                case HUMIDITY_TOLERANCE: {
                    return ReikaBeeHelper.getToleranceValue((EnumTolerance)ibg.getToleranceHumid()) > 0 && ReikaBeeHelper.getToleranceValue((EnumTolerance)ibg.getToleranceHumid()) < 2;
                }
                case SPEED: {
                    return ibg.getSpeed() < BeeAlleleRegistry.Speeds.FASTEST.getAllele().getValue();
                }
                case TEMPERATURE_TOLERANCE: {
                    return ReikaBeeHelper.getToleranceValue((EnumTolerance)ibg.getToleranceTemp()) > 0 && ReikaBeeHelper.getToleranceValue((EnumTolerance)ibg.getToleranceTemp()) < 2;
                }
                case TERRITORY: {
                    return ibg.getTerritory()[0] < BeeAlleleRegistry.Territory.LARGEST.getAllele().getValue()[0];
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "Genetic Improvement";
        }
    }

    private static class ExplorationEffect
    extends LumenAlvearyEffect {
        private ExplorationEffect() {
            super("explore", CrystalElement.LIME, 120);
        }

        @Override
        protected float territoryFactor(TileEntityLumenAlveary te) {
            return 1.5f;
        }

        @Override
        public String getDescription() {
            return "Exploration";
        }
    }

    private static class GeneticFluxEffect
    extends LumenAlvearyEffect {
        private GeneticFluxEffect() {
            super("geneflux", CrystalElement.BLACK, 60);
        }

        @Override
        protected float mutationFactor(TileEntityLumenAlveary te) {
            return 4.0f;
        }

        @Override
        public String getDescription() {
            return "Genetic Flux";
        }
    }

    private static class GeneticImmutabilityEffect
    extends LumenAlvearyEffect {
        private GeneticImmutabilityEffect() {
            super("genelock", CrystalElement.WHITE, 600);
        }

        @Override
        protected float mutationFactor(TileEntityLumenAlveary te) {
            return 0.0f;
        }

        @Override
        protected float decayFactor(TileEntityLumenAlveary te) {
            return 0.0f;
        }

        @Override
        public String getDescription() {
            return "Genetic Immutability";
        }
    }

    private static class GeneticStabilityEffect
    extends LumenAlvearyEffect {
        private GeneticStabilityEffect() {
            super("genestable", CrystalElement.WHITE, 20);
        }

        @Override
        protected float mutationFactor(TileEntityLumenAlveary te) {
            return 0.0f;
        }

        @Override
        protected float decayFactor(TileEntityLumenAlveary te) {
            return 0.75f;
        }

        @Override
        public String getDescription() {
            return "Genetic Stability";
        }

        @Override
        public boolean isOnByDefault() {
            return true;
        }
    }

    private static class GeneticBalancingEffect
    extends LumenAlvearyEffect {
        private static final double pristineConversionChance = 5.0E-4;
        private static final double geneBalancingChance = 0.005;

        private GeneticBalancingEffect() {
            super("genebalance", CrystalElement.WHITE, 80);
        }

        @Override
        protected boolean tick(TileEntityLumenAlveary te) {
            EnumBeeChromosome gene;
            ItemStack queen;
            IBeeHousing ibh = te.getBeeHousing();
            IBeeGenome ibg = te.getBeeGenome();
            if (ibg == null) {
                return false;
            }
            if (ReikaRandomHelper.doWithChance((double)5.0E-4) && (queen = ibh.getBeeInventory().getQueen()) != null && AlleleManager.alleleRegistry.getIndividual(queen) instanceof IBee) {
                ReikaBeeHelper.setPristine((ItemStack)queen, (boolean)true);
            }
            if (ReikaRandomHelper.doWithChance((double)0.005) && (queen = ibh.getBeeInventory().getQueen()) != null && AlleleManager.alleleRegistry.getIndividual(queen) instanceof IBee && this.canBalance(queen, ibg, gene = EnumBeeChromosome.values()[rand.nextInt(EnumBeeChromosome.values().length)])) {
                this.balanceGene(queen, ibg, gene);
            }
            return true;
        }

        @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
        private void balanceGene(ItemStack queen, IBeeGenome ibg, EnumBeeChromosome gene) {
            ReikaBeeHelper.setGene((ItemStack)queen, (IBeeGenome)ibg, (EnumBeeChromosome)gene, (IAllele)ibg.getActiveAllele((IChromosomeType)gene), (boolean)true);
        }

        @DependentMethodStripper.ModDependent(value={ModList.FORESTRY})
        private boolean canBalance(ItemStack queen, IBeeGenome ibg, EnumBeeChromosome gene) {
            if (gene == EnumBeeChromosome.HUMIDITY) {
                return false;
            }
            IAllele primary = ibg.getActiveAllele((IChromosomeType)gene);
            IAllele secondary = ibg.getInactiveAllele((IChromosomeType)gene);
            return !primary.getUID().equals(secondary.getUID());
        }

        @Override
        public String getDescription() {
            return "Genetic Balancing";
        }
    }

    private static class HistoryRewriteEffect
    extends LumenAlvearyEffect {
        private static final double mateRewriteChance = 0.01;

        private HistoryRewriteEffect() {
            super("historyrewrite", CrystalElement.GRAY, 40);
        }

        @Override
        protected boolean tick(TileEntityLumenAlveary te) {
            if (te.cachedQueen != null && ReikaRandomHelper.doWithChance((double)0.01)) {
                ReikaBeeHelper.setBeeMate((IBee)te.cachedQueen, (IBee)te.cachedQueen);
            }
            return true;
        }

        @Override
        public String getDescription() {
            return "History Rewrite";
        }
    }

    private static class LightningProductionEffect
    extends LumenAlvearyEffect {
        private LightningProductionEffect() {
            super("lightning", CrystalElement.YELLOW, 100);
        }

        @Override
        protected boolean tick(TileEntityLumenAlveary te) {
            if (te.getBeeHousing().canBlockSeeTheSky() && te.getBeeHousing().getBiome().func_76738_d() && te.field_145850_b.func_72911_I() && te.field_145850_b.field_73007_j.size() > 0) {
                te.lightningTicks = 15;
            }
            if (te.lightningTicks > 0) {
                int n = 1 + te.lightningTicks / 4;
                for (int i = 0; i < n; ++i) {
                    ReikaBeeHelper.runProductionCycle((IBeeHousing)te.getBeeHousing());
                }
                te.lightningTicks--;
            }
            return true;
        }

        @Override
        public String getDescription() {
            return "Lightning Production";
        }
    }

    private static class AccelerationEffectIII
    extends AccelerationEffect {
        private AccelerationEffectIII() {
            super(7, 1600);
        }
    }

    private static class AccelerationEffectII
    extends AccelerationEffect {
        private AccelerationEffectII() {
            super(3, 480);
        }
    }

    private static class AccelerationEffectI
    extends AccelerationEffect {
        private AccelerationEffectI() {
            super(1, 80);
        }
    }

    private static abstract class AccelerationEffect
    extends LumenAlvearyEffect {
        private final int tickRate;

        private AccelerationEffect(int ticks, int cost) {
            super("accel_" + ticks, CrystalElement.LIGHTBLUE, cost);
            this.tickRate = ticks;
        }

        @Override
        protected final boolean tick(TileEntityLumenAlveary te) {
            if (te.field_145850_b.field_72995_K) {
                return true;
            }
            IBeekeepingLogic bkl = te.getMultiblockLogic().getController().getBeekeepingLogic();
            boolean work = true;
            for (int i = 0; work && te.canQueenWork() && i < this.tickRate; ++i) {
                bkl.doWork();
            }
            return true;
        }

        @Override
        public final String getDescription() {
            return "Acceleration x" + (this.tickRate + 1);
        }
    }

    private static class AutomationEffect
    extends LumenAlvearyEffect {
        private AutomationEffect() {
            super("automate", CrystalElement.GREEN, 100);
        }

        @Override
        protected boolean consumeOnTick() {
            return false;
        }

        @Override
        public String getDescription() {
            return "Genetic Recycling";
        }

        @Override
        protected int tickRate() {
            return 4;
        }

        @Override
        public boolean isOnByDefault() {
            return true;
        }
    }

    public static abstract class LumenAlvearyEffect
    extends PoweredAlvearyEffect {
        public final CrystalElement color;
        public final int requiredEnergy;

        protected LumenAlvearyEffect(String id, CrystalElement e, int amt) {
            super(id);
            this.color = e;
            this.requiredEnergy = amt;
        }

        @Override
        public final String getResource() {
            return this.color.displayName;
        }

        @Override
        public final float getCost() {
            return this.requiredEnergy;
        }

        protected boolean consumeOnTick() {
            return true;
        }

        @Override
        protected boolean isActive(TileEntityLumenAlveary te) {
            return te.energy.containsAtLeast(this.color, this.requiredEnergy);
        }

        @Override
        protected final void consumeEnergy(TileEntityLumenAlveary te, int amount) {
            int amt = amount * this.requiredEnergy;
            if (te.energy.containsAtLeast(this.color, amt)) {
                te.drainEnergy(this.color, amt);
            }
        }

        @Override
        public boolean isOnByDefault() {
            return false;
        }
    }

    private static class RainBoostEffect
    extends VisAlvearyEffect {
        private RainBoostEffect() {
            super("visrainboost", Aspect.WATER, 1);
        }

        @Override
        public String getDescription() {
            return "Precipitative Enhancement";
        }

        @Override
        protected float productionFactor(TileEntityLumenAlveary te) {
            return te.field_145850_b.func_72896_J() ? 1.2f : 1.0f;
        }
    }

    private static class FloweringBoostEffect
    extends VisAlvearyEffect {
        private FloweringBoostEffect() {
            super("visflowerboost", Aspect.EARTH, 2);
        }

        @Override
        public String getDescription() {
            return "Gardener";
        }

        @Override
        protected float pollinationFactor(TileEntityLumenAlveary te) {
            return 1.5f;
        }
    }

    private static class MutationBoostEffect
    extends VisAlvearyEffect {
        private MutationBoostEffect() {
            super("vismutationboost", Aspect.ENTROPY, 4);
        }

        @Override
        public String getDescription() {
            return "Genetic Instability";
        }

        @Override
        protected float mutationFactor(TileEntityLumenAlveary te) {
            return 1.5f;
        }
    }

    private static class EnhancedEffectEffect
    extends VisAlvearyEffect {
        private EnhancedEffectEffect() {
            super("viseffectboost", Aspect.AIR, 20);
        }

        @Override
        public String getDescription() {
            return "Effect Expansion";
        }

        @Override
        protected boolean tick(TileEntityLumenAlveary te) {
            IBeeGenome ibg = te.getBeeGenome();
            if (ibg != null) {
                ibg.getEffect().doEffect(ibg, (IEffectData)new DummyEffectData(), te.getBeeHousing());
            }
            return true;
        }
    }

    private static class NoProductionEffect
    extends VisAlvearyEffect {
        private NoProductionEffect() {
            super("visprodstop", Aspect.ENTROPY, 1);
        }

        @Override
        protected float productionFactor(TileEntityLumenAlveary te) {
            return 0.0f;
        }

        @Override
        public String getDescription() {
            return "Production Nullification";
        }
    }

    private static class ProductionBoostEffect
    extends VisAlvearyEffect {
        private ProductionBoostEffect() {
            super("visprodboost", Aspect.ORDER, 4);
        }

        @Override
        protected float productionFactor(TileEntityLumenAlveary te) {
            return 2.0f;
        }

        @Override
        protected void onProductionTick(TileEntityLumenAlveary te) {
            ItemStack[] items = te.cachedQueen.produceStacks(te.getBeeHousing());
            if (items != null) {
                for (ItemStack is : items) {
                    te.getBeeHousing().getBeeInventory().addProduct(is, false);
                }
            }
        }

        @Override
        public String getDescription() {
            return "Production Boost";
        }

        @Override
        public boolean isOnByDefault() {
            return true;
        }
    }

    public static abstract class VisAlvearyEffect
    extends PoweredAlvearyEffect {
        public final Aspect aspect;
        public final int requiredVis;
        private int removeTick;
        public static final int MULTIPLIER = 10;

        protected VisAlvearyEffect(String id, Aspect a, int amt) {
            super(id);
            this.aspect = a;
            this.requiredVis = amt;
        }

        @Override
        public final String getResource() {
            return this.aspect.getName();
        }

        @Override
        public final float getCost() {
            return (float)this.requiredVis / 10.0f;
        }

        protected boolean consumeOnTick() {
            return true;
        }

        @Override
        protected final boolean isActive(TileEntityLumenAlveary te) {
            return te.aspects.getAmount(this.aspect) >= this.requiredVis;
        }

        @Override
        protected final void consumeEnergy(TileEntityLumenAlveary te, int amount) {
            if (this.removeTick > 0) {
                --this.removeTick;
                return;
            }
            this.removeTick = 10;
            int amt = amount * this.requiredVis;
            te.aspects.remove(this.aspect, this.requiredVis);
        }

        @Override
        public boolean isOnByDefault() {
            return false;
        }
    }

    public static abstract class PoweredAlvearyEffect
    extends AlvearyEffect {
        protected PoweredAlvearyEffect(String id) {
            super(id);
        }

        public abstract String getResource();

        public abstract float getCost();
    }

    public static abstract class AlvearyEffect {
        public final String ID;

        protected AlvearyEffect(String id) {
            this.ID = id;
            effectSet.put(this.ID, this);
            if (this.worksWhenBeesDoNot()) {
                continualSet.add(this);
            }
            if (this.ticksOnClient()) {
                clientSet.add(this);
            }
        }

        public static AlvearyEffect getEffectByID(String id) {
            return (AlvearyEffect)effectSet.get(id);
        }

        public abstract String getDescription();

        protected abstract void consumeEnergy(TileEntityLumenAlveary var1, int var2);

        protected abstract boolean isActive(TileEntityLumenAlveary var1);

        protected boolean tick(TileEntityLumenAlveary te) {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        protected void clientTick(TileEntityLumenAlveary te) {
        }

        protected boolean ticksOnClient() {
            return false;
        }

        public boolean isOnByDefault() {
            return true;
        }

        protected int tickRate() {
            return 1;
        }

        protected void onProductionTick(TileEntityLumenAlveary te) {
        }

        protected boolean worksWhenBeesDoNot() {
            return false;
        }

        protected float productionFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float pollinationFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float lifespanFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float mutationFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float territoryFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected float decayFactor(TileEntityLumenAlveary te) {
            return 1.0f;
        }

        protected boolean isSealed(TileEntityLumenAlveary te) {
            return false;
        }

        protected boolean isSelfLit(TileEntityLumenAlveary te) {
            return false;
        }

        protected boolean isSkySimulated(TileEntityLumenAlveary te) {
            return false;
        }

        protected boolean isHellish(TileEntityLumenAlveary te) {
            return false;
        }
    }
}

