/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface;

import Reika.ChromatiCraft.ModInterface.TileEntityManaBooster;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.DragonAPI.Base.ParticleEntity;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaPhysicsHelper;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityChromaManaBurst
extends ParticleEntity
implements IEntityAdditionalSpawnData {
    private boolean isAccelerated;
    private TileEntityManaBooster.ManaPath path;
    private boolean hitBooster;
    private int pathTick = 0;
    private int boosterEntryTick = 0;
    private int boosterCollectionTick = 0;
    private int boosterExitTick = 0;
    private boolean hitTarget;
    private int targetTick;
    private int amount;
    private int startingAmount;
    private int targetAmount;

    public EntityChromaManaBurst(World world, int amt, TileEntityManaBooster.ManaPath path, boolean accel) {
        super(world, MathHelper.func_76128_c((double)path.pathToBooster.get((int)0).xCoord), MathHelper.func_76128_c((double)path.pathToBooster.get((int)0).yCoord), MathHelper.func_76128_c((double)path.pathToBooster.get((int)0).zCoord));
        this.setPosition(path.pathToBooster.get(0));
        this.setStartingAmount(amt);
        this.path = path;
        this.isAccelerated = accel;
        this.extractMana();
    }

    public EntityChromaManaBurst(World world) {
        super(world);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(27, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(28, (Object)Float.valueOf(0.0f));
    }

    private void setStartingAmount(int amt) {
        this.startingAmount = amt;
        this.setAmount(amt);
        this.targetAmount = amt * 6;
        this.field_70180_af.func_75692_b(25, (Object)this.startingAmount);
    }

    private void setAmount(int amt) {
        this.amount = amt;
        this.field_70180_af.func_75692_b(24, (Object)this.amount);
    }

    public void writeSpawnData(ByteBuf buf) {
        super.writeSpawnData(buf);
        buf.writeInt(this.startingAmount);
        buf.writeBoolean(this.isAccelerated);
    }

    public void readSpawnData(ByteBuf buf) {
        super.readSpawnData(buf);
        this.setStartingAmount(buf.readInt());
        this.isAccelerated = buf.readBoolean();
    }

    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.amount = tag.func_74762_e("mana");
        this.startingAmount = tag.func_74762_e("starting");
    }

    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("mana", this.amount);
        tag.func_74768_a("starting", this.startingAmount);
    }

    protected void onTick() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.path != null) {
                if (this.hitTarget) {
                    ++this.targetTick;
                    if (this.targetTick > 5) {
                        this.func_70106_y();
                    }
                } else if (this.hitBooster) {
                    if (this.amount < this.targetAmount) {
                        this.setAmount(this.amount + Math.max(1, (this.targetAmount - this.amount) / (this.isAccelerated ? 12 : 24)));
                        if (this.boosterEntryTick > 0) {
                            DecimalPosition p = this.getBoosterOrbitPosition();
                            this.setPosition(p);
                            ++this.boosterEntryTick;
                        } else {
                            DecimalPosition p = this.getBoosterEntryPosition();
                            if (this.boosterCollectionTick >= 6) {
                                this.setPosition(p);
                                ++this.boosterEntryTick;
                            } else {
                                ++this.boosterCollectionTick;
                                p = DecimalPosition.interpolate((DecimalPosition)this.path.boosterEntry, (DecimalPosition)p, (double)((double)this.boosterCollectionTick / 6.0));
                                this.setPosition(p);
                            }
                        }
                    } else {
                        DecimalPosition p = this.path.pathToPool.get(this.pathTick);
                        if (this.boosterEntryTick == -1 || this.boosterExitTick >= 6) {
                            this.boosterEntryTick = -1;
                            this.setPosition(p);
                            int t = this.pathTick;
                            this.pathTick = Math.min(this.path.pathToPool.size() - 1, this.pathTick + 1);
                            if (this.pathTick >= this.path.pathToPool.size() - 1) {
                                this.dumpMana();
                            }
                        } else {
                            ++this.boosterExitTick;
                            p = DecimalPosition.interpolate((DecimalPosition)this.getBoosterOrbitPosition(), (DecimalPosition)this.path.boosterExit, (double)((double)this.boosterExitTick / 6.0));
                            this.setPosition(p);
                        }
                    }
                } else {
                    DecimalPosition p = this.path.pathToBooster.get(this.pathTick);
                    this.setPosition(p);
                    ++this.pathTick;
                    if (this.pathTick == this.path.pathToBooster.size()) {
                        this.hitBooster = true;
                        this.pathTick = 0;
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.0;
                        this.field_70159_w = 0.0;
                    }
                }
                this.field_70133_I = true;
                this.field_70180_af.func_75692_b(26, (Object)Float.valueOf((float)this.field_70165_t));
                this.field_70180_af.func_75692_b(27, (Object)Float.valueOf((float)this.field_70163_u));
                this.field_70180_af.func_75692_b(28, (Object)Float.valueOf((float)this.field_70161_v));
            } else {
                ReikaJavaLibrary.pConsole((Object)"Clearing pulse, no path");
                this.func_70106_y();
            }
        } else {
            this.amount = this.field_70180_af.func_75679_c(24);
            this.field_70165_t = this.field_70180_af.func_111145_d(26);
            this.field_70163_u = this.field_70180_af.func_111145_d(27);
            this.field_70161_v = this.field_70180_af.func_111145_d(28);
        }
    }

    private DecimalPosition getBoosterEntryPosition() {
        double ang1 = (0.0 + (double)this.func_145782_y()) % 360.0;
        double ang2 = (0.0 - (double)this.func_145782_y() * 1.6) % 360.0;
        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)0.75, (double)ang1, (double)ang2);
        return new DecimalPosition(this.path.boosterCenter.offset(xyz[0], xyz[1], xyz[2]));
    }

    private DecimalPosition getBoosterOrbitPosition() {
        double ang1 = ((double)this.boosterEntryTick * 2.2 * 4.0 + (double)this.func_145782_y()) % 360.0;
        double ang2 = ((double)this.boosterEntryTick * 1.3 * 4.0 - (double)this.func_145782_y() * 1.6) % 360.0;
        double[] xyz = ReikaPhysicsHelper.polarToCartesian((double)0.75, (double)ang1, (double)ang2);
        return new DecimalPosition(this.path.boosterCenter.offset(xyz[0], xyz[1], xyz[2]));
    }

    private void setPosition(DecimalPosition p) {
        double v = 0.125;
        this.field_70159_w = (p.xCoord - this.field_70165_t) * v;
        this.field_70181_x = (p.yCoord - this.field_70163_u) * v;
        this.field_70179_y = (p.zCoord - this.field_70161_v) * v;
        this.field_70165_t = p.xCoord;
        this.field_70163_u = p.yCoord;
        this.field_70161_v = p.zCoord;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
    }

    public int getMana() {
        return this.amount;
    }

    public float getRenderSize() {
        float base = this.field_70180_af.func_75679_c(25);
        float basefrac = (float)Math.pow(base / 16.0f, 0.25) / 1.25f;
        float frac = (float)this.getMana() / base / 3.0f;
        return frac * basefrac;
    }

    private void extractMana() {
        TileEntityManaBooster.receiveMana(this.field_70170_p, this.path.manaSource, this.startingAmount, true);
        ChromaSounds.FIRE.playSound((Entity)this, 0.1875f, 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
    }

    private void dumpMana() {
        TileEntityManaBooster.dumpMana(this.field_70170_p, this.path.manaTarget, this.amount, true);
        ChromaSounds.GUISEL.playSound((Entity)this, 2.0f, 0.5f);
        this.setPosition(new DecimalPosition(this.path.manaTarget));
        this.hitTarget = true;
    }

    public double getRenderRangeSquared() {
        return 4096.0;
    }

    public double getHitboxSize() {
        return 0.125;
    }

    public boolean despawnOverTime() {
        return false;
    }

    public boolean despawnOverDistance() {
        return false;
    }

    public boolean canInteractWithSpawnLocation() {
        return false;
    }

    public double getSpeed() {
        return 0.0;
    }

    protected boolean dieOnNoVelocity() {
        return false;
    }

    protected boolean onEnterBlock(World world, int x, int y, int z) {
        return false;
    }

    public void func_70108_f(Entity e) {
    }
}

