/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.World.Nether.LavaRiverGenerator;
import Reika.DragonAPI.IO.DirectResourceManager;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaMystcraftHelper;
import com.xcompwiz.mystcraft.api.hook.SymbolValuesAPI;
import com.xcompwiz.mystcraft.api.hook.WordAPI;
import com.xcompwiz.mystcraft.api.symbol.BlockCategory;
import com.xcompwiz.mystcraft.api.symbol.BlockDescriptor;
import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import com.xcompwiz.mystcraft.api.symbol.ModifierUtils;
import com.xcompwiz.mystcraft.api.word.DrawableWord;
import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.api.world.logic.IPopulate;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.world.World;

public class MystPages
implements ReikaMystcraftHelper.MystcraftPageRegistry {
    public static final MystPages instance = new MystPages();

    private MystPages() {
    }

    public void register() {
        Enum p;
        int i;
        for (i = 0; i < Symbols.list.length; ++i) {
            p = Symbols.list[i];
            WordAPI api = (WordAPI)ReikaMystcraftHelper.getAPI((ReikaMystcraftHelper.APISegment)ReikaMystcraftHelper.APISegment.WORD);
            if (api == null) continue;
            api.registerWord(((Symbols)p).getID(), ((Symbols)p).word);
        }
        for (i = 0; i < Pages.list.length; ++i) {
            p = Pages.list[i];
            ReikaMystcraftHelper.setPageRank((IAgeSymbol)p, (int)((Pages)p).itemRank);
            ReikaMystcraftHelper.setRandomAgeWeight((IAgeSymbol)p, (float)((Pages)p).randomWeight);
            ReikaMystcraftHelper.registerAgeSymbol((IAgeSymbol)p);
            ChromatiCraft.logger.log((Object)("Registering custom MystCraft page '" + ((Pages)p).name + "'"));
        }
        SymbolValuesAPI api = (SymbolValuesAPI)ReikaMystcraftHelper.getAPI((ReikaMystcraftHelper.APISegment)ReikaMystcraftHelper.APISegment.SYMBOLVALUES);
        if (api != null) {
            for (int i2 = 0; i2 < Pages.list.length; ++i2) {
                Pages p2 = Pages.list[i2];
                api.setSymbolIsPurchasable((IAgeSymbol)p2, p2.purchasable());
            }
        }
    }

    public static enum Symbols {
        BASE("basic"),
        STRUCTURE("structure"),
        ENERGY("energy"),
        CIVILIZATION("civilization"),
        MATERIAL("material"),
        MINERAL("mineral"),
        HERBAL("herbal"),
        UPGRADE("upgrade"),
        PLAYER("player"),
        INVERSION("invert");

        private final DrawableWord word = new DrawableWord();
        private static final Symbols[] list;

        private Symbols(String s) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                this.setTex(this.word);
            }
            this.word.addDrawComponent(this.ordinal(), 0);
        }

        @SideOnly(value=Side.CLIENT)
        private void setTex(DrawableWord word) {
            String texture = "Reika/ChromatiCraft/Textures/mystpages.png";
            word.setImageSource(DirectResourceManager.getResource((String)texture));
        }

        public String getID() {
            return "chrc_" + this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            list = Symbols.values();
        }
    }

    public static enum Pages implements IAgeSymbol
    {
        PYLONS("Crystal Pylons", 50, 4, 0.25f, Symbols.STRUCTURE, Symbols.ENERGY),
        STRUCTURES("Buried Structures", 200, 4, 0.125f, Symbols.STRUCTURE, Symbols.CIVILIZATION),
        PLANTS("Chroma Plants", 20, 3, 0.75f, Symbols.MATERIAL, Symbols.HERBAL),
        ORES("Chroma Ores", 10, 3, 0.75f, Symbols.MATERIAL, Symbols.MINERAL),
        CRYSTALS("Cave Crystals", 80, 2, 0.5f, Symbols.MATERIAL, Symbols.MINERAL, Symbols.ENERGY),
        TREES("Dye Trees", 5, 1, 1.0f, Symbols.HERBAL, Symbols.ENERGY),
        DENSE("Dense Generation", 400, 6, 0.03125f, Symbols.UPGRADE),
        LOSSY("Lumen Loss", -80, 4, 0.0625f, Symbols.ENERGY, Symbols.CIVILIZATION, Symbols.UPGRADE, Symbols.INVERSION),
        BUFFERDRAIN("Energy Drain", -150, 4, 0.125f, Symbols.ENERGY, Symbols.PLAYER, Symbols.UPGRADE, Symbols.INVERSION),
        HOSTILE("Hostile Aura", -40, 5, 0.03125f, Symbols.ENERGY, Symbols.PLAYER, Symbols.MINERAL, Symbols.INVERSION),
        CORRUPTED("Corrupted Aura", -400, 5, 0.03125f, Symbols.MATERIAL, Symbols.UPGRADE, Symbols.INVERSION),
        LAVARIVER("Sky Rivers", 2, 4, 0.0625f, Symbols.STRUCTURE, Symbols.MATERIAL, Symbols.MINERAL),
        VIOLENTPYLONS("Excessive Discharge", -60, 4, 0.0625f, Symbols.STRUCTURE, Symbols.PLAYER, Symbols.UPGRADE, Symbols.INVERSION),
        UNSTABLEPYLONS("Pylon Destabilization", -200, 5, 0.015625f, Symbols.ENERGY, Symbols.UPGRADE, Symbols.INVERSION);

        public final String name;
        public final int instability;
        private final int itemRank;
        private final float randomWeight;
        private final HashMap<Integer, Boolean> dimCache = new HashMap();
        private final ArrayList<Symbols> icons;
        private static final Pages[] list;

        private Pages(String s, int ins, int r, float w, Symbols ... icons) {
            this.name = s;
            this.instability = ins;
            this.itemRank = r;
            this.randomWeight = w;
            this.icons = ReikaJavaLibrary.makeListFromArray((Object[])icons);
            this.icons.add(0, Symbols.BASE);
        }

        public boolean existsInWorld(World age) {
            Boolean b = this.dimCache.get(age.field_73011_w.field_76574_g);
            if (b == null) {
                b = ReikaMystcraftHelper.isMystAge((World)age) && ReikaMystcraftHelper.isSymbolPresent((World)age, (String)this.identifier());
                this.dimCache.put(age.field_73011_w.field_76574_g, b);
            }
            return b;
        }

        public void registerLogic(AgeDirector age, long seed) {
            switch (this) {
                case LAVARIVER: {
                    BlockDescriptor b1 = ModifierUtils.popBlockMatching((AgeDirector)age, (BlockCategory[])new BlockCategory[]{BlockCategory.STRUCTURE});
                    BlockDescriptor b2 = ModifierUtils.popBlockMatching((AgeDirector)age, (BlockCategory[])new BlockCategory[]{BlockCategory.FLUID});
                    age.registerInterface((IPopulate)new LavaRiverGenerator(seed, b1 != null ? new BlockKey(b1.block, (int)b1.metadata) : null, b2 != null ? new BlockKey(b2.block, (int)b2.metadata) : null));
                    break;
                }
            }
        }

        public int instabilityModifier(int count) {
            return count == 1 ? this.instability : 0;
        }

        public String identifier() {
            return "chrc_" + this.name().toLowerCase(Locale.ENGLISH);
        }

        public String displayName() {
            return this.name;
        }

        public String[] getPoem() {
            ArrayList<String> li = new ArrayList<String>();
            for (Symbols s : this.icons) {
                li.add(s.getID());
            }
            return li.toArray(new String[li.size()]);
        }

        public boolean purchasable() {
            switch (this) {
                case PLANTS: 
                case ORES: 
                case TREES: 
                case CRYSTALS: {
                    return true;
                }
            }
            return false;
        }

        static {
            list = Pages.values();
        }
    }
}

