/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.NEI;

import Reika.ChromatiCraft.GUI.Tile.Inventory.GuiCrystalBrewer;
import Reika.ChromatiCraft.Magic.CrystalPotionController;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Recipe.TileEntityCrystalBrewer;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPotionHelper;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;

public class CrystalBrewerHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Crystal Brewing";
    }

    public String getGuiTexture() {
        return "textures/gui/container/brewing_stand.png";
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() == ChromaItems.POTION.getItemInstance()) {
            this.arecipes.add(new CrystalRecipe(result.func_77960_j() % 16));
        } else if (result.func_77973_b() == Items.field_151068_bn) {
            int id = ReikaPotionHelper.getPotionID((int)result.func_77960_j());
            for (int i = 0; i < 32; ++i) {
                CrystalElement color = CrystalElement.elements[i % 16];
                ItemStack out = TileEntityCrystalBrewer.getPotionStackFromColor(result.func_77960_j(), color, i >= 16);
                if (!ReikaItemHelper.matchStacks((ItemStack)result, (ItemStack)out)) continue;
                this.arecipes.add(new CrystalRecipe(i));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block3: {
            int dmg;
            block4: {
                block2: {
                    if (ingredient.func_77973_b() != ChromaItems.SHARD.getItemInstance()) break block2;
                    this.arecipes.add(new CrystalRecipe(ingredient.func_77960_j()));
                    break block3;
                }
                if (ingredient.func_77973_b() != Items.field_151068_bn) break block3;
                dmg = ingredient.func_77960_j();
                if (dmg != 0) break block4;
                for (int i = 0; i < 32; ++i) {
                    CrystalElement color = CrystalElement.elements[i % 16];
                    if (CrystalPotionController.instance.isPotionModifier(color)) continue;
                    this.arecipes.add(new CrystalRecipe(i));
                }
                break block3;
            }
            if (!ReikaPotionHelper.getPotionValues().values().contains(dmg)) break block3;
            for (int i = 0; i < 32; ++i) {
                CrystalElement color = CrystalElement.elements[i % 16];
                if (!CrystalPotionController.instance.isPotionModifier(color)) continue;
                this.arecipes.add(new CrystalRecipe(i));
            }
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrystalBrewer.class;
    }

    private class CrystalRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final CrystalElement color;
        public final boolean boosted;

        public CrystalRecipe(int dmg) {
            super((TemplateRecipeHandler)CrystalBrewerHandler.this);
            this.color = CrystalElement.elements[dmg % 16];
            this.boosted = dmg >= 16;
        }

        public PositionedStack getResult() {
            return null;
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.getInputShard(), 74, 6);
        }

        public ItemStack getInputShard() {
            return ChromaItems.SHARD.getStackOfMetadata(this.boosted ? 16 + this.color.ordinal() : this.color.ordinal());
        }

        public Potion getOutputPotion() {
            return Potion.field_76425_a[CrystalPotionController.instance.getEffectFromColor(this.color, 20, 0, false).func_76456_a()];
        }

        public List<PositionedStack> getOtherStacks() {
            ItemStack in = new ItemStack((Item)Items.field_151068_bn);
            if (CrystalPotionController.instance.isPotionModifier(this.color)) {
                ArrayList li = ReikaPotionHelper.getBasePotionItems();
                int tick = (int)(System.currentTimeMillis() / 1000L % (long)li.size());
                in = (ItemStack)li.get(tick);
            }
            ItemStack out = TileEntityCrystalBrewer.getPotionStackFromColor(in.func_77960_j(), this.color, this.boosted);
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(new PositionedStack((Object)in, 51, 35));
            stacks.add(new PositionedStack((Object)out, 97, 35));
            return stacks;
        }
    }
}

