/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.NEI;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.FabricationRecipes;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.ModInterface.NEI.NEIChromaConfig;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.TileEntity.Processing.TileEntityGlowFire;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Libraries.IO.ReikaTextureHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Rendering.ReikaGuiAPI;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class GlowFireHandler
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return "Lumen Transmutation";
    }

    public String getGuiTexture() {
        return "/Reika/ChromatiCraft/Textures/GUIs/itemvalue.png";
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)this.getGuiTexture());
        GL11.glDisable((int)2929);
        this.drawExtras(recipe);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        ReikaTextureHelper.bindTexture(ChromatiCraft.class, (String)this.getGuiTexture());
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(32, -12, 105, 10), "ccglowfire", new Object[0]));
    }

    private void loadAllRecipes(boolean costs) {
        Collection<KeyedItemStack> li = costs ? FabricationRecipes.recipes().getFabricableItems() : FabricationRecipes.recipes().getConsumableItems();
        for (KeyedItemStack is : li) {
            ElementTagCompound tag = costs ? TileEntityGlowFire.getCost(is.getItemStack()) : TileEntityGlowFire.getDecompositionValue(is.getItemStack());
            if (tag == null) continue;
            this.arecipes.add(new GlowFireRecipe(is.getItemStack(), tag, true));
        }
        Collections.sort(this.arecipes, NEIChromaConfig.elementRecipeSorter);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId != null && outputId.equals("ccglowfire")) {
            this.loadAllRecipes(true);
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId != null && inputId.equals("ccglowfire")) {
            this.loadAllRecipes(false);
        }
        super.loadUsageRecipes(inputId, ingredients);
    }

    public void loadCraftingRecipes(ItemStack result) {
        ElementTagCompound tag = TileEntityGlowFire.getCost(result);
        if (tag != null) {
            this.arecipes.add(new GlowFireRecipe(result, tag, false));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ElementTagCompound tag = TileEntityGlowFire.getDecompositionValue(ingredient);
        if (tag != null) {
            this.arecipes.add(new GlowFireRecipe(ingredient, tag, true));
        }
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return null;
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawExtras(int recipe) {
        double dy;
        double dx;
        double er;
        double a;
        double val;
        CrystalElement e;
        int i;
        GlowFireRecipe fr = (GlowFireRecipe)this.arecipes.get(recipe);
        if (fr == null) {
            return;
        }
        if (fr.cost == null) {
            throw new IllegalStateException(this.getRecipeName() + " recipe " + fr.item + " has null cost?!");
        }
        ElementTagCompound tag = fr.cost;
        if (ReikaItemHelper.matchStacks((ItemStack)fr.item, (ItemStack)ChromaStacks.glowcavedust)) {
            int lim = tag.getMaximumValue();
            tag = new ElementTagCompound();
            for (CrystalElement e2 : fr.cost.elementSet()) {
                int amt = (int)((double)(lim / 2) + (double)(lim / 2 + 1) * Math.sin((double)(System.identityHashCode(e2) * System.identityHashCode(fr)) + (double)System.currentTimeMillis() / 2400.0));
                tag.addTag(e2, amt);
            }
        }
        double r = 54.0;
        double ox = 81.0;
        double oy = 68.0;
        double ir = 12.0;
        double o = 2.0;
        double max = Math.log((double)tag.getMaximumValue() + o);
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glShadeModel((int)7425);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78378_d(0x303030);
        Tessellator.field_78398_a.func_78377_a(-2.0, 133.0, 0.0);
        Tessellator.field_78398_a.func_78377_a(168.0, 133.0, 0.0);
        Tessellator.field_78398_a.func_78377_a(168.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78377_a(-2.0, 0.0, 0.0);
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78371_b(1);
        Tessellator.field_78398_a.func_78378_d(0x535353);
        for (int i2 = 0; i2 < 16; ++i2) {
            CrystalElement e3 = CrystalElement.elements[i2];
            double a2 = Math.toRadians((double)e3.ordinal() * 22.5 - 90.0);
            double dx2 = ox + r * Math.cos(a2);
            double dy2 = oy + r * Math.sin(a2);
            double dx22 = ox + r * Math.cos(a2 + Math.toRadians(22.5));
            double dy22 = oy + r * Math.sin(a2 + Math.toRadians(22.5));
            Tessellator.field_78398_a.func_78377_a(ox, oy, 0.0);
            Tessellator.field_78398_a.func_78377_a(dx2, dy2, 0.0);
            Tessellator.field_78398_a.func_78377_a(dx2, dy2, 0.0);
            Tessellator.field_78398_a.func_78377_a(dx22, dy22, 0.0);
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double er2 = Math.max(ir, r * Math.log((double)tag.getValue(CrystalElement.BLACK) + o) / max);
        Tessellator.field_78398_a.func_78371_b(6);
        Tessellator.field_78398_a.func_78378_d(!fr.output ? 0xFFFFFF : 0x202020);
        Tessellator.field_78398_a.func_78377_a(ox, oy, 0.0);
        Tessellator.field_78398_a.func_78378_d(fr.output ? 0xFFFFFF : 0x6A6A6A);
        for (i = 0; i < 16; ++i) {
            e = CrystalElement.elements[15 - i];
            val = Math.log((double)tag.getValue(e) + o);
            a = Math.toRadians((double)e.ordinal() * 22.5 - 90.0);
            er = Math.max(ir, r * val / max);
            dx = ox + er * Math.cos(a);
            dy = oy + er * Math.sin(a);
            Tessellator.field_78398_a.func_78380_c(240);
            if (i == 0) {
                Tessellator.field_78398_a.func_78377_a(ox, oy - er2, 0.0);
            }
            Tessellator.field_78398_a.func_78377_a(dx, dy, 0.0);
        }
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78371_b(2);
        Tessellator.field_78398_a.func_78378_d(0);
        for (i = 0; i < 16; ++i) {
            e = CrystalElement.elements[i];
            val = Math.log((double)tag.getValue(e) + o);
            a = Math.toRadians((double)e.ordinal() * 22.5 - 90.0);
            er = Math.max(ir, r * val / max);
            dx = ox + er * Math.cos(a);
            dy = oy + er * Math.sin(a);
            Tessellator.field_78398_a.func_78378_d(e.getColor());
            Tessellator.field_78398_a.func_78377_a(dx, dy, 0.0);
        }
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopAttrib();
        double r2 = r + 6.0;
        for (int i3 = 0; i3 < 16; ++i3) {
            CrystalElement e4 = CrystalElement.elements[i3];
            double val2 = Math.log((double)tag.getValue(e4) + o);
            double a3 = Math.toRadians((double)e4.ordinal() * 22.5 - 90.0);
            int dx3 = (int)(ox + r2 * Math.cos(a3)) - 4;
            int dy3 = (int)(oy + r2 * Math.sin(a3)) - 4;
            Tessellator.field_78398_a.func_78378_d(e4.getColor());
            Tessellator.field_78398_a.func_78377_a((double)dx3, (double)dy3, 0.0);
            IIcon ico = e4.getGlowRune();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ReikaTextureHelper.bindTerrainTexture();
            ReikaGuiAPI.instance.func_94065_a(dx3, dy3, ico, 8, 8);
            if (tag.getValue(e4) <= 0) continue;
            int c = ReikaColorAPI.mixColors((int)e4.getColor(), (int)0xFFFFFF, (float)0.5f);
            String s = String.valueOf(tag.getValue(e4));
            int tx = (double)dx3 > ox ? dx3 + 9 : dx3 - Minecraft.func_71410_x().field_71466_p.func_78256_a(s);
            int ty = dy3 + 1;
            Minecraft.func_71410_x().field_71466_p.func_78276_b(s, tx, ty, c);
        }
    }

    private class GlowFireRecipe
    extends TemplateRecipeHandler.CachedRecipe
    implements NEIChromaConfig.ElementTagRecipe {
        private final ItemStack item;
        private final ElementTagCompound cost;
        private final boolean output;

        public GlowFireRecipe(ItemStack out, ElementTagCompound tag, boolean output) {
            super((TemplateRecipeHandler)GlowFireHandler.this);
            this.item = ReikaItemHelper.getSizedItemStack((ItemStack)out, (int)1);
            this.cost = tag;
            this.output = output;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.item, 73, 59);
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            return stacks;
        }

        @Override
        public ItemStack getItem() {
            return this.item.func_77946_l();
        }

        @Override
        public ElementTagCompound getTag() {
            return this.cost.copy();
        }
    }
}

