/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface;

import Reika.ChromatiCraft.Auxiliary.ChromaAux;
import Reika.ChromatiCraft.Auxiliary.HoldingChecks;
import Reika.ChromatiCraft.Base.BlockAttachableMini;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockVector;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.ParticleController.SplineMotionController;
import Reika.DragonAPI.Instantiable.ParticlePath;
import Reika.DragonAPI.Interfaces.PositionController;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RFWeb {
    private static final HashMap<Integer, RFWeb> instances = new HashMap();
    public static final int RANGE = 9;
    public static final int THROUGHPUT = 1800;
    private final HashMap<Coordinate, RFConnection> data = new HashMap();
    private final int dimensionID;

    private RFWeb(World world) {
        this.dimensionID = world.field_73011_w.field_76574_g;
    }

    public static RFWeb getWeb(World world) {
        RFWeb ret = instances.get(world.field_73011_w.field_76574_g);
        if (ret == null) {
            ret = new RFWeb(world);
            instances.put(world.field_73011_w.field_76574_g, ret);
        }
        return ret;
    }

    private void tick(World world) {
        HashSet<Coordinate> toRemove = new HashSet<Coordinate>();
        int amt = 0;
        for (Map.Entry<Coordinate, RFConnection> e : this.data.entrySet()) {
            IEnergyConnection con;
            boolean valid = false;
            Coordinate c = e.getKey();
            RFConnection r = e.getValue();
            BlockKey at = c.getBlockKey((IBlockAccess)world);
            if (c.getBlockKey((IBlockAccess)world).equals((Object)r.blockType) && (con = r.getConnection(world)) != null) {
                valid = true;
                ++amt;
                r.recalculateFraction(con);
            }
            if (valid) continue;
            toRemove.add(c);
        }
        for (Coordinate c : toRemove) {
            this.removeNode(world, c.xCoord, c.yCoord, c.zCoord);
        }
        if (amt == 0) {
            return;
        }
        for (RFConnection r : this.data.values()) {
            r.balanceWithBranches(this, world);
        }
    }

    public void addNode(World world, int x, int y, int z, ForgeDirection side) {
        if (world.field_72995_K) {
            return;
        }
        Coordinate c = new Coordinate(x, y, z);
        RFConnection get = this.data.get(c);
        if (get != null) {
            return;
        }
        RFConnection con = new RFConnection(world, c, side);
        this.data.put(c, con);
        for (RFConnection r : this.findNear(c)) {
            r.branches.add(c);
            con.branches.add(r.location);
        }
    }

    private Collection<RFConnection> findNear(Coordinate c) {
        ArrayList<RFConnection> li = new ArrayList<RFConnection>();
        for (RFConnection r : this.data.values()) {
            if (!r.location.isWithinDistOnAllCoords(c, 9)) continue;
            li.add(r);
        }
        return li;
    }

    public void removeNode(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        Coordinate c = new Coordinate(x, y, z);
        RFConnection prev = this.data.remove(c);
        for (RFConnection r : this.data.values()) {
            r.branches.remove(c);
        }
    }

    public int tryDistributeEnergy(World world, int x, int y, int z, int amt) {
        amt = Math.min(amt, 1800);
        Coordinate c = new Coordinate(x, y, z);
        RFConnection rf = this.data.get(c);
        if (rf == null) {
            return 0;
        }
        return rf.tryDistribute(this, world, amt);
    }

    @SideOnly(value=Side.CLIENT)
    private static boolean shouldAcceptParticle(World world) {
        return HoldingChecks.MANIPULATOR.isClientHolding() ? true : world.field_73012_v.nextInt(4) == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static void doSendParticle(World world, int x1, int y1, int z1, int x2, int y2, int z2, int amt) {
        int dt;
        if (!RFWeb.shouldAcceptParticle(world)) {
            return;
        }
        ForgeDirection d1 = ((BlockAttachableMini)world.func_147439_a(x1, y1, z1)).getSide((IBlockAccess)world, x1, y1, z1);
        ForgeDirection d2 = ((BlockAttachableMini)world.func_147439_a(x2, y2, z2)).getSide((IBlockAccess)world, x2, y2, z2);
        ParticlePath p = ParticlePath.getPath((World)world, (BlockVector)new BlockVector(x1, y1, z1, d1), (BlockVector)new BlockVector(x2, y2, z2, d2), (double)0.375, (double)0.7);
        EntityCCBlurFX fx = new EntityCCBlurFX(world, (double)x1 + 0.5, (double)y1 + 0.5, (double)z1 + 0.5);
        List path = p != null ? p.getPath() : null;
        int l = p != null ? Math.max(10, 3 * path.size() / 2) : 90;
        float s = Math.max(0.8f, Math.min(2.4f, (float)amt * 2.4f / 1800.0f));
        fx.setColor(0xFF0000).setScale(s).setLife(l).setAlphaFading().forceIgnoreLimits();
        int hash = p != null ? Math.abs(p.hashCode()) : 0;
        int n = dt = p != null ? Math.max(1, 5 - path.size() / 20) : 3;
        if (world.func_82737_E() % (long)dt != (long)(hash % dt)) {
            return;
        }
        if (p != null) {
            fx.setPositionController((PositionController)new SplineMotionController(l, p.spline));
        } else {
            double v = 0.0625;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double dz = z2 - z1;
            double d = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            fx.field_70159_w = v * dx / d;
            fx.field_70181_x = v * dy / d;
            fx.field_70179_y = v * dz / d;
            fx.setColor(0xFF9090).setNoSlowdown();
        }
        if (p != null) {
            EntityCCBlurFX fx2 = new EntityCCBlurFX(world, (double)x1 + 0.5, (double)y1 + 0.5, (double)z1 + 0.5);
            fx2.setColor(0xFFFFFF).setScale(s / 2.0f).setLife(l).setAlphaFading().forceIgnoreLimits();
            fx2.setPositionController((PositionController)new SplineMotionController(l, p.spline).setTick(-6));
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
    }

    static {
        FMLCommonHandler.instance().bus().register((Object)new RFWebHandler());
    }

    private static class RFConnection {
        private final ForgeDirection connection;
        private final Coordinate location;
        private final HashSet<Coordinate> branches = new HashSet();
        private final BlockKey blockType;
        private final boolean canEmit;
        private final boolean canReceive;
        private float currentFraction;

        private RFConnection(World world, Coordinate c, ForgeDirection dir) {
            this.blockType = c.getBlockKey((IBlockAccess)world);
            this.connection = dir;
            this.location = c;
            IEnergyConnection con = this.getConnection(world);
            this.canEmit = con instanceof IEnergyProvider || con instanceof IEnergyHandler;
            this.canReceive = con instanceof IEnergyReceiver || con instanceof IEnergyHandler;
        }

        private void balanceWithBranches(RFWeb web, World world) {
            for (Coordinate c : this.branches) {
                RFConnection r = (RFConnection)web.data.get(c);
                if (r == null || !(this.currentFraction > r.currentFraction)) continue;
                this.moveEnergyTo(world, r, 1800, false);
            }
        }

        private int tryDistribute(RFWeb web, World world, int amt) {
            int total = 0;
            for (Coordinate c : this.branches) {
                int moved;
                RFConnection r = (RFConnection)web.data.get(c);
                if (r == null || r == this || (moved = this.moveEnergyTo(world, r, amt, true)) <= 0) continue;
                total += moved;
                if ((amt -= moved) > 0) continue;
                break;
            }
            return total;
        }

        private int moveEnergyTo(World world, RFConnection r, int amt, boolean forceAllow) {
            int mov = r.addEnergy(world, amt, false);
            if (!forceAllow) {
                mov = this.takeEnergy(world, mov, true);
            }
            if ((mov = (int)((float)mov * ChromaAux.getRFTransferEfficiency(world, this.location.xCoord, this.location.yCoord, this.location.zCoord))) > 0) {
                mov = r.addEnergy(world, mov, true);
            }
            if (mov > 0 && this.shouldCreateParticle(world)) {
                int range = world.field_73012_v.nextInt(3) == 0 ? 60 : 30;
                ReikaPacketHelper.sendDataPacketWithRadius((String)"ChromaData", (int)ChromaPackets.RFWEBSEND.ordinal(), (World)world, (int)this.location.xCoord, (int)this.location.yCoord, (int)this.location.zCoord, (int)range, (int[])new int[]{r.location.xCoord, r.location.yCoord, r.location.zCoord, mov});
            }
            return mov;
        }

        private boolean shouldCreateParticle(World world) {
            return world.field_73012_v.nextInt(2) == 0;
        }

        private int addEnergy(World world, int amt, boolean doAdd) {
            IEnergyConnection con = this.getConnection(world);
            if (con instanceof IEnergyHandler) {
                return ((IEnergyHandler)con).receiveEnergy(this.connection.getOpposite(), amt, !doAdd);
            }
            if (con instanceof IEnergyReceiver) {
                return ((IEnergyReceiver)con).receiveEnergy(this.connection.getOpposite(), amt, !doAdd);
            }
            return 0;
        }

        private int takeEnergy(World world, int amt, boolean doTake) {
            IEnergyConnection con = this.getConnection(world);
            if (con instanceof IEnergyHandler) {
                return ((IEnergyHandler)con).extractEnergy(this.connection.getOpposite(), amt, !doTake);
            }
            if (con instanceof IEnergyProvider) {
                return ((IEnergyProvider)con).extractEnergy(this.connection.getOpposite(), amt, !doTake);
            }
            return 0;
        }

        private void recalculateFraction(IEnergyConnection con) {
            this.currentFraction = (float)this.getCurrentEnergy(con) / (float)this.getCapacity(con);
        }

        private int getCurrentEnergy(IEnergyConnection con) {
            if (con instanceof IEnergyHandler) {
                return ((IEnergyHandler)con).getEnergyStored(this.connection.getOpposite());
            }
            if (con instanceof IEnergyReceiver) {
                return ((IEnergyReceiver)con).getEnergyStored(this.connection.getOpposite());
            }
            if (con instanceof IEnergyProvider) {
                return ((IEnergyProvider)con).getEnergyStored(this.connection.getOpposite());
            }
            return 0;
        }

        private int getCapacity(IEnergyConnection con) {
            if (con instanceof IEnergyHandler) {
                return ((IEnergyHandler)con).getMaxEnergyStored(this.connection.getOpposite());
            }
            if (con instanceof IEnergyReceiver) {
                return ((IEnergyReceiver)con).getMaxEnergyStored(this.connection.getOpposite());
            }
            if (con instanceof IEnergyProvider) {
                return ((IEnergyProvider)con).getMaxEnergyStored(this.connection.getOpposite());
            }
            return 0;
        }

        private IEnergyConnection getConnection(World world) {
            TileEntity te = this.location.offset(this.connection, 1).getTileEntity((IBlockAccess)world);
            return te instanceof IEnergyConnection ? (IEnergyConnection)te : null;
        }
    }

    public static class RFWebHandler {
        @SubscribeEvent
        public void tickEvent(TickEvent.WorldTickEvent evt) {
            if (evt.world.field_72995_K) {
                return;
            }
            RFWeb web = (RFWeb)instances.get(evt.world.field_73011_w.field_76574_g);
            if (web != null) {
                web.tick(evt.world);
            }
        }
    }
}

