/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PoolRecipes;
import Reika.ChromatiCraft.Block.BlockActiveChroma;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Items.ItemCrystalShard;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.APIPacketHandler;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.RotaryCraft.API.ReservoirAPI;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ReservoirHandlers {
    private static final Random rand = new Random();
    public static final int ACCEL_FACTOR = 2;

    private static long getRecentEtherDissolve(TileEntity te, FluidStack fs) {
        long val = fs.tag != null ? fs.tag.func_74763_f("etherdissolve") : 0L;
        return te.func_145831_w().func_82737_E() - val;
    }

    public static class PoolRecipeHandler
    extends ChromaReservoirRecipeHandlerBase {
        @Override
        protected int doTick(TileEntity te, FluidStack fs, EntityPlayer owner, float speed) {
            if (rand.nextInt(3) == 0) {
                int ether = fs.tag != null ? fs.tag.func_74762_e("ether") : 0;
                AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e);
                List li = te.field_145850_b.func_72872_a(EntityItem.class, box);
                for (EntityItem ei : li) {
                    if (!PoolRecipes.instance.canAlloyItem(ei)) continue;
                    PoolRecipes.PoolRecipe pr = PoolRecipes.instance.getPoolRecipe(ei, li, false, owner);
                    if (pr != null) {
                        if (ei.field_70170_p.field_72995_K) {
                            int i = 0;
                            while ((float)i < 2.0f * speed) {
                                ChromaFX.poolRecipeParticles(ei);
                                ++i;
                            }
                            break;
                        }
                        if (ei.field_70173_aa <= 20 || rand.nextInt(20 / (int)(2.0f * speed)) != 0 || ReservoirHandlers.getRecentEtherDissolve(te, fs) < 5L || ei.field_70173_aa < 5 || ei.field_70173_aa < 600 && rand.nextInt((600 - ei.field_70173_aa) / 2) != 0) break;
                        PoolRecipes.instance.makePoolRecipe(ei, pr, ether, te.field_145851_c, te.field_145848_d, te.field_145849_e);
                        fs.tag = null;
                        return 1000;
                    }
                    ei.lifespan = Integer.MAX_VALUE;
                }
            }
            return 0;
        }

        @Override
        protected BlockKey getRune(FluidStack fs) {
            return new BlockKey(ChromaBlocks.PYLONSTRUCT.getBlockInstance(), BlockPylonStructure.StoneTypes.MULTICHROMIC.ordinal());
        }

        @Override
        protected float getRuneSpeedScale() {
            return 2.0f;
        }
    }

    public static class ShardBoostingHandler
    extends ChromaReservoirRecipeHandlerBase {
        @Override
        protected int doTick(TileEntity te, FluidStack fs, EntityPlayer owner, float speed) {
            int dye = fs.tag != null ? fs.tag.func_74762_e("berries") : 0;
            int ether = fs.tag != null ? fs.tag.func_74762_e("ether") : 0;
            CrystalElement e = dye > 0 ? CrystalElement.elements[fs.tag.func_74762_e("element")] : null;
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e);
            List li = te.field_145850_b.func_72872_a(EntityItem.class, box);
            for (EntityItem ei : li) {
                ItemStack is = ei.func_92059_d();
                if (e == null || is.func_77960_j() != e.ordinal() || !ChromaItems.SHARD.matchWith(is) || dye != 24 || !ItemCrystalShard.canCharge(ei)) continue;
                boolean done = false;
                int i = 0;
                while ((float)i < 2.0f * speed && !done) {
                    done = ItemCrystalShard.tickShardCharging(ei, e, ether, te.field_145851_c, te.field_145848_d, te.field_145849_e);
                    ++i;
                }
                if (te.field_145850_b.field_72995_K || !done) continue;
                fs.tag = null;
                return 200;
            }
            return 0;
        }

        @Override
        protected BlockKey getRune(FluidStack fs) {
            int dye = fs.tag != null ? fs.tag.func_74762_e("berries") : 0;
            CrystalElement e = dye > 0 ? CrystalElement.elements[fs.tag.func_74762_e("element")] : null;
            return e != null ? new BlockKey(ChromaBlocks.RUNE.getBlockInstance(), e.ordinal()) : null;
        }

        @Override
        protected float getRuneSpeedScale() {
            return 3.0f;
        }
    }

    public static class ChromaPrepHandler
    extends ChromaReservoirRecipeHandlerBase {
        @Override
        protected int doTick(TileEntity te, FluidStack fs, EntityPlayer owner, float speed) {
            int dye = fs.tag != null ? fs.tag.func_74762_e("berries") : 0;
            int ether = fs.tag != null ? fs.tag.func_74762_e("ether") : 0;
            CrystalElement e = dye > 0 ? CrystalElement.elements[fs.tag.func_74762_e("element")] : null;
            AxisAlignedBB box = ReikaAABBHelper.getBlockAABB((int)te.field_145851_c, (int)te.field_145848_d, (int)te.field_145849_e);
            List li = te.field_145850_b.func_72872_a(EntityItem.class, box);
            boolean flag = false;
            for (EntityItem ei : li) {
                ItemStack is = ei.func_92059_d();
                if (!te.field_145850_b.field_72995_K && rand.nextInt(5) == 0 && dye < 24 && ChromaItems.BERRY.matchWith(is) && (e == null || is.func_77960_j() == e.ordinal())) {
                    e = CrystalElement.elements[is.func_77960_j()];
                    if (fs.tag == null) {
                        fs.tag = new NBTTagCompound();
                    }
                    fs.tag.func_74768_a("element", e.ordinal());
                    while (dye < 24 && is.field_77994_a > 0) {
                        dye = fs.tag.func_74762_e("berries") + 1;
                        fs.tag.func_74768_a("berries", dye);
                        --is.field_77994_a;
                    }
                    if (is.field_77994_a <= 0) {
                        ei.func_70106_y();
                    }
                    flag = true;
                    continue;
                }
                if (te.field_145850_b.field_72995_K || ReservoirHandlers.getRecentEtherDissolve(te, fs) < 2L || ether >= 16 || !ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)ChromaStacks.etherBerries)) continue;
                if (fs.tag == null) {
                    fs.tag = new NBTTagCompound();
                }
                if (ether < 16 && is.field_77994_a > 0) {
                    ether = fs.tag.func_74762_e("ether") + 1;
                    fs.tag.func_74768_a("ether", ether);
                    fs.tag.func_74772_a("etherdissolve", te.field_145850_b.func_82737_E());
                    --is.field_77994_a;
                    ReikaPacketHelper.sendDataPacketWithRadius((String)"DragonAPIData", (int)APIPacketHandler.PacketIDs.PARTICLE.ordinal(), (TileEntity)te, (int)24, (int[])new int[]{ReikaParticleHelper.SPELL.ordinal(), 8});
                }
                if (is.field_77994_a <= 0) {
                    ei.func_70106_y();
                }
                flag = true;
            }
            if (flag && e != null) {
                fs.tag.func_74768_a("renderColor", BlockActiveChroma.getColor(e, dye));
            }
            return 0;
        }

        @Override
        protected BlockKey getRune(FluidStack stored) {
            return null;
        }

        @Override
        protected float getRuneSpeedScale() {
            return 0.0f;
        }
    }

    private static abstract class ChromaReservoirRecipeHandlerBase
    implements ReservoirAPI.TankHandler {
        private ChromaReservoirRecipeHandlerBase() {
        }

        public final int onTick(TileEntity te, FluidStack stored, EntityPlayer owner) {
            if (stored != null && stored.amount >= 1000 && stored.getFluid() == FluidRegistry.getFluid((String)"chroma")) {
                BlockKey bk = this.getRune(stored);
                float sp = bk != null && bk.matchInWorld(te.field_145850_b, te.field_145851_c, te.field_145848_d - 1, te.field_145849_e) ? this.getRuneSpeedScale() : 1.0f;
                return this.doTick(te, stored, owner, sp);
            }
            return 0;
        }

        protected abstract int doTick(TileEntity var1, FluidStack var2, EntityPlayer var3, float var4);

        protected abstract BlockKey getRune(FluidStack var1);

        protected abstract float getRuneSpeedScale();
    }
}

