/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Auxiliary.RecipeManagers.PoolRecipes;
import Reika.ChromatiCraft.Block.BlockPylonStructure;
import Reika.ChromatiCraft.Block.Worldgen.BlockDecoFlower;
import Reika.ChromatiCraft.Block.Worldgen.BlockStructureShield;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredOre;
import Reika.ChromatiCraft.Block.Worldgen.BlockTieredPlant;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Items.ItemCrystalSeeds;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Registry.ChromaBlocks;
import Reika.ChromatiCraft.Registry.ChromaItems;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Instantiable.Data.Maps.ReversibleMultiMap;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class ChromaAspectManager {
    private final ReversibleMultiMap<CrystalElement, Aspect> aspectsColor = new ReversibleMultiMap(MultiMap.CollectionType.HASHSET);
    private final ReversibleMultiMap<CrystalElement, Aspect> aspectsThematic = new ReversibleMultiMap(MultiMap.CollectionType.HASHSET);
    public final Aspect PUZZLE = new Aspect("perplexus", 9502640, new Aspect[]{Aspect.MIND, Aspect.TRAP}, new ResourceLocation("chromaticraft", "textures/aspects/puzzle.png"), 1);
    public final Aspect SIGNAL = new Aspect("signum", 0xFFFF00, new Aspect[]{Aspect.ENERGY, Aspect.AURA}, new ResourceLocation("chromaticraft", "textures/aspects/signal.png"), 1);
    public final Aspect PRECURSOR = new Aspect("principia", 7723775, new Aspect[]{Aspect.ELDRITCH, Aspect.MIND}, new ResourceLocation("chromaticraft", "textures/aspects/precursor.png"), 1);
    public static final ChromaAspectManager instance = new ChromaAspectManager();

    private ChromaAspectManager() {
        this.addAspectColor(CrystalElement.BLACK, Aspect.DARKNESS);
        this.addAspectColor(CrystalElement.RED, Aspect.LIFE, Aspect.HUNGER, Aspect.HEAL);
        this.addAspectColor(CrystalElement.GREEN, Aspect.PLANT, Aspect.POISON, Aspect.EARTH);
        this.addAspectColor(CrystalElement.BROWN, Aspect.BEAST, Aspect.TREE);
        this.addAspectColor(CrystalElement.BLUE, Aspect.WATER, Aspect.TOOL);
        this.addAspectColor(CrystalElement.PURPLE, Aspect.MAGIC, Aspect.TAINT, Aspect.ELDRITCH);
        this.addAspectColor(CrystalElement.CYAN, Aspect.ARMOR, Aspect.SENSES);
        this.addAspectColor(CrystalElement.LIGHTGRAY, Aspect.VOID, Aspect.SOUL, Aspect.METAL);
        this.addAspectColor(CrystalElement.GRAY, Aspect.ENTROPY);
        this.addAspectColor(CrystalElement.PINK, Aspect.MIND);
        this.addAspectColor(CrystalElement.LIME, Aspect.SLIME);
        this.addAspectColor(CrystalElement.YELLOW, Aspect.LIGHT, Aspect.AIR, Aspect.GREED, this.SIGNAL);
        this.addAspectColor(CrystalElement.LIGHTBLUE, Aspect.CRYSTAL, Aspect.MECHANISM, Aspect.MOTION);
        this.addAspectColor(CrystalElement.MAGENTA, Aspect.FLESH);
        this.addAspectColor(CrystalElement.ORANGE, Aspect.FIRE);
        this.addAspectColor(CrystalElement.WHITE, Aspect.ORDER, Aspect.COLD, Aspect.FLIGHT, Aspect.WEATHER);
        this.addAspectTheme(CrystalElement.BLACK, Aspect.MAGIC);
        this.addAspectTheme(CrystalElement.RED, Aspect.ARMOR);
        this.addAspectTheme(CrystalElement.GREEN, Aspect.EARTH, Aspect.PLANT);
        this.addAspectTheme(CrystalElement.BROWN, Aspect.METAL, Aspect.MINE);
        this.addAspectTheme(CrystalElement.BLUE, Aspect.LIGHT);
        this.addAspectTheme(CrystalElement.PURPLE, Aspect.AURA, this.PUZZLE);
        if (Aspect.getAspect((String)"superbia") != null) {
            this.addAspectColor(CrystalElement.PURPLE, Aspect.getAspect((String)"superbia"));
            this.addAspectTheme(CrystalElement.PURPLE, Aspect.getAspect((String)"superbia"));
        }
        this.addAspectTheme(CrystalElement.CYAN, Aspect.WATER);
        this.addAspectTheme(CrystalElement.LIGHTGRAY, Aspect.ENTROPY, Aspect.TRAP);
        this.addAspectTheme(CrystalElement.GRAY, Aspect.EXCHANGE);
        this.addAspectTheme(CrystalElement.PINK, Aspect.WEAPON);
        this.addAspectTheme(CrystalElement.LIME, Aspect.MOTION, Aspect.TRAVEL, Aspect.FLIGHT);
        this.addAspectTheme(CrystalElement.YELLOW, Aspect.ENERGY, this.SIGNAL);
        if (Aspect.getAspect((String)"tempus") != null) {
            this.addAspectTheme(CrystalElement.LIGHTBLUE, Aspect.getAspect((String)"tempus"));
        }
        this.addAspectTheme(CrystalElement.MAGENTA, Aspect.LIFE, Aspect.HEAL);
        this.addAspectTheme(CrystalElement.ORANGE, Aspect.FIRE);
        this.addAspectTheme(CrystalElement.WHITE, Aspect.ORDER, Aspect.AIR);
    }

    private void addAspectColor(CrystalElement e, Aspect ... as) {
        for (int i = 0; i < as.length; ++i) {
            Aspect a = as[i];
            this.aspectsColor.addValue((Object)e, (Object)a);
        }
    }

    private void addAspectTheme(CrystalElement e, Aspect ... as) {
        for (int i = 0; i < as.length; ++i) {
            Aspect a = as[i];
            this.aspectsThematic.addValue((Object)e, (Object)a);
        }
    }

    public Collection<Aspect> getAspects(CrystalElement color) {
        return this.getAspects(color, true);
    }

    public Collection<Aspect> getAspects(CrystalElement color, boolean theme) {
        ReversibleMultiMap<CrystalElement, Aspect> map = theme ? this.aspectsThematic : this.aspectsColor;
        Collection li = map.getForward((Object)color);
        return li != null ? Collections.unmodifiableCollection(li) : null;
    }

    public Collection<CrystalElement> getColorsForAspect(Aspect a) {
        return this.getColorsForAspect(a, true);
    }

    public Collection<CrystalElement> getColorsForAspect(Aspect a, boolean theme) {
        ReversibleMultiMap<CrystalElement, Aspect> map = theme ? this.aspectsThematic : this.aspectsColor;
        Collection li = map.getBackward((Object)a);
        return li != null ? Collections.unmodifiableCollection(li) : null;
    }

    public void register() {
        int i;
        Object[] asp = new Object[]{Aspect.AURA, 10, Aspect.AIR, 3, Aspect.CROP, 4, Aspect.CRYSTAL, 1, Aspect.EARTH, 4, Aspect.TREE, 10, Aspect.EXCHANGE, 5, Aspect.HEAL, 10, Aspect.LIFE, 10, Aspect.LIGHT, 2, Aspect.MAGIC, 10, Aspect.ORDER, 10, Aspect.PLANT, 10, Aspect.VOID, 1};
        ReikaThaumHelper.addAspectsToBlock((Block)ChromaBlocks.RAINBOWLEAF.getBlockInstance(), (Object[])asp);
        ReikaThaumHelper.addAspectsToBlock((Block)ChromaBlocks.RAINBOWSAPLING.getBlockInstance(), (Object[])asp);
        for (int i2 = 0; i2 < CrystalElement.elements.length; ++i2) {
            CrystalElement dye = CrystalElement.elements[i2];
            ItemStack crystal = new ItemStack(ChromaBlocks.CRYSTAL.getBlockInstance(), 1, i2);
            ItemStack lamp = new ItemStack(ChromaBlocks.LAMP.getBlockInstance(), 1, i2);
            ItemStack potion = new ItemStack(ChromaBlocks.SUPER.getBlockInstance(), 1, i2);
            ItemStack shard = ChromaItems.SHARD.getStackOfMetadata(i2);
            ItemStack bshard = ChromaItems.SHARD.getStackOfMetadata(i2 + 16);
            ItemStack rune = new ItemStack(ChromaBlocks.RUNE.getBlockInstance(), 1, i2);
            ItemStack leaf = new ItemStack(ChromaBlocks.DECAY.getBlockInstance(), 1, i2);
            ItemStack leaf2 = new ItemStack(ChromaBlocks.DYELEAF.getBlockInstance(), 1, i2);
            ItemStack berry = ChromaItems.BERRY.getStackOfMetadata(i2);
            ItemStack lumenleaf = new ItemStack(ChromaBlocks.POWERTREE.getBlockInstance(), 1, i2);
            ItemStack pendant = ChromaItems.PENDANT.getStackOf(dye);
            ItemStack pendant3 = ChromaItems.PENDANT3.getStackOf(dye);
            ItemStack acc = ChromaItems.ADJACENCY.getStackOfMetadata(i2);
            ItemStack stone = ChromaItems.ELEMENTAL.getStackOfMetadata(i2);
            ItemStack plant = ChromaBlocks.PLANT.getStackOfMetadata(i2);
            ArrayList li = new ArrayList();
            li.addAll(this.aspectsColor.getForward((Object)dye));
            li.addAll(this.aspectsThematic.getForward((Object)dye));
            ReikaThaumHelper.addAspects((ItemStack)shard, (Object[])new Object[]{Aspect.CRYSTAL, 1});
            ReikaThaumHelper.addAspects((ItemStack)bshard, (Object[])new Object[]{Aspect.CRYSTAL, 2});
            ReikaThaumHelper.addAspects((ItemStack)crystal, (Object[])new Object[]{Aspect.CRYSTAL, 20});
            ReikaThaumHelper.addAspects((ItemStack)crystal, (Object[])new Object[]{Aspect.AURA, 4});
            ReikaThaumHelper.addAspects((ItemStack)crystal, (Object[])new Object[]{Aspect.LIGHT, 3});
            ReikaThaumHelper.addAspects((ItemStack)crystal, (Object[])new Object[]{Aspect.MAGIC, 6});
            ReikaThaumHelper.addAspects((ItemStack)rune, (Object[])new Object[]{Aspect.MAGIC, 8});
            ReikaThaumHelper.addAspects((ItemStack)rune, (Object[])new Object[]{Aspect.CRAFT, 2});
            ReikaThaumHelper.addAspects((ItemStack)lamp, (Object[])new Object[]{Aspect.LIGHT, 8});
            ReikaThaumHelper.addAspects((ItemStack)lamp, (Object[])new Object[]{Aspect.CRYSTAL, 20});
            ReikaThaumHelper.addAspects((ItemStack)potion, (Object[])new Object[]{Aspect.LIGHT, 8});
            ReikaThaumHelper.addAspects((ItemStack)potion, (Object[])new Object[]{Aspect.MAGIC, 16});
            ReikaThaumHelper.addAspects((ItemStack)potion, (Object[])new Object[]{Aspect.AURA, 16});
            ReikaThaumHelper.addAspects((ItemStack)potion, (Object[])new Object[]{Aspect.CRYSTAL, 20});
            ReikaThaumHelper.addAspects((ItemStack)leaf, (Object[])new Object[]{Aspect.PLANT, 3});
            ReikaThaumHelper.addAspects((ItemStack)leaf2, (Object[])new Object[]{Aspect.PLANT, 3});
            ReikaThaumHelper.addAspects((ItemStack)berry, (Object[])new Object[]{Aspect.PLANT, 1});
            ReikaThaumHelper.addAspects((ItemStack)berry, (Object[])new Object[]{Aspect.HUNGER, 1});
            ReikaThaumHelper.addAspects((ItemStack)berry, (Object[])new Object[]{Aspect.ENERGY, 1});
            ReikaThaumHelper.addAspects((ItemStack)lumenleaf, (Object[])new Object[]{Aspect.ENERGY, 4});
            ReikaThaumHelper.addAspects((ItemStack)lumenleaf, (Object[])new Object[]{Aspect.CRYSTAL, 4});
            ReikaThaumHelper.addAspects((ItemStack)lumenleaf, (Object[])new Object[]{Aspect.TREE, 4});
            ReikaThaumHelper.addAspects((ItemStack)lumenleaf, (Object[])new Object[]{Aspect.LIGHT, 4});
            ReikaThaumHelper.addAspects((ItemStack)lumenleaf, (Object[])new Object[]{Aspect.CRAFT, 4});
            ReikaThaumHelper.addAspects((ItemStack)pendant, (Object[])new Object[]{Aspect.CRYSTAL, 8});
            ReikaThaumHelper.addAspects((ItemStack)pendant3, (Object[])new Object[]{Aspect.CRYSTAL, 8});
            ReikaThaumHelper.addAspects((ItemStack)pendant, (Object[])new Object[]{Aspect.TOOL, 8});
            ReikaThaumHelper.addAspects((ItemStack)pendant3, (Object[])new Object[]{Aspect.TOOL, 8});
            ReikaThaumHelper.addAspects((ItemStack)acc, (Object[])new Object[]{Aspect.LIGHT, 4});
            ReikaThaumHelper.addAspects((ItemStack)acc, (Object[])new Object[]{Aspect.AURA, 6});
            ReikaThaumHelper.addAspects((ItemStack)acc, (Object[])new Object[]{Aspect.CRYSTAL, 4});
            ReikaThaumHelper.addAspects((ItemStack)acc, (Object[])new Object[]{Aspect.ENERGY, 4});
            ReikaThaumHelper.addAspects((ItemStack)acc, (Object[])new Object[]{Aspect.TRAVEL, 4});
            ReikaThaumHelper.addAspects((ItemStack)stone, (Object[])new Object[]{Aspect.ENERGY, 1});
            ReikaThaumHelper.addAspects((ItemStack)stone, (Object[])new Object[]{Aspect.EARTH, 1});
            ReikaThaumHelper.addAspects((ItemStack)plant, (Object[])new Object[]{Aspect.PLANT, 2});
            ReikaThaumHelper.addAspects((ItemStack)plant, (Object[])new Object[]{Aspect.CROP, 1});
            for (Aspect a : li) {
                ReikaThaumHelper.addAspects((ItemStack)shard, (Object[])new Object[]{a, 2});
                ReikaThaumHelper.addAspects((ItemStack)bshard, (Object[])new Object[]{a, 5});
                ReikaThaumHelper.addAspects((ItemStack)crystal, (Object[])new Object[]{a, 16});
                ReikaThaumHelper.addAspects((ItemStack)potion, (Object[])new Object[]{a, 16});
                ReikaThaumHelper.addAspects((ItemStack)rune, (Object[])new Object[]{a, 4});
                ReikaThaumHelper.addAspects((ItemStack)leaf, (Object[])new Object[]{a, 2});
                ReikaThaumHelper.addAspects((ItemStack)leaf2, (Object[])new Object[]{a, 2});
                ReikaThaumHelper.addAspects((ItemStack)berry, (Object[])new Object[]{a, 2});
                ReikaThaumHelper.addAspects((ItemStack)lumenleaf, (Object[])new Object[]{a, 8});
                ReikaThaumHelper.addAspects((ItemStack)pendant, (Object[])new Object[]{a, 12});
                ReikaThaumHelper.addAspects((ItemStack)pendant3, (Object[])new Object[]{a, 24});
                ReikaThaumHelper.addAspects((ItemStack)acc, (Object[])new Object[]{a, 8});
                ReikaThaumHelper.addAspects((ItemStack)stone, (Object[])new Object[]{a, 4});
                ReikaThaumHelper.addAspects((ItemStack)plant, (Object[])new Object[]{a, 3});
            }
            for (ItemStack seed : ItemCrystalSeeds.getAllVariants(dye)) {
                ReikaThaumHelper.addAspects((ItemStack)seed, (Object[])new Object[]{Aspect.PLANT, 1});
                for (Aspect a : li) {
                    ReikaThaumHelper.addAspects((ItemStack)seed, (Object[])new Object[]{a, 1});
                }
            }
        }
        Aspect[] flowers = new Aspect[]{Aspect.DARKNESS, Aspect.LIFE, Aspect.POISON, Aspect.BEAST, Aspect.WATER, Aspect.TAINT, Aspect.MOTION, Aspect.SOUL, Aspect.ENTROPY, Aspect.FLESH, Aspect.SLIME, Aspect.GREED, Aspect.COLD, Aspect.MAGIC, Aspect.FIRE, Aspect.ORDER};
        for (int i3 = 0; i3 < 16; ++i3) {
            ReikaThaumHelper.addAspectsToBlockMeta((Block)ChromaBlocks.DYEFLOWER.getBlockInstance(), (int)i3, (Object[])new Object[]{flowers[i3], 1, Aspect.PLANT, 2});
        }
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.auraDust, (Object[])new Object[]{Aspect.AURA, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.auraDust, (Object[])new Object[]{Aspect.MAGIC, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.beaconDust, (Object[])new Object[]{Aspect.AURA, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.beaconDust, (Object[])new Object[]{Aspect.ENERGY, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.beaconDust, (Object[])new Object[]{Aspect.LIGHT, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.purityDust, (Object[])new Object[]{Aspect.ORDER, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.elementDust, (Object[])new Object[]{Aspect.MAGIC, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.bindingCrystal, (Object[])new Object[]{Aspect.TRAP, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.bindingCrystal, (Object[])new Object[]{Aspect.CRYSTAL, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.focusDust, (Object[])new Object[]{Aspect.LIGHT, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.focusDust, (Object[])new Object[]{Aspect.EXCHANGE, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.firaxite, (Object[])new Object[]{Aspect.FIRE, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.spaceDust, (Object[])new Object[]{Aspect.ELDRITCH, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.spaceDust, (Object[])new Object[]{Aspect.VOID, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.waterDust, (Object[])new Object[]{Aspect.WATER, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.enderDust, (Object[])new Object[]{Aspect.TRAVEL, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.enderDust, (Object[])new Object[]{Aspect.MAGIC, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.resocrystal, (Object[])new Object[]{Aspect.ENERGY, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.resonanceDust, (Object[])new Object[]{Aspect.AURA, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.lumaDust, (Object[])new Object[]{Aspect.LIGHT, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.lumaDust, (Object[])new Object[]{Aspect.ENERGY, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.echoCrystal, (Object[])new Object[]{Aspect.MAGIC, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.echoCrystal, (Object[])new Object[]{Aspect.SENSES, 6});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.echoCrystal, (Object[])new Object[]{this.SIGNAL, 6});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.fireEssence, (Object[])new Object[]{Aspect.FIRE, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.fireEssence, (Object[])new Object[]{Aspect.AURA, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.thermiticCrystal, (Object[])new Object[]{Aspect.FIRE, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.thermiticCrystal, (Object[])new Object[]{Aspect.CRYSTAL, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.glowbeans, (Object[])new Object[]{Aspect.EXCHANGE, 8});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.glowbeans, (Object[])new Object[]{Aspect.ENERGY, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.boostroot, (Object[])new Object[]{Aspect.GREED, 8});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.boostroot, (Object[])new Object[]{Aspect.MAGIC, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.lumenGem, (Object[])new Object[]{Aspect.ENERGY, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.lumenGem, (Object[])new Object[]{this.SIGNAL, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.avolite, (Object[])new Object[]{Aspect.ENERGY, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.avolite, (Object[])new Object[]{Aspect.CRYSTAL, 4});
        for (PoolRecipes.PoolRecipe r : PoolRecipes.instance.getAllPoolRecipes()) {
            Collection<ItemStack> ins = r.getInputs();
            ItemStack main = r.getMainInput();
            ItemStack out = r.getOutput();
            AspectList al = new AspectList();
            for (ItemStack in : ins) {
                AspectList al2 = ThaumcraftApiHelper.generateTags((Item)in.func_77973_b(), (int)in.func_77960_j());
                if (al2 == null) continue;
                al.merge(al2);
            }
            AspectList al2 = ThaumcraftApiHelper.generateTags((Item)main.func_77973_b(), (int)main.func_77960_j());
            if (al2 != null) {
                al.merge(al2);
            }
            ReikaThaumHelper.addAspects((ItemStack)out, (AspectList)al);
        }
        Aspect[] tierores = new Aspect[]{Aspect.MAGIC, Aspect.CRAFT, Aspect.TRAP, Aspect.LIGHT, Aspect.TRAVEL, Aspect.WATER, Aspect.FIRE, Aspect.ORDER, Aspect.ENTROPY, Aspect.AURA, Aspect.ELDRITCH, Aspect.GREED, Aspect.WEAPON, Aspect.CRYSTAL, Aspect.ENERGY};
        Aspect[] tierplants = new Aspect[]{Aspect.AURA, Aspect.ORDER, Aspect.ENERGY, Aspect.PLANT, Aspect.EXCHANGE, Aspect.LIGHT, Aspect.GREED};
        for (i = 0; i < BlockTieredOre.TieredOres.list.length; ++i) {
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.TIEREDORE.getStackOfMetadata(i), (Object[])new Object[]{tierores[i], 2});
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.TIEREDORE.getStackOfMetadata(i), (Object[])new Object[]{Aspect.MAGIC, 3});
        }
        for (i = 0; i < BlockTieredPlant.TieredPlants.list.length; ++i) {
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.TIEREDPLANT.getStackOfMetadata(i), (Object[])new Object[]{tierplants[i], 2});
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.TIEREDPLANT.getStackOfMetadata(i), (Object[])new Object[]{Aspect.MAGIC, 3});
        }
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.LOOTCHEST.getStackOf(), (Object[])new Object[]{Aspect.MAGIC, 2, Aspect.GREED, 2, Aspect.TRAP, 1, Aspect.VOID, 20});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.SELECTIVEGLASS.getStackOf(), (Object[])new Object[]{Aspect.MAGIC, 5, Aspect.CRYSTAL, 4, Aspect.AURA, 2, Aspect.ARMOR, 8, Aspect.MIND, 1});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PORTAL.getStackOf(), (Object[])new Object[]{Aspect.MAGIC, 40, Aspect.VOID, 20, Aspect.TRAVEL, 80, this.PUZZLE, 120, this.SIGNAL, 120, Aspect.CRYSTAL, 10});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.REPEATERLAMP.getStackOf(), (Object[])new Object[]{Aspect.LIGHT, 8, Aspect.CRYSTAL, 8});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.CAVEINDICATOR.getStackOf(), (Object[])new Object[]{Aspect.LIGHT, 4, Aspect.TRAP, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.METAALLOYLAMP.getStackOf(), (Object[])new Object[]{this.PRECURSOR, 6, Aspect.LIGHT, 4, Aspect.LIFE, 4});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.ENDER.getStackOf(), (Object[])new Object[]{Aspect.MAGIC, 10, Aspect.WATER, 5, Aspect.AURA, 3, Aspect.TRAVEL, 5, Aspect.ENTROPY, 10, Aspect.EXCHANGE, 5, Aspect.ELDRITCH, 3});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.CHROMA.getStackOf(), (Object[])new Object[]{Aspect.MAGIC, 10, Aspect.WATER, 5, Aspect.AURA, 3, Aspect.CRAFT, 5, Aspect.ORDER, 10, Aspect.EXCHANGE, 5, Aspect.HEAL, 3});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.LUMA.getStackOf(), (Object[])new Object[]{Aspect.MAGIC, 4, Aspect.AURA, 5, Aspect.VOID, 10});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.ARTEFACT.getStackOf(), (Object[])new Object[]{this.PRECURSOR, 20});
        ReikaThaumHelper.addAspects((ItemStack)ChromaItems.DATACRYSTAL.getStackOf(), (Object[])new Object[]{this.PRECURSOR, 10, Aspect.MIND, 5});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.unknownArtefact, (Object[])new Object[]{this.PRECURSOR, 20});
        ReikaThaumHelper.addAspects((ItemStack)ChromaStacks.unknownFragments, (Object[])new Object[]{this.PRECURSOR, 4, Aspect.ENTROPY, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.SMOOTH.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.BEAM.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.COLUMN.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.GLOWCOL.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.ENERGY, 8});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.GLOWBEAM.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.ENERGY, 8});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.FOCUS.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.ENERGY, 12, Aspect.AURA, 8});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.CORNER.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.ENGRAVED.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.CRAFT, 1});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.EMBOSSED.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.CRAFT, 1});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.FOCUSFRAME.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 1, Aspect.ENERGY, 1, Aspect.AURA, 1, Aspect.ENTROPY, 1});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.GROOVE1.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.CRAFT, 1});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.GROOVE2.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.CRAFT, 1});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.BRICKS.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.CRAFT, 1});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.MULTICHROMIC.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 8, Aspect.CRAFT, 2, Aspect.ENERGY, 2, Aspect.AURA, 2});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.STABILIZER.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.ENERGY, 12, Aspect.AURA, 8});
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.RESORING.ordinal()), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.CRYSTAL, 4, Aspect.MAGIC, 2, Aspect.ENERGY, 12, Aspect.AURA, 4, Aspect.EXCHANGE, 6});
        for (i = 0; i < 16; ++i) {
            for (Aspect a : this.aspectsThematic.getForward((Object)CrystalElement.elements[i])) {
                ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.PYLONSTRUCT.getStackOfMetadata(BlockPylonStructure.StoneTypes.MULTICHROMIC.ordinal()), (Object[])new Object[]{a, 2});
            }
        }
        for (i = 0; i <= 8; i += 8) {
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CLOAK.ordinal() + i), (Object[])new Object[]{Aspect.DARKNESS, 4, Aspect.EARTH, 4, Aspect.MAGIC, 2, Aspect.ARMOR, 4, this.PUZZLE, 4, this.PRECURSOR, 2});
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.STONE.ordinal() + i), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.MAGIC, 2, Aspect.ARMOR, 4, this.PUZZLE, 4, this.PRECURSOR, 2});
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.COBBLE.ordinal() + i), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.MAGIC, 2, Aspect.ARMOR, 4, this.PUZZLE, 4, this.PRECURSOR, 2});
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CRACK.ordinal() + i), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.MAGIC, 2, Aspect.ARMOR, 4, this.PUZZLE, 4, this.PRECURSOR, 2});
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.MOSS.ordinal() + i), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.MAGIC, 2, Aspect.ARMOR, 4, this.PUZZLE, 4, Aspect.PLANT, 1, this.PRECURSOR, 2});
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.GLASS.ordinal() + i), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.MAGIC, 2, Aspect.ARMOR, 4, this.PUZZLE, 4, this.PRECURSOR, 2});
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.LIGHT.ordinal() + i), (Object[])new Object[]{Aspect.LIGHT, 4, Aspect.EARTH, 4, Aspect.MAGIC, 2, Aspect.ARMOR, 4, this.PUZZLE, 4, this.PRECURSOR, 2});
            ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.STRUCTSHIELD.getStackOfMetadata(BlockStructureShield.BlockType.CRACKS.ordinal() + i), (Object[])new Object[]{Aspect.EARTH, 4, Aspect.MAGIC, 2, Aspect.ARMOR, 4, this.PUZZLE, 4, this.PRECURSOR, 2});
        }
        block21: for (i = 0; i < BlockDecoFlower.Flowers.list.length; ++i) {
            ItemStack is = ChromaBlocks.DECOFLOWER.getStackOfMetadata(i);
            ItemStack is2 = BlockDecoFlower.Flowers.list[i].getDrop();
            ReikaThaumHelper.addAspects((ItemStack)is, (Object[])new Object[]{Aspect.PLANT, 2, Aspect.MAGIC, 2});
            ReikaThaumHelper.addAspects((ItemStack)is2, (Object[])new Object[]{Aspect.PLANT, 1, Aspect.MAGIC, 2});
            switch (BlockDecoFlower.Flowers.list[i]) {
                case ENDERFLOWER: {
                    ReikaThaumHelper.addAspects((ItemStack)is, (Object[])new Object[]{Aspect.ELDRITCH, 4, Aspect.MOTION, 4});
                    ReikaThaumHelper.addAspects((ItemStack)is2, (Object[])new Object[]{Aspect.ELDRITCH, 1, Aspect.MOTION, 1});
                    continue block21;
                }
                case FLOWIVY: {
                    ReikaThaumHelper.addAspects((ItemStack)is, (Object[])new Object[]{Aspect.LIFE, 4, Aspect.EARTH, 1});
                    ReikaThaumHelper.addAspects((ItemStack)is2, (Object[])new Object[]{Aspect.LIFE, 1, Aspect.EARTH, 1});
                    continue block21;
                }
                case LUMALILY: {
                    ReikaThaumHelper.addAspects((ItemStack)is, (Object[])new Object[]{Aspect.COLD, 4, Aspect.CRYSTAL, 1});
                    ReikaThaumHelper.addAspects((ItemStack)is2, (Object[])new Object[]{Aspect.COLD, 1, Aspect.CRYSTAL, 1});
                    continue block21;
                }
                case RESOCLOVER: {
                    ReikaThaumHelper.addAspects((ItemStack)is, (Object[])new Object[]{Aspect.ENERGY, 4, Aspect.AURA, 4});
                    ReikaThaumHelper.addAspects((ItemStack)is2, (Object[])new Object[]{Aspect.ENERGY, 1, Aspect.AURA, 1});
                    continue block21;
                }
                case SANOBLOOM: {
                    ReikaThaumHelper.addAspects((ItemStack)is, (Object[])new Object[]{Aspect.HEAL, 4, Aspect.TRAVEL, 1});
                    ReikaThaumHelper.addAspects((ItemStack)is2, (Object[])new Object[]{Aspect.HEAL, 1, Aspect.TRAVEL, 1});
                    continue block21;
                }
                case VOIDREED: {
                    ReikaThaumHelper.addAspects((ItemStack)is, (Object[])new Object[]{Aspect.VOID, 4, Aspect.DARKNESS, 1});
                    ReikaThaumHelper.addAspects((ItemStack)is2, (Object[])new Object[]{Aspect.VOID, 1, Aspect.DARKNESS, 1});
                    continue block21;
                }
                case GLOWDAISY: 
                case GLOWROOT: {
                    ReikaThaumHelper.addAspects((ItemStack)is, (Object[])new Object[]{Aspect.LIGHT, 4});
                }
            }
        }
        ReikaThaumHelper.addAspects((ItemStack)ChromaBlocks.WARPNODE.getStackOf(), (Object[])new Object[]{Aspect.TRAVEL, 20, Aspect.AURA, 5, Aspect.ENERGY, 4, Aspect.VOID, 2});
    }

    public ElementTagCompound getElementCost(Aspect a, float depthcost) {
        ElementTagCompound tag = new ElementTagCompound();
        this.recursiveCount(a, tag, 0, depthcost);
        if (tag.isEmpty()) {
            ChromatiCraft.logger.logError((Object)("Aspect " + a.getName() + " was calculated to have zero cost!"));
        }
        return tag;
    }

    private void recursiveCount(Aspect a, ElementTagCompound tag, int depth, float depthcost) {
        block3: {
            Collection li;
            block2: {
                li = this.aspectsThematic.getBackward((Object)a);
                if (li != null && !li.isEmpty()) break block2;
                Aspect[] parents = a.getComponents();
                if (parents == null || parents.length <= 0) break block3;
                for (int i = 0; i < parents.length; ++i) {
                    this.recursiveCount(parents[i], tag, depth + 1, depthcost);
                }
                break block3;
            }
            int amt = depthcost > 0.0f ? (int)((float)(1 + depth) * depthcost) : 1;
            for (CrystalElement e : li) {
                tag.addValueToColor(e, amt);
            }
        }
    }
}

