/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.Auxiliary.ChromaFX;
import Reika.ChromatiCraft.Auxiliary.ChromaStacks;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.Magic.PlayerElementBuffer;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.ChromatiCraft.Render.Particle.EntityRuneFX;
import Reika.DragonAPI.IO.DirectResourceManager;
import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaPlayerAPI;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.IWandRodOnUpdate;
import thaumcraft.api.wands.WandRod;

public class CrystalWand
extends WandRod {
    private static final Random rand = new Random();
    private final IWandRodOnUpdate updater = new WandUpdater();
    private ColorBlendList colors;

    public CrystalWand() {
        super("CRYSTALWAND", 6000, ChromaStacks.crystalWand, 18, null, null);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.registerTexture();
        }
        this.setGlowing(true);
    }

    @SideOnly(value=Side.CLIENT)
    private void registerTexture() {
        this.setTexture(DirectResourceManager.getResource((String)"Reika/ChromatiCraft/Textures/Wands/crystalwand.png"));
        this.colors = new ColorBlendList(10.0f, ChromaFX.getChromaColorTiles());
    }

    public IWandRodOnUpdate getOnUpdate() {
        return this.updater;
    }

    public ResourceLocation getTexture() {
        return super.getTexture();
    }

    @SideOnly(value=Side.CLIENT)
    public static void updateWandClient(EntityPlayer player, int[] data) {
        Vec3 vec = player.func_70040_Z();
        for (CrystalElement e : CrystalElement.elements) {
            if (data[e.ordinal()] <= 0) continue;
            int amt = MathHelper.func_76125_a((int)(data[e.ordinal()] / 2000), (int)1, (int)20);
            for (int i = 0; i < amt; ++i) {
                double px = ReikaRandomHelper.getRandomPlusMinus((double)(player.field_70165_t + vec.field_72450_a), (double)1.0);
                double py = ReikaRandomHelper.getRandomPlusMinus((double)(player.field_70163_u + vec.field_72448_b), (double)0.5);
                double pz = ReikaRandomHelper.getRandomPlusMinus((double)(player.field_70161_v + vec.field_72449_c), (double)1.0);
                EntityRuneFX fx = new EntityRuneFX(player.field_70170_p, px, py, pz, e).setLife(40).setScale(2.0f).setGravity(0.1f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }

    private static class WandUpdater
    implements IWandRodOnUpdate {
        private WandUpdater() {
        }

        public void onUpdate(ItemStack is, EntityPlayer player) {
            int n;
            if (ReikaPlayerAPI.isFake((EntityPlayer)player)) {
                return;
            }
            int n2 = n = ReikaItemHelper.matchStacks((ItemStack)is, (ItemStack)player.func_71045_bC()) ? 100 : 800;
            if (rand.nextInt(n) == 0) {
                AspectList al = ReikaThaumHelper.getVisInWand((ItemStack)is);
                ElementTagCompound tag = new ElementTagCompound();
                boolean flag = false;
                for (Aspect a : Aspect.getPrimalAspects()) {
                    ElementTagCompound cost;
                    int sp;
                    if (al.getAmount(a) <= 0 || (sp = Math.min(10, ReikaThaumHelper.getWandSpaceFor((ItemStack)is, (Aspect)a))) <= 0 || !PlayerElementBuffer.instance.playerHas(player, cost = ChromaAspectManager.instance.getElementCost(a, 1.0f).scale(sp * 4).power(1.25))) continue;
                    PlayerElementBuffer.instance.removeFromPlayer(player, cost);
                    ReikaThaumHelper.addVisToWand((ItemStack)is, (Aspect)a, (int)sp);
                    flag = true;
                }
                if (flag && player instanceof EntityPlayerMP) {
                    int[] arr = ReikaArrayHelper.getLinearArray((int)16);
                    ReikaPacketHelper.sendDataPacket((String)"ChromaData", (int)ChromaPackets.WANDCHARGE.ordinal(), (EntityPlayerMP)((EntityPlayerMP)player), (int[])arr);
                    ChromaSounds.CAST.playSound((Entity)player, 1.0f, 1.0f);
                }
            }
        }
    }
}

