/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.ModInterface.Bees.TileEntityLumenAlveary;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.TileEntityAspectJar;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.TileEntityEssentiaRelay;
import Reika.ChromatiCraft.Registry.ChromaPackets;
import Reika.ChromatiCraft.Registry.ChromaTiles;
import Reika.ChromatiCraft.Render.Particle.EntityCCBlurFX;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Exception.UnreachableCodeException;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.Data.Immutable.DecimalPosition;
import Reika.DragonAPI.Instantiable.Effects.EntityBlurFX;
import Reika.DragonAPI.Instantiable.IO.PacketTarget;
import Reika.DragonAPI.Instantiable.RayTracer;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.Registry.ModEntry;
import Reika.DragonAPI.Libraries.IO.ReikaPacketHelper;
import Reika.DragonAPI.Libraries.Java.ReikaJavaLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.InterfaceCache;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumicenergistics.api.grid.IEssentiaGrid;

public class EssentiaNetwork {
    private static Class jarClass;
    private static Class alembicClass;
    private static Field filterField;
    private static Field amountField;
    private static Field alembicAspectField;
    private static Field alembicAmountField;
    private static Class tubeClass;
    private static Class centrifugeClass;
    private static Class advancedFurnaceNozzleClass;
    private static final SuctionComparator endpointComparator;
    private static final RayTracer tracer;
    private static final HashMap<Integer, EssentiaNetwork> networks;
    private final HashSet<EssentiaSubnet> subnets = new HashSet();

    public static Class getCentrifugeClass() {
        return centrifugeClass;
    }

    public static Class getAdvancedFurnaceNozzleClass() {
        return advancedFurnaceNozzleClass;
    }

    public static EssentiaNetwork getNetwork(World world) {
        int dim = world.field_73011_w.field_76574_g;
        EssentiaNetwork e = networks.get(dim);
        if (e == null) {
            e = new EssentiaNetwork();
            networks.put(dim, e);
        }
        return e;
    }

    private EssentiaNetwork() {
    }

    private static boolean LOS(World world, Coordinate c1, Coordinate c2) {
        tracer.setOrigins((double)c1.xCoord + 0.5, (double)c1.yCoord, (double)c1.zCoord + 0.5, (double)c2.xCoord + 0.5, (double)c2.yCoord + 0.5, (double)c2.zCoord + 0.5);
        return tracer.isClearLineOfSight(world);
    }

    private static Aspect isFilteredJar(IEssentiaTransport te) {
        if (EssentiaNetwork.isJar(te)) {
            try {
                Aspect a = (Aspect)filterField.get(te);
                return a;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static boolean isJar(IEssentiaTransport te) {
        return jarClass != null && jarClass.isAssignableFrom(te.getClass());
    }

    private static boolean shouldSkipEndpoint(TileEntity te) {
        return te instanceof TileEntityEssentiaRelay || tubeClass != null && tubeClass == te.getClass();
    }

    private static NetworkEndpoint createEndpoint(Coordinate loc, IEssentiaTransport te) {
        if (te == null) {
            return null;
        }
        if (ModList.FORESTRY.isLoaded() && te instanceof TileEntityLumenAlveary) {
            return new AlvearyEndpoint(loc, te);
        }
        Aspect a = EssentiaNetwork.isFilteredJar(te);
        if (a != null) {
            return new LabelledJarEndpoint(loc, te, a);
        }
        if (te.getClass() == alembicClass) {
            return new AlembicEndpoint(loc, te);
        }
        if (te.getClass() == centrifugeClass) {
            return new CentrifugeEndpoint(loc, te);
        }
        if (te.getClass() == advancedFurnaceNozzleClass) {
            return new AdvancedFurnaceEndpoint(loc, te);
        }
        if (ModList.APPENG.isLoaded() && InterfaceCache.GRIDHOST.instanceOf((Object)te)) {
            return new EnergisticsEndpoint(loc, te);
        }
        if (te.getClass().getSimpleName().startsWith("TileThaumatorium")) {
            return new ThaumatoriumEndpoint(loc, te);
        }
        return new NetworkEndpoint(loc, te);
    }

    static {
        endpointComparator = new SuctionComparator();
        tracer = new RayTracer(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        networks = new HashMap();
        if (ModList.THAUMCRAFT.isLoaded()) {
            try {
                jarClass = Class.forName("thaumcraft.common.tiles.TileJarFillable");
                filterField = jarClass.getField("aspectFilter");
                amountField = jarClass.getField("amount");
                alembicClass = Class.forName("thaumcraft.common.tiles.TileAlembic");
                alembicAspectField = alembicClass.getField("aspect");
                alembicAmountField = alembicClass.getField("amount");
                tubeClass = Class.forName("thaumcraft.common.tiles.TileTube");
                centrifugeClass = Class.forName("thaumcraft.common.tiles.TileCentrifuge");
                advancedFurnaceNozzleClass = Class.forName("thaumcraft.common.tiles.TileAlchemyFurnaceAdvancedNozzle");
            }
            catch (Exception e) {
                ChromatiCraft.logger.logError((Object)"Could not fetch TC tile classes");
                e.printStackTrace();
                ReflectiveFailureTracker.instance.logModReflectiveFailure((ModEntry)ModList.THAUMCRAFT, e);
            }
        }
        EssentiaNetwork.tracer.airOnly = true;
    }

    public static class EssentiaNode {
        public final Coordinate position;
        private final EssentiaSubnet network;
        private final HashSet<Coordinate> otherNodes = new HashSet();
        private final HashMap<Coordinate, NetworkEndpoint> inertEndpoints = new HashMap();
        private final HashMap<Coordinate, ActiveEndpoint> activeEndpoints = new HashMap();

        private EssentiaNode(EssentiaSubnet n, Coordinate c) {
            this.network = n;
            this.position = c;
        }

        private void destroy(World world, boolean doDrops) {
            this.activeEndpoints.clear();
            this.inertEndpoints.clear();
            this.otherNodes.clear();
            TileEntity te = this.position.getTileEntity((IBlockAccess)world);
            if (te instanceof TileEntityEssentiaRelay) {
                ((TileEntityEssentiaRelay)te).reset();
                if (doDrops) {
                    ((TileEntityEssentiaRelay)te).drop();
                }
            }
        }

        public double getDistanceTo(EssentiaNode c) {
            return this.position.getDistanceTo(c.position);
        }

        private double getDistanceTo(NetworkEndpoint end) {
            return this.position.getDistanceTo(end.point);
        }

        private void findValidEndpoints(World world) {
            int r = 8;
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    for (int k = -r; k <= r; ++k) {
                        int dx = this.position.xCoord + i;
                        int dy = this.position.yCoord + j;
                        int dz = this.position.zCoord + k;
                        this.addEndpointAt(world, dx, dy, dz);
                    }
                }
            }
        }

        private void addEndpointAt(World world, int x, int y, int z) {
            TileEntity te = world.func_147438_o(x, y, z);
            if (te instanceof IEssentiaTransport && !EssentiaNetwork.shouldSkipEndpoint(te)) {
                Coordinate c = new Coordinate(x, y, z);
                NetworkEndpoint end = (NetworkEndpoint)this.network.endpoints.get(c);
                if (end != null) {
                    if (this.getDistanceTo(end) >= end.relay.getDistanceTo(end)) {
                        return;
                    }
                } else {
                    end = EssentiaNetwork.createEndpoint(c, (IEssentiaTransport)te);
                }
                if (end.needsLOS() && !EssentiaNetwork.LOS(world, this.position, c)) {
                    return;
                }
                if (end.requiresAdjacency() && c.getTaxicabDistanceTo(this.position) > 1) {
                    return;
                }
                if (end instanceof ActiveEndpoint) {
                    this.activeEndpoints.put(c, (ActiveEndpoint)end);
                } else {
                    this.inertEndpoints.put(c, end);
                }
                if (end.relay != null) {
                    ((NetworkEndpoint)end).relay.activeEndpoints.remove(end.point);
                    ((NetworkEndpoint)end).relay.inertEndpoints.remove(end.point);
                }
                end.relay = this;
                this.network.endpoints.put(c, end);
                this.network.renderMap.put(c, true);
            }
        }

        private void connect(EssentiaNode c) {
            this.otherNodes.add(c.position);
            c.otherNodes.add(this.position);
        }

        private void disconnect(EssentiaNode c) {
            this.otherNodes.remove(c.position);
            c.otherNodes.remove(this.position);
        }

        public boolean isConnectedTo(EssentiaNode c) {
            return this.otherNodes.contains(c.position);
        }

        private void replaceEndpoint(NetworkEndpoint end) {
            Coordinate c = end.point;
            this.activeEndpoints.remove(c);
            this.inertEndpoints.remove(c);
            if (end instanceof ActiveEndpoint) {
                this.activeEndpoints.put(c, (ActiveEndpoint)end);
            } else {
                this.inertEndpoints.put(c, end);
            }
        }

        public Collection<Coordinate> getNeighbors() {
            return Collections.unmodifiableCollection(this.otherNodes);
        }

        public Collection<Coordinate> getVisibleEndpoints() {
            HashSet<Coordinate> c = new HashSet<Coordinate>();
            c.addAll(this.activeEndpoints.keySet());
            c.addAll(this.inertEndpoints.keySet());
            return c;
        }
    }

    public static class EssentiaSubnet {
        public final int dimension;
        private final EssentiaNetwork parent;
        private final HashMap<Coordinate, EssentiaNode> relays = new HashMap();
        private final HashMap<Coordinate, NetworkEndpoint> endpoints = new HashMap();
        private final HashMap<ImmutablePair<Coordinate, Coordinate>, EssentiaPathCache> pathList = new HashMap();
        private final HashMap<Coordinate, Boolean> renderMap = new HashMap();
        private final StepTimer reListTime = new StepTimer(20);
        private long lastTick;
        private boolean isBeingDestroyed = false;

        private EssentiaSubnet(EssentiaNetwork n, int dim) {
            this.dimension = dim;
            this.parent = n;
            this.parent.subnets.add(this);
        }

        private void prune(World world) {
            if (this.isBeingDestroyed) {
                return;
            }
            boolean flag = true;
            while (flag) {
                flag = false;
                for (EssentiaNode e1 : this.relays.values()) {
                    for (EssentiaNode e2 : this.relays.values()) {
                        for (EssentiaNode e3 : this.relays.values()) {
                            double l23;
                            double l12 = e1.isConnectedTo(e2) ? e1.getDistanceTo(e3) : -1.0;
                            double l13 = e1.isConnectedTo(e3) ? e1.getDistanceTo(e3) : -1.0;
                            double d = l23 = e2.isConnectedTo(e3) ? e2.getDistanceTo(e3) : -1.0;
                            if (!(l12 >= 0.0) || !(l13 >= 0.0) || !(l23 >= 0.0)) continue;
                            this.breakLongestLink(e1, e2, e3, l12, l13, l23);
                            flag = true;
                        }
                    }
                }
            }
        }

        private void breakLongestLink(EssentiaNode e1, EssentiaNode e2, EssentiaNode e3, double l12, double l13, double l23) {
            if (l12 > l13 && l12 > l23) {
                e1.disconnect(e2);
            } else if (l13 > l12 && l13 > l23) {
                e1.disconnect(e3);
            } else {
                e2.disconnect(e3);
            }
        }

        public void destroy(World world, boolean doDrops) {
            this.isBeingDestroyed = true;
            this.parent.subnets.remove(this);
            for (EssentiaNode n : this.relays.values()) {
                n.destroy(world, doDrops);
            }
            this.relays.clear();
            this.endpoints.clear();
            this.pathList.clear();
            this.renderMap.clear();
        }

        private void addRelay(World world, Coordinate c) {
            if (this.isBeingDestroyed) {
                return;
            }
            EssentiaNode n = new EssentiaNode(this, c);
            this.linkNodesTo(world, n);
            this.relays.put(c, n);
            this.renderMap.put(c, false);
            ((TileEntityEssentiaRelay)c.getTileEntity((IBlockAccess)world)).setNetwork(this);
        }

        private void linkNodesTo(World world, EssentiaNode n) {
            if (this.isBeingDestroyed) {
                return;
            }
            for (EssentiaNode c : this.relays.values()) {
                if (!this.canConnect(world, n, c)) continue;
                n.connect(c);
            }
        }

        private boolean canConnect(World world, EssentiaNode n, EssentiaNode c) {
            return n.getDistanceTo(c) <= 8.0 && EssentiaNetwork.LOS(world, n.position, c.position);
        }

        public void reloadEndpoints(World world) {
            if (this.isBeingDestroyed) {
                return;
            }
            for (EssentiaNode c : this.relays.values()) {
                c.activeEndpoints.clear();
                c.inertEndpoints.clear();
            }
            this.findAllEndpoints(world);
        }

        private void findAllEndpoints(World world) {
            if (this.isBeingDestroyed) {
                return;
            }
            for (EssentiaNode c : this.relays.values()) {
                c.findValidEndpoints(world);
            }
        }

        public EssentiaNode getNode(TileEntityEssentiaRelay te) {
            return this.relays.get(new Coordinate((TileEntity)te));
        }

        public int countEssentia(World world, Aspect aspect) {
            if (this.isBeingDestroyed) {
                return 0;
            }
            int sum = 0;
            for (NetworkEndpoint n : this.endpoints.values()) {
                sum += n.getContents(world, aspect);
            }
            return sum;
        }

        public EssentiaMovement removeEssentia(TileEntityEssentiaRelay caller, ForgeDirection callDir, Aspect aspect, int amount) {
            return this.removeEssentia(caller, callDir, aspect, amount, new Coordinate((TileEntity)caller).offset(callDir, 1));
        }

        public EssentiaMovement removeEssentia(TileEntityEssentiaRelay caller, ForgeDirection callDir, Aspect aspect, int amount, Coordinate tgt) {
            if (this.isBeingDestroyed) {
                return null;
            }
            TileEntity target = caller.getAdjacentTileEntity(callDir);
            ArrayList<EssentiaPath> li = new ArrayList<EssentiaPath>();
            ArrayList<NetworkEndpoint> list = new ArrayList<NetworkEndpoint>(this.endpoints.values());
            endpointComparator.setWorld(caller.field_145850_b);
            endpointComparator.setForPull(true);
            Collections.sort(list, endpointComparator);
            endpointComparator.reset();
            NetworkEndpoint end = this.endpoints.get(new Coordinate(target));
            for (NetworkEndpoint p : list) {
                int rem;
                EssentiaPathCache pt;
                if (!this.canTransfer(caller.field_145850_b, p, end, false) || (pt = this.getPath(caller.field_145850_b, p, end)) == null || pt.isEmpty() || (rem = p.takeAspect(caller.field_145850_b, aspect, amount)) <= 0) continue;
                li.add(new EssentiaPath(aspect, rem, pt));
                if ((amount -= rem) > 0) continue;
                break;
            }
            return li.isEmpty() ? null : new EssentiaMovement(li);
        }

        public EssentiaMovement addEssentia(TileEntityEssentiaRelay caller, ForgeDirection callDir, Aspect aspect, int amount) {
            return this.addEssentia(caller, aspect, amount, new Coordinate((TileEntity)caller).offset(callDir, 1));
        }

        public EssentiaMovement addEssentia(TileEntityEssentiaRelay caller, Aspect aspect, int amount, Coordinate src) {
            if (this.isBeingDestroyed) {
                return null;
            }
            ArrayList<EssentiaPath> li = new ArrayList<EssentiaPath>();
            ArrayList<NetworkEndpoint> list = new ArrayList<NetworkEndpoint>(this.endpoints.values());
            endpointComparator.setWorld(caller.field_145850_b);
            endpointComparator.setForPull(false);
            Collections.sort(list, endpointComparator);
            endpointComparator.reset();
            NetworkEndpoint start = this.endpoints.get(src);
            for (NetworkEndpoint p : list) {
                int added;
                EssentiaPathCache pt;
                if (!this.canTransfer(caller.field_145850_b, start, p, false) || (pt = this.getPath(caller.field_145850_b, start, p)) == null || pt.isEmpty() || (added = p.addAspect(caller.field_145850_b, aspect, amount)) <= 0) continue;
                li.add(new EssentiaPath(aspect, added, pt));
                if ((amount -= added) > 0) continue;
                break;
            }
            return li.isEmpty() ? null : new EssentiaMovement(li);
        }

        public EssentiaMovement tick(World world) {
            if (this.isBeingDestroyed) {
                return null;
            }
            if (this.lastTick == world.func_82737_E()) {
                return null;
            }
            this.lastTick = world.func_82737_E();
            this.reListTime.update();
            if (this.reListTime.checkCap()) {
                this.relistEndpoints(world);
            }
            ArrayList<EssentiaPath> li = new ArrayList<EssentiaPath>();
            block0: for (NetworkEndpoint net : this.endpoints.values()) {
                if (!(net instanceof ActiveEndpoint)) continue;
                ActiveEndpoint from = (ActiveEndpoint)net;
                AspectList al = from.getPush(world);
                if (al != null && !al.aspects.isEmpty()) {
                    for (NetworkEndpoint to : this.endpoints.values()) {
                        if (!this.canTransfer(world, from, to, true)) continue;
                        li.addAll(this.transferEssentia(world, from, to, al));
                        if (!al.aspects.isEmpty()) continue;
                        break;
                    }
                }
                if ((al = from.getPull(world)) == null || al.aspects.isEmpty()) continue;
                for (NetworkEndpoint to : this.endpoints.values()) {
                    if (!this.canTransfer(world, to, from, true)) continue;
                    li.addAll(this.transferEssentia(world, to, from, al));
                    if (!al.aspects.isEmpty()) continue;
                    continue block0;
                }
            }
            return li.isEmpty() ? null : new EssentiaMovement(li);
        }

        private void relistEndpoints(World world) {
            ArrayList<NetworkEndpoint> c = new ArrayList<NetworkEndpoint>(this.endpoints.values());
            this.endpoints.clear();
            for (NetworkEndpoint n : c) {
                IEssentiaTransport te = n.getTile(world);
                NetworkEndpoint repl = EssentiaNetwork.createEndpoint(n.point, te);
                if (repl == null) {
                    this.endpoints.remove(n.point);
                    n.relay.activeEndpoints.remove(n.point);
                    n.relay.inertEndpoints.remove(n.point);
                    n.relay = null;
                    continue;
                }
                if (!n.isValid(world) || repl.getClass() != n.getClass()) {
                    repl.relay = n.relay;
                    n.relay = null;
                    repl.relay.replaceEndpoint(repl);
                } else {
                    repl = n;
                }
                this.endpoints.put(repl.point, repl);
            }
        }

        private boolean canTransfer(World world, NetworkEndpoint from, NetworkEndpoint to, boolean isTick) {
            if (this.isBeingDestroyed) {
                return false;
            }
            if (from == null || to == null) {
                ChromatiCraft.logger.logError((Object)"Tried to transfer essentia with a null endpoint!");
                return false;
            }
            if (from == to || from.point.equals((Object)to.point)) {
                return false;
            }
            if (from instanceof LabelledJarEndpoint) {
                return !EssentiaNetwork.isJar(to.getTile(world));
            }
            if (EssentiaNetwork.isJar(from.getTile(world)) && EssentiaNetwork.isJar(to.getTile(world))) {
                return to instanceof LabelledJarEndpoint && ((LabelledJarEndpoint)to).getPull(world) != null;
            }
            return from.canEmit(world, isTick) && to.canReceive(world, isTick) && from.isValid(world) && to.isValid(world);
        }

        private ArrayList<EssentiaPath> transferEssentia(World world, NetworkEndpoint from, NetworkEndpoint to, AspectList al) {
            if (this.isBeingDestroyed) {
                return null;
            }
            ArrayList<EssentiaPath> ret = new ArrayList<EssentiaPath>();
            AspectList it = al.copy();
            for (Aspect a : it.aspects.keySet()) {
                int amt;
                EssentiaPath p = this.transferEssentia(world, from, to, a, Math.min(amt = it.getAmount(a), 4));
                if (p == null) continue;
                ret.add(p);
                al.reduce(a, p.amount);
                if (p.amount < amt) continue;
                al.remove(a);
            }
            return ret;
        }

        private EssentiaPath transferEssentia(World world, NetworkEndpoint from, NetworkEndpoint to, Aspect a, int amount) {
            if (this.isBeingDestroyed) {
                return null;
            }
            EssentiaPathCache pt = this.getPath(world, from, to);
            if (pt == null || pt.isEmpty()) {
                return null;
            }
            int has = from.getContents(world, a);
            int amt = Math.min(amount, has);
            int put = to.addAspect(world, a, amt);
            int put2 = from.takeAspect(world, a, put);
            if (put2 < put) {
                to.takeAspect(world, a, put - put2);
            }
            if (put2 <= 0) {
                return null;
            }
            return new EssentiaPath(a, put2, pt);
        }

        public String toString() {
            return System.identityHashCode(this) + " " + this.relays;
        }

        public Collection<Coordinate> getAllFilteredJars() {
            if (this.isBeingDestroyed) {
                return new ArrayList<Coordinate>();
            }
            HashSet<Coordinate> ret = new HashSet<Coordinate>();
            for (NetworkEndpoint n : this.endpoints.values()) {
                if (!(n instanceof LabelledJarEndpoint)) continue;
                ret.add(n.point);
            }
            return ret;
        }

        public boolean isFilteredJar(Coordinate c) {
            return this.endpoints.get(c) instanceof LabelledJarEndpoint;
        }

        private EssentiaPathCache getPath(World world, NetworkEndpoint from, NetworkEndpoint to) {
            ImmutablePair key = new ImmutablePair((Object)from.point, (Object)to.point);
            EssentiaPathCache path = this.pathList.get(key);
            if (path != null) {
                if (path.isDirty && !path.validate(world)) {
                    this.pathList.remove(key);
                }
                return path;
            }
            ArrayList<Coordinate> li = this.calculatePath(world, from, to);
            if (li != null && !li.isEmpty()) {
                path = new EssentiaPathCache(li, from.needsLOS(), to.needsLOS(), from.getRayOffset(world), to.getRayOffset(world));
                this.pathList.put((ImmutablePair<Coordinate, Coordinate>)key, path);
            }
            return path;
        }

        private ArrayList<Coordinate> calculatePath(World world, NetworkEndpoint from, NetworkEndpoint to) {
            if (from.relay.equals(to.relay)) {
                return this.buildPathBetween(from, to, ((NetworkEndpoint)to).relay.position);
            }
            ArrayList<Coordinate> li = this.getNodePath(world, from.relay, to.relay, new HashSet<Coordinate>());
            return li != null ? this.buildPathBetween(from, to, li.toArray(new Coordinate[li.size()])) : null;
        }

        private ArrayList<Coordinate> getNodePath(World world, EssentiaNode from, EssentiaNode to, HashSet<Coordinate> visited) {
            if (to.otherNodes.contains(from.position)) {
                return ReikaJavaLibrary.makeListFrom((Object[])new Coordinate[]{from.position, to.position});
            }
            for (Coordinate c : to.otherNodes) {
                if (visited.contains(c)) continue;
                visited.add(c);
                EssentiaNode e = this.relays.get(c);
                ArrayList<Coordinate> li = this.getNodePath(world, from, e, visited);
                if (li == null) continue;
                li.add(to.position);
                return li;
            }
            return null;
        }

        private ArrayList<Coordinate> buildPathBetween(NetworkEndpoint from, NetworkEndpoint to, Coordinate ... hops) {
            ArrayList<Coordinate> li = new ArrayList<Coordinate>();
            li.add(from.point);
            for (Coordinate c : hops) {
                li.add(c);
            }
            li.add(to.point);
            return li;
        }

        public Collection<Coordinate> getAllEndpoints() {
            return Collections.unmodifiableCollection(this.endpoints.keySet());
        }

        public Map<Coordinate, Boolean> getGeneralizedNetworkRenderer() {
            return Collections.unmodifiableMap(this.renderMap);
        }
    }

    public static class NetworkBuilder {
        public static EssentiaSubnet buildFrom(TileEntityEssentiaRelay te) {
            HashSet<Coordinate> set = new HashSet<Coordinate>();
            set.add(new Coordinate((TileEntity)te));
            boolean flag = true;
            while (flag) {
                HashSet<Coordinate> toAdd = new HashSet<Coordinate>();
                for (Coordinate c : set) {
                    Collection<Coordinate> li = NetworkBuilder.getNearNodesExcept(te.field_145850_b, c, set);
                    if (li == null) {
                        return null;
                    }
                    toAdd.addAll(li);
                }
                set.addAll(toAdd);
                flag = !toAdd.isEmpty();
            }
            EssentiaSubnet ret = NetworkBuilder.buildNetworkWithNodes(te.field_145850_b, set);
            return ret;
        }

        private static Collection<Coordinate> getNearNodesExcept(World world, Coordinate c, HashSet<Coordinate> set) {
            ArrayList<Coordinate> ret = new ArrayList<Coordinate>();
            int r = 8;
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    for (int k = -r; k <= r; ++k) {
                        int dx = c.xCoord + i;
                        int dy = c.yCoord + j;
                        int dz = c.zCoord + k;
                        Coordinate c2 = new Coordinate(dx, dy, dz);
                        if (set.contains(c2) || ChromaTiles.getTile((IBlockAccess)world, dx, dy, dz) != ChromaTiles.ESSENTIARELAY) continue;
                        EssentiaSubnet net = ((TileEntityEssentiaRelay)world.func_147438_o(dx, dy, dz)).getNetwork();
                        if (net != null) {
                            net.destroy(world, true);
                            return null;
                        }
                        ret.add(c2);
                    }
                }
            }
            return ret;
        }

        private static EssentiaSubnet buildNetworkWithNodes(World world, HashSet<Coordinate> set) {
            EssentiaSubnet net = new EssentiaSubnet(EssentiaNetwork.getNetwork(world), world.field_73011_w.field_76574_g);
            for (Coordinate c : set) {
                net.addRelay(world, c);
            }
            net.findAllEndpoints(world);
            net.prune(world);
            return net;
        }
    }

    private static class SuctionComparator
    implements Comparator<NetworkEndpoint> {
        private boolean suction;
        private World referenceWorld;

        private SuctionComparator() {
        }

        private void setWorld(World world) {
            this.referenceWorld = world;
        }

        private void setForPull(boolean pull) {
            this.suction = pull;
        }

        private void reset() {
            this.referenceWorld = null;
        }

        @Override
        public int compare(NetworkEndpoint o1, NetworkEndpoint o2) {
            if (o1.getClass() == o2.getClass() && o1 instanceof LabelledJarEndpoint) {
                return ((LabelledJarEndpoint)o1).compareTo((LabelledJarEndpoint)o2);
            }
            if (o1 instanceof ActiveEndpoint && o2 instanceof ActiveEndpoint) {
                int amt2;
                AspectList p2;
                ActiveEndpoint a1 = (ActiveEndpoint)o1;
                ActiveEndpoint a2 = (ActiveEndpoint)o2;
                AspectList p1 = this.suction ? a1.getPull(this.referenceWorld) : a1.getPush(this.referenceWorld);
                AspectList aspectList = p2 = this.suction ? a2.getPull(this.referenceWorld) : a2.getPush(this.referenceWorld);
                if (p1 == null && p2 == null) {
                    return this.compareTiles(a1, a2);
                }
                if (p1 == null) {
                    return 1;
                }
                if (p2 == null) {
                    return -1;
                }
                int amt1 = p1.visSize();
                return amt1 == (amt2 = p2.visSize()) ? this.compareTiles(a1, a2) : -Integer.compare(amt1, amt2);
            }
            if (o1 instanceof ActiveEndpoint) {
                return -1;
            }
            if (o2 instanceof ActiveEndpoint) {
                return 1;
            }
            int ret = Integer.compare(o1.suction, o2.suction);
            if (!this.suction) {
                ret = -ret;
            }
            return ret;
        }

        private int compareTiles(ActiveEndpoint o1, ActiveEndpoint o2) {
            if (o1.getClass() == o2.getClass()) {
                return 0;
            }
            if (o1 instanceof LabelledJarEndpoint) {
                return 1;
            }
            if (o2 instanceof LabelledJarEndpoint) {
                return -1;
            }
            return 0;
        }
    }

    private static class NetworkEndpoint {
        public final Coordinate point;
        protected final int tileHash;
        protected final Class tileClass;
        private EssentiaNode relay;
        public final int suction;

        private NetworkEndpoint(Coordinate loc, IEssentiaTransport te) {
            this.point = loc;
            this.tileHash = System.identityHashCode(te);
            this.tileClass = te.getClass();
            int maxsuc = 0;
            for (int i = 0; i < 6; ++i) {
                maxsuc = Math.max(maxsuc, te.getSuctionAmount(ForgeDirection.VALID_DIRECTIONS[i]));
            }
            if (EssentiaNetwork.isFilteredJar(te) != null) {
                maxsuc += 100;
            }
            this.suction = maxsuc;
        }

        public boolean isValid(World world) {
            TileEntity te = this.point.getTileEntity((IBlockAccess)world);
            return te != null && System.identityHashCode(te) == this.tileHash;
        }

        protected final IEssentiaTransport getTile(World world) {
            return (IEssentiaTransport)this.point.getTileEntity((IBlockAccess)world);
        }

        public int getContents(World world, Aspect a) {
            IEssentiaTransport tile = this.getTile(world);
            if (tile == null) {
                return 0;
            }
            if (tile instanceof TileEntityAspectJar) {
                return ((TileEntityAspectJar)tile).getAmount(a);
            }
            for (int i = 0; i < 6; ++i) {
                int ret;
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                if (a != tile.getEssentiaType(dir) || (ret = tile.getEssentiaAmount(dir)) <= 0) continue;
                return ret;
            }
            return 0;
        }

        public int addAspect(World world, Aspect a, int amount) {
            IEssentiaTransport tile = this.getTile(world);
            if (tile == null) {
                return 0;
            }
            int ret = 0;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                if (!tile.canInputFrom(dir)) continue;
                int added = tile.addEssentia(a, amount, dir);
                ret += added;
                if ((amount -= added) <= 0) break;
            }
            return ret;
        }

        public int takeAspect(World world, Aspect a, int amount) {
            IEssentiaTransport tile = this.getTile(world);
            if (tile == null) {
                return 0;
            }
            int ret = 0;
            for (int i = 0; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[i];
                if (!tile.canOutputTo(dir)) continue;
                int rem = tile.takeEssentia(a, amount, dir);
                ret += rem;
                if ((amount -= rem) <= 0) break;
            }
            return ret;
        }

        public boolean canReceive(World world, boolean isTick) {
            return true;
        }

        public boolean canEmit(World world, boolean isTick) {
            return true;
        }

        public final int hashCode() {
            return this.point.hashCode();
        }

        public final boolean equals(Object o) {
            return o != null && o.getClass() == this.getClass() && ((NetworkEndpoint)o).point.equals((Object)this.point);
        }

        public final String toString() {
            return this.getClass() + " # " + this.tileHash + " @ " + this.point + " suc=" + this.suction;
        }

        private void removeFromRelays() {
            if (this.relay != null) {
                this.relay.activeEndpoints.remove(this.point);
                this.relay.inertEndpoints.remove(this.point);
            }
            this.relay = null;
        }

        public boolean requiresAdjacency() {
            return false;
        }

        protected DecimalPosition getRayOffset(World world) {
            return null;
        }

        protected boolean needsLOS() {
            return true;
        }
    }

    private static class EnergisticsEndpoint
    extends NetworkEndpoint {
        private EnergisticsEndpoint(Coordinate loc, IEssentiaTransport te) {
            super(loc, te);
        }

        @Override
        public boolean canReceive(World world, boolean isTick) {
            return true;
        }

        @Override
        public boolean canEmit(World world, boolean isTick) {
            return true;
        }

        @DependentMethodStripper.ModDependent(value={ModList.APPENG})
        private IGrid getGrid(World world) {
            TileEntity te = (TileEntity)this.getTile(world);
            if (te == null) {
                return null;
            }
            IGridNode node = te instanceof IActionHost ? ((IActionHost)te).getActionableNode() : ((IGridHost)te).getGridNode(ForgeDirection.UP);
            return node != null ? node.getGrid() : null;
        }

        @Override
        public int getContents(World world, Aspect a) {
            IGrid grid = this.getGrid(world);
            if (grid == null) {
                return 0;
            }
            IEssentiaGrid cache = (IEssentiaGrid)grid.getCache(IEssentiaGrid.class);
            return (int)Math.min(Integer.MAX_VALUE, cache.getEssentiaAmount(a));
        }
    }

    private static class ThaumatoriumEndpoint
    extends NetworkEndpoint {
        private ThaumatoriumEndpoint(Coordinate loc, IEssentiaTransport te) {
            super(loc, te);
        }

        @Override
        public boolean canReceive(World world, boolean isTick) {
            return !isTick;
        }

        @Override
        public boolean canEmit(World world, boolean isTick) {
            return false;
        }
    }

    private static class CentrifugeEndpoint
    extends NetworkEndpoint {
        private CentrifugeEndpoint(Coordinate loc, IEssentiaTransport te) {
            super(loc, te);
        }

        @Override
        public boolean canReceive(World world, boolean isTick) {
            return !isTick;
        }

        @Override
        public boolean canEmit(World world, boolean isTick) {
            return true;
        }
    }

    private static abstract class ActiveEndpoint
    extends NetworkEndpoint {
        private ActiveEndpoint(Coordinate loc, IEssentiaTransport te) {
            super(loc, te);
        }

        public abstract AspectList getPull(World var1);

        public abstract AspectList getPush(World var1);

        @Override
        public boolean canReceive(World world, boolean isTick) {
            return this.getPush(world) == null && this.getPull(world) != null;
        }

        @Override
        public boolean canEmit(World world, boolean isTick) {
            return this.getPull(world) == null && this.getPush(world) != null;
        }
    }

    private static class AlvearyEndpoint
    extends ActiveEndpoint {
        private AlvearyEndpoint(Coordinate loc, IEssentiaTransport te) {
            super(loc, te);
        }

        @Override
        public AspectList getPull(World world) {
            TileEntityLumenAlveary tile = this.getAlveary(world);
            if (tile == null || !tile.isAlvearyComplete()) {
                return null;
            }
            Collection<? extends TileEntityLumenAlveary.AlvearyEffect> c = TileEntityLumenAlveary.getEffectSet(TileEntityLumenAlveary.VisAlvearyEffect.class);
            AspectList al = new AspectList();
            for (TileEntityLumenAlveary.VisAlvearyEffect visAlvearyEffect : c) {
                if (!tile.isEffectSelected(visAlvearyEffect)) continue;
                al.add(visAlvearyEffect.aspect, visAlvearyEffect.requiredVis * 20);
            }
            return al;
        }

        @Override
        public AspectList getPush(World world) {
            return null;
        }

        @Override
        public boolean isValid(World world) {
            return super.isValid(world) && this.getAlveary(world).isAlvearyComplete();
        }

        private TileEntityLumenAlveary getAlveary(World world) {
            return (TileEntityLumenAlveary)this.getTile(world);
        }

        @Override
        public boolean canEmit(World world, boolean isTick) {
            return false;
        }

        @Override
        public int addAspect(World world, Aspect a, int amount) {
            return this.getAlveary(world).addEssentia(a, amount, null);
        }

        @Override
        protected DecimalPosition getRayOffset(World world) {
            Coordinate c;
            TileEntityLumenAlveary te = this.getAlveary(world);
            if (te != null && (c = te.getAlvearyCenter()) != null) {
                return new DecimalPosition((double)(c.xCoord - te.field_145851_c), (double)(c.yCoord - te.field_145848_d), (double)(c.zCoord - te.field_145849_e));
            }
            return null;
        }

        @Override
        protected boolean needsLOS() {
            return false;
        }
    }

    private static class LabelledJarEndpoint
    extends ActiveEndpoint
    implements Comparable<LabelledJarEndpoint> {
        private final Aspect filter;
        private final boolean isVoid;

        private LabelledJarEndpoint(Coordinate loc, IEssentiaTransport te, Aspect a) {
            super(loc, te);
            this.filter = a;
            this.isVoid = te.getClass().getName().toLowerCase(Locale.ENGLISH).endsWith("void");
        }

        @Override
        public AspectList getPull(World world) {
            IEssentiaTransport tile = this.getTile(world);
            if (tile == null) {
                return null;
            }
            try {
                int has = amountField.getInt(tile);
                int amt = this.isVoid && has >= 64 ? 0 : 1 + has;
                return amt > 0 ? new AspectList().add(this.filter, amt) : null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new AspectList().add(this.filter, 1);
            }
        }

        @Override
        public AspectList getPush(World world) {
            return null;
        }

        @Override
        public boolean isValid(World world) {
            try {
                return super.isValid(world) && filterField.get(this.getTile(world)) == this.filter;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public int addAspect(World world, Aspect a, int amount) {
            if (a != this.filter) {
                return 0;
            }
            return super.addAspect(world, a, amount);
        }

        @Override
        public int compareTo(LabelledJarEndpoint o) {
            if (o.isVoid == this.isVoid) {
                return 0;
            }
            if (this.isVoid) {
                return 1;
            }
            if (o.isVoid) {
                return -1;
            }
            throw new UnreachableCodeException("Two booleans were neither equal nor was either true. Get a new JVM, because yours is broken.");
        }
    }

    private static class AdvancedFurnaceEndpoint
    extends ActiveEndpoint {
        private AdvancedFurnaceEndpoint(Coordinate loc, IEssentiaTransport te) {
            super(loc, te);
        }

        @Override
        public AspectList getPull(World world) {
            return null;
        }

        @Override
        public AspectList getPush(World world) {
            IEssentiaTransport tile = this.getTile(world);
            if (tile == null) {
                return null;
            }
            try {
                IAspectContainer ias = (IAspectContainer)tile;
                return ias.getAspects();
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public int addAspect(World world, Aspect a, int amount) {
            return 0;
        }

        @Override
        public boolean canReceive(World world, boolean isTick) {
            return false;
        }

        @Override
        public boolean requiresAdjacency() {
            return true;
        }
    }

    private static class AlembicEndpoint
    extends ActiveEndpoint {
        private AlembicEndpoint(Coordinate loc, IEssentiaTransport te) {
            super(loc, te);
        }

        @Override
        public AspectList getPull(World world) {
            return null;
        }

        @Override
        public AspectList getPush(World world) {
            IEssentiaTransport tile = this.getTile(world);
            if (tile == null) {
                return null;
            }
            try {
                Aspect a = (Aspect)alembicAspectField.get(tile);
                return a != null ? new AspectList().add(a, alembicAmountField.getInt(tile)) : null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public int addAspect(World world, Aspect a, int amount) {
            return 0;
        }

        @Override
        public boolean canReceive(World world, boolean isTick) {
            return false;
        }
    }

    public static class EssentiaPath {
        private final ArrayList<Coordinate> path;
        public final Coordinate target;
        public final Coordinate source;
        public final DecimalPosition sourceOffset;
        public final DecimalPosition targetOffset;
        public final Aspect aspect;
        public final int amount;
        private long lastParticleTick;

        private EssentiaPath(Aspect a, int amt, EssentiaPathCache p) {
            this.aspect = a;
            this.amount = amt;
            this.path = p.path;
            this.target = this.path.isEmpty() ? null : this.path.get(0);
            this.source = this.path.isEmpty() ? null : this.path.get(this.path.size() - 1);
            this.sourceOffset = p.sourceOffset;
            this.targetOffset = p.targetOffset;
        }

        public void update(World world, int x, int y, int z) {
            long time = world.func_82737_E();
            if (time - this.lastParticleTick <= 2L) {
                return;
            }
            this.doParticles(world, x, y, z);
            this.lastParticleTick = time;
        }

        private void doParticles(World world, int x, int y, int z) {
            for (int i = 0; i < this.path.size() - 1; ++i) {
                NBTTagCompound tag;
                Coordinate loc1 = this.path.get(i);
                Coordinate loc2 = this.path.get(i + 1);
                if (i == 0 && this.sourceOffset != null) {
                    tag = new NBTTagCompound();
                    tag.func_74778_a("tag", this.aspect.getTag());
                    tag.func_74768_a("amt", this.amount);
                    loc1.writeToNBT("loc1", tag);
                    loc2.writeToNBT("loc2", tag);
                    this.sourceOffset.writeToNBT("off1", tag);
                    ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.ESSENTIAPARTICLEWITHOFFSET.ordinal(), (NBTTagCompound)tag, (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x, (double)y, (double)z, 32.0));
                    continue;
                }
                if (i == this.path.size() - 2 && this.targetOffset != null) {
                    tag = new NBTTagCompound();
                    tag.func_74778_a("tag", this.aspect.getTag());
                    tag.func_74768_a("amt", this.amount);
                    loc1.writeToNBT("loc1", tag);
                    loc2.writeToNBT("loc2", tag);
                    this.targetOffset.writeToNBT("off2", tag);
                    ReikaPacketHelper.sendNBTPacket((String)"ChromaData", (int)ChromaPackets.ESSENTIAPARTICLEWITHOFFSET.ordinal(), (NBTTagCompound)tag, (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x, (double)y, (double)z, 32.0));
                    continue;
                }
                ReikaPacketHelper.sendStringIntPacket((String)"ChromaData", (int)ChromaPackets.ESSENTIAPARTICLE.ordinal(), (PacketTarget)new PacketTarget.RadiusTarget(world, (double)x, (double)y, (double)z, 32.0), (String)this.aspect.getTag(), (int[])new int[]{loc1.xCoord, loc2.xCoord, loc1.yCoord, loc2.yCoord, loc1.zCoord, loc2.zCoord, this.amount});
            }
        }

        @SideOnly(value=Side.CLIENT)
        public static void sendParticle(World world, double x1, double x2, double y1, double y2, double z1, double z2, String asp, int amt) {
            Aspect a = Aspect.getAspect((String)asp);
            int l = 100;
            double dx = x2 - x1;
            double dy = y2 - y1;
            double dz = z2 - z1;
            double dd = ReikaMathLibrary.py3d((double)dx, (double)dy, (double)dz);
            double v = 0.25;
            double vx = v * dx / dd;
            double vy = v * dy / dd;
            double vz = v * dz / dd;
            int i = 0;
            for (double d = 0.0; d <= dd; d += 0.125) {
                double px = x1 + 0.5 + dx * d / dd;
                double py = y1 + 0.5 + dy * d / dd;
                double pz = z1 + 0.5 + dz * d / dd;
                double ds = Math.min(dd - d, d);
                float s = (float)(1.5 + (double)amt / 4.0 * ds / 1.0);
                EntityBlurFX fx = new EntityCCBlurFX(world, px, py, pz).setColor(a.getColor()).setLife(l).setScale(s).setRapidExpand();
                EntityBlurFX fx2 = new EntityCCBlurFX(world, px, py, pz).setColor(0xFFFFFF).setLife(l).setScale(s / 2.0f).setRapidExpand();
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx2);
                ++i;
            }
        }

        public String toString() {
            return this.amount + " of " + this.aspect.getName() + " along " + this.path;
        }
    }

    private static class EssentiaPathCache {
        private final ArrayList<Coordinate> path;
        private boolean isDirty = false;
        private final boolean startpointNeedsLOS;
        private final boolean endpointNeedsLOS;
        public final DecimalPosition sourceOffset;
        public final DecimalPosition targetOffset;

        private EssentiaPathCache(ArrayList<Coordinate> li, boolean losstart, boolean losend, DecimalPosition so, DecimalPosition to) {
            this.path = li;
            this.startpointNeedsLOS = losstart;
            this.endpointNeedsLOS = losend;
            this.sourceOffset = so;
            this.targetOffset = to;
        }

        public boolean validate(World world) {
            for (int i = 0; i < this.path.size() - 1; ++i) {
                Coordinate loc1 = this.path.get(i);
                Coordinate loc2 = this.path.get(i + 1);
                if (!this.startpointNeedsLOS && i == 0 || !this.endpointNeedsLOS && i == this.path.size() - 2 || EssentiaNetwork.LOS(world, loc1, loc2)) continue;
                return false;
            }
            return true;
        }

        public void markDirty() {
            this.isDirty = true;
        }

        public boolean isEmpty() {
            return this.path.isEmpty();
        }
    }

    private static class EssentiaPathSearch {
        private final ArrayList<Coordinate> path = new ArrayList();
        private final HashSet<Coordinate> looked = new HashSet();
        private boolean isComplete;

        private EssentiaPathSearch() {
        }
    }

    public static class EssentiaMovement {
        public final int totalAmount;
        private final ArrayList<EssentiaPath> paths;

        private EssentiaMovement(ArrayList<EssentiaPath> li) {
            this.paths = li;
            int sum = 0;
            for (EssentiaPath p : this.paths) {
                sum += p.amount;
            }
            this.totalAmount = sum;
        }

        public Collection<EssentiaPath> paths() {
            return Collections.unmodifiableList(this.paths);
        }
    }
}

