/*
 * Decompiled with CFR 0.152.
 */
package Reika.ChromatiCraft.ModInterface.ThaumCraft;

import Reika.ChromatiCraft.API.AbilityAPI;
import Reika.ChromatiCraft.Auxiliary.Ability.AbilityHelper;
import Reika.ChromatiCraft.ChromatiCraft;
import Reika.ChromatiCraft.Magic.ElementTagCompound;
import Reika.ChromatiCraft.ModInterface.ThaumCraft.ChromaAspectManager;
import Reika.ChromatiCraft.Registry.ChromaGuis;
import Reika.ChromatiCraft.Registry.ChromaIcons;
import Reika.ChromatiCraft.Registry.ChromaSounds;
import Reika.ChromatiCraft.Registry.Chromabilities;
import Reika.ChromatiCraft.Registry.CrystalElement;
import Reika.DragonAPI.ASM.DependentMethodStripper;
import Reika.DragonAPI.Libraries.Rendering.ReikaColorAPI;
import Reika.DragonAPI.ModInteract.DeepInteract.ItemCustomFocus;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.FocusUpgradeType;

public class ItemAbilityFocus
extends ItemCustomFocus {
    public ItemAbilityFocus() {
        super((CreativeTabs)ChromatiCraft.tabChromaTools);
    }

    @SideOnly(value=Side.CLIENT)
    protected String func_111208_A() {
        return "chromaticraft:ability-focus";
    }

    @DependentMethodStripper.ModDependent(value={ModList.THAUMCRAFT})
    public AspectList getVisCost(ItemStack focusStack) {
        AbilityAPI.Ability ab = this.getAbility(focusStack);
        if (ab == null) {
            return new AspectList().add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1).add(Aspect.FIRE, 1).add(Aspect.AIR, 1).add(Aspect.WATER, 1).add(Aspect.EARTH, 1);
        }
        ElementTagCompound tag = AbilityHelper.instance.getUsageElementsFor(ab, null);
        AspectList al = new AspectList();
        for (CrystalElement e : tag.elementSet()) {
            for (Aspect a : ChromaAspectManager.instance.getAspects(e, true)) {
                AspectList al2 = ReikaThaumHelper.decompose((Aspect)a);
                for (Aspect a2 : al2.aspects.keySet()) {
                    al.add(a2, (int)((float)(tag.getValue(e) * al2.getAmount(a2) * 20) * this.getCostScale(focusStack)));
                }
            }
        }
        return al;
    }

    public ItemStack onFocusRightClick(ItemStack wand, World world, EntityPlayer ep, MovingObjectPosition mov) {
        ItemStack focus = ReikaThaumHelper.getWandFocusStack((ItemStack)wand);
        if (focus == null || focus.field_77990_d == null) {
            return null;
        }
        AbilityAPI.Ability a = Chromabilities.getAbility(focus.field_77990_d.func_74779_i("ability"));
        if (a != null && Chromabilities.playerHasAbility(ep, a) && Chromabilities.canPlayerExecuteAt(ep, a)) {
            int pwr = focus.field_77990_d.func_74762_e("power");
            pwr = Math.min(pwr, MathHelper.func_76123_f((float)((float)(a.getMaxPower() * this.getUpgradeLevel(focus, FocusUpgradeType.potency)) / 5.0f)));
            Chromabilities.triggerAbility(ep, a, pwr, this.getCostScale(focus));
        } else {
            ChromaSounds.ERROR.playSound((Entity)ep);
        }
        return null;
    }

    private float getCostScale(ItemStack focus) {
        return Math.max(0.5f, 1.5f - 0.25f * (float)this.getUpgradeLevel(focus, FocusUpgradeType.frugal));
    }

    public boolean canApplyUpgrade(ItemStack focusstack, EntityPlayer player, FocusUpgradeType type, int rank) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer ep) {
        ep.openGui((Object)ChromatiCraft.instance, ChromaGuis.ABILITYFOCUS.ordinal(), world, 0, 0, 0);
        return is;
    }

    public void func_77624_a(ItemStack is, EntityPlayer ep, List li, boolean vb) {
        AbilityAPI.Ability a = this.getAbility(is);
        if (a != null) {
            li.add("Selected Ability: " + a.getDisplayName());
            li.add("Ability Power: " + is.field_77990_d.func_74762_e("power"));
        } else {
            li.add("No ability selected.");
        }
        super.func_77624_a(is, ep, li, vb);
    }

    private AbilityAPI.Ability getAbility(ItemStack is) {
        return is.field_77990_d == null ? null : Chromabilities.getAbility(is.field_77990_d.func_74779_i("ability"));
    }

    public EnumRarity func_77613_e(ItemStack focusstack) {
        return EnumRarity.rare;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFocusColor(ItemStack focusstack) {
        return ReikaColorAPI.getModifiedHue((int)0x22AAFF, (int)((int)(245.0 + 35.0 * Math.sin((double)System.currentTimeMillis() / 250.0))));
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOrnament(ItemStack focusstack) {
        return Items.field_151114_aO.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFocusDepthLayerIcon(ItemStack focusstack) {
        return ChromaIcons.LATTICEITEM.getIcon();
    }

    public int getActivationCooldown(ItemStack focusstack) {
        return 500;
    }

    protected String getID() {
        return "ability";
    }

    public FocusUpgradeType[] getPossibleUpgradesByRank(ItemStack focusstack, int rank) {
        return new FocusUpgradeType[]{FocusUpgradeType.frugal, FocusUpgradeType.potency};
    }
}

